/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.turnsandscenemode.TaSAnno;
import mpi.eudico.client.annotator.turnsandscenemode.TaSSpecialMarkers;
import mpi.eudico.client.annotator.viewer.StyledHighlightPainter;
import mpi.eudico.util.TimeFormatter;

public class TaSCellPanel
extends JPanel {
    private JLabel timeLabel;
    private JLabel speakerLabel;
    private JLabel rowNumberLabel;
    private JTextArea textArea;
    private DecorationPanel indicatorPanel;
    private Border activeBorder = new LineBorder(Constants.ACTIVEANNOTATIONCOLOR, 1);
    private Border activeGapBorder = new LineBorder(new Color(128, 128, 255), 1);
    private JPanel linePanel;
    private Color DEF_PANEL_BG;
    private Color DEF_TEXT_BG;
    public final Color NO_ANN_BG = new Color(230, 230, 250);
    private final String EMPTY_STR = "";
    private final int NUMBER_OF_HIGHLIGHTERS = 4;
    private Highlighter tasHighlighter;
    private TextAreaDocListener docListener;
    private List<StyledHighlightPainter> transPainterList;
    private List<Object> transHighlightInfoList;
    private List<StyledHighlightPainter> speakPainterList;
    private List<Object> speakHighlightInfoList;
    private boolean timeLabelVisible;
    private boolean speakerLabelVisible;
    private TaSAnno curAnnoSegment;
    private long currentMediaTime = -1L;
    private List<KeyStroke> keyStrokesNotToConsume;
    private Font baseFont = null;
    private Font mainTierFont = null;

    public TaSCellPanel() {
        this.initComponents();
    }

    public void setTaSAnnotation(TaSAnno slAnno) {
        this.curAnnoSegment = slAnno;
        if (this.curAnnoSegment != null) {
            this.textArea.setText(this.curAnnoSegment.getText());
            if (slAnno.getAnnotation() == null) {
                this.textArea.setBackground(Constants.EVEN_ROW_BG);
                this.rowNumberLabel.setText("");
            } else {
                this.textArea.setBackground(this.DEF_TEXT_BG);
                int index = slAnno.getAnnotation().getTier().getAnnotations().indexOf(slAnno.getAnnotation());
                if (index >= 0) {
                    this.rowNumberLabel.setText(String.valueOf(index + 1));
                } else {
                    this.rowNumberLabel.setText("");
                }
            }
            long et = this.curAnnoSegment.getEndTime();
            String etLabel = null;
            etLabel = et == Long.MAX_VALUE ? "?" : TimeFormatter.toString(et);
            this.timeLabel.setText(TimeFormatter.toString(this.curAnnoSegment.getBeginTime()) + " - " + etLabel);
            if (this.curAnnoSegment.getParticipant() != null) {
                if (this.curAnnoSegment.getParticipant().length() > 3) {
                    this.speakerLabel.setText(this.curAnnoSegment.getParticipant().substring(0, 3));
                } else {
                    this.speakerLabel.setText(this.curAnnoSegment.getParticipant());
                }
            } else {
                this.speakerLabel.setText("");
            }
        } else {
            this.textArea.setText("");
            this.timeLabel.setText("");
            this.speakerLabel.setText("");
            this.rowNumberLabel.setText("");
            this.textArea.setBackground(this.DEF_TEXT_BG);
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.timeLabelVisible = true;
        this.speakerLabelVisible = false;
        this.timeLabel = new JLabel("T");
        this.speakerLabel = new JLabel("S");
        this.rowNumberLabel = new JLabel("0");
        this.indicatorPanel = new DecorationPanel();
        this.indicatorPanel.setPreferredSize(new Dimension(14, 20));
        this.DEF_PANEL_BG = this.indicatorPanel.getBackground();
        this.linePanel = new JPanel(null);
        this.linePanel.setPreferredSize(new Dimension(1, 1));
        this.textArea = new TaSTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(true);
        this.textArea.setMargin(new Insets(4, 6, 4, 4));
        this.DEF_TEXT_BG = this.textArea.getBackground();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 3;
        gbc.gridheight = 2;
        gbc.weighty = 1.0;
        this.add((Component)this.indicatorPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(6, 3, 2, 4);
        this.add((Component)this.rowNumberLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(6, 3, 2, 4);
        this.add((Component)this.speakerLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(2, 3, 2, 2);
        this.add((Component)this.textArea, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 3, 2, 2);
        this.add((Component)this.timeLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        this.add((Component)this.linePanel, gbc);
        this.updateLayout();
        this.initHighlighters();
    }

    private void initHighlighters() {
        StyledHighlightPainter shp;
        int i;
        this.docListener = new TextAreaDocListener();
        this.textArea.getDocument().addDocumentListener(this.docListener);
        this.tasHighlighter = this.textArea.getHighlighter();
        this.transPainterList = new ArrayList<StyledHighlightPainter>(4);
        this.transHighlightInfoList = new ArrayList<Object>(4);
        for (i = 0; i < 4; ++i) {
            shp = new StyledHighlightPainter(Constants.SIGNALSTEREOBLENDEDCOLOR1, 0, 1);
            shp.setVisible(false);
            try {
                this.transHighlightInfoList.add(this.tasHighlighter.addHighlight(0, 0, shp));
                this.transPainterList.add(shp);
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.speakPainterList = new ArrayList<StyledHighlightPainter>(4);
        this.speakHighlightInfoList = new ArrayList<Object>(4);
        for (i = 0; i < 4; ++i) {
            shp = new StyledHighlightPainter(Constants.SHAREDCOLOR1, 0, 1);
            shp.setVisible(false);
            try {
                this.speakHighlightInfoList.add(this.tasHighlighter.addHighlight(0, 0, shp));
                this.speakPainterList.add(shp);
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private void updateLayout() {
        this.speakerLabel.setVisible(this.speakerLabelVisible);
        this.timeLabel.setVisible(this.timeLabelVisible);
    }

    public void startEditing() {
        this.textArea.requestFocus();
        this.textArea.setCaretPosition(0);
    }

    public void stopEditing() {
        this.textArea.transferFocusUpCycle();
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.indicatorPanel.setBackground(Constants.SELECTIONCOLOR);
        } else {
            this.indicatorPanel.setBackground(this.DEF_PANEL_BG);
        }
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            this.baseFont = font;
            if (this.textArea != null) {
                if (this.mainTierFont == null) {
                    this.textArea.setFont(font);
                } else {
                    this.textArea.setFont(this.mainTierFont.deriveFont((float)font.getSize()));
                }
            }
            if (this.speakerLabel != null) {
                this.speakerLabel.setFont(font);
            }
            if (this.timeLabel != null) {
                int baseSize = font.getSize();
                float timeSize = 10.0f + 2.0f * ((float)baseSize / 10.0f);
                this.timeLabel.setFont(font.deriveFont(timeSize));
            }
            if (this.rowNumberLabel != null && this.timeLabel != null) {
                this.rowNumberLabel.setFont(this.timeLabel.getFont());
            }
        }
    }

    public void setMainTierFont(Font f) {
        this.mainTierFont = f;
        if (this.textArea != null) {
            int baseSize = 16;
            if (this.baseFont != null) {
                baseSize = this.baseFont.getSize();
            }
            if (this.mainTierFont != null) {
                if (this.mainTierFont.getSize() == baseSize) {
                    this.textArea.setFont(this.mainTierFont);
                } else {
                    this.textArea.setFont(this.mainTierFont.deriveFont((float)baseSize));
                }
            } else {
                this.textArea.setFont(this.baseFont);
            }
        }
    }

    public boolean isTimeLabelVisible() {
        return this.timeLabelVisible;
    }

    public void setTimeLabelVisible(boolean timeLabelVisible) {
        if (this.timeLabelVisible != timeLabelVisible) {
            this.timeLabelVisible = timeLabelVisible;
            this.updateLayout();
        }
    }

    public boolean isSpeakerLabelVisible() {
        return this.speakerLabelVisible;
    }

    public void setSpeakerLabelVisible(boolean speakerLabelVisible) {
        if (this.speakerLabelVisible != speakerLabelVisible) {
            this.speakerLabelVisible = speakerLabelVisible;
            this.updateLayout();
        }
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public void setDecorations(boolean inTimeSelection, boolean containsCrosshair, boolean isActiveAnnotation, boolean isActiveGap) {
        this.indicatorPanel.timeSelected = inTimeSelection;
        this.indicatorPanel.crosshairInSegment = containsCrosshair;
        if (isActiveAnnotation) {
            this.setBorder(this.activeBorder);
        } else if (isActiveGap) {
            this.setBorder(this.activeGapBorder);
        } else {
            this.setBorder(null);
        }
    }

    public void updatMediaTime(long mediaTime) {
        this.currentMediaTime = mediaTime;
        this.indicatorPanel.repaint();
    }

    public void setKeyStrokesNotToBeConsumed(List<KeyStroke> keyStrokesNotToBeConsumed) {
        this.keyStrokesNotToConsume = keyStrokesNotToBeConsumed;
    }

    private class DecorationPanel
    extends JPanel {
        boolean timeSelected = true;
        boolean crosshairInSegment = true;
        int chHeight = 10;

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            int w = this.getWidth();
            int h = this.getHeight();
            if (!this.timeSelected) {
                g2d.setColor(TaSCellPanel.this.DEF_PANEL_BG);
            } else {
                g2d.setColor(Constants.SELECTIONCOLOR);
            }
            g2d.fillRect(0, 0, w, h);
            if (this.crosshairInSegment) {
                if (TaSCellPanel.this.currentMediaTime < 0L) {
                    g2d.setColor(Constants.CROSSHAIRCOLOR);
                    g2d.fillRect(0, (h - this.chHeight) / 2, w, this.chHeight);
                    g2d.drawLine(0, 0, w - 1, 0);
                    g2d.drawLine(0, h - 1, w - 1, h - 1);
                } else if (TaSCellPanel.this.currentMediaTime >= TaSCellPanel.this.curAnnoSegment.getBeginTime() && TaSCellPanel.this.currentMediaTime <= TaSCellPanel.this.curAnnoSegment.getEndTime()) {
                    float relPos = (float)(TaSCellPanel.this.currentMediaTime - TaSCellPanel.this.curAnnoSegment.getBeginTime()) / (float)(TaSCellPanel.this.curAnnoSegment.getEndTime() - TaSCellPanel.this.curAnnoSegment.getBeginTime());
                    int yPos = (int)(relPos * (float)h);
                    yPos = yPos > h - this.chHeight ? h - this.chHeight : yPos;
                    g2d.setColor(Constants.CROSSHAIRCOLOR);
                    g2d.fillRect(0, yPos, w, this.chHeight);
                    g2d.drawLine(0, 0, w - 1, 0);
                    g2d.drawLine(0, h - 1, w - 1, h - 1);
                }
            }
        }
    }

    private class TaSTextArea
    extends JTextArea {
        int lastKeyCode;

        private TaSTextArea() {
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            int mask = e.getModifiersEx() & 0x240;
            if (e.getKeyCode() == 32) {
                if (mask != 0) {
                    if (e.getID() == 401) {
                        Action act;
                        Object key = null;
                        key = this.getInputMap().get(KeyStroke.getKeyStrokeForEvent(e));
                        if (key != null && (act = this.getActionMap().get(key)) != null) {
                            act.actionPerformed(null);
                        }
                    }
                    e.consume();
                }
            } else if (e.getKeyCode() == 0) {
                if (mask != 0 && this.lastKeyCode == 32 && e.getID() == 400) {
                    e.consume();
                }
            } else if (e.getKeyCode() == 10 && e.getModifiersEx() == 64) {
                if (e.getID() == 401) {
                    int pos = this.getCaretPosition();
                    try {
                        this.insert("\n", pos);
                    }
                    catch (IllegalArgumentException iae) {
                        this.append("\n");
                    }
                }
                e.consume();
            }
            this.lastKeyCode = e.getKeyCode();
            super.processKeyEvent(e);
        }

        @Override
        public void cut() {
            super.cut();
            Action cutAction = this.getActionMap().get("PostCut");
            if (cutAction != null) {
                cutAction.actionPerformed(null);
            }
        }

        @Override
        public void paste() {
            super.paste();
            Action pasteAction = this.getActionMap().get("PostPaste");
            if (pasteAction != null) {
                pasteAction.actionPerformed(null);
            }
        }
    }

    private class TextAreaDocListener
    implements DocumentListener {
        private TextAreaDocListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.checkHighlights(e.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkHighlights(e.getDocument());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.checkHighlights(e.getDocument());
        }

        private void checkHighlights(Document doc) {
            String t2;
            try {
                t2 = doc.getText(0, doc.getLength());
                int[] transInd = TaSSpecialMarkers.getTranslationIndices(t2);
                if (transInd == null || transInd.length == 0) {
                    for (StyledHighlightPainter shp : TaSCellPanel.this.transPainterList) {
                        shp.setVisible(false);
                    }
                } else {
                    for (int i = 0; i < transInd.length && i < TaSCellPanel.this.transPainterList.size(); ++i) {
                        ((StyledHighlightPainter)TaSCellPanel.this.transPainterList.get(i)).setVisible(true);
                        TaSCellPanel.this.tasHighlighter.changeHighlight(TaSCellPanel.this.transHighlightInfoList.get(i), transInd[i], transInd[i] + 2);
                    }
                    for (int j = transInd.length; j < TaSCellPanel.this.transPainterList.size(); ++j) {
                        ((StyledHighlightPainter)TaSCellPanel.this.transPainterList.get(j)).setVisible(false);
                    }
                }
            }
            catch (BadLocationException t2) {
                // empty catch block
            }
            try {
                t2 = doc.getText(0, doc.getLength());
                int[][] speakerInd = TaSSpecialMarkers.getSpeakerIndices(t2);
                if (speakerInd == null || speakerInd.length == 0) {
                    for (StyledHighlightPainter shp : TaSCellPanel.this.speakPainterList) {
                        shp.setVisible(false);
                    }
                } else {
                    for (int i = 0; i < speakerInd.length && i < TaSCellPanel.this.speakPainterList.size(); ++i) {
                        ((StyledHighlightPainter)TaSCellPanel.this.speakPainterList.get(i)).setVisible(true);
                        TaSCellPanel.this.tasHighlighter.changeHighlight(TaSCellPanel.this.speakHighlightInfoList.get(i), speakerInd[i][0], speakerInd[i][1]);
                    }
                    for (int j = speakerInd.length; j < TaSCellPanel.this.speakPainterList.size(); ++j) {
                        ((StyledHighlightPainter)TaSCellPanel.this.speakPainterList.get(j)).setVisible(false);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

