/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.SIMPLELAN;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.RedoCA;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.commands.UndoCA;
import mpi.eudico.client.annotator.commands.global.MenuAction;
import mpi.eudico.client.annotator.gui.ElanMenuItem;
import mpi.eudico.client.annotator.layout.TurnsAndSceneManager;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.turnsandscenemode.commands.AboutTaSMA;
import mpi.eudico.client.annotator.turnsandscenemode.commands.ExitTaSMA;
import mpi.eudico.client.annotator.turnsandscenemode.commands.HelpTaSMA;
import mpi.eudico.client.annotator.turnsandscenemode.commands.NewTaSMA;
import mpi.eudico.client.annotator.turnsandscenemode.commands.OpenTaSMA;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class TaSFrame
extends ElanFrame2 {
    JMenuItem helpMI;
    protected ElanMenuItem exportRegularEAFMI;
    private JPanel emptyFramePanel;
    private SLWindowListener windowListener;

    public TaSFrame() {
        this.applicationName = SIMPLELAN.getApplicationName() + " " + SIMPLELAN.getVersionString();
        this.setTitle(this.applicationName);
        this.setFrameIcon();
    }

    public TaSFrame(String path) {
        this();
        if (path != null) {
            this.openEAF(path);
        } else {
            ClientLogger.LOG.info("File path is null");
        }
    }

    @Override
    public void setTranscription(Transcription nextTranscription) {
        if (this.transcriptionForThisFrame != null) {
            ClientLogger.LOG.warning("There is already a transcription loaded in this frame");
            return;
        }
        if (nextTranscription == null) {
            ClientLogger.LOG.warning("There new transcription is null");
            return;
        }
        this.transcriptionForThisFrame = nextTranscription;
        this.initElan();
    }

    @Override
    protected void setFrameIcon() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/SIMPLE-ELAN16.png"));
        this.setIconImage(icon.getImage());
    }

    @Override
    protected void initMenuBar() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        MenuAction ma = null;
        ma = new MenuAction("Menu.File");
        this.menuFile = new JMenu(ma);
        this.menuActions.put("Menu.File", ma);
        this.menuBar.add(this.menuFile);
        ma = new NewTaSMA("Menu.File.New", this);
        this.menuActions.put("Menu.File.New", ma);
        this.menuItemFileNew = new JMenuItem(ma);
        this.menuFile.add(this.menuItemFileNew);
        ma = new OpenTaSMA("Menu.File.Open", this);
        this.menuActions.put("Menu.File.Open", ma);
        this.menuItemFileOpen = new JMenuItem(ma);
        this.menuFile.add(this.menuItemFileOpen);
        ma = new MenuAction("Menu.File.Close");
        this.closeMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.File.Close", ma);
        this.menuFile.add(this.closeMI);
        this.menuFile.addSeparator();
        ma = new MenuAction("Menu.File.Save");
        this.saveMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.File.Save", ma);
        this.menuFile.add(this.saveMI);
        ma = new MenuAction("Menu.File.SaveAs");
        this.saveAsMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.File.SaveAs", ma);
        this.menuFile.add(this.saveAsMI);
        ma = new MenuAction("Menu.File.Export.RegularMultitierEAF");
        this.exportRegularEAFMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.File.Export.RegularMultitierEAF", ma);
        this.menuFile.add(this.exportRegularEAFMI);
        this.menuFile.addSeparator();
        ma = new MenuAction("Menu.File.Backup.Auto");
        this.menuActions.put("Menu.File.Backup.Auto", ma);
        this.menuBackup = new JMenu(ma);
        this.menuBackup.setEnabled(false);
        this.menuFile.add(this.menuBackup);
        this.menuFile.addSeparator();
        ma = new ExitTaSMA("Menu.File.Exit", this);
        this.menuActions.put("Menu.File.Exit", ma);
        this.menuItemFileExit = new JMenuItem(ma);
        this.menuFile.add(this.menuItemFileExit);
        ma = new MenuAction("Menu.Edit");
        this.menuActions.put("Menu.Edit", ma);
        this.menuEdit = new JMenu(ma);
        this.menuBar.add(this.menuEdit);
        ma = new MenuAction("Menu.Edit.Undo");
        this.undoMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.Edit.Undo", ma);
        this.menuEdit.add(this.undoMI);
        ma = new MenuAction("Menu.Edit.Redo");
        this.redoMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.Edit.Redo", ma);
        this.menuEdit.add(this.redoMI);
        ma = new MenuAction("Menu.Help");
        this.menuActions.put("Menu.Help", ma);
        this.menuHelp = new JMenu(ma);
        this.menuBar.add(this.menuHelp);
        ma = new HelpTaSMA("Menu.Help.Contents", this);
        this.menuActions.put("Menu.Help.Contents", ma);
        this.menuHelp.add(new JMenuItem(ma));
        ma = new AboutTaSMA("Menu.Help.About", this);
        this.menuActions.put("Menu.Help.About", ma);
        this.menuHelp.add(new JMenuItem(ma));
        this.updateLocale();
    }

    private void initSizeAndLocation() {
        this.setLocation(0, 0);
        this.setSize(600, 400);
    }

    private void initComponents() {
        this.initSizeAndLocation();
        this.updateLocale();
        this.windowListener = new SLWindowListener();
        this.addWindowListener(this.windowListener);
        this.addWindowFocusListener(this.windowListener);
        this.addWindowStateListener(this.windowListener);
        this.getContentPane().addComponentListener(new SLComponentListener());
    }

    @Override
    public void updateLocale() {
        if (this.menuBar != null) {
            super.updateLocale();
        }
    }

    @Override
    protected void initElan() {
        this.viewerManager = new ViewerManager2((TranscriptionImpl)this.transcriptionForThisFrame);
        this.layoutManager = new ElanLayoutManager(this, this.viewerManager);
        ELANCommandFactory.addDocument(this, this.viewerManager, this.layoutManager);
        this.getContentPane().remove(this.emptyFramePanel);
        this.layoutManager.changeMode(5);
        MediaDescriptorUtil.createMediaPlayers((TranscriptionImpl)this.transcriptionForThisFrame, this.transcriptionForThisFrame.getMediaDescriptors());
        ArrayList<String> audioPaths = new ArrayList<String>(4);
        if (this.layoutManager.getSignalViewer() != null) {
            audioPaths.add(this.layoutManager.getSignalViewer().getMediaPath());
        }
        ElanLocale.addElanLocaleListener(this.transcriptionForThisFrame, this);
        this.setFrameTitle();
        this.initMenusAndCommands();
        this.layoutManager.changeMode(5);
        Preferences.addPreferencesListener(this.transcriptionForThisFrame, this.layoutManager);
        Preferences.addPreferencesListener(this.transcriptionForThisFrame, this);
        Preferences.notifyListeners(this.transcriptionForThisFrame);
        this.loadPreferences();
        this.layoutManager.doLayout();
        this.initialized = true;
    }

    @Override
    protected void initFrame() {
        Locale savedLocale = (Locale)Preferences.get("Locale", null);
        if (savedLocale != null) {
            ElanLocale.setLocale(savedLocale);
        }
        this.initMenuBar();
        this.setEmptyLayout();
        this.windowListener = new SLWindowListener();
        this.addWindowListener(this.windowListener);
        this.addWindowFocusListener(this.windowListener);
        this.addWindowStateListener(this.windowListener);
        this.setDefaultCloseOperation(0);
        this.pack();
        Dimension d = Preferences.getDimension("FrameSize-TaS", this.transcriptionForThisFrame);
        if (d == null) {
            d = Preferences.getDimension("FrameSize-TaS", null);
        }
        Rectangle wRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (d != null) {
            if (d.width > wRect.width) {
                d.setSize(wRect.width, d.height);
            }
            if ((double)d.height > wRect.getHeight()) {
                d.setSize(d.width, wRect.height);
            }
            this.setSize(d);
        } else {
            this.setSize(800, 600);
        }
        Point p = Preferences.getPoint("FrameLocation-TaS", this.transcriptionForThisFrame);
        if (p == null) {
            p = Preferences.getPoint("FrameLocation-TaS", null);
        }
        if (p != null) {
            if (p.x < wRect.x) {
                p.x = wRect.x;
            } else if (p.x > wRect.width - 30) {
                p.x = wRect.width - 30;
            }
            if (p.y < wRect.y) {
                p.y = wRect.y;
            } else if (p.y > wRect.height - 30) {
                p.y = wRect.height - 30;
            }
            this.setLocation(p);
        } else {
            this.setLocation((int)(wRect.getWidth() / 2.0 - (double)(this.getWidth() / 2)), (int)(wRect.getHeight() / 2.0 - (double)(this.getHeight() / 2)));
        }
        this.setVisible(true);
    }

    @Override
    protected void initMenusAndCommands() {
        this.menuActions.remove("Menu.File.Close");
        CommandAction closeAction = ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Close");
        KeyStroke closeKS = ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.File.Close", "Menu.Options.TurnsAndSceneMode");
        closeAction.putValue("AcceleratorKey", closeKS);
        this.closeMI.setAction(closeAction, true);
        this.menuActions.remove("Menu.File.Save");
        CommandAction saveAction = ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Save");
        KeyStroke saveKS = ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.File.Save", "Menu.Options.TurnsAndSceneMode");
        saveAction.putValue("AcceleratorKey", saveKS);
        this.saveMI.setAction(saveAction, true);
        this.menuActions.remove("Menu.File.SaveAs");
        CommandAction saveAsAction = ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.SaveAs");
        KeyStroke saveAsKS = ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.File.SaveAs", "Menu.Options.TurnsAndSceneMode");
        saveAsAction.putValue("AcceleratorKey", saveAsKS);
        this.saveAsMI.setAction(saveAsAction, true);
        this.menuActions.remove("Menu.File.Export.RegularMultitierEAF");
        this.exportRegularEAFMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.RegularMultitierEAF"), true);
        this.menuActions.remove("Menu.Edit.Undo");
        UndoCA undoCA = ELANCommandFactory.getUndoCA(this.transcriptionForThisFrame);
        this.undoMI.setAction(undoCA);
        this.menuActions.remove("Menu.Edit.Redo");
        RedoCA redoCA = ELANCommandFactory.getRedoCA(this.transcriptionForThisFrame);
        this.redoMI.setAction(redoCA);
        this.menuBackup.setEnabled(true);
        ButtonGroup backupGroup = new ButtonGroup();
        Integer buDelay = Preferences.getInt("BackUpDelay", null);
        JRadioButtonMenuItem neverMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.Never"));
        if (buDelay == null || buDelay.compareTo(Constants.BACKUP_NEVER) == 0) {
            neverMI.setSelected(true);
        }
        JRadioButtonMenuItem backup1MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.1"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_1) == 0) {
            backup1MI.setSelected(true);
        }
        JRadioButtonMenuItem backup5MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.5"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_5) == 0) {
            backup5MI.setSelected(true);
        }
        JRadioButtonMenuItem backup10MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.10"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_10) == 0) {
            backup10MI.setSelected(true);
        }
        JRadioButtonMenuItem backup20MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.20"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_20) == 0) {
            backup20MI.setSelected(true);
        }
        JRadioButtonMenuItem backup30MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.30"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_30) == 0) {
            backup30MI.setSelected(true);
        }
        backupGroup.add(neverMI);
        backupGroup.add(backup1MI);
        backupGroup.add(backup5MI);
        backupGroup.add(backup10MI);
        backupGroup.add(backup20MI);
        backupGroup.add(backup30MI);
        this.menuBackup.add(neverMI);
        this.menuBackup.add(backup1MI);
        this.menuBackup.add(backup5MI);
        this.menuBackup.add(backup10MI);
        this.menuBackup.add(backup20MI);
        this.menuBackup.add(backup30MI);
        this.localUpdateShortcutMap();
    }

    protected void resetMenusAndCommands() {
        if (this.menuBar != null) {
            MenuAction ma = null;
            ma = new MenuAction("Menu.File.Close");
            this.closeMI.setAction(ma, false);
            this.menuActions.put("Menu.File.Close", ma);
            ma = new MenuAction("Menu.File.Save");
            this.saveMI.setAction(ma, false);
            this.menuActions.put("Menu.File.Save", ma);
            ma = new MenuAction("Menu.File.SaveAs");
            this.saveAsMI.setAction(ma, false);
            this.menuActions.put("Menu.File.SaveAs", ma);
            ma = new MenuAction("Menu.File.Export.RegularMultitierEAF");
            this.exportRegularEAFMI.setAction(ma, false);
            this.menuActions.put("Menu.File.Export.RegularMultitierEAF", ma);
            this.menuBackup.setEnabled(false);
            this.menuBackup.removeAll();
            ma = new MenuAction("Menu.Edit.Undo");
            this.undoMI.setAction(ma, false);
            this.menuActions.put("Menu.Edit.Undo", ma);
            ma = new MenuAction("Menu.Edit.Redo");
            this.redoMI.setAction(ma, false);
            this.menuActions.put("Menu.Edit.Redo", ma);
        }
    }

    protected void setEmptyLayout() {
        if (this.emptyFramePanel == null) {
            this.emptyFramePanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.insets = new Insets(10, 10, 10, 5);
            gbc.fill = 2;
            gbc.weightx = 0.1;
            JPanel openPanel = new JPanel();
            BoxLayout p1BoxLayout = new BoxLayout(openPanel, 1);
            openPanel.setLayout(p1BoxLayout);
            openPanel.setBorder(new TitledBorder(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title")));
            openPanel.add(new JLabel("To open a transcription file"));
            openPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            openPanel.add(new JButton(new OpenTaSMA("Menu.File.Open", this)));
            openPanel.add(Box.createRigidArea(new Dimension(0, 15)));
            openPanel.add(new JLabel("or drop an .eaf file in this window."));
            this.emptyFramePanel.add((Component)openPanel, gbc);
            gbc.gridy = 1;
            JPanel createPanel = new JPanel();
            BoxLayout p2BoxLayout = new BoxLayout(createPanel, 1);
            createPanel.setLayout(p2BoxLayout);
            createPanel.setBorder(new TitledBorder(ElanLocale.getString("Frame.ElanFrame.NewDialog.Title")));
            createPanel.add(new JLabel("To create a new transcription file"));
            createPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            createPanel.add(new JButton(new NewTaSMA("Menu.File.New", this)));
            createPanel.add(Box.createRigidArea(new Dimension(0, 15)));
            createPanel.add(new JLabel("or drop media files in this window."));
            this.emptyFramePanel.add((Component)createPanel, gbc);
            this.emptyFramePanel.setBorder(new CompoundBorder(new EmptyBorder(10, 10, 10, 10), new LineBorder(Color.LIGHT_GRAY, 4, true)));
        }
        if (this.getContentPane().getLayout() == null) {
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.emptyFramePanel, "Center");
            this.getContentPane().invalidate();
            this.getContentPane().validate();
        } else {
            this.getContentPane().add(this.emptyFramePanel);
        }
    }

    private void localUpdateShortcutMap() {
        if (this.undoMI != null && this.undoMI.getAction() != null) {
            Action undoAC = this.undoMI.getAction();
            KeyStroke ks = ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Edit.Undo", "Menu.Options.TurnsAndSceneMode");
            undoAC.putValue("AcceleratorKey", ks);
            if (ks != null) {
                this.getRootPane().getInputMap(2).put(ks, "Menu.Edit.Undo");
                this.getRootPane().getActionMap().put("Menu.Edit.Undo", undoAC);
            }
        }
        if (this.redoMI != null && this.redoMI.getAction() != null) {
            Action redoAC = this.redoMI.getAction();
            KeyStroke reKS = ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Edit.Redo", "Menu.Options.TurnsAndSceneMode");
            redoAC.putValue("AcceleratorKey", reKS);
            if (reKS != null) {
                this.getRootPane().getInputMap(2).put(reKS, "Menu.Edit.Redo");
                this.getRootPane().getActionMap().put("Menu.Edit.Redo", redoAC);
            }
        }
    }

    @Override
    public void updateShortcutMap(String modeConstant) {
        if (modeConstant != null && !modeConstant.equals("Menu.Options.TurnsAndSceneMode")) {
            return;
        }
        if (modeConstant != null && (this.getViewerManager() == null || this.getViewerManager().getTranscription() == null)) {
            return;
        }
        ActionMap actionMap = this.getRootPane().getActionMap();
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.clear();
        actionMap.clear();
        Map<String, KeyStroke> shortMap = ShortcutsUtil.getInstance().getShortcutKeysOnlyIn("Menu.Options.TurnsAndSceneMode");
        Iterator<Map.Entry<String, KeyStroke>> shortIt = shortMap.entrySet().iterator();
        while (shortIt.hasNext()) {
            Action action = null;
            Map.Entry<String, KeyStroke> entry = shortIt.next();
            String actionName = entry.getKey();
            KeyStroke ks = entry.getValue();
            String ksDescription = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(ks);
            if (modeConstant != null && !TurnsAndSceneManager.REDEFINED_ACTIONS.contains(actionName)) {
                action = ELANCommandFactory.getCommandAction(this.getViewerManager().getTranscription(), actionName);
            }
            if (action != null) {
                String shortValue;
                action.putValue("AcceleratorKey", ks);
                if (ks != null) {
                    inputMap.put(ks, actionName);
                    actionMap.put(actionName, action);
                }
                if (ksDescription == null || ksDescription.trim().length() <= 0 || (shortValue = (String)action.getValue("ShortDescription")) == null) continue;
                action.putValue("ShortDescription", shortValue + " (" + ksDescription + ")");
                continue;
            }
            action = (Action)this.menuActions.get(actionName);
            if (action == null) continue;
            action.putValue("AcceleratorKey", ks);
            if (ks == null) continue;
            inputMap.put(ks, actionName);
            actionMap.put(actionName, action);
        }
        this.localUpdateShortcutMap();
    }

    @Override
    public void clearShortcutsMap(String modeConstant) {
        super.clearShortcutsMap("Menu.Options.TurnsAndSceneMode");
    }

    @Override
    protected void savePreferences() {
        if (this.viewerManager != null) {
            Preferences.set("MediaTime-TaS", this.viewerManager.getMasterMediaPlayer().getMediaTime(), this.transcriptionForThisFrame, false, false);
            Preferences.set("SelectionBeginTime-TaS", this.viewerManager.getSelection().getBeginTime(), this.transcriptionForThisFrame, false, false);
            Preferences.set("SelectionEndTime-TaS", this.viewerManager.getSelection().getEndTime(), this.transcriptionForThisFrame, false, false);
            Preferences.set("TimeScaleBeginTime-TaS", this.viewerManager.getTimeScale().getBeginTime(), this.transcriptionForThisFrame, false, true);
        }
        this.setPreference("Locale", ElanLocale.getLocale(), null);
        this.setPreference("FrameSize-TaS", this.getSize(), this.transcriptionForThisFrame);
        Preferences.set("FrameLocation-TaS", this.getLocation(), this.transcriptionForThisFrame, false, true);
    }

    @Override
    protected void loadPreferences() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Long timeScaleBeginTime;
                Long mediaTime;
                Long beginTime = Preferences.getLong("SelectionBeginTime-TaS", TaSFrame.this.transcriptionForThisFrame);
                Long endTime = Preferences.getLong("SelectionEndTime-TaS", TaSFrame.this.transcriptionForThisFrame);
                if (beginTime != null && endTime != null) {
                    TaSFrame.this.viewerManager.getSelection().setSelection(beginTime, endTime);
                }
                if ((mediaTime = Preferences.getLong("MediaTime-TaS", TaSFrame.this.transcriptionForThisFrame)) != null) {
                    TaSFrame.this.viewerManager.getMasterMediaPlayer().setMediaTime(mediaTime);
                }
                if ((timeScaleBeginTime = Preferences.getLong("TimeScaleBeginTime-TaS", TaSFrame.this.transcriptionForThisFrame)) != null) {
                    TaSFrame.this.viewerManager.getTimeScale().setBeginTime(timeScaleBeginTime);
                }
                TaSFrame.this.fullyInitialized = true;
                Preferences.notifyListeners(TaSFrame.this.transcriptionForThisFrame);
                if (TaSFrame.this.layoutManager != null) {
                    TaSFrame.this.layoutManager.doLayout();
                    TaSFrame.this.getRootPane().revalidate();
                }
                Toolkit.getDefaultToolkit().sync();
            }
        });
    }

    @Override
    public void saveAndClose(boolean unregister) {
        super.saveAndClose(false);
    }

    @Override
    public void doClose(boolean unregister) {
        this.savePreferences();
        if (this.transcriptionForThisFrame != null) {
            this.layoutManager.isClosing();
            if (this.viewerManager != null) {
                this.viewerManager.cleanUpOnClose();
            }
            if (this.layoutManager != null) {
                this.layoutManager.cleanUpOnClose();
                this.getContentPane().repaint();
            }
            ELANCommandFactory.removeDocument(this.viewerManager);
            Preferences.removeDocument(this.transcriptionForThisFrame);
            ElanLocale.removeElanLocaleListener(this.transcriptionForThisFrame);
            this.transcriptionForThisFrame = null;
            this.viewerManager = null;
            this.layoutManager = null;
            this.resetMenusAndCommands();
            this.setEmptyLayout();
        } else {
            System.exit(0);
        }
    }

    private class SLWindowListener
    extends WindowAdapter {
        private SLWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            if (TaSFrame.this.layoutManager != null) {
                TaSFrame.this.layoutManager.doLayout();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (TaSFrame.this.transcriptionForThisFrame != null) {
                TaSFrame.this.checkSaveAndClose();
            } else {
                TaSFrame.this.doClose(true);
            }
        }
    }

    private class SLComponentListener
    extends ComponentAdapter {
        private SLComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (TaSFrame.this.layoutManager != null) {
                TaSFrame.this.layoutManager.doLayout();
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (TaSFrame.this.layoutManager != null) {
                TaSFrame.this.layoutManager.doLayout();
            }
        }
    }
}

