/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode.commands;

import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.HTMLViewer;
import mpi.eudico.client.annotator.util.WindowLocationAndSizeManager;

public class HelpTaSMA
extends FrameMenuAction {
    private static JFrame helpDialog = null;
    private float fontSize = 14.0f;
    private final Font htmlFont = new Font("Serif", 0, (int)this.fontSize);
    private JEditorPane htmlPane;

    public HelpTaSMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (helpDialog != null) {
            helpDialog.toFront();
            return;
        }
        try {
            HTMLViewer htmlViewer = new HTMLViewer("/simple-elan.html", false, ElanLocale.getString("Menu.Help"));
            helpDialog = htmlViewer.createHTMLFrame();
            helpDialog.pack();
            if (htmlViewer.getHTMLPane() != null) {
                this.htmlPane = htmlViewer.getHTMLPane();
                this.htmlPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                this.htmlPane.setFont(this.htmlFont.deriveFont(1.2f * (float)this.htmlFont.getSize()));
            }
            helpDialog.setVisible(true);
            helpDialog.addWindowListener(new WindowHandler());
            this.addShortcutActions();
            WindowLocationAndSizeManager.postInit(helpDialog, "HelpFrame-TaS");
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("Message.LoadHelpFile"), ElanLocale.getString("Message.Warning"), 2);
        }
    }

    private void addShortcutActions() {
        if (helpDialog != null) {
            int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            FontZoomAction inAction = new FontZoomAction(1);
            String actKeyIn = "IncreaseFont";
            helpDialog.getRootPane().getActionMap().put(actKeyIn, inAction);
            helpDialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(61, menuShortcutKeyMask, false), actKeyIn);
            FontZoomAction outAction = new FontZoomAction(-1);
            String actKeyOut = "DecreaseFont";
            helpDialog.getRootPane().getActionMap().put(actKeyOut, outAction);
            helpDialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(45, menuShortcutKeyMask, false), actKeyOut);
            FontZoomAction defAction = new FontZoomAction(0);
            String actKeyDef = "DefaultFont";
            helpDialog.getRootPane().getActionMap().put(actKeyDef, defAction);
            helpDialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(48, menuShortcutKeyMask, false), actKeyDef);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            WindowLocationAndSizeManager.storeLocationAndSizePreferences(e.getWindow(), "HelpFrame-TaS");
            helpDialog.removeWindowListener(this);
            helpDialog = null;
        }
    }

    private class FontZoomAction
    extends AbstractAction {
        private int zoomDirection;

        public FontZoomAction(int zoomDirection) {
            this.zoomDirection = zoomDirection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (HelpTaSMA.this.htmlPane != null) {
                float curSize = HelpTaSMA.this.htmlPane.getFont().getSize();
                switch (this.zoomDirection) {
                    case -1: {
                        if (!(curSize >= 6.0f)) break;
                        HelpTaSMA.this.htmlPane.setFont(HelpTaSMA.this.htmlFont.deriveFont(0.8f * curSize));
                        break;
                    }
                    case 0: {
                        HelpTaSMA.this.htmlPane.setFont(HelpTaSMA.this.htmlFont.deriveFont(HelpTaSMA.this.fontSize));
                        break;
                    }
                    case 1: {
                        if (!(curSize <= 100.0f)) break;
                        HelpTaSMA.this.htmlPane.setFont(HelpTaSMA.this.htmlFont.deriveFont(1.2f * curSize));
                        break;
                    }
                }
            }
        }
    }
}

