/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode.commands;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.turnsandscenemode.TaSAnno;
import mpi.eudico.client.annotator.turnsandscenemode.TurnsAndSceneViewer;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;

public class TaSModifyTimeAction
extends AbstractAction {
    private TurnsAndSceneViewer viewer;

    public TaSModifyTimeAction(TurnsAndSceneViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.viewer != null) {
            this.modifyTime();
        }
    }

    private void modifyTime() {
        int editingRow = this.viewer.getAnnotationTable().getEditingRow();
        if (editingRow == -1) {
            ClientLogger.LOG.info("A modify time action occurred but it is unknown in which cell.");
            return;
        }
        TaSAnno curAnno = (TaSAnno)this.viewer.getAnnotationTable().getValueAt(editingRow, 0);
        Transcription transcription = this.viewer.getViewerManager().getTranscription();
        if (curAnno.getAnnotation() != null) {
            TaSAnno prevAnno;
            long curTime = this.viewer.getMediaTime();
            if (curTime >= curAnno.getBeginTime() && curTime <= curAnno.getEndTime()) {
                ClientLogger.LOG.info("Cannot update the time of the cell; media time within the current boundaries.");
                return;
            }
            if (curTime > curAnno.getEndTime()) {
                if (editingRow < this.viewer.getAnnotationTable().getRowCount() - 1) {
                    TaSAnno nextAnno = (TaSAnno)this.viewer.getAnnotationTable().getValueAt(editingRow + 1, 0);
                    if (curTime < nextAnno.getEndTime()) {
                        Command com = ELANCommandFactory.createCommand(transcription, "CommandActions.ModifyAnnotationTime");
                        com.execute(curAnno.getAnnotation(), new Object[]{curAnno.getBeginTime(), curTime});
                    }
                } else {
                    ClientLogger.LOG.info("Cannot update the end time of the last cell");
                }
            } else if (editingRow > 0 && curTime > (prevAnno = (TaSAnno)this.viewer.getAnnotationTable().getValueAt(editingRow - 1, 0)).getBeginTime()) {
                Command com = ELANCommandFactory.createCommand(transcription, "CommandActions.ModifyAnnotationTime");
                com.execute(curAnno.getAnnotation(), new Object[]{curTime, curAnno.getEndTime()});
            }
        }
    }
}

