/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode.commands;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.turnsandscenemode.TaSAnno;
import mpi.eudico.client.annotator.turnsandscenemode.TurnsAndSceneViewer;
import mpi.eudico.client.annotator.util.ClientLogger;

public class TaSPostCutAction
extends AbstractAction {
    private TurnsAndSceneViewer viewer;

    public TaSPostCutAction(TurnsAndSceneViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.viewer != null) {
            this.cutAction();
        }
    }

    private void cutAction() {
        String curText;
        int editingRow = this.viewer.getAnnotationTable().getEditingRow();
        if (editingRow == -1) {
            ClientLogger.LOG.info("A cut action occurred but it is unknown in which cell.");
            return;
        }
        TaSAnno curAnno = (TaSAnno)this.viewer.getAnnotationTable().getValueAt(editingRow, 0);
        if (curAnno.getAnnotation() != null && (curText = this.viewer.getEditor().getTextArea().getText()) != null && !curText.equals(curAnno.getAnnotation().getValue())) {
            Command com = ELANCommandFactory.createCommand(this.viewer.getViewerManager().getTranscription(), "Menu.Annotation.ModifyAnnotation");
            com.execute(curAnno.getAnnotation(), new Object[]{curAnno.getAnnotation().getValue(), curText});
        }
    }
}

