/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.type;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class LinguisticTypeTableModel
extends AbstractTableModel {
    public static final String LABEL_PREF = "EditTypeDialog.Label.";
    public static final String NAME = "Type";
    public static final String STEREOTYPE = "Stereotype";
    public static final String TIME_ALIGNABLE = "TimeAlignable";
    public static final String CV_NAME = "CV";
    public static final String DC_ID = "DCR";
    public static final String SELECT = "Selected";
    public static final String N_A = "-";
    private ArrayList<LinguisticType> types;
    private int[] currentShownStereoTypes;
    private List<String> columnIds;
    private List<List<Object>> data;
    private List<Class> classes;

    public LinguisticTypeTableModel() {
        this(null);
    }

    public LinguisticTypeTableModel(List<LinguisticType> allTypes) {
        this.types = allTypes != null ? new ArrayList<LinguisticType>(allTypes) : new ArrayList(0);
        this.columnIds = new ArrayList<String>();
        this.columnIds.add(SELECT);
        this.columnIds.add(NAME);
        this.columnIds.add(STEREOTYPE);
        this.columnIds.add(CV_NAME);
        this.columnIds.add(DC_ID);
        this.columnIds.add(TIME_ALIGNABLE);
        this.classes = new ArrayList<Class>(this.columnIds.size());
        this.classes.add(Boolean.class);
        this.classes.add(String.class);
        this.classes.add(String.class);
        this.classes.add(String.class);
        this.classes.add(String.class);
        this.classes.add(Boolean.class);
        this.initData();
    }

    public LinguisticTypeTableModel(List<LinguisticType> allTypes, String[] columns) {
        this.types = allTypes != null ? new ArrayList<LinguisticType>(allTypes) : new ArrayList(0);
        this.columnIds = new ArrayList<String>();
        this.classes = new ArrayList<Class>();
        if (columns != null) {
            for (String column : columns) {
                if (column.equals(SELECT)) {
                    this.columnIds.add(SELECT);
                    this.classes.add(Boolean.class);
                    continue;
                }
                if (column.equals(NAME)) {
                    this.columnIds.add(NAME);
                    this.classes.add(String.class);
                    continue;
                }
                if (column.equals(STEREOTYPE)) {
                    this.columnIds.add(STEREOTYPE);
                    this.classes.add(String.class);
                    continue;
                }
                if (column.equals(CV_NAME)) {
                    this.columnIds.add(CV_NAME);
                    this.classes.add(String.class);
                    continue;
                }
                if (column.equals(DC_ID)) {
                    this.columnIds.add(DC_ID);
                    this.classes.add(String.class);
                    continue;
                }
                if (!column.equals(TIME_ALIGNABLE)) continue;
                this.columnIds.add(TIME_ALIGNABLE);
                this.classes.add(Boolean.class);
            }
        } else {
            this.columnIds.add(SELECT);
            this.columnIds.add(NAME);
            this.columnIds.add(STEREOTYPE);
            this.columnIds.add(CV_NAME);
            this.columnIds.add(DC_ID);
            this.columnIds.add(TIME_ALIGNABLE);
            this.classes.add(Boolean.class);
            this.classes.add(String.class);
            this.classes.add(String.class);
            this.classes.add(String.class);
            this.classes.add(String.class);
            this.classes.add(Boolean.class);
        }
        this.initData();
    }

    private void initData() {
        this.initData(this.currentShownStereoTypes);
    }

    private void initData(int[] theseTypes) {
        this.data = new ArrayList<List<Object>>(this.types.size());
        for (int i = 0; i < this.types.size(); ++i) {
            boolean add;
            LinguisticType type = this.types.get(i);
            boolean bl = add = theseTypes == null;
            if (!add) {
                int stereotype = -1;
                if (type.hasConstraints()) {
                    stereotype = type.getConstraints().getStereoType();
                }
                for (int theseType : theseTypes) {
                    if (stereotype != theseType) continue;
                    add = true;
                    break;
                }
            }
            if (!add) continue;
            this.addRowData(type);
        }
        this.fireTableDataChanged();
    }

    private void addRowData(LinguisticType type) {
        if (type == null) {
            return;
        }
        ArrayList<Object> rowData = new ArrayList<Object>(this.getColumnCount());
        if (this.columnIds.indexOf(SELECT) > -1) {
            rowData.add(this.columnIds.indexOf(SELECT), Boolean.FALSE);
        }
        if (this.columnIds.indexOf(NAME) > -1) {
            rowData.add(this.columnIds.indexOf(NAME), type.getLinguisticTypeName());
        }
        if (this.columnIds.indexOf(STEREOTYPE) > -1) {
            String stereoTypeName = N_A;
            if (type.hasConstraints()) {
                stereoTypeName = Constraint.stereoTypes[type.getConstraints().getStereoType()];
            }
            rowData.add(this.columnIds.indexOf(STEREOTYPE), stereoTypeName);
        }
        if (this.columnIds.indexOf(CV_NAME) > -1) {
            String cvName = N_A;
            if (type.isUsingControlledVocabulary()) {
                cvName = type.getControlledVocabularyName();
            }
            rowData.add(this.columnIds.indexOf(CV_NAME), cvName);
        }
        if (this.columnIds.indexOf(DC_ID) > -1) {
            String dcId = N_A;
            if (type.getDataCategory() != null) {
                dcId = type.getDataCategory();
            }
            rowData.add(this.columnIds.indexOf(DC_ID), dcId);
        }
        if (this.columnIds.indexOf(TIME_ALIGNABLE) > -1) {
            rowData.add(this.columnIds.indexOf(TIME_ALIGNABLE), type.isTimeAlignable());
        }
        this.data.add(rowData);
    }

    public void showOnlyStereoTypes(int[] theseTypes) {
        this.currentShownStereoTypes = theseTypes;
        this.initData();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnIds.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.data.size() || columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            return null;
        }
        List<Object> row = this.data.get(rowIndex);
        return row.get(columnIndex);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int findColumn(String columnName) {
        return this.columnIds.indexOf(columnName);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.classes.size()) {
            return null;
        }
        return this.classes.get(columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            return "";
        }
        return ElanLocale.getString(LABEL_PREF + this.columnIds.get(columnIndex));
    }

    public void removeRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.data.size()) {
            this.data.remove(rowIndex);
            this.types.remove(rowIndex);
            this.fireTableDataChanged();
        }
    }

    public void removeAllRows() {
        this.data.clear();
        this.types.clear();
        this.fireTableDataChanged();
    }

    public void addRow(LinguisticType type) {
        if (type == null || this.types.contains(type)) {
            return;
        }
        this.types.add(type);
        if (this.currentShownStereoTypes == null) {
            this.addRowData(type);
            this.fireTableDataChanged();
        } else {
            int stereotype = -1;
            if (type.hasConstraints()) {
                stereotype = type.getConstraints().getStereoType();
            }
            for (int currentShownStereoType : this.currentShownStereoTypes) {
                if (stereotype != currentShownStereoType) continue;
                this.addRowData(type);
                this.fireTableDataChanged();
                break;
            }
        }
    }

    public void addLinguisticType(LinguisticType type) {
        this.addRow(type);
    }

    public void rowDataChanged() {
        this.initData();
        this.fireTableDataChanged();
    }
}

