/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.TimeInterval;
import mpi.eudico.util.TimeIntervalComparator;

public class AnnotationSlicer {
    public static List<Long> getTimeValues(List<TierImpl> tierList) {
        if (tierList == null) {
            return null;
        }
        ArrayList<Long> timeSlotList = new ArrayList<Long>();
        for (int i = 0; i < tierList.size(); ++i) {
            Tier tier = tierList.get(i);
            List<? extends Annotation> annotations = tier.getAnnotations();
            for (int a = 0; a < annotations.size(); ++a) {
                long time = annotations.get(a).getBeginTimeBoundary();
                if (!timeSlotList.contains(time)) {
                    timeSlotList.add(time);
                }
                if (timeSlotList.contains(time = annotations.get(a).getEndTimeBoundary())) continue;
                timeSlotList.add(time);
            }
        }
        Collections.sort(timeSlotList);
        return timeSlotList;
    }

    public static Map<Long, List<Annotation>> getAnnotationMap(List<Long> timeValuesList, List<TierImpl> tierList) {
        HashMap<Long, List<Annotation>> map = new HashMap<Long, List<Annotation>>();
        for (int i = 0; i < timeValuesList.size(); ++i) {
            long currentTimeValue = timeValuesList.get(i);
            ArrayList<Annotation> annList = new ArrayList<Annotation>();
            for (int t = 0; t < tierList.size(); ++t) {
                Annotation ann = tierList.get(t).getAnnotationAtTime(currentTimeValue);
                if (ann == null) continue;
                annList.add(ann);
            }
            map.put(currentTimeValue, annList);
        }
        return map;
    }

    public static SortedMap<TimeInterval, List<Annotation>> getIntervalAnnotationMap(List<Long> timeValuesList, List<TierImpl> tierList) {
        if (timeValuesList == null || timeValuesList.isEmpty()) {
            return null;
        }
        if (tierList == null || tierList.isEmpty()) {
            return null;
        }
        TreeMap<TimeInterval, List<Annotation>> map = new TreeMap<TimeInterval, List<Annotation>>(new TimeIntervalComparator());
        for (int i = 0; i < timeValuesList.size() - 1; ++i) {
            Long time1 = timeValuesList.get(i);
            Long time2 = timeValuesList.get(i + 1);
            long mid = (time1 + time2) / 2L;
            ArrayList<Annotation> annList = new ArrayList<Annotation>();
            boolean anyNonNull = false;
            for (TierImpl t : tierList) {
                Annotation a = t.getAnnotationAtTime(mid);
                if (a != null) {
                    anyNonNull = true;
                }
                annList.add(a);
            }
            if (!anyNonNull) continue;
            map.put(new TimeInterval(time1, time2), annList);
        }
        return map;
    }
}

