/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.util.ClientLogger;

public class ClipWithScriptUtil {
    public File getScriptFile(String scriptFileName) {
        File f = new File(Constants.ELAN_DATA_DIR + File.separator + scriptFileName);
        if (f.exists() && f.isFile() && f.canRead()) {
            return f;
        }
        f = new File(System.getProperty("user.dir") + File.separator + scriptFileName);
        if (f.exists() && f.isFile() && f.canRead()) {
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] parseScriptLine(File scriptFile) {
        if (scriptFile != null) {
            String executable = null;
            String paramLine = null;
            FileReader fileRead = null;
            BufferedReader bufRead = null;
            try {
                fileRead = new FileReader(scriptFile);
                bufRead = new BufferedReader(fileRead);
                String line = null;
                while ((line = bufRead.readLine()) != null) {
                    int index;
                    if (line.length() == 0 || line.startsWith("#")) continue;
                    if ((line = line.trim()).startsWith("\"")) {
                        index = line.indexOf("\"", 1);
                        if (index > -1) {
                            executable = line.substring(1, index);
                            if (index >= line.length() - 2) continue;
                            paramLine = line.substring(index + 2);
                            continue;
                        }
                        executable = null;
                        continue;
                    }
                    index = line.indexOf(32);
                    if (index <= 0) continue;
                    executable = line.substring(0, index);
                    if (index >= line.length() - 1) continue;
                    paramLine = line.substring(index + 1);
                }
                if (executable != null && paramLine != null) {
                    String[] stringArray = new String[]{executable, paramLine};
                    return stringArray;
                }
            }
            catch (FileNotFoundException fnfe) {
                ClientLogger.LOG.warning("The script file can not be found");
                executable = null;
                paramLine = null;
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Error while reading the script file " + ioe.getMessage());
                executable = null;
                paramLine = null;
            }
            finally {
                try {
                    if (fileRead != null) {
                        fileRead.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (bufRead != null) {
                        bufRead.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

