/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.client.util.TranscriptionECVLoader;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.util.ProcessReporter;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.Pair;

public class CorpusECVUpdater {
    private File inputFolder;
    private String inputFolderString;
    private File outputFolder;
    private String outputFolderString;
    private String forcedLanguage;
    private HashMap<String, List<ExternalCV>> urlMap;
    private static final String FLANGKEY = "fLang";
    private static final String FOLDERSKEY = "folders";
    private ProcessReporter reporter = null;
    private Boolean recursive = true;
    private ProgressListener progressListerner;
    private Boolean canceled = false;
    private Map<String, Integer> unknownAnnotations;
    private boolean annotationValuePrecedence = false;

    private CorpusECVUpdater() {
    }

    public CorpusECVUpdater(ProcessReporter reporter) {
        this.reporter = reporter;
    }

    public CorpusECVUpdater(ProcessReporter reporter, ProgressListener progressListener) {
        this.reporter = reporter;
        this.progressListerner = progressListener;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("No folder containing eaf files specified");
            System.out.println("Usage: java (...) CorpusECVUpdater [-L lng] inputfolder [outputfolder]");
            System.exit(1);
        }
        try {
            Map<String, Object> parsedArgs = CorpusECVUpdater.parseArgs(args);
            String fLang = (String)parsedArgs.get(FLANGKEY);
            String[] folders = (String[])parsedArgs.get(FOLDERSKEY);
            System.out.println("Input folder is: " + folders[0]);
            if (folders[1] != null) {
                System.out.println("Output folder is: " + folders[1]);
            } else {
                System.out.println("No output folder specified, overwriting files");
            }
            CorpusECVUpdater cECV = new CorpusECVUpdater();
            int success = cECV.updateFiles(folders, fLang);
            System.out.println("Exit Program: " + success);
            System.exit(success);
        }
        catch (Exception e) {
            System.out.println("The command line arguments are not correct");
            System.out.println("Usage: java (...) CorpusECVUpdater [-L lng] inputfolder [outputfolder]");
            System.exit(1);
        }
    }

    private static Map<String, Object> parseArgs(String[] args) {
        HashMap<String, Object> parsedArgs = new HashMap<String, Object>();
        String fLang = null;
        String[] folders = new String[2];
        if (args.length >= 3) {
            if (args[0].toLowerCase().equals("-l")) {
                fLang = args[1];
                System.out.println("Language to apply is: " + fLang);
                folders[0] = args[2];
                if (args.length > 3) {
                    folders[1] = args[3];
                }
            } else {
                folders[0] = args[0];
                folders[1] = args[1];
            }
        } else {
            folders[0] = args[0];
            if (args.length > 1) {
                folders[1] = args[1];
            }
        }
        System.out.println("Input folder is: " + folders[0]);
        if (folders[1] != null) {
            System.out.println("Output folder is: " + folders[1]);
        } else {
            System.out.println("No output folder specified, overwriting files");
        }
        parsedArgs.put(FLANGKEY, fLang);
        parsedArgs.put(FOLDERSKEY, folders);
        return parsedArgs;
    }

    public int updateFiles(String[] folders, String forceLang) {
        block6: {
            this.forcedLanguage = forceLang;
            this.unknownAnnotations = new HashMap<String, Integer>();
            try {
                this.inputFolder = new File(folders[0]);
                if (!this.inputFolder.exists() || !this.inputFolder.isDirectory()) {
                    System.out.println("The specified path is not a folder containing eaf files: " + folders[0]);
                    return 2;
                }
                this.inputFolderString = this.inputFolder.getAbsolutePath().replace('\\', '/');
                this.outputFolder = null;
                if (folders.length > 1 && folders[1] != null) {
                    boolean created;
                    this.outputFolder = new File(folders[1]);
                    if (!this.outputFolder.exists() && !(created = this.outputFolder.mkdirs())) {
                        System.out.println("Could not create the output folder: " + folders[1]);
                        return 4;
                    }
                    this.outputFolderString = this.outputFolder.getAbsolutePath().replace('\\', '/');
                }
                this.processFileOrDirectory(this.inputFolder, true);
            }
            catch (Throwable t) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block6;
                ClientLogger.LOG.warning("Error while processing files (" + t.getMessage() + ")");
            }
        }
        this.logMessage("\n");
        for (String unknownAnnotation : this.unknownAnnotations.keySet()) {
            this.logMessage("UNKNOWN ANNOTATION: " + unknownAnnotation + " " + this.unknownAnnotations.get(unknownAnnotation));
        }
        return 0;
    }

    private void processFileOrDirectory(File file, Boolean rootFolder) {
        if (file.isDirectory() && (this.recursive.booleanValue() || rootFolder.booleanValue())) {
            File[] subList;
            for (File f : subList = file.listFiles()) {
                if (!this.canceled.booleanValue()) {
                    this.processFileOrDirectory(f, false);
                    continue;
                }
                break;
            }
        } else {
            this.processFile(file);
        }
    }

    private void processFile(File file) {
        if (file.isDirectory()) {
            System.out.println("Error: method called with folder as argument");
        } else {
            try {
                if (file.getName().toLowerCase().endsWith(".eaf")) {
                    if (this.progressListerner != null) {
                        this.progressListerner.progressUpdated(this, -1, file.getAbsolutePath());
                    }
                    this.logMessage("\nFILE: " + file.getAbsolutePath());
                    TranscriptionImpl t = new TranscriptionImpl(file.getAbsolutePath());
                    t.setNotifying(false);
                    t.setUnchanged();
                    if (t.getControlledVocabularies().size() > 0) {
                        boolean allCVSReplaced = true;
                        if (this.urlMap != null) {
                            allCVSReplaced = this.updateAlreadyLoadedCVS(this.urlMap, t);
                        }
                        if (this.urlMap == null || !allCVSReplaced) {
                            TranscriptionECVLoader tl = new TranscriptionECVLoader();
                            tl.loadExternalCVs(t, null, false);
                            this.updateAnnotations(t);
                            this.urlMap = new HashMap<String, List<ExternalCV>>(tl.getLoadedECVMap());
                            CorpusECVUpdater.removeACMEditableObjects(this.urlMap);
                        }
                    }
                    if (this.outputFolder == null) {
                        if (t.isChanged()) {
                            System.out.println("Updated file: " + file.getName());
                            ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscription(t, null, null, 0);
                        }
                    } else {
                        File osFile;
                        String nextPath = file.getAbsolutePath().replace('\\', '/');
                        String outputSubFolder = (nextPath = nextPath.replaceFirst(this.inputFolderString, this.outputFolderString)).substring(0, nextPath.lastIndexOf(47));
                        if (!outputSubFolder.equals(this.outputFolderString) && !(osFile = new File(outputSubFolder)).exists()) {
                            osFile.mkdirs();
                        }
                        if (t.isChanged()) {
                            ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscription(t, null, null, nextPath, 0);
                        }
                    }
                    if (t.isChanged()) {
                        System.out.println("Processed file: " + file.getName());
                    }
                    Preferences.removeDocument(t);
                }
            }
            catch (IOException ioe) {
                System.out.println("Error while processing file: " + ioe.getMessage());
            }
        }
    }

    private static void removeACMEditableObjects(HashMap<String, List<ExternalCV>> loadedMap) {
        Iterator<List<ExternalCV>> ecvIter = loadedMap.values().iterator();
        while (ecvIter.hasNext()) {
            List<ExternalCV> ecvList = loadedMap.get(ecvIter.next());
            if (ecvList == null) continue;
            for (ExternalCV ecv : ecvList) {
                if (ecv == null) continue;
                ecv.removeACMEditableObject();
            }
        }
    }

    private boolean updateAlreadyLoadedCVS(HashMap<String, List<ExternalCV>> loadedMap, TranscriptionImpl t) {
        int numReplacedECV = 0;
        boolean allCVSInMap = true;
        for (int i = 0; i < t.getControlledVocabularies().size(); ++i) {
            String urlString;
            ExternalReference er;
            ExternalCV ecv;
            ControlledVocabulary cv = t.getControlledVocabularies().get(i);
            if (!(cv instanceof ExternalCV) || (ecv = (ExternalCV)cv).isLoadedFromURL() || (er = ecv.getExternalRef()).getReferenceType() != 4 || (urlString = er.getValue()) == null) continue;
            List<ExternalCV> loadedECV = loadedMap.get(urlString);
            if (loadedECV != null) {
                for (ExternalCV lECV : loadedECV) {
                    if (!lECV.getName().equals(ecv.getName())) continue;
                    t.getControlledVocabularies().remove(i);
                    t.getControlledVocabularies().add(i, lECV);
                    ++numReplacedECV;
                    t.setUnchanged();
                }
                continue;
            }
            allCVSInMap = false;
        }
        if (numReplacedECV > 0) {
            this.updateAnnotations(t);
        }
        return allCVSInMap;
    }

    private void updateAnnotations(TranscriptionImpl t) {
        for (TierImpl tier : t.getTiers()) {
            ExternalCV ecv;
            ControlledVocabulary cv;
            Pair<ControlledVocabulary, Integer> pair = tier.getEffectiveLanguage();
            if (pair == null) continue;
            int tierLangIndex = pair.getSecond();
            LinguisticType lt = tier.getLinguisticType();
            String cvname = lt.getControlledVocabularyName();
            if (cvname == null || cvname.isEmpty() || (cv = t.getControlledVocabulary(cvname)) == null || !(cv instanceof ExternalCV) || !(ecv = (ExternalCV)cv).isLoadedFromURL() && !ecv.isLoadedFromCache()) continue;
            int langIndex = cv.getIndexOfLanguage(this.forcedLanguage);
            if (langIndex < 0) {
                if (tierLangIndex < 0) continue;
                langIndex = tierLangIndex;
            }
            for (AbstractAnnotation currentAnn : tier.getAnnotations()) {
                String value;
                CVEntry cvEntry;
                String cvEntryRefId = currentAnn.getCVEntryId();
                if (cvEntryRefId == null) {
                    if (currentAnn.getValue().isEmpty()) continue;
                    cvEntry = ecv.getEntryWithValue(langIndex, currentAnn.getValue());
                    if (cvEntry != null) {
                        this.logMessage("TIER: " + tier.getName() + " - ANNOTATION_ID: " + currentAnn.getId() + " - ANNOTATION_VALUE: " + currentAnn.getValue() + " !! CVE_REF added: " + cvEntry.getId() + " - " + cvEntry.getValue(langIndex));
                        currentAnn.setCVEntryId(cvEntry.getId());
                        t.setChanged();
                        continue;
                    }
                    this.logMessage("TIER: " + tier.getName() + " - ANNOTATION_ID: " + currentAnn.getId() + " - ANNOTATION_VALUE: " + currentAnn.getValue() + " !! Annotation not in ECV");
                    this.registerUnknownAnnotation(currentAnn.getValue());
                    continue;
                }
                if (this.annotationValuePrecedence) {
                    if (currentAnn.getValue().isEmpty()) continue;
                    cvEntry = ecv.getEntryWithValue(langIndex, currentAnn.getValue());
                    if (cvEntry != null) {
                        if (cvEntryRefId.equals(cvEntry.getId())) continue;
                        this.logMessage("TIER: " + tier.getName() + " - ANNOTATION_ID: " + currentAnn.getId() + " - ANNOTATION_VALUE: " + currentAnn.getValue() + " !! CVE_REF updated: " + cvEntryRefId + " => " + cvEntry.getId());
                        currentAnn.setCVEntryId(cvEntry.getId());
                        t.setChanged();
                        continue;
                    }
                    this.logMessage("TIER: " + tier.getName() + " - ANNOTATION_ID: " + currentAnn.getId() + " - ANNOTATION_VALUE: " + currentAnn.getValue() + " !! CVE_REF removed: " + cvEntryRefId);
                    currentAnn.setCVEntryId(null);
                    t.setChanged();
                    this.logMessage("TIER: " + tier.getName() + " - ANNOTATION_ID: " + currentAnn.getId() + " - ANNOTATION_VALUE: " + currentAnn.getValue() + " !! Annotation not in ECV");
                    this.registerUnknownAnnotation(currentAnn.getValue());
                    continue;
                }
                CVEntry entry = ecv.getEntrybyId(cvEntryRefId);
                if (entry != null && (value = entry.getValue(langIndex)) != null && !value.equals(currentAnn.getValue())) {
                    this.logMessage("TIER: " + tier.getName() + " - ANNOTATION_ID: " + currentAnn.getId() + " !! ANNOTATION_VALUE changed: " + currentAnn.getValue() + " => " + value);
                    currentAnn.setValue(value);
                    t.setChanged();
                    continue;
                }
                if (entry != null) continue;
                this.logMessage("TIER: " + tier.getName() + " - ANNOTATION_ID: " + currentAnn.getId() + " - ANNOTATION_VALUE: " + currentAnn.getValue() + " !! CVE_REF removed: " + currentAnn.getCVEntryId());
                currentAnn.setCVEntryId(null);
                t.setChanged();
            }
        }
    }

    private void logMessage(String msg) {
        if (this.reporter == null) {
            System.out.println(msg);
        } else {
            this.reporter.report(msg);
        }
    }

    private void registerUnknownAnnotation(String ann) {
        if (this.unknownAnnotations.containsKey(ann)) {
            this.unknownAnnotations.put(ann, this.unknownAnnotations.get(ann) + 1);
        } else {
            this.unknownAnnotations.put(ann, 1);
        }
    }

    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    public void cancel() {
        this.canceled = true;
    }

    public boolean isAnnotationValuePrecedence() {
        return this.annotationValuePrecedence;
    }

    public void setAnnotationValuePrecedence(boolean annotationValuePrecedence) {
        this.annotationValuePrecedence = annotationValuePrecedence;
    }

    @Deprecated
    public static void runInNewJVM(String lang, String inputdir, String outputdir, String reportfile) throws Exception {
        String separator = System.getProperty("file.separator");
        String classpath = System.getProperty("java.class.path");
        String path = System.getProperty("java.home") + separator + "bin" + separator + "java";
        ProcessBuilder processBuilder = new ProcessBuilder(path, "-Xmx2048m", "-cp", classpath, CorpusECVUpdater.class.getName(), "-L", lang, inputdir, outputdir);
        processBuilder.toString();
        Process process = processBuilder.start();
        InputStream in = process.getInputStream();
        int size = 0;
        byte[] buffer = new byte[1024];
        while ((size = in.read(buffer)) != -1) {
            System.out.write(buffer, 0, size);
        }
        InputStream error = process.getErrorStream();
        int sizeErr = 0;
        byte[] bufferErr = new byte[1024];
        while ((sizeErr = error.read(bufferErr)) != -1) {
            System.out.write(bufferErr, 0, sizeErr);
        }
        process.waitFor();
    }
}

