/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.util.AnnotationDataFlavor;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.util.TimeFormatter;

public class TransferableAnnotation
implements Transferable,
ClipboardOwner {
    private AnnotationDataRecord record;
    private static final DataFlavor[] flavors;
    private static final int STRING = 0;
    private static final int ANNOTATION = 1;
    private String copyOption = "annotation + begintime + endtime";
    private String prefTimeFormat = null;
    private boolean useCopyCurrentTimeFormat = false;

    public TransferableAnnotation(AnnotationDataRecord record) {
        Boolean boolPref;
        if (record == null) {
            throw new NullPointerException("AnnotationDataRecord is null.");
        }
        this.record = record;
        String stringPref = Preferences.getString("EditingPanel.CopyOption", null);
        if (stringPref != null) {
            this.copyOption = stringPref;
        }
        this.prefTimeFormat = Preferences.getString("CurrentTime.Copy.TimeFormat", null);
        if (this.prefTimeFormat != null && (boolPref = Preferences.getBool("CopyAnnotation.UseCopyCurrentTimeFormat", null)) != null) {
            this.useCopyCurrentTimeFormat = boolPref;
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor == null) {
            return false;
        }
        for (DataFlavor flavor2 : flavors) {
            if (!flavor.equals(flavor2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (flavors.length > 1 && flavor.equals(flavors[1])) {
            return this.record;
        }
        if (flavor.equals(flavors[0])) {
            return this.recordParamString();
        }
        return null;
    }

    private String recordParamString() {
        if (this.record != null) {
            if (this.copyOption.equals("annotation only")) {
                return this.record.getValue();
            }
            if (this.copyOption.equals("filename + tiername + begintime + endtime")) {
                String fileName = this.record.getFilePath();
                if (fileName != null) {
                    if (fileName.indexOf(47) > -1 && fileName.lastIndexOf(47) < fileName.length() - 2) {
                        fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                    }
                    return this.record.getValue() + " (" + fileName + ", " + this.record.getTierName() + ", " + this.getFormattedTime(this.record.getBeginTime()) + ", " + this.getFormattedTime(this.record.getEndTime()) + ")";
                }
                return this.record.getValue() + ",T=" + this.record.getTierName() + ",B=" + this.getFormattedTime(this.record.getBeginTime()) + ",E=" + this.getFormattedTime(this.record.getEndTime());
            }
            return this.record.getValue() + ",T=" + this.record.getTierName() + ",B=" + this.getFormattedTime(this.record.getBeginTime()) + ",E=" + this.getFormattedTime(this.record.getEndTime());
        }
        return "null";
    }

    private String getFormattedTime(long time) {
        if (this.prefTimeFormat != null && this.useCopyCurrentTimeFormat) {
            if (this.prefTimeFormat.equals("hh:mm:ss.ms")) {
                return TimeFormatter.toString(time);
            }
            if (this.prefTimeFormat.equals("ss.ms")) {
                return TimeFormatter.toSSMSString(time);
            }
            if (this.prefTimeFormat.equals("NTSC")) {
                return TimeFormatter.toTimecodeNTSC(time);
            }
            if (this.prefTimeFormat.equals("PAL")) {
                return TimeFormatter.toTimecodePAL(time);
            }
            if (this.prefTimeFormat.equals("PAL-50fps")) {
                return TimeFormatter.toTimecodePAL50(time);
            }
        }
        return String.valueOf(time);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.record = null;
    }

    static {
        AnnotationDataFlavor flav = AnnotationDataFlavor.getInstance();
        flavors = flav == null ? new DataFlavor[]{DataFlavor.stringFlavor} : new DataFlavor[]{DataFlavor.stringFlavor, flav};
    }
}

