/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import mpi.eudico.client.annotator.Preferences;

public class WindowLocationAndSizeManager {
    public static void postInit(Window window, String prefPrefix) {
        WindowLocationAndSizeManager.postInit(window, prefPrefix, 0, 0);
    }

    public static void postInit(Window window, String prefPrefix, int minimalWidth, int minimalHeight) {
        int targetH;
        int targetW;
        window.pack();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Insets ins = Toolkit.getDefaultToolkit().getScreenInsets(ge.getDefaultScreenDevice().getDefaultConfiguration());
        int maxW = dim.width - ins.left - ins.right;
        int maxH = dim.height - ins.top - ins.bottom;
        Point location = null;
        Dimension size = null;
        if (prefPrefix != null) {
            location = Preferences.getPoint(prefPrefix + ".Location", null);
            size = Preferences.getDimension(prefPrefix + ".Size", null);
        }
        if (location != null) {
            Point p = location;
            int x = p.x <= maxW - 50 ? p.x : maxW - 50;
            int y = p.y <= maxH - 50 ? p.y : maxH - 50;
            window.setLocation(x, y);
        } else {
            window.setLocationRelativeTo(window.getParent());
        }
        if (size != null) {
            Dimension d = size;
            targetW = d.width < maxW ? d.width : maxW;
            targetH = d.height < maxH ? d.height : maxH;
        } else {
            targetW = window.getSize().width < minimalWidth ? minimalWidth : window.getSize().width;
            targetW = targetW > maxW ? maxW : targetW;
            targetH = window.getSize().height < minimalHeight ? minimalHeight : window.getSize().height;
            targetH = targetH > maxH ? maxH : targetH;
        }
        window.setSize(targetW, targetH);
    }

    public static void storeLocationAndSizePreferences(Window window, String prefPrefix) {
        if (window != null && prefPrefix != null) {
            Point p = window.getLocation();
            Dimension d = window.getSize();
            Preferences.set(prefPrefix + ".Location", p, null, false, false);
            Preferences.set(prefPrefix + ".Size", d, null, false, false);
        }
    }
}

