/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import javax.swing.JComponent;
import mpi.eudico.client.annotator.ActiveAnnotation;
import mpi.eudico.client.annotator.ActiveAnnotationUser;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.MediaPlayerUser;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesUser;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.SelectionUser;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.viewer.Viewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;

public abstract class AbstractViewer
extends JComponent
implements ControllerListener,
MediaPlayerUser,
SelectionUser,
ActiveAnnotationUser,
ElanLocaleListener,
Viewer,
PreferencesUser {
    private ViewerManager2 viewerManager;
    private ElanMediaPlayer player;
    private Selection selection;
    private ActiveAnnotation activeAnnotation;

    @Override
    public abstract void controllerUpdate(ControllerEvent var1);

    @Override
    public void setViewerManager(ViewerManager2 viewerManager) {
        this.viewerManager = viewerManager;
    }

    @Override
    public ViewerManager2 getViewerManager() {
        return this.viewerManager;
    }

    @Override
    public void setPlayer(ElanMediaPlayer player) {
        this.player = player;
    }

    @Override
    public void startPlayer() {
        if (this.player == null) {
            return;
        }
        this.player.start();
    }

    @Override
    public void playInterval(long startTime, long stopTime) {
        if (this.player == null) {
            return;
        }
        this.player.playInterval(startTime, stopTime);
    }

    @Override
    public void stopPlayer() {
        if (this.player == null) {
            return;
        }
        this.player.stop();
        this.viewerManager.getMediaPlayerController().stopLoop();
    }

    @Override
    public boolean playerIsPlaying() {
        if (this.player == null) {
            return false;
        }
        return this.player.isPlaying();
    }

    @Override
    public void setMediaTime(long milliSeconds) {
        if (this.player == null) {
            return;
        }
        this.player.setMediaTime(milliSeconds);
        this.viewerManager.getMediaPlayerController().stopLoop();
    }

    @Override
    public long getMediaTime() {
        if (this.player == null) {
            return 0L;
        }
        return this.player.getMediaTime();
    }

    @Override
    public void setRate(float rate) {
        if (this.player == null) {
            return;
        }
        this.player.setRate(rate);
    }

    @Override
    public float getRate() {
        if (this.player == null) {
            return 0.0f;
        }
        return this.player.getRate();
    }

    @Override
    public long getMediaDuration() {
        if (this.player == null) {
            return 0L;
        }
        return this.player.getMediaDuration();
    }

    @Override
    public void mediaOffsetChanged() {
        this.repaint();
    }

    @Override
    public float getVolume() {
        if (this.player == null) {
            return 0.0f;
        }
        return this.viewerManager.getVolumeManager().getSubVolume(this.player);
    }

    @Override
    public void setVolume(float level) {
        if (this.player == null) {
            return;
        }
        this.viewerManager.getVolumeManager().setSubVolume(this.player, level);
    }

    @Override
    public void setSelectionObject(Selection selection) {
        this.selection = selection;
    }

    @Override
    public void setSelection(long begin, long end) {
        if (this.selection == null) {
            return;
        }
        if (begin == end) {
            this.selection.setSelection(begin, end);
            return;
        }
        TierImpl constrainingTier = null;
        if (this.getActiveAnnotation() != null) {
            constrainingTier = (TierImpl)this.getActiveAnnotation().getTier();
        } else if (this.getViewerManager().getMultiTierControlPanel() != null) {
            constrainingTier = (TierImpl)this.getViewerManager().getMultiTierControlPanel().getActiveTier();
        }
        if (constrainingTier != null && constrainingTier.getLinguisticType().hasConstraints()) {
            Constraint c = constrainingTier.getLinguisticType().getConstraints();
            long[] segment = new long[]{begin, end};
            TierImpl parent = constrainingTier.getParentTier();
            if (this.getActiveAnnotation() == null || !(this.getActiveAnnotation() instanceof AlignableAnnotation)) {
                c.forceTimes(segment, parent);
            } else {
                Annotation pa = this.getActiveAnnotation().getParentAnnotation();
                if (pa != null && pa instanceof AlignableAnnotation) {
                    segment[0] = begin < pa.getBeginTimeBoundary() ? pa.getBeginTimeBoundary() : begin;
                    segment[1] = end > pa.getEndTimeBoundary() ? pa.getEndTimeBoundary() : end;
                } else {
                    c.forceTimes(segment, parent);
                }
            }
            begin = segment[0];
            end = segment[1];
        }
        this.selection.setSelection(begin, end);
    }

    public void isClosing() {
    }

    public void setSelection(Annotation annotation) {
        if (this.selection == null) {
            return;
        }
        this.selection.setSelection(annotation);
    }

    @Override
    public long getSelectionBeginTime() {
        if (this.selection == null) {
            return 0L;
        }
        return this.selection.getBeginTime();
    }

    @Override
    public long getSelectionEndTime() {
        if (this.selection == null) {
            return 0L;
        }
        return this.selection.getEndTime();
    }

    @Override
    public abstract void updateSelection();

    @Override
    public void setActiveAnnotationObject(ActiveAnnotation activeAnnotation) {
        this.activeAnnotation = activeAnnotation;
    }

    @Override
    public Annotation getActiveAnnotation() {
        if (this.activeAnnotation == null) {
            return null;
        }
        return this.activeAnnotation.getAnnotation();
    }

    @Override
    public void setActiveAnnotation(Annotation annotation) {
        if (this.activeAnnotation == null) {
            return;
        }
        Command c = ELANCommandFactory.createCommand(this.getViewerManager().getTranscription(), "Commands.ActiveAnnotation");
        c.execute(this.getViewerManager(), new Object[]{annotation});
    }

    @Override
    public abstract void updateActiveAnnotation();

    @Override
    public abstract void updateLocale();

    @Override
    public void setPreference(String key, Object value, Object document) {
        if (document instanceof Transcription) {
            Preferences.set(key, value, (Transcription)document, false, false);
        } else {
            Preferences.set(key, value, null, false, false);
        }
    }

    @Deprecated
    protected Object getPreference(String key, Transcription document) {
        return Preferences.get(key, document);
    }

    @Override
    public abstract void preferencesChanged();
}

