/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.TierOrder;
import mpi.eudico.client.annotator.TierOrderListener;
import mpi.eudico.client.annotator.gui.MenuScroller;
import mpi.eudico.client.annotator.tiersets.TierSet;
import mpi.eudico.client.annotator.tiersets.TierSetListener;
import mpi.eudico.client.annotator.tiersets.TierSetUtil;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class AnnotationDensityViewer
extends AbstractViewer
implements ACMEditListener,
MouseListener,
ActionListener,
TierSetListener {
    private static Dimension SLIDERDIMENSION = new Dimension(600, 28);
    private static String N_A = "-";
    private final int imageHeight = 5;
    private int imageWidth;
    private TranscriptionImpl transcription;
    private BufferedImage bi;
    private Graphics2D big2d;
    private BufferedImage displayImage;
    private JPopupMenu popup;
    private JMenu tierSubMenu;
    private List<JCheckBoxMenuItem> tierCheckBoxes;
    private JMenu annotatorSubMenu;
    private List<JCheckBoxMenuItem> annotatorCheckBoxes;
    private JMenu participantSubMenu;
    private List<JCheckBoxMenuItem> participantCheckBoxes;
    private JMenu linguisticTypeSubMenu;
    private List<JCheckBoxMenuItem> linguisticTypeCheckBoxes;
    private JMenu languageSubMenu;
    private List<JCheckBoxMenuItem> languageCheckBoxes;
    private JMenu tiersetSubMenu;
    private List<JCheckBoxMenuItem> tiersetCheckBoxes;
    private JRadioButtonMenuItem allAnnotationsRB;
    private ViewMode viewMode = ViewMode.SHOW_ALL;
    private List<String> viewModeKeywords = new ArrayList<String>();
    private TierOrder tierOrder;

    public AnnotationDensityViewer(TranscriptionImpl transcription) {
        this.transcription = transcription;
        this.setPreferredSize(SLIDERDIMENSION);
        TierSetUtil.getTierSetUtilInstance().addTierSetListener(transcription, this);
        this.paintBuffer();
    }

    public void setTierOrderObject(TierOrder tierOrder) {
        this.tierOrder = tierOrder;
        tierOrder.addTierOrderListener(new TierOrderListener(){

            @Override
            public void updateTierOrder(List<String> tierOrder) {
                AnnotationDensityViewer.this.createPopupMenu();
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return SLIDERDIMENSION;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return SLIDERDIMENSION;
    }

    private void paintBuffer() {
        this.imageWidth = this.getWidth() > 0 ? this.getWidth() : AnnotationDensityViewer.SLIDERDIMENSION.width;
        if (this.bi == null || this.bi.getWidth() != this.imageWidth || this.bi.getHeight() != 5) {
            this.bi = new BufferedImage(this.imageWidth, 5, 1);
            this.big2d = this.bi.createGraphics();
        }
        this.big2d.setColor(Color.lightGray);
        this.big2d.fillRect(0, 0, this.imageWidth, 5);
        this.big2d.setColor(Color.white);
        this.big2d.fillRect(0, 0, this.imageWidth, 1);
        this.big2d.drawLine(0, 0, 0, 5);
        this.big2d.setColor(Color.darkGray);
        this.big2d.fillRect(0, 4, this.imageWidth, 1);
        this.big2d.setColor(Color.darkGray.brighter());
        int duration = (int)this.getMediaDuration();
        if (duration == 0) {
            this.displayImage = this.bi;
            this.repaint();
            return;
        }
        this.updateAnnotationFilter();
        this.displayImage = this.bi;
        this.repaint();
    }

    private void updateAnnotationFilter() {
        ArrayList<Annotation> filtered_annotations = new ArrayList<Annotation>();
        List<TierImpl> allTiers = this.transcription.getTiers();
        TierImpl.ValueGetter getter = null;
        switch (this.viewMode) {
            case SHOW_BY_TIER: {
                for (String tierName : this.viewModeKeywords) {
                    TierImpl tier = this.transcription.getTierWithId(tierName);
                    if (tier == null) continue;
                    for (Annotation annotation : tier.getAnnotations()) {
                        filtered_annotations.add(annotation);
                    }
                }
                break;
            }
            case SHOW_BY_ANNOTATOR: {
                getter = new TierImpl.AnnotatorGetter();
                break;
            }
            case SHOW_BY_PARTICIPANT: {
                getter = new TierImpl.ParticipantGetter();
                break;
            }
            case SHOW_BY_TYPE: {
                getter = new TierImpl.LinguisticTypeNameGetter();
                break;
            }
            case SHOW_BY_LANGUAGE: {
                getter = new TierImpl.LanguageGetter();
                break;
            }
            case SHOW_BY_TIERSET: {
                for (String tierset : this.viewModeKeywords) {
                    List<String> tiersInTierset = TierSetUtil.getTierSetUtilInstance().getTierSet(tierset).getVisibleTierList();
                    Iterator iterator = tiersInTierset.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        TierImpl tier = this.transcription.getTierWithId(string);
                        if (tier == null) continue;
                        for (Annotation annotation : tier.getAnnotations()) {
                            filtered_annotations.add(annotation);
                        }
                    }
                }
                break;
            }
            default: {
                for (TierImpl t : allTiers) {
                    for (Annotation annotation : t.getAnnotations()) {
                        filtered_annotations.add(annotation);
                    }
                }
            }
        }
        if (getter != null) {
            for (TierImpl t : allTiers) {
                String value = getter.getSortValue(t);
                if (!this.viewModeKeywords.contains(value)) continue;
                for (Annotation annotation : t.getAnnotations()) {
                    filtered_annotations.add(annotation);
                }
            }
        }
        for (Annotation annotation : filtered_annotations) {
            int begintime = (int)annotation.getBeginTimeBoundary();
            int n = (int)annotation.getEndTimeBoundary();
            int n2 = (begintime + n) / 2;
            int intx = (int)((float)this.imageWidth * ((float)n2 / (float)this.getMediaDuration()));
            this.big2d.drawLine(intx, 0, intx, 5);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getWidth() != this.imageWidth) {
            this.paintBuffer();
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.displayImage != null) {
            g2d.drawImage((Image)this.displayImage, 0, 15, this);
        }
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu("Density");
        this.allAnnotationsRB = new JRadioButtonMenuItem(ElanLocale.getString("MultiTierControlPanel.Menu.ShowAllTiers"));
        this.allAnnotationsRB.setSelected(true);
        this.allAnnotationsRB.setEnabled(false);
        this.allAnnotationsRB.addActionListener(this);
        this.popup.add(this.allAnnotationsRB);
        this.popup.addSeparator();
        this.tierSubMenu = new JMenu(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuTier"));
        this.annotatorSubMenu = new JMenu(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuAnnotator"));
        this.participantSubMenu = new JMenu(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuParticipant"));
        this.linguisticTypeSubMenu = new JMenu(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuLinguisticType"));
        this.languageSubMenu = new JMenu(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuLanguage"));
        this.tiersetSubMenu = new JMenu(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuTierSet"));
        MenuScroller.setScrollerFor(this.tierSubMenu);
        MenuScroller.setScrollerFor(this.linguisticTypeSubMenu);
        if (this.transcription != null) {
            List<TierImpl> allTiers;
            if (this.tierOrder != null && this.tierOrder.getTierOrder() != null) {
                List<String> tierOrderList = this.tierOrder.getTierOrder();
                allTiers = new ArrayList<TierImpl>();
                for (int i = 0; i < tierOrderList.size(); ++i) {
                    TierImpl t = this.transcription.getTierWithId(tierOrderList.get(i));
                    if (t == null || allTiers.contains(t)) continue;
                    allTiers.add(t);
                }
            } else {
                allTiers = this.transcription.getTiers();
            }
            this.tierCheckBoxes = new ArrayList<JCheckBoxMenuItem>();
            this.annotatorCheckBoxes = new ArrayList<JCheckBoxMenuItem>();
            HashSet<String> annotators = new HashSet<String>();
            this.participantCheckBoxes = new ArrayList<JCheckBoxMenuItem>();
            HashSet<String> participants = new HashSet<String>();
            this.linguisticTypeCheckBoxes = new ArrayList<JCheckBoxMenuItem>();
            this.languageCheckBoxes = new ArrayList<JCheckBoxMenuItem>();
            HashSet<String> languages = new HashSet<String>();
            this.tiersetCheckBoxes = new ArrayList<JCheckBoxMenuItem>();
            for (TierImpl tier : allTiers) {
                String name = tier.getName();
                JCheckBoxMenuItem tierCheckBoxItem = new JCheckBoxMenuItem(name);
                tierCheckBoxItem.setActionCommand("TIER_" + name);
                tierCheckBoxItem.addActionListener(this);
                this.tierCheckBoxes.add(tierCheckBoxItem);
                this.tierSubMenu.add(tierCheckBoxItem);
                if (!tier.getAnnotator().isEmpty()) {
                    annotators.add(tier.getAnnotator());
                } else {
                    annotators.add(N_A);
                }
                if (!tier.getParticipant().isEmpty()) {
                    participants.add(tier.getParticipant());
                } else {
                    participants.add(N_A);
                }
                String value = tier.getLangRef();
                if (value != null && !value.isEmpty()) {
                    languages.add(value);
                    continue;
                }
                languages.add(N_A);
            }
            for (String annotator : annotators) {
                JCheckBoxMenuItem annotatorCheckBoxItem = new JCheckBoxMenuItem(annotator);
                annotatorCheckBoxItem.setActionCommand("ANNO_" + annotator);
                annotatorCheckBoxItem.addActionListener(this);
                this.annotatorCheckBoxes.add(annotatorCheckBoxItem);
                this.annotatorSubMenu.add(annotatorCheckBoxItem);
            }
            for (String participant : participants) {
                JCheckBoxMenuItem participantCheckBoxItem = new JCheckBoxMenuItem(participant);
                participantCheckBoxItem.setActionCommand("PART_" + participant);
                participantCheckBoxItem.addActionListener(this);
                this.participantCheckBoxes.add(participantCheckBoxItem);
                this.participantSubMenu.add(participantCheckBoxItem);
            }
            List<LinguisticType> linguisticTypes = this.transcription.getLinguisticTypes();
            for (LinguisticType linguisticType : linguisticTypes) {
                JCheckBoxMenuItem linguisticTypeCheckboxItem = new JCheckBoxMenuItem(linguisticType.getLinguisticTypeName());
                linguisticTypeCheckboxItem.setActionCommand("TYPE_" + linguisticType.getLinguisticTypeName());
                linguisticTypeCheckboxItem.addActionListener(this);
                this.linguisticTypeCheckBoxes.add(linguisticTypeCheckboxItem);
                this.linguisticTypeSubMenu.add(linguisticTypeCheckboxItem);
            }
            for (String language : languages) {
                JCheckBoxMenuItem languageCheckboxItem = new JCheckBoxMenuItem(language);
                languageCheckboxItem.setActionCommand("LANG_" + language);
                languageCheckboxItem.addActionListener(this);
                this.languageCheckBoxes.add(languageCheckboxItem);
                this.languageSubMenu.add(languageCheckboxItem);
            }
            for (String tierset : TierSetUtil.getTierSetUtilInstance().getTierSetList()) {
                JCheckBoxMenuItem tiersetCheckBoxItem = new JCheckBoxMenuItem(tierset);
                tiersetCheckBoxItem.setActionCommand("TRST_" + tierset);
                tiersetCheckBoxItem.addActionListener(this);
                this.tiersetCheckBoxes.add(tiersetCheckBoxItem);
                this.tiersetSubMenu.add(tiersetCheckBoxItem);
            }
        }
        this.popup.add(this.tierSubMenu);
        this.popup.add(this.participantSubMenu);
        this.popup.add(this.annotatorSubMenu);
        this.popup.add(this.linguisticTypeSubMenu);
        this.popup.add(this.languageSubMenu);
        this.popup.add(this.tiersetSubMenu);
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 0: 
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                this.createPopupMenu();
                this.updateAnnotationFilter();
            }
        }
        this.paintBuffer();
    }

    @Override
    public void updateLocale() {
        if (this.allAnnotationsRB != null) {
            this.allAnnotationsRB.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ShowAllTiers"));
        }
        if (this.tierSubMenu != null) {
            this.tierSubMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuTier"));
        }
        if (this.annotatorSubMenu != null) {
            this.annotatorSubMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuAnnotator"));
        }
        if (this.participantSubMenu != null) {
            this.participantSubMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuParticipant"));
        }
        if (this.linguisticTypeSubMenu != null) {
            this.linguisticTypeSubMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuLinguisticType"));
        }
        if (this.languageSubMenu != null) {
            this.languageSubMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SubMenuLanguage"));
        }
    }

    @Override
    public void updateActiveAnnotation() {
    }

    @Override
    public void updateSelection() {
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
    }

    @Override
    public void preferencesChanged() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            if (this.popup == null) {
                this.createPopupMenu();
            }
            this.popup.show(this, e.getPoint().x, e.getPoint().y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void deselectBoxes(List<JCheckBoxMenuItem> boxes) {
        for (JCheckBoxMenuItem checkBox : boxes) {
            checkBox.setSelected(false);
        }
    }

    private void deselectTiers() {
        this.deselectBoxes(this.tierCheckBoxes);
    }

    private void deselectAnnotators() {
        this.deselectBoxes(this.annotatorCheckBoxes);
    }

    private void deselectParticipants() {
        this.deselectBoxes(this.participantCheckBoxes);
    }

    private void deselectLinguisticTypes() {
        this.deselectBoxes(this.linguisticTypeCheckBoxes);
    }

    private void deselectLanguages() {
        this.deselectBoxes(this.languageCheckBoxes);
    }

    private void deselectTiersets() {
        this.deselectBoxes(this.tiersetCheckBoxes);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ViewMode old_viewMode = this.viewMode;
        if (e.getSource() == this.allAnnotationsRB) {
            this.viewMode = ViewMode.SHOW_ALL;
            this.deselectLinguisticTypes();
            this.deselectAnnotators();
            this.deselectParticipants();
            this.deselectTiers();
            this.deselectLanguages();
            this.deselectTiersets();
            this.viewModeKeywords.clear();
            if (this.allAnnotationsRB.isSelected()) {
                this.allAnnotationsRB.setEnabled(false);
            }
        } else {
            String keyword = e.getActionCommand().substring(5);
            String filterType = e.getActionCommand().substring(0, 5);
            if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                this.allAnnotationsRB.setSelected(false);
                this.allAnnotationsRB.setEnabled(true);
                if (filterType.equals("TIER_")) {
                    this.viewMode = ViewMode.SHOW_BY_TIER;
                } else if (filterType.equals("ANNO_")) {
                    this.viewMode = ViewMode.SHOW_BY_ANNOTATOR;
                } else if (filterType.equals("PART_")) {
                    this.viewMode = ViewMode.SHOW_BY_PARTICIPANT;
                } else if (filterType.equals("TYPE_")) {
                    this.viewMode = ViewMode.SHOW_BY_TYPE;
                } else if (filterType.equals("LANG_")) {
                    this.viewMode = ViewMode.SHOW_BY_LANGUAGE;
                } else if (filterType.equals("TRST_")) {
                    this.viewMode = ViewMode.SHOW_BY_TIERSET;
                }
                if (old_viewMode != this.viewMode) {
                    this.viewModeKeywords.clear();
                    if (this.viewMode != ViewMode.SHOW_BY_TIER) {
                        this.deselectTiers();
                    }
                    if (this.viewMode != ViewMode.SHOW_BY_ANNOTATOR) {
                        this.deselectAnnotators();
                    }
                    if (this.viewMode != ViewMode.SHOW_BY_PARTICIPANT) {
                        this.deselectParticipants();
                    }
                    if (this.viewMode != ViewMode.SHOW_BY_TYPE) {
                        this.deselectAnnotators();
                    }
                    if (this.viewMode != ViewMode.SHOW_BY_LANGUAGE) {
                        this.deselectLanguages();
                    }
                    if (this.viewMode != ViewMode.SHOW_BY_TIERSET) {
                        this.deselectTiersets();
                    }
                }
                if (N_A.equals(keyword)) {
                    this.viewModeKeywords.add("");
                } else {
                    this.viewModeKeywords.add(keyword);
                }
            } else {
                if (N_A.equals(keyword)) {
                    this.viewModeKeywords.remove("");
                } else {
                    this.viewModeKeywords.remove(keyword);
                }
                if (this.viewModeKeywords.isEmpty()) {
                    this.viewMode = ViewMode.SHOW_ALL;
                    this.allAnnotationsRB.setSelected(true);
                    this.allAnnotationsRB.setEnabled(false);
                }
            }
        }
        this.paintBuffer();
    }

    @Override
    public void mediaOffsetChanged() {
        this.paintBuffer();
    }

    @Override
    public void tierSetChanged() {
        if (this.viewMode == ViewMode.SHOW_BY_TIERSET) {
            this.updateTiersetSubmenu();
            this.paintBuffer();
        }
    }

    @Override
    public void tierSetVisibilityChanged(TierSet set) {
        if (this.viewMode == ViewMode.SHOW_BY_TIERSET) {
            this.updateTiersetSubmenu();
            this.paintBuffer();
        }
    }

    @Override
    public void tierVisibilityChanged(String tierName, boolean isVisible) {
        if (this.viewMode == ViewMode.SHOW_BY_TIERSET) {
            this.updateTiersetSubmenu();
            this.paintBuffer();
        }
    }

    private void updateTiersetSubmenu() {
        ArrayList<String> keywordsToDelete = new ArrayList<String>();
        for (JCheckBoxMenuItem checkBox : this.tiersetCheckBoxes) {
            String checkBoxText = checkBox.getText();
            if (TierSetUtil.getTierSetUtilInstance().checkIfTierSetExists(checkBoxText)) continue;
            if (checkBox.isSelected()) {
                keywordsToDelete.add(checkBoxText);
            }
            this.tiersetSubMenu.remove(checkBox);
        }
        for (String keyword : keywordsToDelete) {
            this.viewModeKeywords.remove(keyword);
        }
        if (this.viewModeKeywords.isEmpty()) {
            this.viewMode = ViewMode.SHOW_ALL;
            this.allAnnotationsRB.setSelected(true);
            this.allAnnotationsRB.setEnabled(false);
        }
    }

    private static enum ViewMode {
        SHOW_ALL,
        SHOW_BY_TIER,
        SHOW_BY_TYPE,
        SHOW_BY_ANNOTATOR,
        SHOW_BY_PARTICIPANT,
        SHOW_BY_LANGUAGE,
        SHOW_BY_TIERSET;

    }
}

