/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.util.Tag2D;
import mpi.eudico.client.annotator.util.Tier2D;
import mpi.eudico.client.annotator.viewer.DefaultTimeScaleBasedViewer;
import mpi.eudico.client.annotator.viewer.MultiTierControlPanel;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.client.annotator.viewer.SegmentationControlPanel;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.TimeInterval;

public class SegmentationViewer2
extends DefaultTimeScaleBasedViewer
implements MultiTierViewer,
AdjustmentListener,
ACMEditListener,
ChangeListener {
    public static final int TWO_TIMES_SEGMENTATION = 0;
    public static final int ONE_TIME_SEGMENTATION = 1;
    public static final int ONE_TIME_FIXED_SEGMENTATION = 2;
    public static final int TWO_TIMES_PRESS_RELEASE_SEGMENTATION = 3;
    private TranscriptionImpl transcription;
    private int pixelsForTierHeight;
    private int pixelsForTierHeightMargin;
    private int defBarWidth;
    private int[] tierYPositions;
    private SegmentationControlPanel segmentationControlPanel;
    private JScrollBar scrollBar;
    private JScrollBar hScrollBar;
    private JPanel zoomSliderPanel;
    private JSlider zoomSlider;
    private final int ZOOMSLIDER_WIDTH = 100;
    private JPanel corner;
    private int verticalScrollOffset;
    private int rhDist = 3;
    private Tier2D editTier2d;
    private Tag2D dragEditTag2D;
    private int editTierHeight = 25;
    private ArrayList<Tier2D> allTiers;
    private List<Tier2D> visibleTiers;
    private boolean singleStrokeIsBegin = true;
    private long fixedDuration = 1000L;
    private long delayDuration = 0L;
    private ButtonGroup fontSizeBG;
    private JMenu fontMenu;
    private JMenuItem deleteAnnoMI;
    private JMenuItem mergeNextAnnoMI;
    private JMenuItem mergeBeforeAnnoMI;
    private JMenuItem splitAnnoMI;
    private JMenuItem modifyAnnoTimeDlgMI;
    private String curTier;
    private InputMap mainInputMap;
    private InputMap cvInputMap;
    private ActionMap mainActionMap;
    private ActionMap cvActionMap;
    private int segmentMode = 0;
    private long lastSegmentTime = -1L;
    private int timeCount = 0;
    private long currentBeginTime = -1L;
    private AnnotationDataRecord lastRecord = null;
    private final Object paintlock = new Object();
    private final int DRAG_EDIT_MARGIN = 8;
    private final int DRAG_EDIT_CENTER = 0;
    private final int DRAG_EDIT_LEFT = 1;
    private final int DRAG_EDIT_RIGHT = 2;
    private int dragEditMode = 0;
    private boolean dragEditing;
    private long dragParentBegin = -1L;
    private long dragParentEnd = -1L;
    private long splitTime;
    private Map<String, Action> actionMap;
    private boolean pressReleaseKeyDown;
    private AbstractAction segmentTypeAction;
    private AbstractAction segmentPressAction;
    private AbstractAction segmentReleaseAction;

    public SegmentationViewer2() {
        this.addMouseWheelListener(this);
        String bufImg = System.getProperty("useBufferedImage");
        if (bufImg != null && bufImg.toLowerCase().equals("true")) {
            this.useBufferedImage = true;
        }
        this.pressReleaseKeyDown = false;
    }

    public SegmentationViewer2(Transcription transcription) {
        this();
        this.transcription = (TranscriptionImpl)transcription;
        this.initViewer2();
    }

    private void initViewer2() {
        this.pixelsForTierHeight = this.calcTierHeight();
        this.pixelsForTierHeightMargin = 2;
        this.scrollBar = new JScrollBar(1, 0, 50, 0, 200);
        this.scrollBar.setUnitIncrement(this.pixelsForTierHeight / 2);
        this.scrollBar.setBlockIncrement(this.pixelsForTierHeight);
        this.scrollBar.addAdjustmentListener(this);
        this.hScrollBar = new JScrollBar(0, 0, 50, 0, 400);
        this.hScrollBar.setUnitIncrement(10);
        this.hScrollBar.setBlockIncrement(40);
        this.hScrollBar.addAdjustmentListener(this);
        this.add(this.hScrollBar);
        this.add(this.scrollBar);
        this.zoomSlider = new JSlider(10, 300, 100);
        this.zoomSlider.putClientProperty("JComponent.sizeVariant", "small");
        this.zoomSliderPanel = new JPanel(null);
        this.zoomSliderPanel.add(this.zoomSlider);
        this.zoomSlider.addChangeListener(this);
        this.zoomSlider.setToolTipText(String.valueOf(this.zoomSlider.getValue()));
        this.corner = new JPanel();
        this.add(this.corner);
        KeyStroke[] ks = this.zoomSlider.getRegisteredKeyStrokes();
        ActionMap am = this.zoomSlider.getActionMap();
        for (KeyStroke element : ks) {
            int condition;
            InputMap im;
            if (element.getKeyCode() == 37 || element.getKeyCode() == 39 || (im = this.zoomSlider.getInputMap(condition = this.zoomSlider.getConditionForKeyStroke(element))) == null) continue;
            Object obj = im.get(element);
            am.remove(obj);
            if (am.getParent() != null) {
                am.getParent().remove(obj);
            }
            im.remove(element);
        }
        this.add(this.zoomSliderPanel);
        this.actionMap = new HashMap<String, Action>();
        this.mainInputMap = this.getInputMap(2);
        this.mainActionMap = this.getActionMap();
        this.segmentTypeAction = new SegmentAction();
        this.actionMap.put("CommandActions.NextActiveTier", new ActiveTierAction(true));
        this.actionMap.put("CommandActions.PreviousActiveTier", new ActiveTierAction(false));
        this.actionMap.put("Menu.Annotation.DeleteAnnotation", new DeleteAnnotationAction());
        this.actionMap.put("Menu.Annotation.MergeWithNext", new MergeAnnotationAction(true));
        this.actionMap.put("Menu.Annotation.MergeWithBefore", new MergeAnnotationAction(false));
        this.actionMap.put("Menu.Annotation.SplitAnnotation", new SplitAnnotationAction());
        this.actionMap.put("Menu.Annotation.ModifyAnnotationTimeDialog", new ModifyTimeDlgAction());
        DeleteAnnotationAction delac2 = new DeleteAnnotationAction(KeyStroke.getKeyStroke(127, 0));
        String key = "delact2";
        this.mainInputMap.put((KeyStroke)delac2.getValue("AcceleratorKey"), key);
        this.mainActionMap.put(key, delac2);
        this.getInputMap(0).put((KeyStroke)delac2.getValue("AcceleratorKey"), key);
        this.getInputMap(1).put((KeyStroke)delac2.getValue("AcceleratorKey"), key);
        key = "SegmentationMode.Actions.Segment";
        this.mainInputMap.put((KeyStroke)this.segmentTypeAction.getValue("AcceleratorKey"), key);
        this.mainActionMap.put(key, this.segmentTypeAction);
        this.getInputMap(0).put((KeyStroke)this.segmentTypeAction.getValue("AcceleratorKey"), key);
        this.getInputMap(1).put((KeyStroke)this.segmentTypeAction.getValue("AcceleratorKey"), key);
        this.segmentPressAction = new PressReleaseSegmentAction(false);
        this.segmentReleaseAction = new PressReleaseSegmentAction(true);
        this.initTiers();
        this.updateShortcutMaps();
        this.paintBuffer();
    }

    private void updateShortcutMaps() {
        ShortcutsUtil scu = ShortcutsUtil.getInstance();
        for (Map.Entry<String, Action> pair : this.actionMap.entrySet()) {
            String actionName = pair.getKey();
            Action ca = pair.getValue();
            if (ca == null) continue;
            ca.putValue("AcceleratorKey", scu.getKeyStrokeForAction(actionName, "Menu.Options.SegmentationMode"));
            this.mainInputMap.put((KeyStroke)ca.getValue("AcceleratorKey"), actionName);
            this.mainActionMap.put(actionName, ca);
            this.getInputMap(0).put((KeyStroke)ca.getValue("AcceleratorKey"), actionName);
            this.getInputMap(1).put((KeyStroke)ca.getValue("AcceleratorKey"), actionName);
        }
    }

    private int getDefaultBarWidth() {
        int width = 20;
        if (UIManager.getDefaults().get("ScrollBar.width") != null) {
            width = (Integer)UIManager.getDefaults().get("ScrollBar.width");
        }
        return width;
    }

    private int calcTierHeight() {
        int th = (int)((double)this.font.getSize() * 2.5 + (double)(36 / this.font.getSize()));
        th = th * 2 / 3;
        this.editTierHeight = (int)(2.5 * (double)th);
        return th;
    }

    private void initTiers() {
        this.defBarWidth = this.getDefaultBarWidth() + 2;
        this.allTiers = new ArrayList(20);
        this.visibleTiers = new ArrayList<Tier2D>(this.allTiers.size());
        if (this.transcription == null) {
            this.tierYPositions = new int[0];
            return;
        }
        this.extractTiers();
        this.tierYPositions = new int[this.allTiers.size()];
    }

    private void extractTiers() {
        for (TierImpl tier : this.transcription.getTiers()) {
            Tier2D tier2d;
            if (tier.hasParentTier() && (tier.getLinguisticType().getConstraints() == null || tier.getLinguisticType().getConstraints().getStereoType() != 1) || (tier2d = this.createTier2D(tier)) == null) continue;
            this.allTiers.add(tier2d);
            this.visibleTiers.add(tier2d);
        }
        if (this.allTiers.size() > 0) {
            this.setActiveTier(this.allTiers.get(0).getTier());
        }
    }

    private Tier2D createTier2D(TierImpl tier) {
        if (tier == null) {
            return null;
        }
        Tier2D tier2d = new Tier2D(tier);
        for (Annotation annotation : tier.getAnnotations()) {
            Tag2D tag2d = new Tag2D(annotation);
            int xPos = this.timeToPixels(annotation.getBeginTimeBoundary());
            tag2d.setX(xPos);
            int tagWidth = this.timeToPixels(annotation.getEndTimeBoundary()) - xPos;
            tag2d.setWidth(tagWidth);
            tag2d.setTruncatedValue(this.truncateString(annotation.getValue(), tagWidth, this.metrics));
            tier2d.addTag(tag2d);
        }
        return tier2d;
    }

    private void reextractTier(Tier2D tier2d) {
        if (tier2d == null) {
            return;
        }
        tier2d.getTagsList().clear();
        for (Annotation annotation : tier2d.getTier().getAnnotations()) {
            Tag2D tag2d = new Tag2D(annotation);
            int xPos = this.timeToPixels(annotation.getBeginTimeBoundary());
            tag2d.setX(xPos);
            int tagWidth = this.timeToPixels(annotation.getEndTimeBoundary()) - xPos;
            tag2d.setWidth(tagWidth);
            tag2d.setTruncatedValue(this.truncateString(annotation.getValue(), tagWidth, this.metrics));
            tier2d.addTag(tag2d);
        }
        this.paintBuffer();
    }

    private void recalculateTagSizes() {
        for (Tier2D tier2d : this.allTiers) {
            Iterator<Tag2D> tagIt = tier2d.getTags();
            while (tagIt.hasNext()) {
                Tag2D tag2d = tagIt.next();
                int xPos = this.timeToPixels(tag2d.getBeginTime());
                tag2d.setX(xPos);
                int tagWidth = this.timeToPixels(tag2d.getEndTime()) - xPos;
                tag2d.setWidth(tagWidth);
                tag2d.setTruncatedValue(this.truncateString(tag2d.getValue(), tagWidth, this.metrics));
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (SystemReporting.antiAliasedText) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (!this.useBufferedImage) {
            this.paintUnbuffered(g2d);
            return;
        }
        int h = this.getHeight();
        if (this.bi != null) {
            g2d.drawImage((Image)this.bi, 0, 0, this);
        }
        if (this.currentBeginTime > -1L) {
            int y = this.rulerHeight + 2 * this.pixelsForTierHeightMargin;
            int x = this.xAt(this.currentBeginTime);
            if (x >= 0 && x <= this.imageWidth) {
                g2d.setColor(Constants.SHAREDCOLOR6);
                g2d.drawLine(x, y, x, y + this.editTierHeight - 2 * this.pixelsForTierHeightMargin);
            }
        }
        if (this.selectionBeginPos != this.selectionEndPos) {
            g2d.setColor(Constants.SELECTIONCOLOR);
            g2d.setComposite(this.alpha04);
            g2d.fillRect(this.selectionBeginPos, 0, this.selectionEndPos - this.selectionBeginPos, this.imageHeight);
            g2d.setComposite(AlphaComposite.SrcOver);
        }
        if (this.dragEditTag2D != null) {
            this.paintEditTag(g2d);
        }
        if (this.crossHairPos >= 0 && this.crossHairPos <= this.imageWidth) {
            g2d.setColor(Constants.CROSSHAIRCOLOR);
            g2d.drawLine(this.crossHairPos, 0, this.crossHairPos, h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintBuffer() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.imageWidth != this.getWidth()) {
            this.imageWidth = this.getWidth();
        }
        if (this.imageHeight != this.getHeight()) {
            this.imageHeight = this.getHeight();
        }
        this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
        if (!this.useBufferedImage) {
            this.repaint();
            return;
        }
        Object object = this.paintlock;
        synchronized (object) {
            int width;
            int x;
            Tag2D tag2d;
            if (this.bi == null || this.bi.getWidth() < this.imageWidth || this.bi.getHeight() < this.imageHeight) {
                this.bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
                this.big2d = this.bi.createGraphics();
            }
            if (SystemReporting.antiAliasedText) {
                this.big2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.big2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
            this.big2d.fillRect(0, 0, this.imageWidth, this.bi.getHeight());
            this.big2d.setColor(Color.WHITE);
            this.big2d.fillRect(0, this.rulerHeight, this.imageWidth, this.editTierHeight);
            long dur = this.getMediaDuration();
            int xx = this.xAt(dur);
            if (this.intervalEndTime > dur) {
                if (!SystemReporting.isMacOS()) {
                    this.big2d.setColor(UIManager.getColor("Panel.background"));
                } else {
                    this.big2d.setColor(Color.LIGHT_GRAY);
                }
                this.big2d.fillRect(xx, 0, this.imageWidth - xx, this.bi.getHeight());
            }
            this.big2d.translate(-((int)((float)this.intervalBeginTime / this.msPerPixel)), 0);
            if (this.timeRulerVisible) {
                this.big2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                this.ruler.paint(this.big2d, this.intervalBeginTime, this.imageWidth, this.msPerPixel, 1);
            }
            this.big2d.setFont(this.font);
            int y = this.rulerHeight + this.editTierHeight - this.verticalScrollOffset;
            int ax = this.timeToPixels(this.intervalBeginTime);
            this.big2d.setColor(Constants.LIGHTBACKGROUNDCOLOR);
            if (this.intervalBeginTime < this.getMediaDuration()) {
                int numStripes = Math.max(this.visibleTiers.size(), this.imageHeight / this.pixelsForTierHeight);
                int yy = y;
                for (int i = 0; i < numStripes; ++i) {
                    if (i % 2 == 0) continue;
                    yy = y + i * this.pixelsForTierHeight;
                    if (yy < this.rulerHeight + this.editTierHeight) {
                        if (yy + this.pixelsForTierHeight <= this.rulerHeight + this.editTierHeight) continue;
                        this.big2d.fillRect(ax, this.rulerHeight + this.editTierHeight, xx, this.pixelsForTierHeight - (this.rulerHeight + this.editTierHeight - yy));
                        continue;
                    }
                    this.big2d.fillRect(ax, y + i * this.pixelsForTierHeight, xx, this.pixelsForTierHeight);
                }
            }
            this.big2d.setColor(Constants.SHAREDCOLOR6);
            int height = this.pixelsForTierHeight - 2 * this.pixelsForTierHeightMargin;
            y = this.rulerHeight + this.pixelsForTierHeightMargin + this.pixelsForTierHeight / 2;
            Tier2D tier2d = null;
            if (this.editTier2d != null) {
                Iterator<Tag2D> tagIt = this.editTier2d.getTags();
                while (tagIt.hasNext()) {
                    tag2d = tagIt.next();
                    if (tag2d.getEndTime() < this.intervalBeginTime) continue;
                    if (tag2d.getBeginTime() > this.intervalEndTime) break;
                    x = tag2d.getX();
                    width = tag2d.getWidth();
                    this.big2d.drawLine(x, y, x, y + height);
                    this.big2d.drawLine(x, y + (height - this.rhDist), x + width, y + (height - this.rhDist));
                    this.big2d.drawLine(x + width, y, x + width, y + height);
                    int descent = this.big2d.getFontMetrics().getDescent();
                    this.big2d.drawString(tag2d.getTruncatedValue(), (float)(x + 4), (float)(y + (height - this.rhDist - descent + 1)));
                }
            }
            y = this.rulerHeight + this.editTierHeight + this.pixelsForTierHeightMargin - this.verticalScrollOffset;
            for (int i = 0; i < this.visibleTiers.size(); ++i) {
                tier2d = this.visibleTiers.get(i);
                if (tier2d == null) continue;
                if (y < this.rulerHeight + this.editTierHeight) {
                    y += this.pixelsForTierHeight;
                    continue;
                }
                Iterator<Tag2D> tagIt = tier2d.getTags();
                while (tagIt.hasNext()) {
                    tag2d = tagIt.next();
                    if (tag2d.getEndTime() < this.intervalBeginTime) continue;
                    if (tag2d.getBeginTime() > this.intervalEndTime) break;
                    x = tag2d.getX();
                    width = tag2d.getWidth();
                    this.big2d.drawLine(x, y, x, y + height);
                    this.big2d.drawLine(x, y + (height - this.rhDist), x + width, y + (height - this.rhDist));
                    this.big2d.drawLine(x + width, y, x + width, y + height);
                    int descent = this.big2d.getFontMetrics().getDescent();
                    this.big2d.drawString(tag2d.getTruncatedValue(), (float)(x + 4), (float)(y + (height - this.rhDist - descent + 1)));
                }
                y += this.pixelsForTierHeight;
            }
            this.big2d.setColor(Constants.SELECTIONCOLOR);
            this.big2d.drawLine(ax, this.rulerHeight, ax + this.imageWidth, this.rulerHeight);
            this.big2d.drawLine(ax, this.rulerHeight + this.editTierHeight, ax + this.imageWidth, this.rulerHeight + this.editTierHeight);
            y = this.rulerHeight + this.pixelsForTierHeightMargin;
            this.big2d.setTransform(new AffineTransform());
        }
        this.repaint();
    }

    private void paintUnbuffered(Graphics2D g2d) {
        int width;
        int x;
        Tag2D tag2d;
        int h = this.getHeight();
        int w = this.getWidth();
        this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)w * this.msPerPixel));
        g2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        g2d.fillRect(0, 0, w, h);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, this.rulerHeight, w, this.editTierHeight);
        long dur = this.getMediaDuration();
        int xx = this.xAt(dur);
        if (this.intervalEndTime > dur) {
            if (!SystemReporting.isMacOS()) {
                g2d.setColor(UIManager.getColor("Panel.background"));
            } else {
                g2d.setColor(Color.LIGHT_GRAY);
            }
            g2d.fillRect(xx, 0, w - xx, h);
        }
        g2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
        g2d.translate(-((int)((float)this.intervalBeginTime / this.msPerPixel)), 0);
        this.ruler.paint(g2d, this.intervalBeginTime, w, this.msPerPixel, 1);
        g2d.setFont(this.font);
        int y = this.rulerHeight + this.editTierHeight - this.verticalScrollOffset;
        int ax = this.timeToPixels(this.intervalBeginTime);
        g2d.setColor(Constants.LIGHTBACKGROUNDCOLOR);
        if (this.intervalBeginTime < this.getMediaDuration()) {
            int numStripes = Math.max(this.visibleTiers.size(), h / this.pixelsForTierHeight);
            int yy = y;
            for (int i = 0; i < numStripes; ++i) {
                if (i % 2 == 0) continue;
                yy = y + i * this.pixelsForTierHeight;
                if (yy < this.rulerHeight + this.editTierHeight) {
                    if (yy + this.pixelsForTierHeight <= this.rulerHeight + this.editTierHeight) continue;
                    g2d.fillRect(ax, this.rulerHeight + this.editTierHeight, xx, this.pixelsForTierHeight - (this.rulerHeight + this.editTierHeight - yy));
                    continue;
                }
                g2d.fillRect(ax, y + i * this.pixelsForTierHeight, xx, this.pixelsForTierHeight);
            }
        }
        if (this.selectionBeginPos != this.selectionEndPos) {
            g2d.translate((double)ax, 0.0);
            g2d.setColor(Constants.SELECTIONCOLOR);
            g2d.setComposite(this.alpha04);
            g2d.fillRect(this.selectionBeginPos, 0, this.selectionEndPos - this.selectionBeginPos, this.imageHeight);
            g2d.setComposite(AlphaComposite.SrcOver);
            g2d.translate((double)(-ax), 0.0);
        }
        g2d.setColor(Constants.SHAREDCOLOR6);
        int height = this.pixelsForTierHeight - 2 * this.pixelsForTierHeightMargin;
        y = this.rulerHeight + this.pixelsForTierHeightMargin + this.pixelsForTierHeight / 2;
        Tier2D tier2d = null;
        if (this.editTier2d != null) {
            Iterator<Tag2D> tagIt = this.editTier2d.getTags();
            while (tagIt.hasNext()) {
                tag2d = tagIt.next();
                if (tag2d.getEndTime() < this.intervalBeginTime) continue;
                if (tag2d.getBeginTime() > this.intervalEndTime) break;
                x = tag2d.getX();
                width = tag2d.getWidth();
                g2d.drawLine(x, y, x, y + height);
                g2d.drawLine(x, y + (height - this.rhDist), x + width, y + (height - this.rhDist));
                g2d.drawLine(x + width, y, x + width, y + height);
                int descent = g2d.getFontMetrics().getDescent();
                g2d.drawString(tag2d.getTruncatedValue(), (float)(x + 4), (float)(y + (height - this.rhDist - descent + 1)));
            }
        }
        y = this.rulerHeight + this.editTierHeight + this.pixelsForTierHeightMargin - this.verticalScrollOffset;
        for (int i = 0; i < this.visibleTiers.size(); ++i) {
            tier2d = this.visibleTiers.get(i);
            if (tier2d == null) continue;
            if (y < this.rulerHeight + this.editTierHeight) {
                y += this.pixelsForTierHeight;
                continue;
            }
            Iterator<Tag2D> tagIt = tier2d.getTags();
            while (tagIt.hasNext()) {
                tag2d = tagIt.next();
                if (tag2d.getEndTime() < this.intervalBeginTime) continue;
                if (tag2d.getBeginTime() > this.intervalEndTime) break;
                x = tag2d.getX();
                width = tag2d.getWidth();
                g2d.drawLine(x, y, x, y + height);
                g2d.drawLine(x, y + (height - this.rhDist), x + width, y + (height - this.rhDist));
                g2d.drawLine(x + width, y, x + width, y + height);
                int descent = g2d.getFontMetrics().getDescent();
                g2d.drawString(tag2d.getTruncatedValue(), (float)(x + 4), (float)(y + (height - this.rhDist - descent + 1)));
            }
            y += this.pixelsForTierHeight;
        }
        g2d.setColor(Constants.SELECTIONCOLOR);
        g2d.drawLine(ax, this.rulerHeight, ax + this.imageWidth, this.rulerHeight);
        g2d.drawLine(ax, this.rulerHeight + this.editTierHeight, ax + this.imageWidth, this.rulerHeight + this.editTierHeight);
        y = this.rulerHeight + this.pixelsForTierHeightMargin;
        g2d.translate((double)ax, 0.0);
        if (this.currentBeginTime > -1L) {
            y = this.rulerHeight + 2 * this.pixelsForTierHeightMargin;
            x = this.xAt(this.currentBeginTime);
            if (x >= 0 && x <= w) {
                g2d.setColor(Constants.SHAREDCOLOR6);
                g2d.drawLine(x, y, x, y + this.editTierHeight - 2 * this.pixelsForTierHeightMargin);
            }
        }
        if (this.dragEditTag2D != null) {
            this.paintEditTag(g2d);
        }
        if (this.crossHairPos >= 0 && this.crossHairPos <= this.imageWidth) {
            g2d.setColor(Constants.CROSSHAIRCOLOR);
            g2d.drawLine(this.crossHairPos, 0, this.crossHairPos, h);
        }
    }

    private void paintEditTag(Graphics2D g2d) {
        if (this.dragEditTag2D != null) {
            int x = (int)((float)this.dragEditTag2D.getX() - (float)this.intervalBeginTime / this.msPerPixel);
            int y = this.timeRulerVisible ? this.rulerHeight + 2 * this.pixelsForTierHeightMargin : 2 * this.pixelsForTierHeightMargin;
            int h = this.editTierHeight - 4 * this.pixelsForTierHeightMargin;
            g2d.setColor(Color.GREEN);
            g2d.fillRect(x, y, 2, h);
            g2d.fillRect(x + this.dragEditTag2D.getWidth(), y, 2, h);
            g2d.fillRect(x, y + h / 2, this.dragEditTag2D.getWidth(), 2);
        }
    }

    private String truncateString(String string, int width, FontMetrics fMetrics) {
        int stringWidth;
        Object line = string.replace('\n', ' ');
        if (fMetrics != null && (stringWidth = fMetrics.stringWidth((String)line)) > width - 4) {
            int i = 0;
            Object s = "";
            int size = ((String)line).length();
            while (i < size && fMetrics.stringWidth((String)s) <= width - 4) {
                s = (String)s + ((String)line).charAt(i++);
            }
            line = !((String)s).equals("") ? ((String)s).substring(0, ((String)s).length() - 1) : s;
        }
        return line;
    }

    @Override
    public int getRightMargin() {
        return this.defBarWidth;
    }

    @Override
    protected void createPopupMenu() {
        super.createPopupMenu();
        int fontSize = this.getFont().getSize();
        this.fontSizeBG = new ButtonGroup();
        this.fontMenu = new JMenu(ElanLocale.getString("Menu.View.FontSize"));
        for (int element : Constants.FONT_SIZES) {
            JRadioButtonMenuItem fontRB = new JRadioButtonMenuItem(String.valueOf(element));
            fontRB.setActionCommand("font" + element);
            if (fontSize == element) {
                fontRB.setSelected(true);
            }
            fontRB.addActionListener(this);
            this.fontSizeBG.add(fontRB);
            this.fontMenu.add(fontRB);
        }
        if (this.popup.getComponentCount() >= 2) {
            this.popup.add((Component)this.fontMenu, 1);
        } else {
            this.popup.add(this.fontMenu);
        }
        this.popup.addSeparator();
        this.deleteAnnoMI = new JMenuItem(this.actionMap.get("Menu.Annotation.DeleteAnnotation"));
        this.deleteAnnoMI.setEnabled(false);
        this.popup.add(this.deleteAnnoMI);
        this.mergeNextAnnoMI = new JMenuItem(this.actionMap.get("Menu.Annotation.MergeWithNext"));
        this.mergeNextAnnoMI.setEnabled(false);
        this.popup.add(this.mergeNextAnnoMI);
        this.mergeBeforeAnnoMI = new JMenuItem(this.actionMap.get("Menu.Annotation.MergeWithBefore"));
        this.mergeBeforeAnnoMI.setEnabled(false);
        this.popup.add(this.mergeBeforeAnnoMI);
        this.splitAnnoMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.SplitAnnotation"));
        this.splitAnnoMI.setAction(this.actionMap.get("Menu.Annotation.SplitAnnotation"));
        this.splitAnnoMI.setEnabled(false);
        this.popup.add(this.splitAnnoMI);
        this.modifyAnnoTimeDlgMI = new JMenuItem(this.actionMap.get("Menu.Annotation.ModifyAnnotationTimeDialog"));
        this.modifyAnnoTimeDlgMI.setEnabled(false);
        this.popup.add(this.modifyAnnoTimeDlgMI);
    }

    @Override
    protected void updatePopup(Point p) {
        if (this.popup == null) {
            return;
        }
        boolean isEditAnnotation = this.dragEditTag2D != null;
        this.deleteAnnoMI.setEnabled(isEditAnnotation);
        this.modifyAnnoTimeDlgMI.setEnabled(isEditAnnotation);
        this.checkForSplitAnnotation();
        if (isEditAnnotation) {
            Annotation aa = this.dragEditTag2D.getAnnotation();
            TierImpl tier = (TierImpl)aa.getTier();
            this.mergeBeforeAnnoMI.setEnabled(tier.getAnnotationBefore(aa) != null);
            this.mergeNextAnnoMI.setEnabled(tier.getAnnotationAfter(aa) != null);
        } else {
            this.mergeBeforeAnnoMI.setEnabled(false);
            this.mergeNextAnnoMI.setEnabled(false);
        }
        Point inverse = new Point(p);
        inverse.x += this.timeToPixels(this.intervalBeginTime);
        inverse.y += this.verticalScrollOffset;
        this.splitTime = this.pixelToTime(inverse.x);
    }

    private void checkForSplitAnnotation() {
        List<TierImpl> childTiers;
        Annotation aa;
        TierImpl tier;
        this.splitAnnoMI.setEnabled(false);
        if (this.dragEditTag2D != null && (tier = (TierImpl)(aa = this.dragEditTag2D.getAnnotation()).getTier()).isTimeAlignable() && !tier.hasParentTier() && (childTiers = tier.getChildTiers()) != null) {
            boolean valid = false;
            for (int i = 0; i < childTiers.size(); ++i) {
                TierImpl childTier = childTiers.get(i);
                if (childTier.getLinguisticType().getConstraints().getStereoType() != 4) {
                    valid = false;
                    break;
                }
                valid = true;
            }
            this.splitAnnoMI.setEnabled(valid);
            if (!valid) {
                List<TierImpl> dependentTiers = tier.getDependentTiers();
                ArrayList<Annotation> dependingAnnotations = new ArrayList<Annotation>();
                for (int i = 0; i < dependentTiers.size(); ++i) {
                    if (dependentTiers.get(i).getLinguisticType().getConstraints().getStereoType() == 4) continue;
                    dependingAnnotations.addAll(aa.getChildrenOnTier(dependentTiers.get(i)));
                }
                if (dependingAnnotations.size() == 0) {
                    this.splitAnnoMI.setEnabled(true);
                }
            }
        }
    }

    @Override
    public void setMultiTierControlPanel(MultiTierControlPanel controller) {
    }

    public void setSegmentationControlPanel(SegmentationControlPanel segment) {
        this.segmentationControlPanel = segment;
        this.notifySegmentationControlPanel();
    }

    public void setSegmentationMode(int nextMode) {
        if (nextMode == this.segmentMode) {
            return;
        }
        if (nextMode >= 0 && nextMode <= 3) {
            int oldMode = this.segmentMode;
            this.segmentMode = nextMode;
            this.timeCount = 0;
            this.lastSegmentTime = -1L;
            if (this.segmentMode == 3 || this.segmentMode != 3 && oldMode == 3) {
                this.switchActions();
            }
        }
    }

    private void switchActions() {
        if (this.segmentMode == 3) {
            this.mainInputMap.remove((KeyStroke)this.segmentTypeAction.getValue("AcceleratorKey"));
            this.mainActionMap.remove("SegmentationMode.Actions.Segment");
            this.getInputMap(0).remove((KeyStroke)this.segmentTypeAction.getValue("AcceleratorKey"));
            this.getInputMap(1).remove((KeyStroke)this.segmentTypeAction.getValue("AcceleratorKey"));
            this.segmentPressAction = new PressReleaseSegmentAction(false);
            String key = "SegDown";
            this.mainInputMap.put((KeyStroke)this.segmentPressAction.getValue("AcceleratorKey"), key);
            this.mainActionMap.put(key, this.segmentPressAction);
            this.getInputMap(0).put((KeyStroke)this.segmentPressAction.getValue("AcceleratorKey"), key);
            this.getInputMap(1).put((KeyStroke)this.segmentPressAction.getValue("AcceleratorKey"), key);
            this.segmentReleaseAction = new PressReleaseSegmentAction(true);
            key = "SegUp";
            this.mainInputMap.put((KeyStroke)this.segmentReleaseAction.getValue("AcceleratorKey"), key);
            this.mainActionMap.put(key, this.segmentReleaseAction);
            this.getInputMap(0).put((KeyStroke)this.segmentReleaseAction.getValue("AcceleratorKey"), key);
            this.getInputMap(1).put((KeyStroke)this.segmentReleaseAction.getValue("AcceleratorKey"), key);
        } else {
            String key = "SegDown";
            this.mainInputMap.remove((KeyStroke)this.segmentPressAction.getValue("AcceleratorKey"));
            this.mainActionMap.remove(key);
            this.getInputMap(0).remove((KeyStroke)this.segmentPressAction.getValue("AcceleratorKey"));
            this.getInputMap(1).remove((KeyStroke)this.segmentPressAction.getValue("AcceleratorKey"));
            key = "SegUp";
            this.mainInputMap.remove((KeyStroke)this.segmentReleaseAction.getValue("AcceleratorKey"));
            this.mainActionMap.remove(key);
            this.getInputMap(0).remove((KeyStroke)this.segmentReleaseAction.getValue("AcceleratorKey"));
            this.getInputMap(1).remove((KeyStroke)this.segmentReleaseAction.getValue("AcceleratorKey"));
            key = "SegmentationMode.Actions.Segment";
            this.mainInputMap.put((KeyStroke)this.segmentTypeAction.getValue("AcceleratorKey"), key);
            this.mainActionMap.put(key, this.segmentTypeAction);
            this.getInputMap(0).put((KeyStroke)this.segmentTypeAction.getValue("AcceleratorKey"), key);
            this.getInputMap(1).put((KeyStroke)this.segmentTypeAction.getValue("AcceleratorKey"), key);
        }
    }

    public void setFixedSegmentDuration(long duration) {
        this.fixedDuration = duration;
    }

    public boolean isSingleStrokeIsBegin() {
        return this.singleStrokeIsBegin;
    }

    public void setSingleStrokeIsBegin(boolean singleStrokeIsBegin) {
        this.singleStrokeIsBegin = singleStrokeIsBegin;
    }

    public void setDelayDuration(long delayDuration) {
        this.delayDuration = delayDuration;
        if (delayDuration < 0L) {
            delayDuration = -delayDuration;
        }
    }

    public void addSegmentTime(CVEntry cve) {
        long cur = this.getMediaTime() - this.delayDuration;
        if (cur < 0L) {
            cur = 0L;
        }
        if (this.segmentMode == 0) {
            if (cur != this.lastSegmentTime) {
                ++this.timeCount;
                if (this.timeCount % 2 != 0) {
                    this.lastSegmentTime = cur;
                    this.setCurrentBeginTime(this.lastSegmentTime);
                } else {
                    if (cve != null) {
                        AnnotationDataRecord adr = cur > this.lastSegmentTime ? new AnnotationDataRecord(this.curTier, cve.getValue(), this.lastSegmentTime, cur) : new AnnotationDataRecord(this.curTier, cve.getValue(), cur, this.lastSegmentTime);
                        adr.setCvEntry(cve);
                        if (adr.getEndTime() - adr.getBeginTime() > 0L) {
                            this.createAnnotation(adr);
                        }
                    } else {
                        TimeInterval ti = cur > this.lastSegmentTime ? new TimeInterval(this.lastSegmentTime, cur) : new TimeInterval(cur, this.lastSegmentTime);
                        if (ti.getDuration() > 0L) {
                            this.createAnnotation(ti);
                        }
                    }
                    this.lastSegmentTime = cur;
                    this.setCurrentBeginTime(-1L);
                }
            } else {
                ++this.timeCount;
                if (this.timeCount % 2 != 0) {
                    this.lastSegmentTime = cur;
                    this.setCurrentBeginTime(this.lastSegmentTime);
                } else {
                    ++this.timeCount;
                }
            }
        } else if (this.segmentMode == 1) {
            if (this.lastSegmentTime == -1L) {
                ++this.timeCount;
                this.lastSegmentTime = cur;
                this.setCurrentBeginTime(this.lastSegmentTime);
            } else if (cur != this.lastSegmentTime) {
                ++this.timeCount;
                if (cve != null) {
                    AnnotationDataRecord adr = cur > this.lastSegmentTime ? new AnnotationDataRecord(this.curTier, cve.getValue(), this.lastSegmentTime, cur) : new AnnotationDataRecord(this.curTier, cve.getValue(), cur, this.lastSegmentTime);
                    adr.setCvEntry(cve);
                    if (adr.getEndTime() - adr.getBeginTime() > 0L) {
                        this.createAnnotation(adr);
                    }
                } else {
                    TimeInterval ti = cur > this.lastSegmentTime ? new TimeInterval(this.lastSegmentTime, cur) : new TimeInterval(cur, this.lastSegmentTime);
                    if (ti.getDuration() > 0L) {
                        this.createAnnotation(ti);
                    }
                }
                this.setCurrentBeginTime(-1L);
                this.lastSegmentTime = cur;
            }
        } else {
            if (cve != null) {
                AnnotationDataRecord adr;
                if (this.singleStrokeIsBegin) {
                    adr = new AnnotationDataRecord(this.curTier, cve.getValue(), cur, cur + this.fixedDuration);
                } else {
                    long bb = cur - this.fixedDuration;
                    if (bb < 0L) {
                        bb = 0L;
                    }
                    adr = new AnnotationDataRecord(this.curTier, cve.getValue(), bb, cur);
                }
                adr.setCvEntry(cve);
                if (adr.getEndTime() - adr.getBeginTime() > 0L) {
                    this.createAnnotation(adr);
                }
            } else {
                TimeInterval ti = null;
                if (this.singleStrokeIsBegin) {
                    ti = new TimeInterval(cur, cur + this.fixedDuration);
                } else {
                    long bb = cur - this.fixedDuration;
                    if (bb < 0L) {
                        bb = 0L;
                    }
                    ti = new TimeInterval(bb, cur);
                }
                if (ti.getDuration() > 0L) {
                    this.createAnnotation(ti);
                }
            }
            this.lastSegmentTime = cur;
        }
    }

    private void addPressReleaseTime(boolean release) {
        long cur = this.getMediaTime() - this.delayDuration;
        if (cur < 0L) {
            cur = 0L;
        }
        if (!release) {
            this.lastSegmentTime = cur;
            this.setCurrentBeginTime(this.lastSegmentTime);
        } else {
            TimeInterval ti = cur > this.lastSegmentTime ? new TimeInterval(this.lastSegmentTime, cur) : new TimeInterval(cur, this.lastSegmentTime);
            if (ti.getDuration() > 0L) {
                this.createAnnotation(ti);
            }
            this.lastSegmentTime = cur;
            this.setCurrentBeginTime(-1L);
        }
    }

    private void notifySegmentationControlPanel() {
        if (this.segmentationControlPanel == null) {
            return;
        }
        this.segmentationControlPanel.setEditTierHeight(this.rulerHeight + this.editTierHeight);
        this.segmentationControlPanel.setTierHeight(this.pixelsForTierHeight);
        if (this.segmentationControlPanel.getFont().getSize() != this.font.getSize()) {
            this.segmentationControlPanel.setFont(this.segmentationControlPanel.getFont().deriveFont((float)this.font.getSize()));
        }
        if (this.tierYPositions.length != this.visibleTiers.size() + 1) {
            this.tierYPositions = new int[this.visibleTiers.size() + 1];
        }
        if (this.tierYPositions.length > 0) {
            this.tierYPositions[0] = this.rulerHeight + this.editTierHeight / 2;
            for (int i = 0; i < this.visibleTiers.size(); ++i) {
                this.tierYPositions[i + 1] = this.rulerHeight + this.editTierHeight + (i + 1) * this.pixelsForTierHeight - this.verticalScrollOffset;
            }
        }
        this.segmentationControlPanel.setTierPositions(this.tierYPositions);
    }

    private void updateScrollBar() {
        int value = this.scrollBar.getValue();
        int max = this.visibleTiers.size() * this.pixelsForTierHeight + this.rulerHeight + this.editTierHeight;
        this.scrollBar.removeAdjustmentListener(this);
        this.scrollBar.setValue(0);
        this.scrollBar.setMaximum(max);
        this.scrollBar.setVisibleAmount(this.getHeight() - this.defBarWidth);
        if (value + this.getHeight() > max) {
            value = max - this.getHeight();
        }
        this.scrollBar.setValue(value);
        this.scrollBar.revalidate();
        this.scrollBar.addAdjustmentListener(this);
        this.verticalScrollOffset = this.scrollBar.getValue();
        this.notifySegmentationControlPanel();
    }

    private void updateHorScrollBar() {
        int value = this.hScrollBar.getValue();
        if (value != (int)((float)this.intervalBeginTime / this.msPerPixel)) {
            value = (int)((float)this.intervalBeginTime / this.msPerPixel);
        }
        int max = (int)((float)this.getMediaDuration() / this.msPerPixel + 10.0f);
        this.hScrollBar.removeAdjustmentListener(this);
        this.hScrollBar.setBlockIncrement(this.getWidth() - this.defBarWidth);
        this.hScrollBar.setValues(value, this.getWidth() - this.defBarWidth, 0, max);
        this.hScrollBar.revalidate();
        this.hScrollBar.addAdjustmentListener(this);
    }

    @Override
    protected void setLocalTimeScaleIntervalBeginTime(long begin) {
        if (begin == this.intervalBeginTime) {
            return;
        }
        this.intervalBeginTime = begin;
        this.intervalEndTime = (long)((float)this.intervalBeginTime + (float)this.imageWidth * this.msPerPixel);
        this.crossHairPos = this.xAt(this.crossHairTime);
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        this.updateHorScrollBar();
        this.paintBuffer();
    }

    @Override
    protected void setLocalTimeScaleMsPerPixel(float step) {
        int zoom;
        if (step == this.msPerPixel) {
            return;
        }
        this.msPerPixel = step >= 0.025f ? step : 0.025f;
        boolean playing = this.playerIsPlaying();
        if (playing) {
            this.stopPlayer();
        }
        long mediaTime = this.getMediaTime();
        int oldScreenPos = this.crossHairPos;
        int newMediaX = (int)((float)mediaTime / this.msPerPixel);
        int numScreens = this.imageWidth > 0 ? (int)((float)mediaTime / ((float)this.imageWidth * this.msPerPixel)) : 0;
        int newScreenPos = newMediaX - numScreens * this.imageWidth;
        int diff = oldScreenPos - newScreenPos;
        this.intervalBeginTime = (long)((float)(numScreens * this.imageWidth - diff) * this.msPerPixel);
        if (this.intervalBeginTime < 0L) {
            this.intervalBeginTime = 0L;
        }
        this.intervalEndTime = this.intervalBeginTime + (long)((float)this.imageWidth * this.msPerPixel);
        this.recalculateTagSizes();
        this.crossHairPos = this.xAt(mediaTime);
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        this.updateHorScrollBar();
        this.paintBuffer();
        if (playing) {
            this.startPlayer();
        }
        if ((zoom = (int)(100.0f * (10.0f / this.msPerPixel))) <= 0) {
            zoom = 100;
        }
        this.updateZoomPopup(zoom);
        this.setPreference("SegmentationViewer.ZoomLevel", (Object)Float.valueOf(zoom), this.transcription);
        if (this.zoomSlider != null) {
            if (zoom <= 100) {
                this.zoomSlider.setValue(zoom);
            } else {
                float factor = (float)(zoom - 100) / 900.0f;
                int zm = 100 + (int)(factor * (float)(this.zoomSlider.getMaximum() - 100));
                if (zm != this.zoomSlider.getValue()) {
                    this.zoomSlider.removeChangeListener(this);
                    this.zoomSlider.setValue(zm);
                    this.zoomSlider.addChangeListener(this);
                    this.zoomSlider.setToolTipText(String.valueOf(zoom));
                }
            }
        }
    }

    @Override
    public synchronized void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent || event instanceof StopEvent) {
            this.crossHairTime = this.getMediaTime();
            if (!this.playerIsPlaying()) {
                this.recalculateInterval(this.crossHairTime);
                this.crossHairPos = this.xAt(this.crossHairTime);
                this.repaint();
            } else {
                long intervalMidTime = (this.intervalBeginTime + this.intervalEndTime) / 2L;
                if ((float)this.crossHairTime > (float)intervalMidTime + 1.0f * this.msPerPixel) {
                    this.setIntervalBeginTime(this.intervalBeginTime + (this.crossHairTime - intervalMidTime));
                } else if (!this.useBufferedImage) {
                    this.crossHairPos = this.xAt(this.crossHairTime);
                    this.repaint();
                } else if (this.crossHairTime < intervalMidTime) {
                    int oldPos = this.crossHairPos;
                    this.crossHairPos = this.xAt(this.crossHairTime);
                    if (this.useBufferedImage) {
                        if (this.crossHairPos >= oldPos) {
                            this.repaint(oldPos - 2, 0, this.crossHairPos - oldPos + 4, this.getHeight());
                        } else {
                            this.repaint(this.crossHairPos - 2, 0, oldPos - this.crossHairPos + 4, this.getHeight());
                        }
                    } else {
                        this.repaint();
                    }
                } else {
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void updateSelection() {
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        this.paintBuffer();
    }

    @Override
    public void updateLocale() {
        if (this.segmentationControlPanel != null) {
            this.segmentationControlPanel.updateLocale();
        }
        super.updateLocale();
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 0: {
                if (!(e.getModification() instanceof TierImpl)) break;
                this.tierAdded((TierImpl)e.getModification());
                if (this.segmentationControlPanel == null) break;
                this.segmentationControlPanel.addTier((TierImpl)e.getModification());
                break;
            }
            case 1: {
                if (!(e.getModification() instanceof TierImpl)) break;
                this.tierRemoved((Tier)e.getModification());
                if (this.segmentationControlPanel == null) break;
                this.segmentationControlPanel.removeTier((TierImpl)e.getModification());
                break;
            }
            case 2: {
                if (!(e.getInvalidatedObject() instanceof TierImpl)) break;
                this.tierChanged((TierImpl)e.getInvalidatedObject());
                if (this.segmentationControlPanel == null) break;
                this.segmentationControlPanel.changeTier((TierImpl)e.getInvalidatedObject());
                break;
            }
            case 3: {
                if (!(e.getInvalidatedObject() instanceof TierImpl) || !(e.getModification() instanceof Annotation)) break;
                TierImpl invTier = (TierImpl)e.getInvalidatedObject();
                List<TierImpl> depTiers = invTier.getDependentTiers();
                if (depTiers == null) {
                    depTiers = new ArrayList<TierImpl>();
                }
                depTiers.add(0, invTier);
                this.annotationAdded(invTier, (Annotation)e.getModification());
                if (this.lastRecord == null) break;
                Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.ModifyAnnotation");
                Object[] args = new Object[]{"", this.lastRecord.getValue(), this.lastRecord.getExtRef(), this.lastRecord.getCvEntryId()};
                c.execute(e.getModification(), args);
                this.lastRecord = null;
                break;
            }
            case 8: {
                if (!(e.getSource() instanceof Annotation)) break;
                Annotation a = (Annotation)e.getSource();
                this.annotationChanged(a);
                break;
            }
            case 6: 
            case 7: 
            case 14: {
                this.transcriptionChanged();
            }
        }
    }

    private void annotationAdded(Tier tier, Annotation ann) {
        for (int i = 0; i < this.allTiers.size(); ++i) {
            Tag2D tag2d;
            Tier2D tier2d = this.allTiers.get(i);
            if (tier2d.getTier() != tier) continue;
            long bt = ann.getBeginTimeBoundary();
            long et = ann.getEndTimeBoundary();
            int bx = this.timeToPixels(bt);
            int ex = this.timeToPixels(et);
            List<Tag2D> annos = tier2d.getTagsList();
            int size = annos.size();
            boolean overlap = false;
            for (int j = size - 1; j >= 0 && (tag2d = annos.get(j)).getX() + tag2d.getWidth() > bx; --j) {
                if (tag2d.getX() >= ex) continue;
                if (tag2d.getX() >= bx && tag2d.getX() + tag2d.getWidth() <= ex) {
                    tier2d.removeTag(tag2d);
                    overlap = true;
                    continue;
                }
                tag2d.annotationTimesChanged();
                tag2d.setX(this.timeToPixels(tag2d.getBeginTime()));
                tag2d.setWidth(this.timeToPixels(tag2d.getEndTime()) - tag2d.getX());
                tag2d.setTruncatedValue(this.truncateString(tag2d.getValue(), tag2d.getWidth(), this.metrics));
                overlap = true;
            }
            tag2d = new Tag2D(ann);
            int xPos = this.timeToPixels(bt);
            tag2d.setX(xPos);
            int tagWidth = this.timeToPixels(et) - xPos;
            tag2d.setWidth(tagWidth);
            tag2d.setTruncatedValue(this.truncateString(ann.getValue(), tagWidth, this.metrics));
            tier2d.insertTag(tag2d);
            if (!overlap) break;
            break;
        }
        this.paintBuffer();
    }

    private void annotationChanged(Annotation ann) {
        if (ann == null) {
            return;
        }
        Tier2D tier2d = null;
        if (this.editTier2d.getTier() == ann.getTier()) {
            tier2d = this.editTier2d;
        } else {
            Tier2D t2d = null;
            for (int i = 0; i < this.allTiers.size(); ++i) {
                t2d = this.allTiers.get(i);
                if (t2d.getTier() != ann.getTier()) continue;
                tier2d = t2d;
                break;
            }
        }
        if (tier2d != null) {
            List<Tag2D> annos = tier2d.getTagsList();
            int size = annos.size();
            for (int j = size - 1; j >= 0; --j) {
                Tag2D tag2d = annos.get(j);
                if (tag2d.getAnnotation() != ann) continue;
                tag2d.setTruncatedValue(this.truncateString(ann.getValue(), tag2d.getWidth(), this.metrics));
                break;
            }
        }
    }

    private void tierAdded(TierImpl tier) {
        Tier2D tier2d;
        if (tier.hasParentTier() && tier.getLinguisticType().getConstraints() != null && tier.getLinguisticType().getConstraints().getStereoType() != 1) {
            return;
        }
        boolean found = false;
        for (Tier2D t2d : this.allTiers) {
            if (t2d.getTier() != tier && !t2d.getTier().getName().equals(tier.getName())) continue;
            found = true;
            break;
        }
        if (!found && (tier2d = this.createTier2D(tier)) != null) {
            this.allTiers.add(tier2d);
            this.tierYPositions = new int[this.allTiers.size()];
        }
    }

    private void tierRemoved(Tier tier) {
        for (int i = 0; i < this.allTiers.size(); ++i) {
            Tier2D tier2d = this.allTiers.get(i);
            if (tier2d.getTier() != tier) continue;
            this.allTiers.remove(i);
            this.visibleTiers.remove(tier2d);
            if (tier2d == this.editTier2d) {
                if (this.visibleTiers.size() > 0) {
                    this.setActiveTier(this.visibleTiers.get(0).getTier());
                } else if (this.allTiers.size() > 0) {
                    this.setActiveTier(this.allTiers.get(0).getTier());
                }
            }
            this.tierYPositions = new int[this.allTiers.size()];
            break;
        }
    }

    private void tierChanged(TierImpl tier) {
        for (int i = 0; i < this.allTiers.size(); ++i) {
            Tier2D tier2d = this.allTiers.get(i);
            if (tier2d.getTier() != tier) continue;
            if (!tier.hasParentTier() || tier.getLinguisticType().getConstraints() != null && tier.getLinguisticType().getConstraints().getStereoType() == 1) {
                tier2d.updateName();
                break;
            }
            this.allTiers.remove(i);
            this.visibleTiers.remove(tier2d);
            if (tier2d == this.editTier2d) {
                if (this.visibleTiers.size() > 0) {
                    this.setActiveTier(this.visibleTiers.get(0).getTier());
                } else if (this.allTiers.size() > 0) {
                    this.setActiveTier(this.allTiers.get(0).getTier());
                }
            }
            this.tierYPositions = new int[this.allTiers.size()];
            if (this.segmentationControlPanel == null) break;
            this.segmentationControlPanel.removeTier(tier);
            break;
        }
    }

    private void transcriptionChanged() {
        for (int i = 0; i < this.allTiers.size(); ++i) {
            Tier2D tier2d = this.allTiers.get(i);
            this.reextractTier(tier2d);
        }
        this.paintBuffer();
    }

    @Override
    public void preferencesChanged() {
        Boolean rulerVisible;
        Float zoomLevel;
        Integer fontSize = Preferences.getInt("SegmentationViewer.FontSize", this.transcription);
        if (fontSize != null) {
            this.setFontSize(fontSize);
        }
        if ((zoomLevel = Preferences.getFloat("SegmentationViewer.ZoomLevel", this.transcription)) != null) {
            float zl = zoomLevel.floatValue();
            if ((double)zl > 5000.0) {
                zl = 5000.0f;
            }
            float newMsPerPixel = 100.0f / zl * 10.0f;
            this.setMsPerPixel(newMsPerPixel);
            this.updateZoomPopup((int)zl);
        }
        if ((rulerVisible = Preferences.getBool("SegmentationViewer.TimeRulerVisible", this.transcription)) != null) {
            this.setTimeRulerVisible(rulerVisible);
            if (this.timeRulerVisMI != null && this.timeRulerVisible != this.timeRulerVisMI.isSelected()) {
                this.timeRulerVisMI.setSelected(this.timeRulerVisible);
            }
        }
        super.preferencesChanged();
    }

    public void shortcutsChanged() {
        this.updateShortcutMaps();
    }

    private void setPreference(String key, Object value, Transcription trans) {
        Preferences.set(key, value, trans, false, false);
    }

    private void createAnnotation(TimeInterval ti) {
        if (ti != null && this.editTier2d != null) {
            this.lastRecord = ti instanceof AnnotationDataRecord ? (AnnotationDataRecord)ti : null;
            Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.NewAnnotation");
            Object[] args = new Object[]{ti.getBeginTime(), ti.getEndTime()};
            c.execute(this.editTier2d.getTier(), args);
        }
    }

    public void setCurrentBeginTime(long time) {
        this.currentBeginTime = time;
        this.paintBuffer();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.intervalWidth = this.imageWidth = this.getWidth() - this.defBarWidth;
        this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        }
        if (this.getWidth() > 200) {
            this.hScrollBar.setBounds(0, this.getHeight() - this.defBarWidth, this.getWidth() - this.defBarWidth - 100, this.defBarWidth);
            this.updateHorScrollBar();
            this.scrollBar.setBounds(this.getWidth() - this.defBarWidth, 0, this.defBarWidth, this.getHeight() - this.defBarWidth);
            this.updateScrollBar();
            if (!this.zoomSliderPanel.isVisible()) {
                this.zoomSliderPanel.setVisible(true);
            }
            this.zoomSliderPanel.setBounds(this.hScrollBar.getWidth(), this.getHeight() - this.defBarWidth, 100, this.defBarWidth);
            this.zoomSlider.setBounds(0, 0, 100, this.defBarWidth);
            this.corner.setBounds(this.getWidth() - this.defBarWidth, this.getHeight() - this.defBarWidth, this.defBarWidth, this.defBarWidth);
        } else {
            this.zoomSliderPanel.setVisible(false);
            this.hScrollBar.setBounds(0, this.getHeight() - this.defBarWidth, this.getWidth() - this.defBarWidth, this.defBarWidth);
            this.updateHorScrollBar();
            this.scrollBar.setBounds(this.getWidth() - this.defBarWidth, 0, this.defBarWidth, this.getHeight() - this.defBarWidth);
            this.updateScrollBar();
            this.corner.setBounds(this.getWidth() - this.defBarWidth, this.getHeight() - this.defBarWidth, this.defBarWidth, this.defBarWidth);
        }
        this.paintBuffer();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        super.componentResized(e);
    }

    @Override
    public void setActiveTier(Tier tier) {
        if (tier != null) {
            if (this.editTier2d != null && this.editTier2d.getTier() == tier) {
                return;
            }
            this.dragEditTag2D = null;
            for (Tier2D t2d : this.allTiers) {
                if (t2d.getTier() != tier) continue;
                this.editTier2d = t2d;
                if (this.segmentationControlPanel != null) {
                    this.segmentationControlPanel.setActiveTier(tier);
                }
                this.setActionsForTier((TierImpl)tier);
                this.paintBuffer();
                break;
            }
        } else {
            this.dragEditTag2D = null;
            this.editTier2d = null;
            if (this.segmentationControlPanel != null) {
                this.segmentationControlPanel.setActiveTier(null);
            }
            this.setActionsForTier(null);
            this.paintBuffer();
        }
    }

    private void setActionsForTier(TierImpl tier) {
        ControlledVocabulary cv;
        String cvname;
        if (this.cvInputMap != null) {
            this.cvInputMap.clear();
        }
        if (this.cvActionMap != null) {
            this.cvActionMap.clear();
        }
        if (tier != null && (cvname = tier.getLinguisticType().getControlledVocabularyName()) != null && (cv = this.transcription.getControlledVocabulary(cvname)) != null) {
            if (this.cvInputMap == null) {
                this.cvInputMap = new ComponentInputMap(this);
                this.mainInputMap.setParent(this.cvInputMap);
            }
            if (this.cvActionMap == null) {
                this.cvActionMap = new ActionMap();
                this.mainActionMap.setParent(this.cvActionMap);
            }
            String cveId = "cve-";
            int i = 0;
            for (CVEntry e : cv) {
                if (e.getShortcutKeyCode() <= 0) continue;
                String nextId = cveId + i;
                ++i;
                SegmentAction sa = new SegmentAction(e);
                this.cvInputMap.put((KeyStroke)sa.getValue("AcceleratorKey"), nextId);
                this.cvActionMap.put(nextId, sa);
            }
        }
    }

    public void setNextTierActive(boolean down) {
        for (int i = 0; i < this.visibleTiers.size(); ++i) {
            Tier2D nt2d = this.visibleTiers.get(i);
            if (nt2d != this.editTier2d) continue;
            if (down) {
                if (i < this.visibleTiers.size() - 1) {
                    this.setActiveTier(this.visibleTiers.get(i + 1).getTier());
                    break;
                }
                this.setActiveTier(this.visibleTiers.get(0).getTier());
                break;
            }
            if (i > 0) {
                this.setActiveTier(this.visibleTiers.get(i - 1).getTier());
                break;
            }
            this.setActiveTier(this.visibleTiers.get(this.visibleTiers.size() - 1).getTier());
            break;
        }
    }

    public void updateFont(Font f) {
        int oldSize = this.font.getSize();
        this.font = f;
        this.setFont(this.font);
        this.metrics = this.getFontMetrics(this.font);
        this.recalculateTagSizes();
        this.pixelsForTierHeight = this.calcTierHeight();
        if (oldSize != f.getSize()) {
            this.notifySegmentationControlPanel();
            this.paintBuffer();
            this.scrollBar.setBlockIncrement(this.pixelsForTierHeight);
            this.updateScrollBar();
        } else {
            this.paintBuffer();
        }
    }

    public void setFontSize(int fontSize) {
        this.updateFont(this.getFont().deriveFont((float)fontSize));
        if (this.popup != null) {
            Enumeration<AbstractButton> en = this.fontSizeBG.getElements();
            while (en.hasMoreElements()) {
                JMenuItem item = (JMenuItem)en.nextElement();
                String value = item.getText();
                try {
                    int v = Integer.parseInt(value);
                    if (v != fontSize) continue;
                    item.setSelected(true);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
    }

    @Override
    public void setVisibleTiers(List<TierImpl> tiers) {
        if (tiers != null) {
            this.visibleTiers.clear();
            block0: for (Tier tier : tiers) {
                for (Tier2D t2d : this.allTiers) {
                    if (t2d.getTier() != tier) continue;
                    this.visibleTiers.add(t2d);
                    continue block0;
                }
            }
            this.notifySegmentationControlPanel();
            this.paintBuffer();
        }
    }

    @Override
    protected void setTimeRulerVisible(boolean visible) {
        if (visible == this.timeRulerVisible) {
            return;
        }
        super.setTimeRulerVisible(visible);
        this.paintBuffer();
        this.notifySegmentationControlPanel();
        this.setPreference("SegmentationViewer.TimeRulerVisible", (Object)this.timeRulerVisible, this.transcription);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        int value = e.getValue();
        if (e.getSource() == this.scrollBar) {
            this.verticalScrollOffset = value;
            this.notifySegmentationControlPanel();
        } else if (e.getSource() == this.hScrollBar) {
            this.setIntervalBeginTime(this.pixelToTime(value));
        }
        this.paintBuffer();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.zoomSlider) {
            float nmspp;
            int zoomValue = this.zoomSlider.getValue();
            if (zoomValue > 100) {
                float factor = (float)(zoomValue - 100) / (float)(this.zoomSlider.getMaximum() - 100);
                zoomValue = 100 + (int)(factor * 900.0f);
            }
            if ((nmspp = 100.0f / (float)zoomValue * 10.0f) != this.msPerPixel) {
                this.setMsPerPixel(nmspp);
            }
            this.zoomSlider.setToolTipText(String.valueOf(zoomValue));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().indexOf("font") > -1) {
            String sizeString = e.getActionCommand();
            int index = sizeString.indexOf("font") + 4;
            int size = 12;
            try {
                size = Integer.parseInt(sizeString.substring(index));
            }
            catch (NumberFormatException nfe) {
                System.err.println("Error parsing font size");
            }
            this.updateFont(this.getFont().deriveFont((float)size));
            this.setPreference("SegmentationViewer.FontSize", (Object)size, this.transcription);
            return;
        }
        super.actionPerformed(e);
    }

    private Tag2D getAnnotationAtX(int x) {
        if (this.editTier2d == null) {
            return null;
        }
        long t = this.timeAt(x);
        for (int i = 0; i < this.editTier2d.getTagsList().size(); ++i) {
            Tag2D t2d = this.editTier2d.getTagsList().get(i);
            if (t >= t2d.getBeginTime() && t <= t2d.getEndTime()) {
                return t2d;
            }
            if (t2d.getEndTime() > t) break;
        }
        return null;
    }

    private void updateDragEditTag(Point dragEndPoint) {
        if (this.dragEditTag2D == null) {
            return;
        }
        int diff = dragEndPoint.x - this.dragStartPoint.x;
        switch (this.dragEditMode) {
            case 0: {
                if (this.dragParentBegin == -1L) {
                    this.dragEditTag2D.setX(this.dragEditTag2D.getX() + diff);
                    this.dragStartPoint = dragEndPoint;
                } else {
                    long bt = this.pixelToTime(this.dragEditTag2D.getX() + diff);
                    if (diff < 0) {
                        if (bt < this.dragParentBegin) {
                            bt = this.dragParentBegin;
                            int nx = this.timeToPixels(bt);
                            this.dragEditTag2D.setX(nx);
                        } else {
                            this.dragEditTag2D.setX(this.dragEditTag2D.getX() + diff);
                            this.dragStartPoint = dragEndPoint;
                        }
                    } else {
                        long et = this.pixelToTime(this.dragEditTag2D.getX() + this.dragEditTag2D.getWidth() + diff);
                        if (et > this.dragParentEnd) {
                            et = this.dragParentEnd;
                            bt = et - this.pixelToTime(this.dragEditTag2D.getWidth());
                            this.dragEditTag2D.setX(this.timeToPixels(bt));
                        } else {
                            this.dragEditTag2D.setX(this.dragEditTag2D.getX() + diff);
                            this.dragStartPoint = dragEndPoint;
                        }
                    }
                }
                this.setMediaTime(this.pixelToTime(this.dragEditTag2D.getX()));
                break;
            }
            case 1: {
                if (this.dragEditTag2D.getX() + diff >= this.dragEditTag2D.getX() + this.dragEditTag2D.getWidth() - 1) break;
                if (this.dragParentBegin == -1L || diff > 0) {
                    this.dragEditTag2D.setX(this.dragEditTag2D.getX() + diff);
                    this.dragEditTag2D.setWidth(this.dragEditTag2D.getWidth() - diff);
                    this.dragStartPoint = dragEndPoint;
                } else if (this.dragParentBegin > -1L && diff < 0) {
                    long bt = this.pixelToTime(this.dragEditTag2D.getX() + diff);
                    if (bt < this.dragParentBegin) {
                        bt = this.dragParentBegin;
                        int nx = this.timeToPixels(bt);
                        this.dragEditTag2D.setX(nx);
                        this.dragEditTag2D.setWidth(this.timeToPixels(this.dragEditTag2D.getEndTime() - bt));
                    } else {
                        this.dragEditTag2D.setX(this.dragEditTag2D.getX() + diff);
                        this.dragEditTag2D.setWidth(this.dragEditTag2D.getWidth() - diff);
                        this.dragStartPoint = dragEndPoint;
                    }
                }
                this.setMediaTime(this.pixelToTime(this.dragEditTag2D.getX()));
                break;
            }
            case 2: {
                if (this.dragEditTag2D.getWidth() + diff <= 1) break;
                if (this.dragParentEnd == -1L || diff < 0) {
                    this.dragEditTag2D.setWidth(this.dragEditTag2D.getWidth() + diff);
                    this.dragStartPoint = dragEndPoint;
                } else if (this.dragParentEnd > -1L && diff > 0) {
                    long et = this.pixelToTime(this.dragEditTag2D.getX() + this.dragEditTag2D.getWidth() + diff);
                    if (et > this.dragParentEnd) {
                        et = this.dragParentEnd;
                        this.dragEditTag2D.setWidth(this.timeToPixels(et) - this.dragEditTag2D.getX());
                    } else {
                        this.dragEditTag2D.setWidth(this.dragEditTag2D.getWidth() + diff);
                        this.dragStartPoint = dragEndPoint;
                    }
                }
                this.setMediaTime(this.pixelToTime(this.dragEditTag2D.getX() + this.dragEditTag2D.getWidth()));
            }
        }
        this.repaint();
    }

    private void doDragModifyAnnotationTime() {
        if (this.dragEditTag2D == null) {
            return;
        }
        AlignableAnnotation editAnn = null;
        if (this.dragEditTag2D.getAnnotation() instanceof AlignableAnnotation) {
            editAnn = (AlignableAnnotation)this.dragEditTag2D.getAnnotation();
        }
        if (editAnn == null) {
            return;
        }
        long beginTime = 0L;
        long endTime = 0L;
        switch (this.dragEditMode) {
            case 0: {
                beginTime = this.pixelToTime(this.dragEditTag2D.getX());
                endTime = this.pixelToTime(this.dragEditTag2D.getX() + this.dragEditTag2D.getWidth());
                break;
            }
            case 1: {
                beginTime = this.pixelToTime(this.dragEditTag2D.getX());
                endTime = this.dragEditTag2D.getEndTime();
                break;
            }
            case 2: {
                beginTime = this.dragEditTag2D.getBeginTime();
                endTime = this.pixelToTime(this.dragEditTag2D.getX() + this.dragEditTag2D.getWidth());
            }
        }
        if (endTime <= beginTime) {
            return;
        }
        if ((float)Math.abs(beginTime - this.dragEditTag2D.getBeginTime()) < this.msPerPixel && (float)Math.abs(endTime - this.dragEditTag2D.getEndTime()) < this.msPerPixel) {
            return;
        }
        Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.ModifyAnnotationTime");
        c.execute(editAnn, new Object[]{beginTime, endTime});
    }

    protected void deleteEditAnnotation() {
        if (this.dragEditTag2D == null) {
            return;
        }
        AbstractAnnotation editAnn = null;
        if (this.dragEditTag2D.getAnnotation() instanceof AlignableAnnotation) {
            editAnn = (AlignableAnnotation)this.dragEditTag2D.getAnnotation();
        }
        if (editAnn == null) {
            return;
        }
        Tier tier = editAnn.getTier();
        this.dragEditTag2D = null;
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.DeleteAnnotation");
        c.execute(tier, new Object[]{this.getViewerManager(), editAnn});
    }

    protected void mergeAnnotation(boolean next) {
        if (this.dragEditTag2D != null) {
            Annotation aa = this.dragEditTag2D.getAnnotation();
            Command c = next ? ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.MergeWithNext") : ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.MergeWithBefore");
            c.execute(this.transcription, new Object[]{aa, next});
        }
    }

    protected void splitAnnotation() {
        if (this.dragEditTag2D != null) {
            Annotation ann = this.dragEditTag2D.getAnnotation();
            Object[] arguments = new Object[2];
            arguments[0] = ann;
            if (ann.getBeginTimeBoundary() < this.splitTime && ann.getEndTimeBoundary() > this.splitTime) {
                arguments[1] = this.splitTime;
            }
            Command command = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.SplitAnnotation");
            command.execute(this.transcription, arguments);
        }
    }

    protected void modifyAnnotationTimeDlg() {
        if (this.dragEditTag2D != null) {
            Annotation ann = this.dragEditTag2D.getAnnotation();
            Object[] arguments = new Object[]{ann};
            Command command = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.ModifyAnnotationTimeDialog");
            command.execute(this.getViewerManager(), arguments);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        this.dragEndPoint = e.getPoint();
        if (this.panMode) {
            int scrolldiff = this.dragEndPoint.x - this.dragStartPoint.x;
            long newTime = this.intervalBeginTime - (long)((int)((float)scrolldiff * this.msPerPixel));
            if (this.intervalBeginTime < 0L && newTime < this.intervalBeginTime) {
                newTime = this.intervalBeginTime;
            }
            this.setIntervalBeginTime(newTime);
            this.dragStartPoint = this.dragEndPoint;
            return;
        }
        if (this.dragEditing) {
            this.updateDragEditTag(this.dragEndPoint);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int y;
        Tag2D oldEdit = this.dragEditTag2D;
        int n = y = this.timeRulerVisible ? this.rulerHeight : 0;
        if (e.getY() > y && e.getY() < y + this.editTierHeight) {
            this.dragEditTag2D = this.getAnnotationAtX(e.getX());
            if (this.dragEditTag2D != null) {
                int x = (int)((float)this.dragEditTag2D.getBeginTime() / this.msPerPixel - (float)this.intervalBeginTime / this.msPerPixel);
                int x2 = x + (int)((float)(this.dragEditTag2D.getEndTime() - this.dragEditTag2D.getBeginTime()) / this.msPerPixel);
                if (Math.abs(x - e.getX()) < 8) {
                    this.dragEditMode = 1;
                    this.setCursor(Cursor.getPredefinedCursor(10));
                } else if (Math.abs(x2 - e.getX()) < 8) {
                    this.dragEditMode = 2;
                    this.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    this.dragEditMode = 0;
                    this.setCursor(Cursor.getPredefinedCursor(13));
                }
                if (x2 - x < 24) {
                    this.dragEditMode = 0;
                    this.setCursor(Cursor.getPredefinedCursor(13));
                }
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.repaint();
        } else {
            this.dragEditTag2D = null;
            if (oldEdit != null) {
                this.repaint();
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (this.dragEditTag2D != null) {
            this.setSelection(this.dragEditTag2D.getAnnotation().getBeginTimeBoundary(), this.dragEditTag2D.getAnnotation().getEndTimeBoundary());
        } else {
            Tag2D tag2d = this.getAnnotationAtX(e.getX());
            if (tag2d != null) {
                this.setSelection(tag2d.getAnnotation().getBeginTimeBoundary(), tag2d.getAnnotation().getEndTimeBoundary());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (this.dragEditTag2D != null) {
            Tag2D copy = new Tag2D(this.dragEditTag2D.getAnnotation());
            copy.setX(this.dragEditTag2D.getX());
            copy.setWidth(this.dragEditTag2D.getWidth());
            this.dragEditTag2D = copy;
            this.dragStartPoint = e.getPoint();
            this.dragStartTime = this.timeAt(e.getX());
            this.dragEditing = true;
            if (((TierImpl)this.dragEditTag2D.getAnnotation().getTier()).hasParentTier()) {
                AlignableAnnotation pa = (AlignableAnnotation)this.dragEditTag2D.getAnnotation().getParentAnnotation();
                if (pa != null) {
                    this.dragParentBegin = pa.getBeginTimeBoundary();
                    this.dragParentEnd = pa.getEndTimeBoundary();
                } else {
                    this.dragParentBegin = -1L;
                    this.dragParentEnd = -1L;
                }
            } else {
                this.dragParentBegin = -1L;
                this.dragParentEnd = -1L;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.popup != null && this.popup.isVisible()) {
            return;
        }
        if (this.dragEditing) {
            this.setCursor(Cursor.getDefaultCursor());
            this.doDragModifyAnnotationTime();
            this.dragEditing = false;
            this.dragEditTag2D = null;
            this.dragParentBegin = -1L;
            this.dragParentEnd = -1L;
            this.repaint();
        } else {
            super.mouseReleased(e);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() == 0) {
            return;
        }
        if (e.isControlDown()) {
            super.mouseWheelMoved(e);
        } else if (e.isShiftDown()) {
            super.mouseWheelMoved(e);
        } else if (e.getUnitsToScroll() > 0) {
            this.scrollBar.setValue(this.scrollBar.getValue() + this.pixelsForTierHeight);
        } else {
            this.scrollBar.setValue(this.scrollBar.getValue() - this.pixelsForTierHeight);
        }
    }

    public class SegmentAction
    extends AbstractAction {
        public SegmentAction() {
            this.putValue("AcceleratorKey", ShortcutsUtil.getInstance().getKeyStrokeForAction("SegmentationMode.Actions.Segment", "Menu.Options.SegmentationMode"));
            this.putValue("Default", null);
        }

        public SegmentAction(CVEntry cve) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(cve.getShortcutKeyCode(), 0));
            this.putValue("Default", cve);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object val = this.getValue("Default");
            if (val instanceof CVEntry) {
                SegmentationViewer2.this.addSegmentTime((CVEntry)val);
            } else {
                SegmentationViewer2.this.addSegmentTime(null);
            }
        }
    }

    public class ActiveTierAction
    extends AbstractAction {
        private boolean down = true;

        public ActiveTierAction(boolean down) {
            this.down = down;
            if (down) {
                this.putValue("Name", ElanLocale.getString("CommandActions.NextActiveTier"));
                this.putValue("AcceleratorKey", ShortcutsUtil.getInstance().getKeyStrokeForAction("CommandActions.NextActiveTier", "Menu.Options.SegmentationMode"));
                this.putValue("Default", null);
            } else {
                this.putValue("Name", ElanLocale.getString("CommandActions.PreviousActiveTier"));
                this.putValue("AcceleratorKey", ShortcutsUtil.getInstance().getKeyStrokeForAction("CommandActions.PreviousActiveTier", "Menu.Options.SegmentationMode"));
                this.putValue("Default", null);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SegmentationViewer2.this.setNextTierActive(this.down);
        }
    }

    public class DeleteAnnotationAction
    extends AbstractAction {
        public DeleteAnnotationAction() {
            super(ElanLocale.getString("Menu.Annotation.DeleteAnnotation"));
            this.putValue("AcceleratorKey", ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Annotation.DeleteAnnotation", "Menu.Options.SegmentationMode"));
            this.putValue("Default", null);
        }

        public DeleteAnnotationAction(KeyStroke keyStroke) {
            this.putValue("AcceleratorKey", keyStroke);
            this.putValue("Default", null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SegmentationViewer2.this.deleteEditAnnotation();
        }
    }

    public class MergeAnnotationAction
    extends AbstractAction {
        private boolean next = true;

        public MergeAnnotationAction(boolean next) {
            this.next = next;
            if (next) {
                this.putValue("Name", ElanLocale.getString("Menu.Annotation.MergeWithNext"));
                this.putValue("AcceleratorKey", ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Annotation.MergeWithNext", "Menu.Options.SegmentationMode"));
                this.putValue("Default", null);
            } else {
                this.putValue("Name", ElanLocale.getString("Menu.Annotation.MergeWithBefore"));
                this.putValue("AcceleratorKey", ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Annotation.MergeWithBefore", "Menu.Options.SegmentationMode"));
                this.putValue("Default", null);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SegmentationViewer2.this.mergeAnnotation(this.next);
        }
    }

    public class SplitAnnotationAction
    extends AbstractAction {
        public SplitAnnotationAction() {
            super(ElanLocale.getString("Menu.Annotation.SplitAnnotation"));
            this.putValue("AcceleratorKey", ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Annotation.SplitAnnotation", "Menu.Options.SegmentationMode"));
            this.putValue("Default", null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SegmentationViewer2.this.splitAnnotation();
        }
    }

    public class ModifyTimeDlgAction
    extends AbstractAction {
        public ModifyTimeDlgAction() {
            super(ElanLocale.getString("Menu.Annotation.ModifyAnnotationTimeDialog"));
            this.putValue("AcceleratorKey", ShortcutsUtil.getInstance().getKeyStrokeForAction("Menu.Annotation.ModifyAnnotationTimeDialog", "Menu.Options.SegmentationMode"));
            this.putValue("Default", null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SegmentationViewer2.this.modifyAnnotationTimeDlg();
        }
    }

    public class PressReleaseSegmentAction
    extends AbstractAction {
        private boolean up;

        public PressReleaseSegmentAction(boolean up) {
            this.up = up;
            KeyStroke ks = ShortcutsUtil.getInstance().getKeyStrokeForAction("SegmentationMode.Actions.Segment", "Menu.Options.SegmentationMode");
            if (ks == null) {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0, up));
            } else {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(ks.getKeyCode(), 0, up));
            }
            this.putValue("Default", null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.up && SegmentationViewer2.this.pressReleaseKeyDown) {
                return;
            }
            SegmentationViewer2.this.pressReleaseKeyDown = !this.up;
            SegmentationViewer2.this.addPressReleaseTime(this.up);
        }
    }
}

