/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.WaveFormViewerMenuManager;
import mpi.eudico.client.util.SelectableObject;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import nl.mpi.util.FileUtility;

public class SignalViewerControlPanel
extends JPanel
implements ActionListener {
    private JComboBox wfComboBox;
    private WaveFormViewerMenuManager manager;

    public SignalViewerControlPanel(WaveFormViewerMenuManager manager) {
        this.manager = manager;
        this.initComponents();
    }

    private void initComponents() {
        this.manager.setSignalViewerControlPanel(this);
        this.setLayout(new GridBagLayout());
        this.wfComboBox = new JComboBox();
        this.wfComboBox.addActionListener(this);
        int origFontSize = this.wfComboBox.getFont().getSize();
        this.wfComboBox.setFont(new Font(this.wfComboBox.getFont().getFontName(), this.wfComboBox.getFont().getStyle(), 5 * origFontSize / 6));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 6);
        this.add((Component)this.wfComboBox, gbc);
        this.initViewerPopUPMenu();
    }

    public void initViewerPopUPMenu() {
        this.wfComboBox.removeActionListener(this);
        this.wfComboBox.removeAllItems();
        List<SelectableObject<MediaDescriptor>> list = this.manager.getWaveFormList();
        JComboBoxItem selectedItem = null;
        for (SelectableObject<MediaDescriptor> sob : list) {
            String mediaUrl = sob.getValue().mediaURL;
            String fileName = FileUtility.fileNameFromPath(mediaUrl);
            JComboBoxItem item = new JComboBoxItem(mediaUrl, fileName);
            this.wfComboBox.addItem(item);
            if (!sob.isSelected()) continue;
            selectedItem = item;
        }
        if (selectedItem != null) {
            this.wfComboBox.setSelectedItem(selectedItem);
        }
        this.wfComboBox.addActionListener(this);
    }

    public void updateWaveFormPanel(String mediaUrl) {
        this.wfComboBox.removeActionListener(this);
        for (int i = 0; i < this.wfComboBox.getItemCount(); ++i) {
            JComboBoxItem item = (JComboBoxItem)this.wfComboBox.getItemAt(i);
            if (!item.mediaURL.equals(mediaUrl)) continue;
            this.wfComboBox.setSelectedIndex(i);
            break;
        }
        this.wfComboBox.addActionListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.wfComboBox) {
            String mediaURL = ((JComboBoxItem)this.wfComboBox.getSelectedItem()).mediaURL;
            this.manager.performActionFor(mediaURL, e);
        }
    }

    private class JComboBoxItem {
        String mediaURL;
        String fileName;

        JComboBoxItem(String mediaURL, String fileName) {
            this.mediaURL = mediaURL;
            this.fileName = fileName;
        }

        public String toString() {
            return this.fileName;
        }
    }
}

