/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListCellRenderer;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesListener;
import mpi.eudico.client.annotator.TierOrderListener;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.grid.GridViewer;
import mpi.eudico.client.annotator.tiersets.TierSetUtil;
import mpi.eudico.client.annotator.util.TierMenuStringFormatter;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewer;
import mpi.eudico.client.annotator.viewer.SubtitleViewer;
import mpi.eudico.client.annotator.viewer.TextViewer;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class SingleTierViewerPanel
extends JPanel
implements ACMEditListener,
ElanLocaleListener,
ItemListener,
TierOrderListener,
PreferencesListener,
MouseListener,
ActionListener {
    private String EMPTY_ITEM = ElanLocale.getString("SingleTierViewerPanel.ComboBoxDefaultString");
    private String none_item = ElanLocale.getString("SingleTierViewerPanel.ComboBoxSelectNone");
    private ViewerManager2 viewerManager;
    private SingleTierViewer viewer;
    private JComboBox tierComboBox;
    private Map<String, Tier> tierTable;
    private Tier currentTier;
    private List<String> tierOrder;
    private JButton optionIcon;
    private JPopupMenu popupMenu;
    private JRadioButtonMenuItem normalMI;
    private JRadioButtonMenuItem multiAssMI;
    private JRadioButtonMenuItem multiSubMI;
    private int gridMode;
    private boolean workWithTierSet = false;
    private Boolean alphabeticTierOrder = false;

    public SingleTierViewerPanel(ViewerManager2 viewerManager) {
        this.viewerManager = viewerManager;
        this.tierComboBox = new JComboBox();
        this.tierComboBox.setMaximumRowCount(20);
        this.optionIcon = new JButton();
        this.tierTable = new HashMap<String, Tier>();
        this.processAlphabeticTierOrderPreference();
        this.fillComboBox();
        this.tierComboBox.addItemListener(this);
        this.setLayout(new BorderLayout());
        this.tierComboBox.setRenderer(new EmptyRenderer(this.tierComboBox.getRenderer()));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (SingleTierViewerPanel.this.viewer instanceof AbstractViewer) {
                    ((AbstractViewer)((Object)SingleTierViewerPanel.this.viewer)).isClosing();
                }
            }
        });
        Preferences.addPreferencesListener(viewerManager.getTranscription(), this);
    }

    public void setViewer(SingleTierViewer viewer) {
        this.viewer = viewer;
        if (this.currentTier != null) {
            this.viewerManager.setTierForViewer(viewer, this.currentTier);
        }
        if (viewer instanceof GridViewer) {
            try {
                ImageIcon icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/triangle_down.gif"));
                this.optionIcon.setIcon(icon);
            }
            catch (Exception ex) {
                this.optionIcon.setText("Options");
            }
            this.optionIcon.addMouseListener(this);
            this.optionIcon.setToolTipText(ElanLocale.getString("SingleTierViewerPanel.Label.ToolTip"));
            JPanel jp = new JPanel();
            jp.setLayout(new BorderLayout());
            jp.add((Component)this.optionIcon, "West");
            jp.add((Component)this.tierComboBox, "Center");
            this.add((Component)jp, "North");
            this.gridMode = ((GridViewer)viewer).getMode();
        } else {
            this.add((Component)this.tierComboBox, "North");
        }
        this.add((Component)((AbstractViewer)((Object)viewer)), "Center");
    }

    public SingleTierViewer getViewer() {
        return this.viewer;
    }

    private void fillComboBox() {
        this.tierComboBox.removeAllItems();
        this.tierTable.clear();
        this.tierComboBox.addItem(this.EMPTY_ITEM);
        if (this.tierOrder != null) {
            for (int i = 0; i < this.tierOrder.size(); ++i) {
                String tierName = this.tierOrder.get(i);
                TierImpl tier = ((TranscriptionImpl)this.viewerManager.getTranscription()).getTierWithId(tierName);
                if (tier == null) continue;
                String label = TierMenuStringFormatter.GetFormattedString(tier);
                this.tierComboBox.addItem(label);
                this.tierTable.put(label, tier);
            }
        } else {
            try {
                List<TierImpl> tiers = ((TranscriptionImpl)this.viewerManager.getTranscription()).getTiers();
                int tiers_size = tiers.size();
                for (int i = 0; i < tiers_size; ++i) {
                    TierImpl tier = tiers.get(i);
                    String label = TierMenuStringFormatter.GetFormattedString(tier);
                    this.tierComboBox.addItem(label);
                    this.tierTable.put(label, tier);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                this.updateComboBox();
                break;
            }
            case 2: {
                if (!(e.getInvalidatedObject() instanceof TierImpl)) break;
                this.tierChanged((TierImpl)e.getInvalidatedObject());
                break;
            }
            default: {
                return;
            }
        }
    }

    private void tierChanged(TierImpl tier) {
        block8: {
            if (tier == this.currentTier) {
                String currentLabel = (String)this.tierComboBox.getSelectedItem();
                String newLabel = TierMenuStringFormatter.GetFormattedString(tier);
                if (!newLabel.equals(currentLabel)) {
                    this.tierTable.remove(currentLabel);
                    this.tierTable.put(newLabel, this.currentTier);
                    for (int i = 0; i < this.tierComboBox.getItemCount(); ++i) {
                        if (!this.tierComboBox.getItemAt(i).equals(currentLabel)) continue;
                        this.tierComboBox.removeItemAt(i);
                        this.tierComboBox.insertItemAt(newLabel, i);
                        this.tierComboBox.setSelectedItem(newLabel);
                        break;
                    }
                }
            } else {
                String newLabel = TierMenuStringFormatter.GetFormattedString(tier);
                if (!this.tierTable.containsKey(newLabel)) {
                    for (String name : this.tierTable.keySet()) {
                        if (this.tierTable.get(name) != tier) continue;
                        this.tierTable.remove(name);
                        this.tierTable.put(newLabel, tier);
                        for (int i = 0; i < this.tierComboBox.getItemCount(); ++i) {
                            if (!this.tierComboBox.getItemAt(i).equals(name)) continue;
                            this.tierComboBox.removeItemAt(i);
                            this.tierComboBox.insertItemAt(newLabel, i);
                            break block8;
                        }
                        break;
                    }
                }
            }
        }
        if (this.viewer instanceof GridViewer && (this.gridMode == 1 || this.gridMode == 2)) {
            this.updateComboBox();
        }
    }

    private void updateComboBox() {
        try {
            Tier selTier = this.currentTier;
            switch (this.gridMode) {
                case 0: {
                    this.fillComboBox();
                    break;
                }
                case 1: {
                    this.fillComboBoxMulti(4);
                    break;
                }
                case 2: {
                    this.fillComboBoxMulti(3);
                    break;
                }
            }
            if (selTier != null) {
                this.selectTier(selTier);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object objSource = e.getSource();
        if (objSource == this.tierComboBox && e.getStateChange() == 1) {
            String selectedTierName = (String)this.tierComboBox.getSelectedItem();
            Tier tier = null;
            if (!selectedTierName.equals(this.EMPTY_ITEM)) {
                tier = this.tierTable.get(selectedTierName);
            }
            this.viewerManager.setTierForViewer(this.viewer, tier);
            this.currentTier = tier;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.normalMI) {
            if (this.normalMI.isSelected()) {
                this.gridMode = 0;
                if (this.viewer instanceof GridViewer) {
                    ((GridViewer)this.viewer).setMode(0);
                }
                this.updateComboBox();
            }
        } else if (e.getSource() == this.multiAssMI) {
            if (this.multiAssMI.isSelected()) {
                this.gridMode = 1;
                if (this.viewer instanceof GridViewer) {
                    ((GridViewer)this.viewer).setMode(1);
                }
                this.updateComboBox();
            }
        } else if (e.getSource() == this.multiSubMI && this.multiSubMI.isSelected()) {
            this.gridMode = 2;
            if (this.viewer instanceof GridViewer) {
                ((GridViewer)this.viewer).setMode(2);
            }
            this.updateComboBox();
        }
    }

    private void fillComboBoxMulti(int constraint) {
        this.tierComboBox.removeAllItems();
        this.tierTable.clear();
        this.tierComboBox.addItem(this.EMPTY_ITEM);
        if (this.tierOrder != null) {
            block2: for (int i = 0; i < this.tierOrder.size(); ++i) {
                List<TierImpl> dependentTiers;
                String tierName = this.tierOrder.get(i);
                TierImpl tier = ((TranscriptionImpl)this.viewerManager.getTranscription()).getTierWithId(tierName);
                if (tier == null || (dependentTiers = tier.getDependentTiers()) == null) continue;
                for (int d = 0; d < dependentTiers.size(); ++d) {
                    TierImpl depeTier = dependentTiers.get(d);
                    if (depeTier.getLinguisticType().getConstraints().getStereoType() != constraint) continue;
                    this.addToCombo(tier);
                    continue block2;
                }
            }
        } else {
            try {
                List<TierImpl> tiers = ((TranscriptionImpl)this.viewerManager.getTranscription()).getTiers();
                int tiers_size = tiers.size();
                for (int i = 0; i < tiers_size; ++i) {
                    TierImpl tier = tiers.get(i);
                    LinguisticType lt = tier.getLinguisticType();
                    Constraint c = lt.getConstraints();
                    if (c == null || c.getStereoType() != constraint) continue;
                    TierImpl tierParent = tier.getParentTier();
                    this.addToCombo(tierParent);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addToCombo(Tier tierParent) {
        String label = TierMenuStringFormatter.GetFormattedString((TierImpl)tierParent);
        String str = null;
        int combo_size = this.tierComboBox.getItemCount();
        for (int i = 0; i < combo_size; ++i) {
            str = (String)this.tierComboBox.getItemAt(i);
            if (str == null || !label.equals(str)) continue;
            return;
        }
        this.tierComboBox.addItem(label);
        this.tierTable.put(label, tierParent);
    }

    public void selectTier(String tierName) {
        if (tierName != null) {
            if (this.tierTable.containsKey(tierName)) {
                this.tierComboBox.setSelectedItem(tierName);
            } else {
                Tier t = this.viewerManager.getTranscription().getTierWithId(tierName);
                if (t != null) {
                    this.selectTier(t);
                }
            }
        }
    }

    private void selectTier(Tier tier) {
        if (tier == null) {
            this.tierComboBox.setSelectedIndex(0);
        } else {
            for (String key : this.tierTable.keySet()) {
                Tier tierIt = this.tierTable.get(key);
                if (tierIt != tier) continue;
                this.tierComboBox.setSelectedItem(key);
                break;
            }
        }
    }

    public String getSelectedTierName() {
        String name = null;
        if (this.currentTier != null) {
            name = this.currentTier.getName();
        }
        return name;
    }

    public boolean isMultiTierMode() {
        if (this.viewer instanceof GridViewer) {
            return this.gridMode == 1 || this.gridMode == 2;
        }
        return false;
    }

    @Deprecated
    public void setMultiTierMode(boolean multiMode) {
        if (!multiMode) {
            this.setTierMode(0);
        } else {
            this.setTierMode(1);
        }
    }

    public void setTierMode(int mode) {
        if (this.viewer instanceof GridViewer) {
            this.gridMode = mode;
        }
    }

    @Override
    public void updateLocale() {
        String oldItem = this.EMPTY_ITEM;
        this.EMPTY_ITEM = ElanLocale.getString("SingleTierViewerPanel.ComboBoxDefaultString");
        this.none_item = ElanLocale.getString("SingleTierViewerPanel.ComboBoxSelectNone");
        if (!oldItem.equals(this.EMPTY_ITEM) && this.tierComboBox.getItemCount() > 0) {
            this.tierComboBox.removeItemListener(this);
            this.tierComboBox.removeItemAt(0);
            this.tierComboBox.insertItemAt(this.EMPTY_ITEM, 0);
            this.tierComboBox.addItemListener(this);
        }
        this.optionIcon.setToolTipText(ElanLocale.getString("SingleTierViewerPanel.Label.ToolTip"));
        if (this.popupMenu != null) {
            this.normalMI.setText(ElanLocale.getString("SingleTierViewerPanel.Label.SingleTier"));
            this.multiAssMI.setText(ElanLocale.getString("SingleTierViewerPanel.Label.MultiTier.Association"));
            this.multiSubMI.setText(ElanLocale.getString("SingleTierViewerPanel.Label.MultiTier.Subdivision"));
        }
    }

    @Override
    public void updateTierOrder(List<String> tierOrder) {
        if (this.workWithTierSet) {
            ArrayList<String> tierList = new ArrayList<String>();
            TierSetUtil tierSetUtil = TierSetUtil.getTierSetUtilInstance();
            for (String tierSetName : tierSetUtil.getVisibleTierSets()) {
                for (String tierName : tierSetUtil.getTierSet(tierSetName).getTierList()) {
                    if (tierList.contains(tierName)) continue;
                    tierList.add(tierName);
                }
            }
            tierOrder = tierList;
        } else if (tierOrder == null) {
            return;
        }
        this.tierComboBox.removeItemListener(this);
        this.tierOrder = tierOrder;
        Object selectedObj = this.tierComboBox.getSelectedItem();
        if (this.viewer instanceof GridViewer) {
            switch (this.gridMode) {
                case 0: {
                    this.fillComboBox();
                    break;
                }
                case 1: {
                    this.fillComboBoxMulti(4);
                    break;
                }
                case 2: {
                    this.fillComboBoxMulti(3);
                    break;
                }
            }
        } else if (this.viewer instanceof TextViewer || this.viewer instanceof SubtitleViewer) {
            this.fillComboBox();
        } else if (this.workWithTierSet) {
            this.fillComboBox();
        }
        for (int i = 0; i < this.tierComboBox.getItemCount(); ++i) {
            if (!selectedObj.equals(this.tierComboBox.getItemAt(i))) continue;
            this.tierComboBox.setSelectedItem(selectedObj);
            break;
        }
        this.tierComboBox.addItemListener(this);
    }

    @Override
    public void preferencesChanged() {
        Boolean val = Preferences.getBool("WorkwithTierSets", null);
        if (val != null) {
            this.workWithTierSet = val;
        }
        this.processAlphabeticTierOrderPreference();
        if (this.workWithTierSet) {
            this.updateTierOrder(null);
        } else if (this.alphabeticTierOrder.booleanValue()) {
            this.updateTierOrder(this.tierOrder);
        } else {
            this.updateTierOrder(this.viewerManager.getMultiTierControlPanel().getTierOrder());
        }
        this.updateComboBox();
    }

    private void processAlphabeticTierOrderPreference() {
        Boolean boolPref = Preferences.getBool("SingleTierViewer.TierOrderInDropdown", null);
        if (boolPref instanceof Boolean) {
            if (boolPref.booleanValue()) {
                List<TierImpl> tiers = ((TranscriptionImpl)this.viewerManager.getTranscription()).getTiers();
                ArrayList<String> tierOrder = new ArrayList<String>();
                for (TierImpl tier : tiers) {
                    tierOrder.add(tier.getName());
                }
                Collections.sort(tierOrder);
                this.tierOrder = tierOrder;
                this.alphabeticTierOrder = true;
            } else {
                this.alphabeticTierOrder = false;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!(this.viewer instanceof GridViewer)) {
            return;
        }
        if (e.getSource() == this.optionIcon) {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
                this.normalMI = new JRadioButtonMenuItem(ElanLocale.getString("SingleTierViewerPanel.Label.SingleTier"));
                this.normalMI.addActionListener(this);
                this.multiAssMI = new JRadioButtonMenuItem(ElanLocale.getString("SingleTierViewerPanel.Label.MultiTier.Association"));
                this.multiAssMI.addActionListener(this);
                this.multiSubMI = new JRadioButtonMenuItem(ElanLocale.getString("SingleTierViewerPanel.Label.MultiTier.Subdivision"));
                this.multiSubMI.addActionListener(this);
                ButtonGroup bg = new ButtonGroup();
                bg.add(this.normalMI);
                bg.add(this.multiAssMI);
                bg.add(this.multiSubMI);
                switch (this.gridMode) {
                    case 0: {
                        this.normalMI.setSelected(true);
                        break;
                    }
                    case 1: {
                        this.multiAssMI.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.multiSubMI.setSelected(true);
                        break;
                    }
                    default: {
                        this.normalMI.setSelected(true);
                    }
                }
                this.popupMenu.add(this.normalMI);
                this.popupMenu.add(this.multiAssMI);
                this.popupMenu.add(this.multiSubMI);
            }
            this.popupMenu.show(this.optionIcon, 5, 5);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class EmptyRenderer
    implements ListCellRenderer {
        private ListCellRenderer mainRenderer;

        EmptyRenderer(ListCellRenderer renderer) {
            this.mainRenderer = renderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index == 0 && SingleTierViewerPanel.this.currentTier != null) {
                return this.mainRenderer.getListCellRendererComponent(list, SingleTierViewerPanel.this.none_item, index, isSelected, cellHasFocus);
            }
            return this.mainRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

