/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableColumnHider
extends MouseAdapter {
    private TableColumnModel tcm;
    private Map<String, IndexedColumn> hidden = new HashMap<String, IndexedColumn>();
    JPopupMenu popup;

    public TableColumnHider(JTable table) {
        this.tcm = table.getColumnModel();
    }

    public void hide(String columnName) {
        if (this.hidden.containsKey(columnName)) {
            return;
        }
        try {
            int index = this.tcm.getColumnIndex(columnName);
            TableColumn column = this.tcm.getColumn(index);
            IndexedColumn ic = new IndexedColumn(index, column);
            this.hidden.put(columnName, ic);
            column.setMinWidth(0);
            column.setMaxWidth(0);
            column.setResizable(false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void show(String columnName) {
        IndexedColumn ic = this.hidden.remove(columnName);
        if (ic != null) {
            ic.restore();
        }
    }

    public JPopupMenu newPopupMenu(String[] columnNames) {
        this.popup = new JPopupMenu();
        for (int i = 0; i < columnNames.length; ++i) {
            JCheckBoxMenuItem checkBox = new JCheckBoxMenuItem(columnNames[i]);
            checkBox.setSelected(true);
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JCheckBoxMenuItem cb = (JCheckBoxMenuItem)evt.getSource();
                    String columnName = cb.getText();
                    if (cb.isSelected()) {
                        TableColumnHider.this.show(columnName);
                    } else {
                        TableColumnHider.this.hide(columnName);
                    }
                }
            });
            this.popup.add(checkBox);
        }
        return this.popup;
    }

    private void setSelected(String name, boolean value) {
        if (this.popup == null) {
            return;
        }
        int n = this.popup.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JCheckBoxMenuItem mi;
            Component c = this.popup.getComponent(i);
            if (!(c instanceof JCheckBoxMenuItem) || !(mi = (JCheckBoxMenuItem)c).getText().equals(name)) continue;
            mi.setSelected(value);
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            if (!SwingUtilities.isLeftMouseButton(e) || !SwingUtilities.isRightMouseButton(e)) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
            return;
        }
    }

    public List<String> getPreferences() {
        ArrayList<String> pref = new ArrayList<String>();
        pref.addAll(this.hidden.keySet());
        return pref;
    }

    public void applyPreferences(List<String> hiddenList) {
        if (hiddenList != null) {
            for (String s : this.hidden.keySet()) {
                if (hiddenList.contains(s)) continue;
                this.show(s);
                this.setSelected(s, true);
            }
            for (String s : hiddenList) {
                this.hide(s);
                this.setSelected(s, false);
            }
        }
    }

    private static class IndexedColumn {
        private TableColumn column;
        private int minWidth;
        private int preferredWidth;
        private int maxWidth;
        private boolean resizable;

        public IndexedColumn(Integer index, TableColumn column) {
            this.column = column;
            this.minWidth = column.getMinWidth();
            this.preferredWidth = column.getPreferredWidth();
            this.maxWidth = column.getMaxWidth();
            this.resizable = column.getResizable();
        }

        public void restore() {
            this.column.setMaxWidth(this.maxWidth);
            this.column.setMinWidth(this.minWidth);
            this.column.setPreferredWidth(this.preferredWidth);
            this.column.setResizable(this.resizable);
        }
    }
}

