/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.InlineEditBoxListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.ShowInBrowserCommand;
import mpi.eudico.client.annotator.comments.CommentEnvelope;
import mpi.eudico.client.annotator.comments.CommentManager;
import mpi.eudico.client.annotator.dcr.ELANLocalDCRConnector;
import mpi.eudico.client.annotator.gui.InlineEditBox;
import mpi.eudico.client.annotator.mediadisplayer.MediaDisplayer;
import mpi.eudico.client.annotator.mediadisplayer.MediaDisplayerFactory;
import mpi.eudico.client.annotator.mediadisplayer.MediaDisplayerHost;
import mpi.eudico.client.annotator.util.AnnotationTransfer;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.DragTag2D;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.util.Tag2D;
import mpi.eudico.client.annotator.util.Tier2D;
import mpi.eudico.client.annotator.viewer.CommentViewer;
import mpi.eudico.client.annotator.viewer.GesturesListener;
import mpi.eudico.client.annotator.viewer.MultiTierControlPanel;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.client.annotator.viewer.TimeRuler;
import mpi.eudico.client.annotator.viewer.TimeScaleBasedViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StartEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.client.util.TierAssociation;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.TimeFormatter;

public class TimeLineViewer
extends TimeScaleBasedViewer
implements ComponentListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
AdjustmentListener,
ActionListener,
GesturesListener,
MultiTierViewer,
ACMEditListener,
ChangeListener,
InlineEditBoxListener,
MediaDisplayerHost {
    static final int PIXELS_FOR_SECOND = 100;
    private TranscriptionImpl transcription;
    private boolean timeRulerVisible;
    private int rulerHeight;
    private TimeRuler ruler;
    private Font font;
    private Font tooltipFont;
    private FontMetrics metrics;
    private BufferedImage bi;
    private Graphics2D big2d;
    private AlphaComposite alpha04;
    private AlphaComposite alpha07;
    private BasicStroke stroke;
    private BasicStroke stroke2;
    private Color dropHighlightColor;
    private HashMap<String, Object> prefTierFonts;
    private Map<String, Color> highlightColors;
    private float msPerPixel;
    public final int DEFAULT_MS_PER_PIXEL = 10;
    private static final Color COMMENT_INDICATOR_INTERIOR_COLOR = new Color(128, 240, 128);
    private static final Color COMMENT_INDICATOR_EDGE_COLOR = new Color(64, 128, 255);
    private static final AlphaComposite COMMENT_INDICATOR_ALPHA = AlphaComposite.getInstance(3, 0.3764706f);
    private int resolution;
    private int imageWidth;
    private int imageHeight;
    private long crossHairTime;
    private int crossHairPos;
    private long intervalBeginTime;
    private long intervalEndTime;
    private int verticalScrollOffset;
    private int horizontalScrollOffset;
    private long selectionBeginTime;
    private long selectionEndTime;
    private int selectionBeginPos;
    private int selectionEndPos;
    private long dragStartTime;
    private Point dragStartPoint;
    private Point dragEndPoint;
    private long splitTime;
    private Color symAnnColor = Constants.SHAREDCOLOR1;
    public final int SCROLL_OFFSET = 16;
    private DragScroller scroller;
    private JPopupMenu popup;
    private ButtonGroup zoomBG;
    private JMenu zoomMI;
    private JRadioButtonMenuItem customZoomMI;
    private ButtonGroup fontSizeBG;
    private JMenu fontMenu;
    private JCheckBoxMenuItem timeScaleConMI;
    private JCheckBoxMenuItem activeAnnStrokeBoldMI;
    private JCheckBoxMenuItem hScrollBarVisMI;
    private JCheckBoxMenuItem tickerModeMI;
    private JCheckBoxMenuItem timeRulerVisMI;
    private JCheckBoxMenuItem reducedTierHeightMI;
    private int staticMenuItems;
    private JMenuItem newAnnoMI;
    private JMenuItem newAnnoBeforeMI;
    private JMenuItem newAnnoAfterMI;
    private JMenuItem modifyAnnoMI;
    private JMenuItem modifyAnnoDCMI;
    private JMenuItem showInBrowserMI;
    private JMenuItem mergeAnnoNextMI;
    private JMenuItem mergeAnnoBeforeMI;
    private JMenuItem splitAnnotationMI;
    private JMenuItem modifyAnnoTimeMI;
    private JMenuItem modifyAnnoTimeDlgMI;
    private JMenuItem deleteAnnoValueMI;
    private JMenuItem deleteAnnoMI;
    private JMenuItem zoomSelectionMI;
    private JMenuItem zoomToEntireMediaMI;
    private JMenuItem deleteSelAnnosMI;
    private JMenuItem copyAnnoMI;
    private JMenuItem copyAnnoTreeMI;
    private JMenuItem pasteAnnoHereMI;
    private JMenuItem pasteAnnoTreeHereMI;
    private JMenuItem shiftActiveAnnMI;
    private List<JMenuItem> contextSensitiveItems;
    private boolean timeScaleConnected;
    private boolean panMode;
    private boolean tickerMode = false;
    private boolean showEmptySlots;
    private boolean aaStrokeBold;
    protected int pixelsForTierHeight;
    protected int pixelsForTierHeightMargin;
    private ArrayList<Tier2D> allTiers;
    private List<Tier2D> visibleTiers;
    private Tag2D hoverTag2D;
    private int hoverTierIndex;
    private List<Tag2D> selectedAnnotations;
    protected Tag2D cursorTag2D;
    private int cursorTierIndex;
    private Tier2D rightClickTier;
    private long rightClickTime;
    private JScrollBar scrollBar;
    private JScrollBar hScrollBar;
    private boolean hScrollBarVisible = true;
    private JPanel zoomSliderPanel;
    private JSlider zoomSlider;
    private final int ZOOMSLIDER_WIDTH = 100;
    private JPanel corner;
    private int horScrollSpeed = 10;
    private final int defBarWidth;
    private int[] tierYPositions;
    private int tooltipFontSize;
    MultiTierControlPanel multiTierControlPanel;
    private InlineEditBox editBox;
    private boolean deselectCommits = true;
    private boolean forceOpenControlledVocabulary = false;
    private DragTag2D dragEditTag2D;
    private boolean dragEditing;
    private Color dragEditColor = Color.green;
    private final int DRAG_EDIT_MARGIN = 8;
    private final int DRAG_EDIT_CENTER = 0;
    private final int DRAG_EDIT_LEFT = 1;
    private final int DRAG_EDIT_RIGHT = 2;
    private final int DRAG_EDIT_UP = 3;
    private final int DRAG_EDIT_DOWN = 4;
    private int dragEditMode = 0;
    private boolean clearSelOnSingleClick = true;
    private long dragParentBegin = -1L;
    private long dragParentEnd = -1L;
    private boolean reducedTierHeight = false;
    private int rhDist = 3;
    boolean stopScrolling = true;
    private Object tierLock = new Object();
    private boolean useBufferedImage = false;
    private boolean centerAnnotation = true;
    private boolean delayedAnnotationActivation = false;
    private boolean activateNewAnnotation = true;
    private Annotation lastCreatedAnnotation;
    private Tag2D previousHoverTag2D = null;
    private MediaDisplayer mediaDisplayer;

    public TimeLineViewer() {
        this.initViewer();
        this.initTiers();
        this.defBarWidth = this.getDefaultBarWidth() + 2;
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.useBufferedImage = SystemReporting.useBufferedPainting;
    }

    public TimeLineViewer(Transcription transcription) {
        this();
        this.transcription = (TranscriptionImpl)transcription;
        this.paintBuffer();
        this.initTiers();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        return false;
    }

    private void initViewer() {
        this.font = Constants.DEFAULTFONT;
        this.setFont(this.font);
        this.metrics = this.getFontMetrics(this.font);
        this.tooltipFontSize = this.getDefaultTooltipFontSize();
        this.tooltipFont = this.font.deriveFont((float)this.tooltipFontSize);
        this.prefTierFonts = new HashMap();
        this.selectedAnnotations = new ArrayList<Tag2D>(10);
        int dismissDelay = Integer.MAX_VALUE;
        ToolTipManager.sharedInstance().setDismissDelay(dismissDelay);
        this.timeRulerVisible = true;
        this.ruler = Constants.DEFAULT_LF_LABEL_FONT != null ? new TimeRuler(Constants.deriveSmallFont(Constants.DEFAULT_LF_LABEL_FONT), TimeFormatter.toString(0L), 5) : new TimeRuler(this.font, TimeFormatter.toString(0L), 5);
        this.rulerHeight = this.ruler.getHeight();
        this.stroke = new BasicStroke();
        this.stroke2 = new BasicStroke(2.0f);
        this.dropHighlightColor = new Color(255, 255, 255, 192);
        this.msPerPixel = 10.0f;
        this.resolution = 100;
        this.crossHairTime = 0L;
        this.crossHairPos = 0;
        this.intervalBeginTime = 0L;
        this.intervalEndTime = 0L;
        this.verticalScrollOffset = 0;
        this.selectionBeginTime = 0L;
        this.selectionEndTime = 0L;
        this.selectionBeginPos = 0;
        this.selectionEndPos = 0;
        this.dragStartTime = 0L;
        this.timeScaleConnected = true;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.alpha04 = AlphaComposite.getInstance(3, 0.4f);
        this.alpha07 = AlphaComposite.getInstance(3, 0.7f);
        this.pixelsForTierHeight = this.calcTierHeight();
        this.pixelsForTierHeightMargin = 2;
        this.scrollBar = new JScrollBar(1, 0, 50, 0, 200);
        this.scrollBar.setUnitIncrement(this.pixelsForTierHeight / 2);
        this.scrollBar.setBlockIncrement(this.pixelsForTierHeight);
        this.scrollBar.addAdjustmentListener(this);
        this.hScrollBar = new JScrollBar(0, 0, 50, 0, 400);
        this.hScrollBar.setUnitIncrement(10);
        this.hScrollBar.setBlockIncrement(40);
        this.hScrollBar.addAdjustmentListener(this);
        this.setLayout(null);
        this.add(this.scrollBar);
        this.add(this.hScrollBar);
        this.zoomSlider = new JSlider(this.ZOOMLEVELS[0], 300, 100);
        this.zoomSlider.putClientProperty("JComponent.sizeVariant", "small");
        this.zoomSliderPanel = new JPanel(null);
        this.zoomSliderPanel.add(this.zoomSlider);
        this.zoomSlider.addChangeListener(this);
        this.zoomSlider.setToolTipText(String.valueOf(this.zoomSlider.getValue()));
        this.add(this.zoomSliderPanel);
        this.corner = new JPanel();
        this.add(this.corner);
        this.editBox = new InlineEditBox(true);
        this.editBox.setFont(this.font);
        this.editBox.setVisible(false);
        this.add(this.editBox);
        this.editBox.addInlineEditBoxListener(this);
        this.editBox.setMediaDisplayerHost(this);
    }

    @Override
    public void isClosing() {
        if (this.editBox != null && this.editBox.isVisible()) {
            Boolean boolPref = Preferences.getBool("InlineEdit.DeselectCommits", null);
            if (boolPref != null && !boolPref.booleanValue()) {
                this.editBox.cancelEdit();
            } else {
                this.editBox.commitEdit();
            }
        }
        if (this.multiTierControlPanel != null) {
            this.multiTierControlPanel.isClosing();
        }
    }

    private int getDefaultBarWidth() {
        int width = 20;
        if (UIManager.getDefaults().get("ScrollBar.width") != null) {
            width = (Integer)UIManager.getDefaults().get("ScrollBar.width");
        }
        return width;
    }

    private void initTiers() {
        this.allTiers = new ArrayList(20);
        this.visibleTiers = new ArrayList<Tier2D>(this.allTiers.size());
        if (this.transcription == null) {
            this.tierYPositions = new int[0];
            return;
        }
        this.extractTiers();
        this.tierYPositions = new int[this.allTiers.size()];
    }

    private void extractTiers() {
        for (TierImpl tier : this.transcription.getTiers()) {
            Tier2D tier2d = this.createTier2D(tier);
            this.allTiers.add(tier2d);
        }
    }

    private void setColor(Tag2D tag2d, Annotation a, ControlledVocabulary cv) {
        CVEntry cve;
        String id = a.getCVEntryId();
        if (id != null && (cve = cv.getEntrybyId(id)) != null) {
            tag2d.setColor(cve.getPrefColor());
            return;
        }
        tag2d.setColor(null);
    }

    private Tier2D createTier2D(TierImpl tier) {
        Tier2D tier2d = new Tier2D(tier);
        TierImpl markTier = null;
        ControlledVocabulary cv = this.transcription.getControlledVocabulary(tier.getLinguisticType().getControlledVocabularyName());
        if (cv == null && (markTier = TierAssociation.findMarkerTierFor(this.transcription, tier)) != null) {
            cv = this.transcription.getControlledVocabulary(markTier.getLinguisticType().getControlledVocabularyName());
        }
        for (Annotation annotation : tier.getAnnotations()) {
            Tag2D tag2d = new Tag2D(annotation);
            int xPos = this.timeToPixels(annotation.getBeginTimeBoundary());
            tag2d.setX(xPos);
            int tagWidth = this.timeToPixels(annotation.getEndTimeBoundary()) - xPos;
            tag2d.setWidth(tagWidth);
            tag2d.setTruncatedValue(this.truncateString(annotation.getValue(), tagWidth, this.metrics));
            if (cv != null) {
                if (markTier == null) {
                    this.setColor(tag2d, annotation, cv);
                } else {
                    List<Annotation> ch = ((AbstractAnnotation)annotation).getChildrenOnTier(markTier);
                    if (ch.size() >= 1) {
                        Annotation ma = ch.get(0);
                        this.setColor(tag2d, ma, cv);
                    }
                }
            }
            tier2d.addTag(tag2d);
            if (annotation != this.getActiveAnnotation()) continue;
            this.cursorTag2D = tag2d;
        }
        return tier2d;
    }

    private void recalculateTagSizes() {
        for (Tier2D tier2d : this.allTiers) {
            Font tierFont = this.getFontForTier(tier2d.getTier());
            FontMetrics tierMetrics = this.getFontMetrics(tierFont);
            Iterator<Tag2D> tagIt = tier2d.getTags();
            while (tagIt.hasNext()) {
                Tag2D tag2d = tagIt.next();
                int xPos = this.timeToPixels(tag2d.getBeginTime());
                tag2d.setX(xPos);
                int tagWidth = this.timeToPixels(tag2d.getEndTime()) - xPos;
                tag2d.setWidth(tagWidth);
                tag2d.setTruncatedValue(this.truncateString(tag2d.getValue(), tagWidth, tierMetrics));
            }
        }
    }

    private void reextractTagsForTier(Tier2D tier2d) {
        if (this.transcription == null || tier2d == null) {
            return;
        }
        TierImpl tier = tier2d.getTier();
        if (tier == null) {
            return;
        }
        Font prefFont = this.getFontForTier(tier);
        FontMetrics tierMetrics = this.getFontMetrics(prefFont);
        tier2d.getTagsList().clear();
        TierImpl markTier = null;
        ControlledVocabulary cv = this.transcription.getControlledVocabulary(tier.getLinguisticType().getControlledVocabularyName());
        if (cv == null && (markTier = TierAssociation.findMarkerTierFor(this.transcription, tier)) != null) {
            cv = this.transcription.getControlledVocabulary(markTier.getLinguisticType().getControlledVocabularyName());
        }
        for (Annotation annotation : tier.getAnnotations()) {
            Tag2D tag2d = new Tag2D(annotation);
            int xPos = this.timeToPixels(annotation.getBeginTimeBoundary());
            tag2d.setX(xPos);
            int tagWidth = this.timeToPixels(annotation.getEndTimeBoundary()) - xPos;
            tag2d.setWidth(tagWidth);
            tag2d.setTruncatedValue(this.truncateString(annotation.getValue(), tagWidth, tierMetrics));
            if (cv != null) {
                if (markTier == null) {
                    this.setColor(tag2d, annotation, cv);
                } else {
                    List<Annotation> ch = ((AbstractAnnotation)annotation).getChildrenOnTier(markTier);
                    if (ch.size() >= 1) {
                        Annotation ma = ch.get(0);
                        this.setColor(tag2d, ma, cv);
                    }
                }
            }
            tier2d.addTag(tag2d);
            if (annotation != this.getActiveAnnotation()) continue;
            this.cursorTag2D = tag2d;
        }
    }

    private String truncateString(String string, int width, FontMetrics fMetrics) {
        int stringWidth;
        String line = string.replace('\n', ' ');
        if (fMetrics != null && (stringWidth = fMetrics.stringWidth(line)) > (width -= 4)) {
            int lwb = 0;
            int upb = line.length();
            String s = line;
            double fraction = (double)width / (double)stringWidth;
            lwb = Math.max(lwb, (int)(0.8 * fraction * (double)line.length() - 1.0));
            upb = Math.min((int)(1.2 * fraction * (double)line.length() + 1.0), upb);
            while (lwb < upb) {
                int mid = (upb + lwb + 1) / 2;
                s = line.substring(0, mid);
                stringWidth = fMetrics.stringWidth(s);
                if (stringWidth > width) {
                    upb = mid - 1;
                    continue;
                }
                lwb = mid;
                if (stringWidth != width) continue;
                break;
            }
            line = line.substring(0, lwb);
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintBuffer() {
        if (!this.useBufferedImage) {
            this.repaint();
            return;
        }
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.getWidth() - this.defBarWidth != this.imageWidth || this.imageHeight != this.visibleTiers.size() * this.pixelsForTierHeight + this.rulerHeight) {
            this.imageWidth = this.getWidth() - this.defBarWidth;
            this.imageHeight = this.visibleTiers.size() * this.pixelsForTierHeight + this.rulerHeight;
            if (this.imageWidth <= 0 || this.imageHeight <= 0) {
                return;
            }
            this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            if (this.timeScaleConnected) {
                this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
            }
        }
        if (this.bi == null || this.bi.getWidth() < this.imageWidth || this.bi.getHeight() < this.imageHeight) {
            this.bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
            this.big2d = this.bi.createGraphics();
        }
        if (this.bi.getHeight() > this.imageHeight) {
            this.imageHeight = this.bi.getHeight();
        }
        if (SystemReporting.antiAliasedText) {
            this.big2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.big2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        this.big2d.fillRect(0, 0, this.imageWidth, this.bi.getHeight());
        long dur = this.getMediaDuration();
        int xx = this.xAt(dur);
        if (this.intervalEndTime > dur) {
            if (xx >= 0 && xx <= this.imageWidth) {
                this.big2d.setColor(Color.LIGHT_GRAY);
                this.big2d.drawLine(xx, 0, xx, this.bi.getHeight());
            }
            if (xx <= this.imageWidth) {
                int n = xx = xx < 0 ? 0 : xx;
                if (!SystemReporting.isMacOS()) {
                    this.big2d.setColor(UIManager.getColor("Panel.background"));
                }
                this.big2d.fillRect(xx < 0 ? 0 : xx + 1, 0, this.imageWidth - xx, this.bi.getHeight());
            }
        }
        this.big2d.translate(-((int)((float)this.intervalBeginTime / this.msPerPixel)), 0);
        int y = this.rulerHeight;
        int ax = this.timeToPixels(this.intervalBeginTime);
        this.big2d.setColor(Constants.LIGHTBACKGROUNDCOLOR);
        if (this.intervalBeginTime < dur) {
            int numStripes = Math.max(this.visibleTiers.size(), this.imageHeight / this.pixelsForTierHeight);
            for (int i = 0; i < numStripes; ++i) {
                if (i % 2 == 0) continue;
                this.big2d.fillRect(ax, y + i * this.pixelsForTierHeight, xx, this.pixelsForTierHeight);
            }
        }
        if (this.selectionBeginPos != this.selectionEndPos) {
            int beginPos = this.timeToPixels(this.getSelectionBeginTime());
            int endPos = this.timeToPixels(this.getSelectionEndTime());
            this.big2d.setColor(Constants.SELECTIONCOLOR);
            this.big2d.setComposite(this.alpha04);
            this.big2d.fillRect(beginPos, 0, endPos - beginPos, this.rulerHeight);
            this.big2d.setComposite(AlphaComposite.Src);
            this.big2d.fillRect(beginPos, this.rulerHeight, endPos - beginPos, this.imageHeight - this.rulerHeight);
        }
        if (this.highlightColors != null) {
            this.big2d.setComposite(this.alpha04);
            for (int i = 0; i < this.visibleTiers.size(); ++i) {
                Color highlightColor = this.highlightColors.get(this.visibleTiers.get(i).getName());
                if (highlightColor == null) continue;
                this.big2d.setColor(highlightColor);
                this.big2d.fillRect(ax, y + i * this.pixelsForTierHeight, this.imageWidth - (this.imageWidth - xx), this.pixelsForTierHeight);
            }
            this.big2d.setComposite(AlphaComposite.Src);
        }
        int h = this.pixelsForTierHeight - 2 * this.pixelsForTierHeightMargin;
        Font tf = null;
        Object object = this.tierLock;
        synchronized (object) {
            for (Tier2D tier2d : this.visibleTiers) {
                int startIndex;
                tf = this.getFontForTier(tier2d.getTier());
                this.big2d.setFont(tf);
                if (tier2d.isActive()) {
                    this.big2d.setColor(Constants.ACTIVETIERCOLOR);
                    this.big2d.setComposite(this.alpha07);
                    this.big2d.fillRect(ax, y, this.imageWidth, this.pixelsForTierHeight);
                    this.big2d.setComposite(AlphaComposite.Src);
                }
                for (int i = startIndex = this.findStartIndex(tier2d.getTagsList(), this.intervalBeginTime); i < tier2d.getTagsList().size(); ++i) {
                    Tag2D tag2d = tier2d.getTagsList().get(i);
                    if (tag2d.getEndTime() < this.intervalBeginTime) continue;
                    if (tag2d.getBeginTime() > this.intervalEndTime) break;
                    this.paintTag(this.big2d, tag2d, tag2d.getX(), y + this.pixelsForTierHeightMargin, tag2d.getWidth(), h);
                }
                y += this.pixelsForTierHeight;
            }
        }
        this.big2d.setTransform(new AffineTransform());
        this.big2d.setFont(this.font);
        if (this.timeRulerVisible) {
            this.big2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
            this.big2d.fillRect(0, 0, this.imageWidth, this.verticalScrollOffset + this.rulerHeight);
            this.big2d.setColor(Constants.SELECTIONCOLOR);
            this.big2d.drawLine(0, this.verticalScrollOffset + this.rulerHeight, this.imageWidth, this.verticalScrollOffset + this.rulerHeight);
            this.big2d.translate(-((int)((float)this.intervalBeginTime / this.msPerPixel)), this.verticalScrollOffset);
            if (this.selectionBeginPos != this.selectionEndPos) {
                int beginPos = this.timeToPixels(this.getSelectionBeginTime());
                int endPos = this.timeToPixels(this.getSelectionEndTime());
                this.big2d.setColor(Constants.SELECTIONCOLOR);
                this.big2d.setComposite(this.alpha04);
                this.big2d.fillRect(beginPos, 0, endPos - beginPos, this.rulerHeight);
                this.big2d.setComposite(AlphaComposite.Src);
            }
            this.big2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
            this.ruler.paint(this.big2d, this.intervalBeginTime, this.imageWidth, this.msPerPixel, 1);
            this.big2d.setTransform(new AffineTransform());
        }
        this.paintCommentIndicators(this.big2d, true);
        this.repaint();
    }

    private boolean commentIsVisible(CommentEnvelope comment) {
        String tierName = comment.getTierName();
        if (tierName != null && !tierName.isEmpty()) {
            if (this.visibleTiers.isEmpty()) {
                return false;
            }
            if (this.visibleTiers.size() < this.allTiers.size()) {
                for (Tier2D t2d : this.visibleTiers) {
                    if (!t2d.getName().equals(tierName)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private void paintCommentIndicators(Graphics2D gr2d, boolean buffered) {
        if (!this.timeRulerVisible) {
            return;
        }
        ViewerManager2 vm = this.getViewerManager();
        if (vm == null) {
            return;
        }
        CommentViewer cv = vm.getCommentViewer();
        if (cv == null) {
            return;
        }
        CommentManager cm = cv.getCommentManager();
        int rulerY = buffered ? this.verticalScrollOffset : 0;
        int rulerH = this.timeRulerVisible ? this.rulerHeight : 0;
        Graphics2D ruler = null;
        if (this.timeRulerVisible) {
            ruler = (Graphics2D)gr2d.create();
            ruler.setColor(COMMENT_INDICATOR_INTERIOR_COLOR);
            ruler.setComposite(COMMENT_INDICATOR_ALPHA);
        }
        long lastEndTime = 0L;
        int vertOffset = 0;
        int barHeight = 5;
        int barStagger = 2;
        boolean someMoreToTheLeft = false;
        boolean someMoreToTheRight = false;
        for (CommentEnvelope comment : cm.getList()) {
            long commentEndTime = comment.getEndTime();
            if (commentEndTime < this.intervalBeginTime) {
                if (!this.timeRulerVisible) continue;
                someMoreToTheLeft = someMoreToTheLeft || this.commentIsVisible(comment);
                continue;
            }
            long commentStartTime = comment.getStartTime();
            if (commentStartTime > this.intervalEndTime) {
                if (!this.timeRulerVisible) break;
                someMoreToTheRight = someMoreToTheRight || this.commentIsVisible(comment);
                break;
            }
            if (!this.commentIsVisible(comment)) continue;
            if (commentStartTime >= lastEndTime) {
                vertOffset = 0;
            }
            lastEndTime = Math.max(lastEndTime, commentEndTime);
            int leftpixel = this.xAt(commentStartTime);
            int width = this.xAt(commentEndTime) - leftpixel;
            width = Math.max(10, width);
            if (!this.timeRulerVisible) continue;
            ruler.setColor(COMMENT_INDICATOR_INTERIOR_COLOR);
            ruler.fillRect(leftpixel + 1, rulerY + vertOffset + 1, width - 2, 3);
            ruler.setColor(COMMENT_INDICATOR_EDGE_COLOR);
            ruler.drawRect(leftpixel, rulerY + vertOffset, width - 1, 4);
            vertOffset = Math.min(vertOffset + 2, rulerH - 5);
        }
        if (someMoreToTheLeft) {
            ruler.setColor(COMMENT_INDICATOR_EDGE_COLOR);
            int left = 0;
            int w = rulerH * 2 / 3;
            ruler.fillPolygon(new int[]{left, left + w, left + w}, new int[]{rulerY + rulerH / 2, rulerY, rulerY + rulerH}, 3);
        }
        if (someMoreToTheRight) {
            ruler.setColor(COMMENT_INDICATOR_EDGE_COLOR);
            int right = this.xAt(this.intervalEndTime);
            int w = rulerH * 2 / 3;
            ruler.fillPolygon(new int[]{right, right - w, right - w}, new int[]{rulerY + rulerH / 2, rulerY, rulerY + rulerH}, 3);
        }
        if (this.timeRulerVisible) {
            ruler.dispose();
        }
    }

    private String getCommentTip(Point pp) {
        CommentViewer cv;
        long time = this.timeAt(pp.x);
        StringBuilder text = new StringBuilder();
        text.append("<html>");
        text.append(TimeFormatter.toString(time));
        ViewerManager2 vm = this.getViewerManager();
        if (vm != null && (cv = vm.getCommentViewer()) != null) {
            CommentManager cm = cv.getCommentManager();
            int lines = 0;
            for (CommentEnvelope comment : cm.getList()) {
                long commentEndTime = comment.getEndTime();
                if (commentEndTime < time) continue;
                long commentStartTime = comment.getStartTime();
                if (commentStartTime > time) break;
                String message = comment.getMessage();
                text.append("<br/>");
                this.appendEscaped(text, message, 132);
                if (lines <= 20) continue;
                break;
            }
        }
        text.append("</html>");
        return text.toString();
    }

    private void appendEscaped(StringBuilder dest, String src, int maxLength) {
        maxLength = Math.min(maxLength, src.length());
        block5: for (int i = 0; i < maxLength; ++i) {
            char c = src.charAt(i);
            switch (c) {
                case '<': {
                    dest.append("&lt;");
                    continue block5;
                }
                case '>': {
                    dest.append("&gt;");
                    continue block5;
                }
                case '&': {
                    dest.append("&amp;");
                    continue block5;
                }
                default: {
                    dest.append(c);
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int he;
        int y;
        int w;
        int x;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (SystemReporting.antiAliasedText) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (!this.useBufferedImage) {
            this.paintUnbuffered(g2d);
            return;
        }
        int h = this.getHeight();
        int ww = this.getWidth();
        g2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        g2d.fillRect(0, 0, this.imageWidth, h);
        long dur = this.getMediaDuration();
        int xx = this.xAt(dur);
        if (this.intervalEndTime > dur) {
            if (xx >= 0 && xx <= ww) {
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawLine(xx, 0, xx, h);
            }
            if (xx <= ww) {
                int n = xx = xx < 0 ? 0 : xx;
                if (!SystemReporting.isMacOS()) {
                    g2d.setColor(UIManager.getColor("Panel.background"));
                }
                g2d.fillRect(xx < 0 ? 0 : xx + 1, 0, ww - xx, h);
            }
        }
        if (this.bi != null) {
            g2d.translate(0, -this.verticalScrollOffset);
            if (this.selectionBeginPos != this.selectionEndPos && this.bi.getHeight() < h) {
                g2d.setColor(Constants.SELECTIONCOLOR);
                g2d.fillRect(this.selectionBeginPos, 0, this.selectionEndPos - this.selectionBeginPos, h);
            }
            g2d.drawImage((Image)this.bi, 0, 0, this);
            g2d.translate(0, this.verticalScrollOffset);
        }
        g2d.setFont(this.font);
        if (this.cursorTag2D != null && this.visibleTiers.contains(this.cursorTag2D.getTier2D())) {
            x = this.cursorTag2D.getX() - (int)((float)this.intervalBeginTime / this.msPerPixel);
            w = this.cursorTag2D.getWidth();
            y = this.rulerHeight + this.cursorTierIndex * this.pixelsForTierHeight + this.pixelsForTierHeightMargin - this.verticalScrollOffset;
            he = this.pixelsForTierHeight - 2 * this.pixelsForTierHeightMargin;
            this.paintCursorTag2D(g2d, this.cursorTag2D, x, y, w, he);
        }
        if (this.showEmptySlots) {
            for (int i = 0; i < this.visibleTiers.size(); ++i) {
                TierImpl ti = this.visibleTiers.get(i).getTier();
                if (ti.getParentTier() == null || ti.isTimeAlignable()) continue;
                y = this.rulerHeight + i * this.pixelsForTierHeight + this.pixelsForTierHeightMargin - this.verticalScrollOffset;
                he = this.pixelsForTierHeight - 2 * this.pixelsForTierHeightMargin;
                this.paintEmptySlots(g2d, ti, y, he);
            }
        }
        if (this.dragEditTag2D != null) {
            x = (int)((float)this.dragEditTag2D.getX() - (float)this.intervalBeginTime / this.msPerPixel);
            w = this.dragEditTag2D.getWidth();
            y = this.rulerHeight + this.cursorTierIndex * this.pixelsForTierHeight + this.pixelsForTierHeightMargin - this.verticalScrollOffset + this.dragEditTag2D.getY();
            he = this.pixelsForTierHeight - 2 * this.pixelsForTierHeightMargin;
            this.paintDragEditTag2D(g2d, x, y, w, he);
        }
        this.paintSelectedAnnotations(g2d);
        if (this.crossHairPos >= 0 && this.crossHairPos <= this.imageWidth) {
            g2d.setColor(Constants.CROSSHAIRCOLOR);
            g2d.drawLine(this.crossHairPos, 0, this.crossHairPos, h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintUnbuffered(Graphics2D g2d) {
        int he;
        int yy;
        int h = this.getHeight();
        int w = this.getWidth();
        g2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        g2d.fillRect(0, 0, w, h);
        int y = this.rulerHeight - this.verticalScrollOffset;
        g2d.setColor(Constants.LIGHTBACKGROUNDCOLOR);
        for (int i = 0; i < this.visibleTiers.size(); ++i) {
            if (i % 2 == 0) continue;
            g2d.fillRect(0, y + i * this.pixelsForTierHeight, w, this.pixelsForTierHeight);
        }
        long dur = this.getMediaDuration();
        int xx = this.xAt(dur);
        if (this.intervalEndTime > dur) {
            if (xx >= 0 && xx <= w) {
                g2d.setColor(Color.LIGHT_GRAY);
                g2d.drawLine(xx, 0, xx, h);
            }
            if (xx <= w) {
                int n = xx = xx < 0 ? 0 : xx;
                if (!SystemReporting.isMacOS()) {
                    g2d.setColor(UIManager.getColor("Panel.background"));
                }
                g2d.fillRect(xx < 0 ? 0 : xx + 1, 0, w - xx, h);
            }
        }
        if (this.selectionBeginPos != this.selectionEndPos) {
            g2d.setColor(Constants.SELECTIONCOLOR);
            g2d.setComposite(this.alpha04);
            g2d.fillRect(this.selectionBeginPos, 0, this.selectionEndPos - this.selectionBeginPos, this.rulerHeight);
            g2d.setComposite(AlphaComposite.SrcOver);
            g2d.fillRect(this.selectionBeginPos, this.rulerHeight, this.selectionEndPos - this.selectionBeginPos, w - this.rulerHeight);
        }
        if (this.highlightColors != null) {
            g2d.setComposite(this.alpha04);
            for (int i = 0; i < this.visibleTiers.size(); ++i) {
                Color highlightColor = this.highlightColors.get(this.visibleTiers.get(i).getName());
                if (highlightColor == null) continue;
                g2d.setColor(highlightColor);
                g2d.fillRect(0, y + i * this.pixelsForTierHeight, w, this.pixelsForTierHeight);
            }
            g2d.setComposite(AlphaComposite.SrcOver);
        }
        int ax = this.timeToPixels(this.intervalBeginTime);
        g2d.translate(-ax, 0);
        int ht = this.pixelsForTierHeight - 2 * this.pixelsForTierHeightMargin;
        Font tf = null;
        Object object = this.tierLock;
        synchronized (object) {
            for (Tier2D tier2d : this.visibleTiers) {
                int startIndex;
                tf = this.getFontForTier(tier2d.getTier());
                g2d.setFont(tf);
                if (tier2d.isActive()) {
                    g2d.setColor(Constants.ACTIVETIERCOLOR);
                    g2d.setComposite(this.alpha07);
                    g2d.fillRect(ax, y, this.imageWidth, this.pixelsForTierHeight);
                    g2d.setComposite(AlphaComposite.SrcOver);
                }
                for (int i = startIndex = this.findStartIndex(tier2d.getTagsList(), this.intervalBeginTime); i < tier2d.getTagsList().size(); ++i) {
                    Tag2D tag2d = tier2d.getTagsList().get(i);
                    if (tag2d.getEndTime() < this.intervalBeginTime) continue;
                    if (tag2d.getBeginTime() > this.intervalEndTime) break;
                    this.paintTag(g2d, tag2d, tag2d.getX(), y + this.pixelsForTierHeightMargin, tag2d.getWidth(), ht);
                }
                y += this.pixelsForTierHeight;
            }
        }
        if (this.timeRulerVisible) {
            g2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
            g2d.fillRect(ax, 0, w, this.rulerHeight);
            g2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
            this.ruler.paint(g2d, this.intervalBeginTime, w, this.msPerPixel, 1);
        }
        g2d.setFont(this.font);
        g2d.translate(ax, 0);
        if (this.selectionBeginPos != this.selectionEndPos && this.timeRulerVisible) {
            g2d.setColor(Constants.SELECTIONCOLOR);
            g2d.setComposite(this.alpha04);
            g2d.fillRect(this.selectionBeginPos, 0, this.selectionEndPos - this.selectionBeginPos, this.rulerHeight);
            g2d.setComposite(AlphaComposite.SrcOver);
        }
        if (this.timeRulerVisible) {
            g2d.setColor(Constants.SELECTIONCOLOR);
            g2d.drawLine(0, this.rulerHeight, w, this.rulerHeight);
        }
        if (this.cursorTag2D != null && this.visibleTiers.contains(this.cursorTag2D.getTier2D())) {
            int x = this.cursorTag2D.getX() - (int)((float)this.intervalBeginTime / this.msPerPixel);
            int ww = this.cursorTag2D.getWidth();
            yy = this.rulerHeight + this.cursorTierIndex * this.pixelsForTierHeight + this.pixelsForTierHeightMargin - this.verticalScrollOffset;
            he = this.pixelsForTierHeight - 2 * this.pixelsForTierHeightMargin;
            this.paintCursorTag2D(g2d, this.cursorTag2D, x, yy, ww, he);
        }
        if (this.showEmptySlots) {
            for (int i = 0; i < this.visibleTiers.size(); ++i) {
                TierImpl ti = this.visibleTiers.get(i).getTier();
                if (ti.getParentTier() == null || ti.isTimeAlignable()) continue;
                yy = this.rulerHeight + i * this.pixelsForTierHeight + this.pixelsForTierHeightMargin - this.verticalScrollOffset;
                he = this.pixelsForTierHeight - 2 * this.pixelsForTierHeightMargin;
                this.paintEmptySlots(g2d, ti, yy, he);
            }
        }
        if (this.dragEditTag2D != null) {
            int x = (int)((float)this.dragEditTag2D.getX() - (float)this.intervalBeginTime / this.msPerPixel);
            int ww = this.dragEditTag2D.getWidth();
            yy = this.rulerHeight + this.cursorTierIndex * this.pixelsForTierHeight + this.pixelsForTierHeightMargin - this.verticalScrollOffset + this.dragEditTag2D.getY();
            he = this.pixelsForTierHeight - 2 * this.pixelsForTierHeightMargin;
            this.paintDragEditTag2D(g2d, x, yy, ww, he);
        }
        this.paintSelectedAnnotations(g2d);
        if (this.crossHairPos >= 0 && this.crossHairPos <= w) {
            g2d.setColor(Constants.CROSSHAIRCOLOR);
            g2d.drawLine(this.crossHairPos, 0, this.crossHairPos, h);
        }
        this.paintCommentIndicators(g2d, false);
    }

    private void paintTag(Graphics2D g2d, Tag2D tag2d, int x, int y, int width, int height) {
        int topHeight = height / 4;
        int midHeight = height / 2;
        int botHeight = height * 3 / 4;
        if (this.reducedTierHeight) {
            topHeight = height / 2 - this.rhDist;
            midHeight = height - this.rhDist;
            botHeight = height;
        } else {
            topHeight = height / 4;
            midHeight = height / 2;
            botHeight = height * 3 / 4;
        }
        boolean alignable = tag2d.getAnnotation() instanceof AlignableAnnotation;
        if (tag2d.getColor() != null) {
            g2d.setColor(tag2d.getColor());
            if (this.reducedTierHeight) {
                g2d.fillRect(x, y, width, midHeight);
            } else {
                int h = alignable ? midHeight : midHeight / 2;
                g2d.fillRect(x, y + midHeight, width, h);
            }
        }
        if (alignable) {
            int botE;
            int topE;
            int botB;
            int topB;
            AlignableAnnotation a = (AlignableAnnotation)tag2d.getAnnotation();
            if (a.getBegin().isTimeAligned()) {
                topB = 0;
                botB = height;
            } else {
                topB = topHeight;
                botB = botHeight;
            }
            if (a.getEnd().isTimeAligned()) {
                topE = 0;
                botE = height;
            } else {
                topE = topHeight;
                botE = botHeight;
            }
            g2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
            g2d.drawLine(x, y + topB, x, y + botB);
            g2d.drawLine(x, y + midHeight, x + width, y + midHeight);
            g2d.drawLine(x + width, y + topE, x + width, y + botE);
        } else {
            g2d.setColor(this.symAnnColor);
            g2d.drawLine(x, y + topHeight, x, y + botHeight);
            g2d.drawLine(x, y + midHeight, x + width, y + midHeight);
            g2d.drawLine(x + width, y + topHeight, x + width, y + botHeight);
        }
        if (tag2d.isTruncated()) {
            g2d.setColor(Constants.SHAREDCOLOR6);
            g2d.fillRect(x + width - 2, y + midHeight - 2, 2, 2);
        }
        g2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
        int descent = g2d.getFontMetrics().getDescent();
        g2d.drawString(tag2d.getTruncatedValue(), (float)(x + 4), (float)(y + (midHeight - descent + 1)));
    }

    private void paintCursorTag2D(Graphics2D g2d, Tag2D tag2d, int x, int y, int width, int height) {
        if (tag2d.getAnnotation() instanceof AlignableAnnotation) {
            int mid;
            int bottom;
            AlignableAnnotation a = (AlignableAnnotation)tag2d.getAnnotation();
            TimeSlot b = a.getBegin();
            g2d.setColor(Constants.ACTIVEANNOTATIONCOLOR);
            if (this.aaStrokeBold) {
                g2d.setStroke(this.stroke2);
            }
            int top = b.isTimeAligned() ? 0 : height / 4;
            int n = bottom = b.isTimeAligned() ? height : height * 3 / 4;
            if (this.reducedTierHeight) {
                top = height / 2 - this.rhDist;
                bottom = height;
            }
            g2d.drawLine(x, y + top, x, y + bottom);
            int n2 = mid = this.reducedTierHeight ? height - this.rhDist : height / 2;
            if (this.aaStrokeBold) {
                ++mid;
            }
            g2d.drawLine(x, y + mid, x + width, y + mid);
            g2d.drawLine(x + width, y + top, x + width, y + bottom);
            g2d.setStroke(this.stroke);
        } else {
            g2d.setColor(Constants.ACTIVEANNOTATIONCOLOR);
            if (this.aaStrokeBold) {
                g2d.setStroke(this.stroke2);
            }
            if (!this.reducedTierHeight) {
                g2d.drawLine(x, y + height / 4, x, y + height * 3 / 4);
                g2d.drawLine(x, y + height / 2, x + width, y + height / 2);
                g2d.drawLine(x + width, y + height / 4, x + width, y + height * 3 / 4);
            } else {
                g2d.drawLine(x, y + (height / 2 - this.rhDist), x, y + height);
                g2d.drawLine(x, y + (height - this.rhDist), x + width, y + (height - this.rhDist));
                g2d.drawLine(x + width, y + (height / 2 - this.rhDist), x + width, y + height);
            }
            g2d.setStroke(this.stroke);
        }
    }

    private void paintDragEditTag2D(Graphics2D g2d, int x, int y, int width, int height) {
        g2d.setColor(this.dragEditColor);
        if (this.aaStrokeBold) {
            g2d.setStroke(this.stroke2);
        }
        int top = 0;
        int bottom = height;
        g2d.drawLine(x, y + top, x, y + bottom);
        int n = top = this.reducedTierHeight ? height / 2 - this.rhDist : height / 2;
        if (this.aaStrokeBold) {
            ++top;
        }
        g2d.drawLine(x, y + top, x + width, y + top);
        g2d.drawLine(x + width, y, x + width, y + bottom);
        if (this.dragEditTag2D != null && this.dragEditTag2D.isOverTargetTier) {
            g2d.drawRect(x, y, width, height);
            g2d.setColor(this.dropHighlightColor);
            g2d.fillRect(x, y, width, height);
        }
        g2d.setStroke(this.stroke);
    }

    private void paintEmptySlots(Graphics2D g2d, TierImpl ti, int y, int he) {
        try {
            TierImpl parent = ti.getParentTier();
            for (Annotation annotation : parent.getAnnotations()) {
                if (annotation.getEndTimeBoundary() < this.intervalBeginTime) continue;
                if (annotation.getBeginTimeBoundary() <= this.intervalEndTime) {
                    if (annotation.getChildrenOnTier(ti).size() != 0) continue;
                    int x = (int)((float)annotation.getBeginTimeBoundary() / this.msPerPixel - (float)this.intervalBeginTime / this.msPerPixel);
                    int wi = (int)((float)(annotation.getEndTimeBoundary() - annotation.getBeginTimeBoundary()) / this.msPerPixel);
                    g2d.setColor(Constants.SHAREDCOLOR4);
                    g2d.fillRect(x, y, wi, he);
                    g2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                    g2d.drawRect(x, y, wi, he);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void paintSelectedAnnotations(Graphics2D g2d) {
        if (this.selectedAnnotations.size() != 0) {
            g2d.setColor(Constants.SHAREDCOLOR5);
            int xOff = (int)((float)this.intervalBeginTime / this.msPerPixel);
            for (Tag2D t2d : this.selectedAnnotations) {
                if (!this.visibleTiers.contains(t2d.getTier2D())) continue;
                g2d.drawRect(t2d.getX() - xOff, this.rulerHeight + this.getTierIndexForAnnotation(t2d.getAnnotation()) * this.pixelsForTierHeight + 1 - this.verticalScrollOffset, t2d.getWidth(), this.pixelsForTierHeight - 2);
            }
        }
    }

    private int findStartIndex(List<Tag2D> tagList, long sTime) {
        if (tagList.size() < 40) {
            return 0;
        }
        int lo = 0;
        int hi = tagList.size();
        int mi = hi / 2;
        while (mi - lo > 2) {
            Tag2D tag = tagList.get(mi);
            if (tag.getBeginTime() > sTime) {
                hi = mi;
                mi = lo + (hi - lo) / 2;
                continue;
            }
            if (tag.getEndTime() < sTime) {
                lo = mi;
                mi = lo + (hi - lo) / 2;
                continue;
            }
            if (tag.getBeginTime() > sTime || tag.getEndTime() < sTime) continue;
            return mi;
        }
        return lo;
    }

    public int xAt(long t) {
        return (int)((float)(t - this.intervalBeginTime) / this.msPerPixel);
    }

    public long timeAt(int x) {
        return this.intervalBeginTime + (long)((int)((float)x * this.msPerPixel));
    }

    private int timeToPixels(long theTime) {
        return (int)((float)theTime / this.msPerPixel);
    }

    private long pixelToTime(int x) {
        return (long)((float)x * this.msPerPixel);
    }

    public int calcTierHeight() {
        int th = (int)((double)this.font.getSize() * 2.5 + (double)(36 / this.font.getSize()));
        if (this.reducedTierHeight) {
            th = th * 2 / 3;
        }
        return th;
    }

    @Override
    public void updateTimeScale() {
        if (this.timeScaleConnected) {
            if (this.getGlobalTimeScaleMsPerPixel() != this.msPerPixel) {
                this.setLocalTimeScaleMsPerPixel(this.getGlobalTimeScaleMsPerPixel());
            } else if (this.getGlobalTimeScaleIntervalBeginTime() != this.intervalBeginTime) {
                this.setLocalTimeScaleIntervalBeginTime(this.getGlobalTimeScaleIntervalBeginTime());
            }
        }
    }

    public void setTimeScaleConnected(boolean connected) {
        this.timeScaleConnected = connected;
        if (this.timeScaleConnected) {
            if (this.msPerPixel != this.getGlobalTimeScaleMsPerPixel()) {
                this.setLocalTimeScaleMsPerPixel(this.getGlobalTimeScaleMsPerPixel());
            }
            if (this.intervalBeginTime != this.getGlobalTimeScaleIntervalBeginTime()) {
                this.setLocalTimeScaleIntervalBeginTime(this.getGlobalTimeScaleIntervalBeginTime());
            }
        }
    }

    public boolean getTimeScaleConnected() {
        return this.timeScaleConnected;
    }

    public void setMsPerPixel(float mspp) {
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleMsPerPixel(mspp);
            this.setGlobalTimeScaleIntervalBeginTime(this.intervalBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        } else {
            this.setLocalTimeScaleMsPerPixel(mspp);
        }
    }

    private void setLocalTimeScaleMsPerPixel(float step) {
        if (this.msPerPixel == step) {
            return;
        }
        this.msPerPixel = step >= 0.025f ? step : 0.025f;
        this.resolution = (int)(1000.0f / this.msPerPixel);
        boolean playing = this.playerIsPlaying();
        if (playing) {
            this.stopPlayer();
        }
        long mediaTime = this.getMediaTime();
        int oldScreenPos = this.crossHairPos;
        int newMediaX = (int)((float)mediaTime / this.msPerPixel);
        int numScreens = this.imageWidth > 0 ? (int)((float)mediaTime / ((float)this.imageWidth * this.msPerPixel)) : 0;
        int newScreenPos = newMediaX - numScreens * this.imageWidth;
        int diff = oldScreenPos - newScreenPos;
        this.intervalBeginTime = (long)((float)(numScreens * this.imageWidth - diff) * this.msPerPixel);
        if (this.intervalBeginTime < 0L) {
            this.intervalBeginTime = 0L;
        }
        this.intervalEndTime = this.intervalBeginTime + (long)((float)this.imageWidth * this.msPerPixel);
        this.recalculateTagSizes();
        this.crossHairPos = this.xAt(mediaTime);
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        this.updateHorScrollBar();
        this.paintBuffer();
        if (playing) {
            this.startPlayer();
        }
        float zoomFl = 100.0f * (10.0f / this.msPerPixel);
        int zoom = (int)zoomFl;
        this.updateZoomPopup(zoomFl);
        this.setPreference("TimeLineViewer.ZoomLevel", Float.valueOf(zoomFl), this.transcription);
        if (this.zoomSlider != null) {
            this.zoomSlider.removeChangeListener(this);
            if (zoom <= 100) {
                if (zoom < this.zoomSlider.getMinimum()) {
                    this.zoomSlider.setValue(this.zoomSlider.getMinimum());
                } else {
                    this.zoomSlider.setValue(zoom);
                }
            } else {
                float factor = (float)(zoom - 100) / 900.0f;
                int zm = 100 + (int)(factor * (float)(this.zoomSlider.getMaximum() - 100));
                if (zm != this.zoomSlider.getValue()) {
                    this.zoomSlider.setValue(zm);
                }
            }
            this.zoomSlider.addChangeListener(this);
            this.zoomSlider.setToolTipText(String.valueOf(zoom));
        }
    }

    public float getMsPerPixel() {
        return this.msPerPixel;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution < 1 ? 1 : resolution;
        float mspp = 1000.0f / (float)resolution;
        this.setMsPerPixel(mspp);
    }

    public void setResolutionFactor(float factor) {
        int res = (int)(100.0f * factor);
        this.setResolution(res);
    }

    public int getResolution() {
        return this.resolution;
    }

    private Tag2D getTagAt(Point2D p, int tierIndex) {
        if (tierIndex < 0 || tierIndex > this.visibleTiers.size() - 1) {
            return null;
        }
        long pTime = this.pixelToTime((int)p.getX());
        Iterator<Tag2D> it = this.visibleTiers.get(tierIndex).getTags();
        while (it.hasNext()) {
            Tag2D t2d = it.next();
            if (pTime < t2d.getBeginTime() || pTime > t2d.getEndTime()) continue;
            return t2d;
        }
        return null;
    }

    private int getTierIndexForPoint(Point2D p) {
        int y = (int)p.getY() - this.rulerHeight;
        if (y < 0 || y > this.visibleTiers.size() * this.pixelsForTierHeight) {
            return -1;
        }
        return y / this.pixelsForTierHeight;
    }

    private int getTierIndexForAnnotation(Annotation annotation) {
        Tier tier = annotation.getTier();
        int index = -1;
        for (int i = 0; i < this.visibleTiers.size(); ++i) {
            if (this.visibleTiers.get(i).getTier() != tier) continue;
            index = i;
            break;
        }
        return index;
    }

    private Tag2D getHoverTag(Point p) {
        p.x += this.timeToPixels(this.intervalBeginTime);
        p.y += this.verticalScrollOffset;
        this.hoverTierIndex = this.getTierIndexForPoint(p);
        Tag2D hover = this.getTagAt(p, this.hoverTierIndex);
        return hover;
    }

    private void updateDragEditTag(Point dragEndPoint) {
        if (this.dragEditTag2D == null) {
            return;
        }
        this.dragEditTag2D.move(dragEndPoint.x - this.dragStartPoint.x, dragEndPoint.y - this.dragStartPoint.y);
        int diff = dragEndPoint.x - this.dragStartPoint.x;
        int diffy = dragEndPoint.y - this.dragStartPoint.y;
        if (this.dragEditMode == 0 && (Math.abs(this.dragEditTag2D.getDy()) > Math.abs(this.dragEditTag2D.getDx()) || Math.abs(this.dragEditTag2D.getDy()) >= this.pixelsForTierHeight)) {
            this.dragEditTag2D.setY(this.dragEditTag2D.getY() + diffy);
            this.dragEditTag2D.resetX();
            this.dragStartPoint = dragEndPoint;
            int index = this.getTierIndexForPoint(new Point(dragEndPoint.x, dragEndPoint.y + this.verticalScrollOffset));
            if (index > -1 && index < this.visibleTiers.size()) {
                Tier2D t2d = this.visibleTiers.get(index);
                this.dragEditTag2D.isOverTargetTier = t2d != this.dragEditTag2D.getTier2D() && t2d.getTier().getParentTier() == null;
            }
        } else {
            switch (this.dragEditMode) {
                case 0: {
                    this.dragEditTag2D.resetY();
                    if (this.dragParentBegin == -1L) {
                        this.dragEditTag2D.setX(this.dragEditTag2D.getX() + diff);
                        this.dragStartPoint = dragEndPoint;
                    } else {
                        long bt = this.pixelToTime(this.dragEditTag2D.getX() + diff);
                        if (diff < 0) {
                            if (bt < this.dragParentBegin) {
                                bt = this.dragParentBegin;
                                int nx = this.timeToPixels(bt);
                                this.dragEditTag2D.setX(nx);
                            } else {
                                this.dragEditTag2D.setX(this.dragEditTag2D.getX() + diff);
                                this.dragStartPoint = dragEndPoint;
                            }
                        } else {
                            long et = this.pixelToTime(this.dragEditTag2D.getX() + this.dragEditTag2D.getWidth() + diff);
                            if (et > this.dragParentEnd) {
                                et = this.dragParentEnd;
                                bt = et - this.pixelToTime(this.dragEditTag2D.getWidth());
                                this.dragEditTag2D.setX(this.timeToPixels(bt));
                            } else {
                                this.dragEditTag2D.setX(this.dragEditTag2D.getX() + diff);
                                this.dragStartPoint = dragEndPoint;
                            }
                        }
                    }
                    this.setMediaTime(this.pixelToTime(this.dragEditTag2D.getX()));
                    break;
                }
                case 1: {
                    if (this.dragEditTag2D.getX() + diff >= this.dragEditTag2D.getX() + this.dragEditTag2D.getWidth() - 1) break;
                    if (this.dragParentBegin == -1L || diff > 0) {
                        this.dragEditTag2D.setX(this.dragEditTag2D.getX() + diff);
                        this.dragEditTag2D.setWidth(this.dragEditTag2D.getWidth() - diff);
                        this.dragStartPoint = dragEndPoint;
                    } else if (this.dragParentBegin > -1L && diff < 0) {
                        long bt = this.pixelToTime(this.dragEditTag2D.getX() + diff);
                        if (bt < this.dragParentBegin) {
                            bt = this.dragParentBegin;
                            int nx = this.timeToPixels(bt);
                            this.dragEditTag2D.setX(nx);
                            this.dragEditTag2D.setWidth(this.timeToPixels(this.dragEditTag2D.getEndTime() - bt));
                        } else {
                            this.dragEditTag2D.setX(this.dragEditTag2D.getX() + diff);
                            this.dragEditTag2D.setWidth(this.dragEditTag2D.getWidth() - diff);
                            this.dragStartPoint = dragEndPoint;
                        }
                    }
                    this.setMediaTime(this.pixelToTime(this.dragEditTag2D.getX()));
                    break;
                }
                case 2: {
                    if (this.dragEditTag2D.getWidth() + diff <= 1) break;
                    if (this.dragParentEnd == -1L || diff < 0) {
                        this.dragEditTag2D.setWidth(this.dragEditTag2D.getWidth() + diff);
                        this.dragStartPoint = dragEndPoint;
                    } else if (this.dragParentEnd > -1L && diff > 0) {
                        long et = this.pixelToTime(this.dragEditTag2D.getX() + this.dragEditTag2D.getWidth() + diff);
                        if (et > this.dragParentEnd) {
                            et = this.dragParentEnd;
                            this.dragEditTag2D.setWidth(this.timeToPixels(et) - this.dragEditTag2D.getX());
                        } else {
                            this.dragEditTag2D.setWidth(this.dragEditTag2D.getWidth() + diff);
                            this.dragStartPoint = dragEndPoint;
                        }
                    }
                    this.setMediaTime(this.pixelToTime(this.dragEditTag2D.getX() + this.dragEditTag2D.getWidth()));
                }
            }
        }
        this.repaint();
    }

    public long getIntervalBeginTime() {
        return this.intervalBeginTime;
    }

    public long getIntervalEndTime() {
        return this.intervalEndTime;
    }

    public void setIntervalBeginTime(long begin) {
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(begin);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        } else {
            this.setLocalTimeScaleIntervalBeginTime(begin);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recalculateInterval(long mediaTime) {
        long newBeginTime = this.intervalBeginTime;
        long newEndTime = this.intervalEndTime;
        if (this.playerIsPlaying()) {
            if (mediaTime > this.intervalEndTime) {
                newBeginTime = this.intervalEndTime;
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
                while ((newEndTime = (long)((float)newEndTime + ((float)this.imageWidth + this.msPerPixel))) < mediaTime) {
                    newBeginTime = (long)((float)newBeginTime + (float)this.imageWidth * this.msPerPixel);
                }
            } else {
                if (mediaTime >= this.intervalBeginTime) return;
                newEndTime = this.intervalBeginTime;
                newBeginTime = newEndTime - (long)((int)((float)this.imageWidth * this.msPerPixel));
                while ((newEndTime = (long)((float)newEndTime - (float)this.imageWidth * this.msPerPixel)) > mediaTime) {
                    newBeginTime = (long)((float)newBeginTime - (float)this.imageWidth * this.msPerPixel);
                }
                if (newBeginTime < 0L) {
                    newBeginTime = 0L;
                    newEndTime = (long)((float)this.imageWidth * this.msPerPixel);
                }
            }
        } else {
            if (mediaTime < this.intervalBeginTime) {
                newBeginTime = mediaTime - (long)((int)(16.0f * this.msPerPixel));
                if (newBeginTime < 0L) {
                    newBeginTime = 0L;
                }
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            } else if (mediaTime > this.intervalEndTime && (newBeginTime = (newEndTime = mediaTime + (long)((int)(16.0f * this.msPerPixel))) - (long)((int)((float)this.imageWidth * this.msPerPixel))) < 0L) {
                newBeginTime = 0L;
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            }
            if (newBeginTime == this.getSelectionBeginTime() && (float)newBeginTime > 16.0f * this.msPerPixel) {
                newBeginTime = (long)((float)newBeginTime - 16.0f * this.msPerPixel);
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            }
            if (newEndTime == this.getSelectionEndTime() && (newBeginTime = (newEndTime = (long)((float)newEndTime + 16.0f * this.msPerPixel)) - (long)((int)((float)this.imageWidth * this.msPerPixel))) < 0L) {
                newBeginTime = 0L;
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            }
            if (mediaTime == this.getSelectionBeginTime() && (float)this.getSelectionEndTime() > (float)newEndTime - 16.0f * this.msPerPixel && !this.panMode) {
                newEndTime = this.getSelectionEndTime() + (long)((int)(16.0f * this.msPerPixel));
                newBeginTime = newEndTime - (long)((int)((float)this.imageWidth * this.msPerPixel));
                if (newBeginTime > mediaTime && (float)mediaTime > 16.0f * this.msPerPixel) {
                    newBeginTime = mediaTime - (long)((int)(16.0f * this.msPerPixel));
                    newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
                } else if (newBeginTime > mediaTime) {
                    newBeginTime = 0L;
                    newEndTime = (long)((float)this.imageWidth * this.msPerPixel);
                }
            }
        }
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(newBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(newEndTime);
            return;
        } else {
            this.setLocalTimeScaleIntervalBeginTime(newBeginTime);
        }
    }

    private void setLocalTimeScaleIntervalBeginTime(long begin) {
        if (begin == this.intervalBeginTime) {
            return;
        }
        this.intervalBeginTime = begin;
        this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
        if (this.editBox.isVisible()) {
            if (this.getActiveAnnotation() != null) {
                int x = this.xAt(this.getActiveAnnotation().getBeginTimeBoundary());
                this.editBox.setLocation(x, this.editBox.getY());
            } else {
                this.dismissEditBox();
            }
        }
        this.crossHairPos = this.xAt(this.crossHairTime);
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        this.updateHorScrollBar();
        this.paintBuffer();
    }

    public int getVerticalScrollOffset() {
        return this.verticalScrollOffset;
    }

    public void setVerticalScrollOffset(int offset) {
        this.verticalScrollOffset = offset;
        this.paintBuffer();
    }

    private void ensureVerticalVisibilityOfActiveAnnotation() {
        if (this.cursorTag2D == null) {
            return;
        }
        int cy = this.cursorTierIndex * this.pixelsForTierHeight;
        if (cy < this.verticalScrollOffset) {
            this.scrollBar.setValue(cy);
        } else if (cy + this.pixelsForTierHeight - this.verticalScrollOffset > this.getHeight() - this.rulerHeight) {
            this.scrollBar.setValue(cy + this.pixelsForTierHeight + this.rulerHeight - this.getHeight());
        }
    }

    public int getHorizontalScrollOffset() {
        return this.horizontalScrollOffset;
    }

    public void setHorizontalScrollOffset(int offset) {
        this.horizontalScrollOffset = offset;
    }

    private void updateScrollBar() {
        int value = this.scrollBar.getValue();
        int max = this.visibleTiers.size() * this.pixelsForTierHeight + this.rulerHeight;
        this.scrollBar.setValue(0);
        this.scrollBar.setMaximum(max);
        if (this.hScrollBarVisible) {
            this.scrollBar.setVisibleAmount(this.getHeight() - this.defBarWidth);
        } else {
            this.scrollBar.setVisibleAmount(this.getHeight());
        }
        if (value + this.getHeight() > max) {
            value = max - this.getHeight();
        }
        this.scrollBar.setValue(value);
        this.scrollBar.revalidate();
    }

    private void updateHorScrollBar() {
        if (!this.hScrollBarVisible) {
            return;
        }
        int value = this.hScrollBar.getValue();
        if (value != (int)((float)this.intervalBeginTime / this.msPerPixel)) {
            value = (int)((float)this.intervalBeginTime / this.msPerPixel);
        }
        int max = (int)((float)this.getMediaDuration() / this.msPerPixel + 10.0f);
        this.hScrollBar.removeAdjustmentListener(this);
        this.hScrollBar.setBlockIncrement(this.getWidth() - this.defBarWidth);
        this.hScrollBar.setValues(value, this.getWidth() - this.defBarWidth, 0, max);
        this.hScrollBar.revalidate();
        this.hScrollBar.addAdjustmentListener(this);
    }

    private void notifyMultiTierControlPanel() {
        if (this.multiTierControlPanel == null) {
            return;
        }
        if (this.tierYPositions.length != this.visibleTiers.size()) {
            this.tierYPositions = new int[this.visibleTiers.size()];
        }
        if (this.tierYPositions.length > 0) {
            int bh = this.timeRulerVisible ? this.rulerHeight : 0;
            this.tierYPositions[0] = bh + this.pixelsForTierHeight / 2 - this.verticalScrollOffset;
            for (int i = 1; i < this.visibleTiers.size(); ++i) {
                this.tierYPositions[i] = this.tierYPositions[0] + i * this.pixelsForTierHeight;
            }
        }
        this.multiTierControlPanel.setTierPositions(this.tierYPositions);
    }

    public Dimension getViewerSize() {
        return new Dimension(this.imageWidth, this.imageHeight);
    }

    public int getLeftMargin() {
        return 0;
    }

    public int getRightMargin() {
        return this.scrollBar.getWidth();
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu("TimeLine Viewer");
        this.zoomMI = new JMenu(ElanLocale.getString("TimeScaleBasedViewer.Zoom"));
        this.zoomBG = new ButtonGroup();
        this.zoomSelectionMI = new JMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Selection"));
        this.zoomSelectionMI.addActionListener(this);
        this.zoomMI.add(this.zoomSelectionMI);
        this.zoomToEntireMediaMI = new JMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Zoom.EntireMedia"));
        this.zoomToEntireMediaMI.addActionListener(this);
        this.zoomMI.add(this.zoomToEntireMediaMI);
        this.customZoomMI = new JRadioButtonMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom"));
        this.customZoomMI.setEnabled(false);
        this.zoomBG.add(this.customZoomMI);
        this.zoomMI.add(this.customZoomMI);
        this.zoomMI.addSeparator();
        for (int element : this.ZOOMLEVELS) {
            JRadioButtonMenuItem zoomRB = new JRadioButtonMenuItem(element + "%");
            zoomRB.setActionCommand(String.valueOf(element));
            zoomRB.addActionListener(this);
            this.zoomBG.add(zoomRB);
            this.zoomMI.add(zoomRB);
            if (element != 100) continue;
            zoomRB.setSelected(true);
        }
        this.popup.add(this.zoomMI);
        int fontSize = this.getFont().getSize();
        this.fontSizeBG = new ButtonGroup();
        this.fontMenu = new JMenu(ElanLocale.getString("Menu.View.FontSize"));
        for (int element : Constants.FONT_SIZES) {
            JRadioButtonMenuItem fontRB = new JRadioButtonMenuItem(String.valueOf(element));
            fontRB.setActionCommand("font" + element);
            if (fontSize == element) {
                fontRB.setSelected(true);
            }
            fontRB.addActionListener(this);
            this.fontSizeBG.add(fontRB);
            this.fontMenu.add(fontRB);
        }
        this.popup.add(this.fontMenu);
        this.activeAnnStrokeBoldMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeLineViewer.ActiveAnnotationBold"));
        this.activeAnnStrokeBoldMI.setSelected(this.aaStrokeBold);
        this.activeAnnStrokeBoldMI.setActionCommand("aastroke");
        this.activeAnnStrokeBoldMI.addActionListener(this);
        this.popup.add(this.activeAnnStrokeBoldMI);
        this.reducedTierHeightMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeLineViewer.ReducedTierHeight"));
        this.reducedTierHeightMI.setSelected(this.reducedTierHeight);
        this.reducedTierHeightMI.setActionCommand("redTH");
        this.reducedTierHeightMI.addActionListener(this);
        this.popup.add(this.reducedTierHeightMI);
        this.hScrollBarVisMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeLineViewer.Menu.HScrollBar"));
        this.hScrollBarVisMI.setSelected(this.hScrollBarVisible);
        this.hScrollBarVisMI.setActionCommand("hsVis");
        this.hScrollBarVisMI.addActionListener(this);
        this.popup.add(this.hScrollBarVisMI);
        this.timeRulerVisMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeScaleBasedViewer.TimeRuler.Visible"));
        this.timeRulerVisMI.setSelected(this.timeRulerVisible);
        this.timeRulerVisMI.addActionListener(this);
        this.popup.add(this.timeRulerVisMI);
        this.popup.addSeparator();
        this.timeScaleConMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Connected"), this.timeScaleConnected);
        this.timeScaleConMI.setActionCommand("connect");
        this.timeScaleConMI.addActionListener(this);
        this.popup.add(this.timeScaleConMI);
        this.tickerModeMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeScaleBasedViewer.TickerMode"));
        this.tickerModeMI.setSelected(this.tickerMode);
        this.tickerModeMI.addActionListener(this);
        this.popup.add(this.tickerModeMI);
        this.staticMenuItems = this.popup.getComponentCount();
        this.contextSensitiveItems = new ArrayList<JMenuItem>();
        this.popup.addSeparator();
        this.contextSensitiveItems.add(null);
        this.newAnnoMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.NewAnnotation"));
        this.newAnnoMI.setActionCommand("newAnn");
        this.newAnnoMI.addActionListener(this);
        this.popup.add(this.newAnnoMI);
        this.contextSensitiveItems.add(this.newAnnoMI);
        this.newAnnoBeforeMI = new JMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Annotation.NewAnnotationBefore"));
        this.popup.add(this.newAnnoBeforeMI);
        this.contextSensitiveItems.add(this.newAnnoBeforeMI);
        this.newAnnoAfterMI = new JMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Annotation.NewAnnotationAfter"));
        this.popup.add(this.newAnnoAfterMI);
        this.contextSensitiveItems.add(this.newAnnoAfterMI);
        this.modifyAnnoMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.ModifyAnnotation"));
        this.modifyAnnoMI.setActionCommand("modifyAnn");
        this.modifyAnnoMI.addActionListener(this);
        this.popup.add(this.modifyAnnoMI);
        this.contextSensitiveItems.add(this.modifyAnnoMI);
        this.modifyAnnoDCMI = new JMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Annotation.ModifyAnnotationDatCat"));
        this.popup.add(this.modifyAnnoDCMI);
        this.contextSensitiveItems.add(this.modifyAnnoDCMI);
        this.showInBrowserMI = new JMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Annotation.ShowInBrowser"));
        this.popup.add(this.showInBrowserMI);
        this.contextSensitiveItems.add(this.showInBrowserMI);
        this.mergeAnnoNextMI = new JMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Annotation.MergeWithNext"));
        this.popup.add(this.mergeAnnoNextMI);
        this.contextSensitiveItems.add(this.mergeAnnoNextMI);
        this.mergeAnnoBeforeMI = new JMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Annotation.MergeWithBefore"));
        this.popup.add(this.mergeAnnoBeforeMI);
        this.contextSensitiveItems.add(this.mergeAnnoBeforeMI);
        this.splitAnnotationMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.SplitAnnotation"));
        this.splitAnnotationMI.setEnabled(false);
        this.splitAnnotationMI.addActionListener(this);
        this.popup.add(this.splitAnnotationMI);
        this.contextSensitiveItems.add(this.splitAnnotationMI);
        this.deleteAnnoValueMI = new JMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Annotation.RemoveAnnotationValue"));
        this.popup.add(this.deleteAnnoValueMI);
        this.contextSensitiveItems.add(this.deleteAnnoValueMI);
        this.modifyAnnoTimeMI = new JMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "CommandActions.ModifyAnnotationTime"));
        this.popup.add(this.modifyAnnoTimeMI);
        this.contextSensitiveItems.add(this.modifyAnnoTimeMI);
        this.modifyAnnoTimeDlgMI = new JMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Annotation.ModifyAnnotationTimeDialog"));
        this.popup.add(this.modifyAnnoTimeDlgMI);
        this.contextSensitiveItems.add(this.modifyAnnoTimeDlgMI);
        this.deleteAnnoMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.DeleteAnnotation"));
        this.deleteAnnoMI.setActionCommand("deleteAnn");
        this.deleteAnnoMI.addActionListener(this);
        this.popup.add(this.deleteAnnoMI);
        this.contextSensitiveItems.add(this.deleteAnnoMI);
        this.deleteSelAnnosMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.DeleteSelectedAnnotations"));
        this.deleteSelAnnosMI.addActionListener(this);
        this.popup.add(this.deleteSelAnnosMI);
        this.contextSensitiveItems.add(this.deleteSelAnnosMI);
        this.popup.addSeparator();
        this.contextSensitiveItems.add(null);
        this.copyAnnoMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.CopyAnnotation"));
        this.copyAnnoMI.addActionListener(this);
        this.popup.add(this.copyAnnoMI);
        this.contextSensitiveItems.add(this.copyAnnoMI);
        this.copyAnnoTreeMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.CopyAnnotationTree"));
        this.copyAnnoTreeMI.addActionListener(this);
        this.popup.add(this.copyAnnoTreeMI);
        this.contextSensitiveItems.add(this.copyAnnoTreeMI);
        this.pasteAnnoHereMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.PasteAnnotationHere"));
        this.pasteAnnoHereMI.addActionListener(this);
        this.popup.add(this.pasteAnnoHereMI);
        this.contextSensitiveItems.add(this.pasteAnnoHereMI);
        this.pasteAnnoTreeHereMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.PasteAnnotationTreeHere"));
        this.pasteAnnoTreeHereMI.addActionListener(this);
        this.popup.add(this.pasteAnnoTreeHereMI);
        this.contextSensitiveItems.add(this.pasteAnnoTreeHereMI);
        this.popup.addSeparator();
        this.contextSensitiveItems.add(null);
        this.shiftActiveAnnMI = new JMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Annotation.ShiftActiveAnnotation"));
        this.shiftActiveAnnMI.setText(ElanLocale.getString("Menu.Annotation.Shift") + " " + ElanLocale.getString("Menu.Annotation.ShiftActiveAnnotation"));
        this.popup.add(this.shiftActiveAnnMI);
        this.contextSensitiveItems.add(this.shiftActiveAnnMI);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        float zoomFl = 100.0f * (10.0f / this.msPerPixel);
        this.updateZoomPopup(zoomFl);
    }

    private void updateZoomPopup(float zoom) {
        if (this.popup == null) {
            return;
        }
        if (zoom > 74.99f && zoom < 75.0f) {
            zoom = 75.0f;
        } else if ((double)zoom > 149.99 && zoom < 150.0f) {
            zoom = 150.0f;
        }
        int zoomMenuIndex = -1;
        for (int i = 0; i < this.ZOOMLEVELS.length; ++i) {
            if (zoom != (float)this.ZOOMLEVELS[i]) continue;
            zoomMenuIndex = i;
            break;
        }
        Enumeration<AbstractButton> en = this.zoomBG.getElements();
        int counter = 0;
        while (en.hasMoreElements()) {
            JRadioButtonMenuItem rbmi = (JRadioButtonMenuItem)en.nextElement();
            if (counter == zoomMenuIndex + 1) {
                rbmi.setSelected(true);
                break;
            }
            rbmi.setSelected(false);
            ++counter;
        }
        if (zoomMenuIndex == -1) {
            this.customZoomMI.setSelected(true);
            this.customZoomMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom") + " - " + zoom + "%");
        } else {
            this.customZoomMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom"));
        }
    }

    private void checkForSplitAnnotation() {
        List<TierImpl> childTiers;
        TierImpl tier;
        this.splitAnnotationMI.setEnabled(false);
        Annotation activeAnnotation = this.getActiveAnnotation();
        if (activeAnnotation != null && (tier = (TierImpl)activeAnnotation.getTier()).isTimeAlignable() && !tier.hasParentTier() && (childTiers = tier.getChildTiers()) != null) {
            boolean valid = false;
            for (int i = 0; i < childTiers.size(); ++i) {
                TierImpl childTier = childTiers.get(i);
                if (childTier.getLinguisticType().getConstraints().getStereoType() != 4) {
                    valid = false;
                    break;
                }
                valid = true;
            }
            this.splitAnnotationMI.setEnabled(valid);
            if (!valid) {
                List<TierImpl> dependentTiers = tier.getDependentTiers();
                boolean dependingAnnotationsExist = false;
                for (TierImpl depTier : dependentTiers) {
                    if (depTier.getLinguisticType().getConstraints().getStereoType() == 4 || activeAnnotation.getChildrenOnTier(depTier).size() <= 0) continue;
                    dependingAnnotationsExist = true;
                    break;
                }
                if (!dependingAnnotationsExist) {
                    this.splitAnnotationMI.setEnabled(true);
                }
            }
        }
    }

    private void zoomIn() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        float nz = zoom + 10.0f;
        float nm = 100.0f / nz * 10.0f;
        this.setMsPerPixel(nm);
    }

    private void zoomOut() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        float nz = zoom - 10.0f;
        if (nz < (float)this.ZOOMLEVELS[0]) {
            nz = this.ZOOMLEVELS[0];
        }
        float nm = 100.0f / nz * 10.0f;
        this.setMsPerPixel(nm);
    }

    private void zoomToSelection() {
        long selInterval = this.getSelectionEndTime() - this.getSelectionBeginTime();
        if (selInterval < 150L) {
            selInterval = 150L;
        }
        int sw = this.imageWidth != 0 ? this.imageWidth - 32 : this.getWidth() - this.defBarWidth - 32;
        float nextMsPP = (float)selInterval / (float)sw;
        this.setMsPerPixel(nextMsPP);
        if (!this.playerIsPlaying()) {
            long ibt = this.getSelectionBeginTime() - (long)(16.0f * this.msPerPixel);
            if (ibt < 0L) {
                ibt = 0L;
            }
            this.setIntervalBeginTime(ibt);
        }
        this.setPreference("TimeLineViewer.ZoomLevel", Float.valueOf(100.0f * (10.0f / this.msPerPixel)), this.transcription);
    }

    private void zoomToShowEntireMedia() {
        int areaWidth = this.getWidth() - this.defBarWidth - 16;
        float nextMsPP = (float)this.getMediaDuration() / (float)areaWidth;
        if (nextMsPP != this.msPerPixel) {
            this.setMsPerPixel(nextMsPP);
            this.setIntervalBeginTime(0L);
            if (this.getViewerManager() != null) {
                this.setPreference("SignalViewer.ZoomLevel", Float.valueOf(100.0f * (10.0f / this.msPerPixel)), this.getViewerManager().getTranscription());
            }
        }
    }

    @Override
    public void zoomInStep() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        if (zoom >= (float)this.ZOOMLEVELS[this.ZOOMLEVELS.length - 1]) {
            return;
        }
        int zoomMenuIndex = -1;
        for (int i = 0; i < this.ZOOMLEVELS.length; ++i) {
            if (zoom < (float)this.ZOOMLEVELS[i]) {
                zoomMenuIndex = i;
                break;
            }
            if (zoom != (float)this.ZOOMLEVELS[i]) continue;
            zoomMenuIndex = i + 1;
        }
        if (zoomMenuIndex >= 0 && zoomMenuIndex < this.ZOOMLEVELS.length) {
            int nextZoom = this.ZOOMLEVELS[zoomMenuIndex];
            float nextMsPerPixel = 100.0f / (float)nextZoom * 10.0f;
            this.setMsPerPixel(nextMsPerPixel);
            this.updateZoomPopup(nextZoom);
        }
    }

    @Override
    public void zoomOutStep() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        if (zoom <= (float)this.ZOOMLEVELS[0]) {
            return;
        }
        int zoomMenuIndex = -1;
        for (int i = this.ZOOMLEVELS.length - 1; i >= 0; --i) {
            if (zoom > (float)this.ZOOMLEVELS[i]) {
                zoomMenuIndex = i;
                break;
            }
            if (zoom != (float)this.ZOOMLEVELS[i]) continue;
            zoomMenuIndex = i - 1;
        }
        if (zoomMenuIndex >= 0 && zoomMenuIndex < this.ZOOMLEVELS.length) {
            int nextZoom = this.ZOOMLEVELS[zoomMenuIndex];
            float nextMsPerPixel = 100.0f / (float)nextZoom * 10.0f;
            this.setMsPerPixel(nextMsPerPixel);
            this.updateZoomPopup(nextZoom);
        }
    }

    @Override
    public void zoomToDefault() {
        if ((int)this.msPerPixel != 10) {
            int nextZoom = 100;
            float nextMsPerPixel = 10.0f;
            this.setMsPerPixel(nextMsPerPixel);
            this.updateZoomPopup(nextZoom);
        }
    }

    private void updatePopup(Point p) {
        this.enableAndDisablePopupItems(p);
        this.addAndRemovePopupItems();
    }

    private void enableAndDisablePopupItems(Point p) {
        this.newAnnoMI.setEnabled(false);
        this.newAnnoBeforeMI.setEnabled(false);
        this.newAnnoAfterMI.setEnabled(false);
        this.modifyAnnoMI.setEnabled(false);
        this.modifyAnnoDCMI.setEnabled(false);
        this.showInBrowserMI.setEnabled(false);
        this.modifyAnnoTimeMI.setEnabled(false);
        this.deleteAnnoValueMI.setEnabled(false);
        this.deleteAnnoMI.setEnabled(false);
        this.deleteSelAnnosMI.setEnabled(false);
        this.copyAnnoMI.setEnabled(false);
        this.copyAnnoTreeMI.setEnabled(false);
        this.pasteAnnoHereMI.setEnabled(false);
        this.pasteAnnoTreeHereMI.setEnabled(false);
        this.splitAnnotationMI.setEnabled(false);
        this.splitTime = 0L;
        this.zoomSelectionMI.setEnabled(this.getSelectionBeginTime() != this.getSelectionEndTime());
        if (this.timeRulerVisible && p.y < this.rulerHeight) {
            return;
        }
        Point inverse = new Point(p);
        inverse.x += this.timeToPixels(this.intervalBeginTime);
        inverse.y += this.verticalScrollOffset;
        this.rightClickTime = this.pixelToTime(inverse.x);
        if (this.rightClickTime > this.getMediaDuration()) {
            return;
        }
        boolean supportsInsertion = false;
        int tierIndex = this.getTierIndexForPoint(inverse);
        if (tierIndex < 0) {
            return;
        }
        this.rightClickTier = this.visibleTiers.get(tierIndex);
        TierImpl tier = this.rightClickTier.getTier();
        if (tier == null) {
            return;
        }
        try {
            Tag2D tag2d;
            LinguisticType lt = tier.getLinguisticType();
            Constraint c = null;
            if (lt != null) {
                c = lt.getConstraints();
            }
            if (c != null) {
                supportsInsertion = c.supportsInsertion();
            }
            this.checkForSplitAnnotation();
            this.splitTime = this.rightClickTime;
            if (this.selectedAnnotations.size() > 0) {
                this.deleteSelAnnosMI.setEnabled(true);
            }
            if ((tag2d = this.getTagAt(inverse, tierIndex)) != null && tag2d == this.cursorTag2D) {
                this.modifyAnnoMI.setEnabled(true);
                this.modifyAnnoDCMI.setEnabled(true);
                this.deleteAnnoValueMI.setEnabled(true);
                this.deleteAnnoMI.setEnabled(true);
                this.copyAnnoMI.setEnabled(true);
                this.copyAnnoTreeMI.setEnabled(true);
                if (supportsInsertion) {
                    this.newAnnoAfterMI.setEnabled(true);
                    this.newAnnoBeforeMI.setEnabled(true);
                }
                if (tier.isTimeAlignable()) {
                    this.newAnnoMI.setEnabled(true);
                    if (this.getSelectionBeginTime() != this.getSelectionEndTime()) {
                        this.modifyAnnoTimeMI.setEnabled(true);
                    }
                }
                if (ShowInBrowserCommand.hasBrowserLinkInECV(this.getViewerManager().getActiveAnnotation().getAnnotation()).booleanValue()) {
                    this.showInBrowserMI.setEnabled(true);
                }
            } else {
                Annotation refA;
                Annotation parentA;
                if (this.getSelectionBeginTime() != this.getSelectionEndTime() && this.getSelectionBeginTime() <= this.rightClickTime && this.getSelectionEndTime() >= this.rightClickTime) {
                    if (tier.isTimeAlignable()) {
                        this.newAnnoMI.setEnabled(true);
                    } else if (tier.getParentTier() != null && (c.getStereoType() == 4 || c.getStereoType() == 3)) {
                        parentA = tier.getParentTier().getAnnotationAtTime(this.rightClickTime);
                        refA = tier.getAnnotationAtTime(this.rightClickTime);
                        if (parentA != null && refA == null) {
                            this.newAnnoMI.setEnabled(true);
                        }
                    }
                }
                if (AnnotationTransfer.validContentsOnClipboard()) {
                    if (tier.getParentTier() == null) {
                        this.pasteAnnoHereMI.setEnabled(true);
                        this.pasteAnnoTreeHereMI.setEnabled(true);
                    } else {
                        parentA = tier.getParentTier().getAnnotationAtTime(this.rightClickTime);
                        refA = tier.getAnnotationAtTime(this.rightClickTime);
                        if (parentA != null && refA == null) {
                            this.pasteAnnoHereMI.setEnabled(true);
                            this.pasteAnnoTreeHereMI.setEnabled(true);
                        }
                    }
                }
            }
        }
        catch (Exception rex) {
            rex.printStackTrace();
        }
    }

    private void addAndRemovePopupItems() {
        int pos = this.staticMenuItems;
        boolean prevIsASeparator = false;
        for (JMenuItem item : this.contextSensitiveItems) {
            if (item == null) {
                if (pos < this.popup.getComponentCount() && this.popup.getComponent(pos) instanceof JPopupMenu.Separator) {
                    if (prevIsASeparator) {
                        this.popup.remove(pos);
                    } else {
                        ++pos;
                    }
                } else if (!prevIsASeparator) {
                    this.popup.add((Component)new JPopupMenu.Separator(), pos);
                    ++pos;
                }
                prevIsASeparator = true;
                continue;
            }
            if (item.isEnabled()) {
                if (item.getParent() == null) {
                    this.popup.add((Component)item, pos);
                }
                ++pos;
                prevIsASeparator = false;
                continue;
            }
            if (item.getParent() == null) continue;
            if (this.popup.getComponent(pos) == item) {
                this.popup.remove(pos);
                continue;
            }
            this.popup.remove(item);
        }
        if (prevIsASeparator) {
            this.popup.remove(pos - 1);
        }
        this.popup.validate();
    }

    private void dismissEditBox() {
        if (this.editBox.isVisible()) {
            if (this.deselectCommits) {
                this.editBox.commitEdit();
            } else {
                this.editBox.cancelEdit();
            }
        }
    }

    public void setKeyStrokesNotToBeConsumed(List<KeyStroke> ksList) {
        this.editBox.setKeyStrokesNotToBeConsumed(ksList);
    }

    protected void showEditBoxForTag(Tag2D tag2d) {
        if (tag2d.getAnnotation() == null) {
            return;
        }
        this.editBox.setAnnotation(tag2d.getAnnotation(), this.forceOpenControlledVocabulary);
        int tierIndex = this.getTierIndexForAnnotation(tag2d.getAnnotation());
        int y = this.rulerHeight + tierIndex * this.pixelsForTierHeight - this.verticalScrollOffset;
        int x = this.xAt(tag2d.getBeginTime());
        Font f = this.getFontForTier(tag2d.getTier2D().getTier());
        if (f != null) {
            this.editBox.setFont(f);
        }
        this.editBox.configureEditor(JPanel.class, null, new Dimension(tag2d.getWidth() + 2, this.pixelsForTierHeight));
        this.updateEditBoxLocation(this.editBox, x, y);
        this.editBox.startEdit();
        this.forceOpenControlledVocabulary = false;
    }

    public void showEditBoxForAnnotation(Annotation ann) {
        Font f;
        if (ann == null) {
            return;
        }
        this.editBox.setAnnotation(ann);
        int tierIndex = this.getTierIndexForAnnotation(ann);
        int y = this.rulerHeight + tierIndex * this.pixelsForTierHeight - this.verticalScrollOffset;
        int x = this.xAt(ann.getBeginTimeBoundary());
        int w = this.xAt(ann.getEndTimeBoundary()) - x;
        if (x < 0) {
            w = w - -x + 2;
            x = 2;
        }
        if ((f = this.getFontForTier(ann.getTier())) != null) {
            this.editBox.setFont(f);
        }
        this.editBox.configureEditor(JPanel.class, null, new Dimension(w + 2, this.pixelsForTierHeight));
        this.updateEditBoxLocation(this.editBox, x, y);
        this.editBox.startEdit();
    }

    private void updateEditBoxLocation(InlineEditBox editBox, int x, int y) {
        if (x + editBox.getWidth() > this.getWidth() - this.defBarWidth) {
            x = Math.max(0, this.getWidth() - this.defBarWidth - editBox.getWidth());
        }
        if (editBox.getHeight() > this.getHeight() - this.defBarWidth) {
            editBox.setSize(editBox.getWidth(), this.getHeight() - this.defBarWidth);
        }
        if (y + editBox.getHeight() > this.getHeight() - this.defBarWidth) {
            y = Math.max(0, this.getHeight() - this.defBarWidth - editBox.getHeight());
        }
        editBox.setLocation(x, y);
    }

    private void annotationChanged(TierImpl tier, Annotation ann) {
        Iterator<Tier2D> allTierIt = this.allTiers.iterator();
        this.dismissEditBox();
        block0: while (allTierIt.hasNext()) {
            Tier2D t2d = allTierIt.next();
            if (t2d.getTier() != tier) continue;
            List<Tag2D> tagList = t2d.getTagsList();
            for (Tag2D tag2d : tagList) {
                if (tag2d.getAnnotation() != ann) continue;
                tag2d.setTruncatedValue(this.truncateString(ann.getValue(), tag2d.getWidth(), this.metrics));
                ControlledVocabulary cv = this.transcription.getControlledVocabulary(tier.getLinguisticType().getControlledVocabularyName());
                if (cv == null) break block0;
                String id = ann.getCVEntryId();
                CVEntry e = cv.getEntrybyId(id);
                if (e == null) {
                    tag2d.setColor(null);
                    break block0;
                }
                tag2d.setColor(e.getPrefColor());
                TierImpl parTier = tier.getParentTier();
                if (parTier == null || tier != TierAssociation.findMarkerTierFor(this.transcription, parTier)) continue block0;
                for (Tier2D pt : this.allTiers) {
                    if (pt.getTier() != parTier) continue;
                    for (Tag2D pa2d : pt.getTagsList()) {
                        if (pa2d.getBeginTime() == tag2d.getBeginTime() && pa2d.getEndTime() == tag2d.getEndTime()) {
                            pa2d.setColor(e.getPrefColor());
                            continue block0;
                        }
                        if (pa2d.getBeginTime() <= tag2d.getBeginTime()) continue;
                        continue block0;
                    }
                    continue block0;
                }
                continue block0;
            }
        }
        this.paintBuffer();
    }

    private void tierAdded(TierImpl tier) {
        Tier2D tier2d = new Tier2D(tier);
        for (Annotation annotation : tier.getAnnotations()) {
            Tag2D tag2d = new Tag2D(annotation);
            int xPos = this.timeToPixels(annotation.getBeginTimeBoundary());
            tag2d.setX(xPos);
            int tagWidth = this.timeToPixels(annotation.getEndTimeBoundary()) - xPos;
            tag2d.setWidth(tagWidth);
            tag2d.setTruncatedValue(this.truncateString(annotation.getValue(), tagWidth, this.metrics));
            tier2d.addTag(tag2d);
        }
        this.allTiers.add(tier2d);
        this.tierYPositions = new int[this.allTiers.size()];
    }

    private void tierRemoved(TierImpl tier) {
        this.dismissEditBox();
        for (int i = 0; i < this.allTiers.size(); ++i) {
            Tier2D tier2d = this.allTiers.get(i);
            if (tier2d.getTier() != tier) continue;
            this.allTiers.remove(i);
            this.prefTierFonts.remove(tier.getName());
            if (this.cursorTag2D == null || this.cursorTag2D.getTier2D() != tier2d) break;
            this.cursorTag2D = null;
            this.setActiveAnnotation(null);
            break;
        }
    }

    private void tierChanged(TierImpl tier) {
        List<Object> depTiers = new ArrayList();
        if (tier != null) {
            depTiers = tier.getDependentTiers();
        }
        for (int i = 0; i < this.allTiers.size(); ++i) {
            Tier2D tier2d = this.allTiers.get(i);
            if (tier2d.getTier() == tier) {
                Object opf;
                if (!tier2d.getName().equals(tier.getName()) && (opf = this.prefTierFonts.remove(tier2d.getName())) != null) {
                    this.prefTierFonts.put(tier.getName(), opf);
                }
                tier2d.updateName();
            }
            if (tier2d.getTier() != tier && !depTiers.contains(tier2d.getTier())) continue;
            this.reextractTagsForTier(tier2d);
        }
    }

    private void annotationsAdded(List<TierImpl> tiers) {
        int mode = this.transcription.getTimeChangePropagationMode();
        if (mode != 2) {
            this.dismissEditBox();
            for (int i = 0; i < this.allTiers.size(); ++i) {
                Tier2D tier2d = this.allTiers.get(i);
                if (!tiers.contains(tier2d.getTier())) continue;
                this.reextractTagsForTier(tier2d);
            }
            this.paintBuffer();
        } else {
            this.transcriptionChanged();
        }
    }

    private void autoInsertAnnotation(Point p, int tierIndex) {
        if (tierIndex < 0 || tierIndex > this.visibleTiers.size() - 1) {
            return;
        }
        TierImpl child = this.visibleTiers.get(tierIndex).getTier();
        if (child == null) {
            return;
        }
        long clickTime = this.pixelToTime((int)p.getX());
        if (child.isTimeAlignable() || !child.hasParentTier()) {
            if (clickTime >= this.getSelectionBeginTime() && clickTime <= this.getSelectionEndTime()) {
                Command c = this.createNewAnnotationCommand();
                Object[] args = new Object[]{this.getSelectionBeginTime(), this.getSelectionEndTime()};
                c.execute(child, args);
            }
        } else {
            TierImpl parent = child.getParentTier();
            Annotation ann = parent.getAnnotationAtTime(clickTime);
            if (ann != null) {
                Command c = this.createNewAnnotationCommand();
                Object[] args = new Object[]{clickTime, clickTime};
                c.execute(child, args);
            }
        }
    }

    private Command createNewAnnotationCommand() {
        Command c = null;
        Boolean val = Preferences.getBool("CreateDependingAnnotations", null);
        c = val != null && val != false ? ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.NewAnnotationRecursive") : ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.NewAnnotation");
        return c;
    }

    private void annotationsRemoved() {
        this.transcriptionChanged();
    }

    private void annotationTimeChanged(List<TierImpl> tiers) {
        int mode = this.transcription.getTimeChangePropagationMode();
        if (mode != 2) {
            for (int i = 0; i < this.allTiers.size(); ++i) {
                Tier2D tier2d = this.allTiers.get(i);
                if (!tiers.contains(tier2d.getTier())) continue;
                this.reextractTagsForTier(tier2d);
            }
            this.paintBuffer();
        } else {
            this.transcriptionChanged();
        }
    }

    private void transcriptionChanged() {
        this.cursorTag2D = null;
        this.dismissEditBox();
        for (int i = 0; i < this.allTiers.size(); ++i) {
            Tier2D tier2d = this.allTiers.get(i);
            this.reextractTagsForTier(tier2d);
        }
        if (this.cursorTag2D != null) {
            this.cursorTierIndex = this.visibleTiers.indexOf(this.cursorTag2D.getTier2D());
        }
        this.paintBuffer();
    }

    private int getDefaultTooltipFontSize() {
        Object value = UIManager.getDefaults().get("ToolTip.font");
        if (value != null && value instanceof Font) {
            return ((Font)value).getSize();
        }
        return 12;
    }

    private Font getFontForTier(Tier tier) {
        Font fo;
        if (tier != null && (fo = (Font)this.prefTierFonts.get(tier.getName())) != null) {
            return fo;
        }
        return this.font;
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip tip = new JToolTip();
        tip.setFont(this.tooltipFont);
        tip.setComponent(this);
        return tip;
    }

    public void setTranscription(Transcription transcription) {
        Tier2D tier2d;
        int i;
        this.transcription = (TranscriptionImpl)transcription;
        this.hoverTag2D = null;
        this.hoverTierIndex = 0;
        this.cursorTag2D = null;
        this.cursorTierIndex = 0;
        ArrayList<TierImpl> oldVisibles = new ArrayList<TierImpl>(this.visibleTiers.size());
        for (int i2 = 0; i2 < this.visibleTiers.size(); ++i2) {
            Tier2D tier2d2 = this.visibleTiers.get(i2);
            oldVisibles.add(tier2d2.getTier());
        }
        String activeTierName = "";
        for (i = 0; i < this.allTiers.size(); ++i) {
            tier2d = this.allTiers.get(i);
            if (!tier2d.isActive()) continue;
            activeTierName = tier2d.getName();
            break;
        }
        this.initTiers();
        for (i = 0; i < this.allTiers.size(); ++i) {
            tier2d = this.allTiers.get(i);
            if (!tier2d.getName().equals(activeTierName)) continue;
            tier2d.setActive(true);
            break;
        }
        this.setVisibleTiers(oldVisibles);
    }

    @Override
    public synchronized void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent || event instanceof StopEvent) {
            this.crossHairTime = this.getMediaTime();
            if (!this.playerIsPlaying()) {
                if (this.scroller == null) {
                    this.recalculateInterval(this.crossHairTime);
                    this.crossHairPos = this.xAt(this.crossHairTime);
                    this.repaint();
                } else {
                    this.recalculateInterval(this.crossHairTime);
                }
            } else if (this.tickerMode) {
                long intervalMidTime = (this.intervalBeginTime + this.intervalEndTime) / 2L;
                if ((float)this.crossHairTime > (float)intervalMidTime + 1.0f * this.msPerPixel) {
                    this.setIntervalBeginTime(this.intervalBeginTime + (this.crossHairTime - intervalMidTime));
                } else if (this.crossHairTime < intervalMidTime) {
                    if (this.crossHairTime < this.intervalBeginTime) {
                        this.setIntervalBeginTime(Math.max(0L, this.crossHairTime - (intervalMidTime - this.intervalBeginTime)));
                    } else {
                        int oldPos = this.crossHairPos;
                        this.crossHairPos = this.xAt(this.crossHairTime);
                        if (this.crossHairPos >= oldPos) {
                            this.repaint(oldPos - 2, 0, this.crossHairPos - oldPos + 4, this.getHeight());
                        } else {
                            this.repaint(this.crossHairPos - 2, 0, oldPos - this.crossHairPos + 4, this.getHeight());
                        }
                    }
                } else {
                    this.repaint();
                }
            } else if (this.crossHairTime < this.intervalBeginTime || this.crossHairTime > this.intervalEndTime) {
                this.recalculateInterval(this.crossHairTime);
            } else {
                int oldPos = this.crossHairPos;
                this.crossHairPos = this.xAt(this.crossHairTime);
                int newPos = this.crossHairPos;
                if (newPos >= oldPos) {
                    this.repaint(oldPos - 2, 0, newPos - oldPos + 4, this.getHeight());
                } else {
                    this.repaint(newPos - 2, 0, oldPos - newPos + 4, this.getHeight());
                }
            }
            if (event instanceof StopEvent) {
                this.paintBuffer();
            }
        } else if (event instanceof StartEvent && !this.useBufferedImage) {
            this.paintBuffer();
        }
    }

    @Override
    public void updateActiveAnnotation() {
        this.dismissEditBox();
        Annotation anno = this.getActiveAnnotation();
        if (anno != null) {
            block0: for (Tier2D tier2d : this.allTiers) {
                if (tier2d.getTier() != anno.getTier()) continue;
                Iterator<Tag2D> tagIter = tier2d.getTags();
                while (tagIter.hasNext()) {
                    Tag2D tag2d = tagIter.next();
                    if (tag2d.getAnnotation() != anno) continue;
                    this.cursorTag2D = tag2d;
                    this.cursorTierIndex = this.visibleTiers.indexOf(this.cursorTag2D.getTier2D());
                    this.ensureVerticalVisibilityOfActiveAnnotation();
                    continue block0;
                }
            }
            long beginTime = anno.getBeginTimeBoundary();
            long endTime = anno.getEndTimeBoundary();
            if (!this.playerIsPlaying()) {
                long newBeginTime = this.intervalBeginTime;
                long newEndTime = this.intervalEndTime;
                boolean updateInterval = false;
                if (this.centerAnnotation) {
                    long intMid = (long)((float)this.imageWidth * this.msPerPixel / 2.0f);
                    long annMid = (endTime + beginTime) / 2L;
                    newBeginTime = annMid - intMid;
                    newEndTime = annMid + intMid;
                    if (newBeginTime < 0L) {
                        newBeginTime = 0L;
                        newEndTime = (long)((float)this.imageWidth * this.msPerPixel);
                    }
                    updateInterval = true;
                } else if (beginTime < this.intervalBeginTime || endTime > this.intervalEndTime) {
                    if (beginTime < newBeginTime && (float)beginTime > 16.0f * this.msPerPixel) {
                        newBeginTime = beginTime - (long)((int)(16.0f * this.msPerPixel));
                        newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
                    } else if (endTime > newEndTime) {
                        newEndTime = endTime + (long)((int)(16.0f * this.msPerPixel));
                        newBeginTime = newEndTime - (long)((int)((float)this.imageWidth * this.msPerPixel));
                        if (newBeginTime > beginTime && (float)beginTime > 16.0f * this.msPerPixel) {
                            newBeginTime = beginTime - (long)((int)(16.0f * this.msPerPixel));
                            newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
                        } else if (newBeginTime > beginTime) {
                            newBeginTime = 0L;
                            newEndTime = (long)((float)this.imageWidth * this.msPerPixel);
                        }
                        updateInterval = true;
                    }
                }
                if (this.timeScaleConnected && updateInterval) {
                    this.setGlobalTimeScaleIntervalBeginTime(newBeginTime);
                    this.setGlobalTimeScaleIntervalEndTime(newEndTime);
                } else {
                    this.setLocalTimeScaleIntervalBeginTime(newBeginTime);
                }
            }
        } else {
            this.cursorTag2D = null;
        }
        this.repaint();
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 0: {
                if (!(e.getModification() instanceof TierImpl)) break;
                this.tierAdded((TierImpl)e.getModification());
                if (this.multiTierControlPanel == null) break;
                this.multiTierControlPanel.tierAdded((TierImpl)e.getModification());
                break;
            }
            case 1: {
                if (!(e.getModification() instanceof TierImpl)) break;
                this.tierRemoved((TierImpl)e.getModification());
                if (this.multiTierControlPanel == null) break;
                this.multiTierControlPanel.tierRemoved((TierImpl)e.getModification());
                break;
            }
            case 2: {
                if (!(e.getInvalidatedObject() instanceof TierImpl)) break;
                this.tierChanged((TierImpl)e.getInvalidatedObject());
                if (this.multiTierControlPanel == null) break;
                this.multiTierControlPanel.tierChanged((TierImpl)e.getInvalidatedObject());
                break;
            }
            case 3: {
                if (!(e.getInvalidatedObject() instanceof TierImpl) || !(e.getModification() instanceof Annotation)) break;
                TierImpl invTier = (TierImpl)e.getInvalidatedObject();
                List<TierImpl> depTiers = invTier.getDependentTiers();
                if (depTiers == null) {
                    depTiers = new ArrayList<TierImpl>();
                }
                depTiers.add(0, invTier);
                this.annotationsAdded(depTiers);
                this.delayedAnnotationActivation = true;
                this.lastCreatedAnnotation = (Annotation)e.getModification();
                this.showEditBoxForAnnotation((Annotation)e.getModification());
                if (this.editBox.isVisible()) {
                    this.editBox.requestFocus();
                }
                if (this.multiTierControlPanel == null) break;
                this.multiTierControlPanel.annotationsChanged();
                break;
            }
            case 4: 
            case 5: {
                if (!(e.getInvalidatedObject() instanceof TierImpl) || !(e.getModification() instanceof Annotation)) break;
                this.delayedAnnotationActivation = true;
                this.lastCreatedAnnotation = (Annotation)e.getModification();
                List<TierImpl> tiers = this.transcription.getTiers();
                this.annotationsAdded(tiers);
                this.showEditBoxForAnnotation((Annotation)e.getModification());
                if (this.editBox.isVisible()) {
                    this.editBox.requestFocus();
                }
                if (this.multiTierControlPanel == null) break;
                this.multiTierControlPanel.annotationsChanged();
                break;
            }
            case 14: {
                if (!(e.getInvalidatedObject() instanceof Transcription)) break;
                this.transcriptionChanged();
                if (this.multiTierControlPanel == null) break;
                this.multiTierControlPanel.annotationsChanged();
                break;
            }
            case 6: {
                if (!(e.getInvalidatedObject() instanceof Transcription)) break;
                this.annotationsRemoved();
                if (this.multiTierControlPanel == null) break;
                this.multiTierControlPanel.annotationsChanged();
                break;
            }
            case 7: {
                if (!(e.getInvalidatedObject() instanceof AlignableAnnotation)) break;
                TierImpl invTier = (TierImpl)((AlignableAnnotation)e.getInvalidatedObject()).getTier();
                List<TierImpl> depTiers = invTier.getDependentTiers();
                if (depTiers == null) {
                    depTiers = new ArrayList<TierImpl>();
                }
                depTiers.add(0, invTier);
                this.annotationTimeChanged(depTiers);
                break;
            }
            case 8: {
                Annotation a;
                if (!(e.getSource() instanceof Annotation) || !((a = (Annotation)e.getSource()).getTier() instanceof TierImpl)) break;
                this.annotationChanged((TierImpl)a.getTier(), a);
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                this.paintBuffer();
                break;
            }
        }
        this.selectedAnnotations.clear();
    }

    @Override
    public void updateSelection() {
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        this.paintBuffer();
    }

    @Override
    public void updateLocale() {
        if (this.popup != null) {
            this.zoomMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Zoom"));
            this.timeScaleConMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Connected"));
            this.activeAnnStrokeBoldMI.setText(ElanLocale.getString("TimeLineViewer.ActiveAnnotationBold"));
            this.reducedTierHeightMI.setText(ElanLocale.getString("TimeLineViewer.ReducedTierHeight"));
            this.hScrollBarVisMI.setText(ElanLocale.getString("TimeLineViewer.Menu.HScrollBar"));
            this.fontMenu.setText(ElanLocale.getString("Menu.View.FontSize"));
            this.newAnnoMI.setText(ElanLocale.getString("Menu.Annotation.NewAnnotation"));
            this.newAnnoBeforeMI.setText(ElanLocale.getString("Menu.Annotation.NewAnnotationBefore"));
            this.newAnnoAfterMI.setText(ElanLocale.getString("Menu.Annotation.NewAnnotationAfter"));
            this.modifyAnnoMI.setText(ElanLocale.getString("Menu.Annotation.ModifyAnnotation"));
            this.showInBrowserMI.setText(ElanLocale.getString("Menu.Annotation.ShowInBrowser"));
            this.copyAnnoMI.setText(ElanLocale.getString("Menu.Annotation.CopyAnnotation"));
            this.copyAnnoTreeMI.setText(ElanLocale.getString("Menu.Annotation.CopyAnnotationTree"));
            this.pasteAnnoHereMI.setText(ElanLocale.getString("Menu.Annotation.PasteAnnotationHere"));
            this.pasteAnnoTreeHereMI.setText(ElanLocale.getString("Menu.Annotation.PasteAnnotationTreeHere"));
            this.deleteAnnoMI.setText(ElanLocale.getString("Menu.Annotation.DeleteAnnotation"));
            this.shiftActiveAnnMI.setText(ElanLocale.getString("Menu.Annotation.Shift") + " " + ElanLocale.getString("Menu.Annotation.ShiftActiveAnnotation"));
        }
        if (this.editBox != null) {
            this.editBox.updateLocale();
        }
    }

    public void updateFont(Font f) {
        int oldSize = this.font.getSize();
        this.font = f;
        this.setFont(this.font);
        this.tooltipFont = this.font.deriveFont((float)this.tooltipFontSize);
        this.metrics = this.getFontMetrics(this.font);
        Iterator<String> keyIt = this.prefTierFonts.keySet().iterator();
        String key = null;
        Font prFont = null;
        while (keyIt.hasNext()) {
            key = keyIt.next();
            prFont = (Font)this.prefTierFonts.get(key);
            if (prFont == null) continue;
            this.prefTierFonts.put(key, new Font(prFont.getName(), 0, this.font.getSize()));
        }
        this.recalculateTagSizes();
        this.pixelsForTierHeight = this.calcTierHeight();
        if (oldSize != f.getSize()) {
            if (this.multiTierControlPanel != null) {
                this.multiTierControlPanel.setFont(this.font);
            }
            this.notifyMultiTierControlPanel();
            this.paintBuffer();
            this.scrollBar.setBlockIncrement(this.pixelsForTierHeight);
            this.updateScrollBar();
        } else {
            this.paintBuffer();
        }
    }

    public void setFontSize(int fontSize) {
        this.updateFont(this.getFont().deriveFont((float)fontSize));
        if (this.popup != null) {
            Enumeration<AbstractButton> en = this.fontSizeBG.getElements();
            while (en.hasMoreElements()) {
                JMenuItem item = (JMenuItem)en.nextElement();
                String value = item.getText();
                try {
                    int v = Integer.parseInt(value);
                    if (v != fontSize) continue;
                    item.setSelected(true);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
    }

    public int getFontSize() {
        return this.font.getSize();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        int value = e.getValue();
        if (e.getSource() == this.scrollBar) {
            if (this.editBox.isVisible()) {
                Point p = this.editBox.getLocation();
                p.y += this.verticalScrollOffset - value;
                this.editBox.setLocation(p);
            }
            this.setVerticalScrollOffset(value);
            this.notifyMultiTierControlPanel();
        } else if (e.getSource() == this.hScrollBar) {
            this.setIntervalBeginTime(this.pixelToTime(value));
            this.setHorizontalScrollOffset(value);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.zoomSlider) {
            float nmspp;
            int zoomValue = this.zoomSlider.getValue();
            if (zoomValue > 100) {
                float factor = (float)(zoomValue - 100) / (float)(this.zoomSlider.getMaximum() - 100);
                zoomValue = 100 + (int)(factor * 900.0f);
            }
            if ((nmspp = 100.0f / (float)zoomValue * 10.0f) != this.msPerPixel) {
                this.setMsPerPixel(nmspp);
            }
            this.zoomSlider.setToolTipText(String.valueOf(zoomValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisibleTiers(List<TierImpl> tiers) {
        this.dismissEditBox();
        int oldNum = this.visibleTiers.size();
        Object object = this.tierLock;
        synchronized (object) {
            this.visibleTiers.clear();
            block3: for (Tier tier : tiers) {
                for (Tier2D t2d : this.allTiers) {
                    if (t2d.getTier() != tier) continue;
                    this.visibleTiers.add(t2d);
                    continue block3;
                }
            }
        }
        if (this.cursorTag2D != null) {
            this.cursorTierIndex = this.visibleTiers.indexOf(this.cursorTag2D.getTier2D());
        }
        this.notifyMultiTierControlPanel();
        this.paintBuffer();
        if (oldNum != this.visibleTiers.size()) {
            this.updateScrollBar();
        }
    }

    @Override
    public void setActiveTier(Tier tier) {
        for (Tier2D t2d : this.allTiers) {
            if (t2d.getTier() == tier) {
                t2d.setActive(true);
                int tierIndex = this.visibleTiers.indexOf(t2d);
                int cy = tierIndex * this.pixelsForTierHeight;
                if (cy < this.verticalScrollOffset) {
                    this.scrollBar.setValue(cy);
                    continue;
                }
                if (cy + this.pixelsForTierHeight - this.verticalScrollOffset <= this.getHeight() - this.rulerHeight - this.defBarWidth) continue;
                this.scrollBar.setValue(cy + this.pixelsForTierHeight + this.rulerHeight + this.defBarWidth - this.getHeight());
                continue;
            }
            t2d.setActive(false);
        }
        this.paintBuffer();
    }

    @Override
    public void setMultiTierControlPanel(MultiTierControlPanel controller) {
        this.multiTierControlPanel = controller;
        this.notifyMultiTierControlPanel();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (!this.useBufferedImage) {
            this.imageWidth = this.getWidth() - this.defBarWidth;
            this.imageHeight = this.getHeight();
            if (this.hScrollBarVisible) {
                this.imageHeight -= this.defBarWidth;
            }
            this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            if (this.timeScaleConnected) {
                this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
            }
        }
        this.paintBuffer();
        if (this.hScrollBarVisible) {
            if (this.getWidth() > 200) {
                if (!this.zoomSliderPanel.isVisible()) {
                    this.zoomSliderPanel.setVisible(true);
                }
                this.hScrollBar.setBounds(0, this.getHeight() - this.defBarWidth, this.getWidth() - this.defBarWidth - 100, this.defBarWidth);
                this.updateHorScrollBar();
                this.scrollBar.setBounds(this.getWidth() - this.defBarWidth, 0, this.defBarWidth, this.getHeight() - this.defBarWidth);
                this.zoomSliderPanel.setBounds(this.hScrollBar.getWidth(), this.getHeight() - this.defBarWidth, 100, this.defBarWidth);
                this.zoomSlider.setBounds(0, 0, 100, this.defBarWidth);
                this.corner.setBounds(this.getWidth() - this.defBarWidth, this.getHeight() - this.defBarWidth, this.defBarWidth, this.defBarWidth);
            } else {
                this.zoomSliderPanel.setVisible(false);
                this.hScrollBar.setBounds(0, this.getHeight() - this.defBarWidth, this.getWidth() - this.defBarWidth, this.defBarWidth);
                this.updateHorScrollBar();
                this.scrollBar.setBounds(this.getWidth() - this.defBarWidth - 1, 0, this.defBarWidth, this.getHeight() - this.defBarWidth);
                this.corner.setBounds(this.getWidth() - this.defBarWidth, this.getHeight() - this.defBarWidth, this.defBarWidth, this.defBarWidth);
            }
        } else {
            this.scrollBar.setBounds(this.getWidth() - this.defBarWidth - 1, 0, this.defBarWidth, this.getHeight());
            this.corner.setBounds(this.getWidth() - this.defBarWidth, this.getHeight() - this.defBarWidth, 0, 0);
        }
        this.updateScrollBar();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.componentResized(e);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            return;
        }
        Annotation annotation = null;
        boolean shouldShowEditBox = false;
        this.requestFocus();
        Point pp = e.getPoint();
        if (e.getClickCount() == 1 && e.isAltDown()) {
            Point inverse = new Point(pp);
            this.dismissEditBox();
            inverse.x += this.timeToPixels(this.intervalBeginTime);
            inverse.y += this.verticalScrollOffset;
            Tag2D selTag = this.getTagAt(inverse, this.getTierIndexForPoint(inverse));
            if (selTag != null) {
                if (this.selectedAnnotations.contains(selTag)) {
                    this.selectedAnnotations.remove(selTag);
                } else {
                    this.selectedAnnotations.add(selTag);
                }
            } else {
                this.selectedAnnotations.clear();
            }
            if (this.selectedAnnotations.size() != 0) {
                long bt = Long.MAX_VALUE;
                long et = Long.MIN_VALUE;
                for (Tag2D iterT2d : this.selectedAnnotations) {
                    if (iterT2d.getBeginTime() < bt) {
                        bt = iterT2d.getBeginTime();
                    }
                    if (iterT2d.getEndTime() <= et) continue;
                    et = iterT2d.getEndTime();
                }
                if (bt < et) {
                    this.setSelection(bt, et);
                }
            } else {
                this.setSelection(0L, 0L);
            }
            this.repaint();
        } else if (e.getClickCount() == 1 && e.isShiftDown()) {
            if (this.getSelectionBeginTime() != this.getSelectionEndTime()) {
                long clickTime = this.timeAt(pp.x);
                if (clickTime > this.getSelectionEndTime()) {
                    this.setSelection(this.getSelectionBeginTime(), clickTime);
                } else if (clickTime < this.getSelectionBeginTime()) {
                    this.setSelection(clickTime, this.getSelectionEndTime());
                } else if (clickTime - this.getSelectionBeginTime() < this.getSelectionEndTime() - clickTime) {
                    this.setSelection(clickTime, this.getSelectionEndTime());
                } else {
                    this.setSelection(this.getSelectionBeginTime(), clickTime);
                }
            } else {
                long medTime;
                long clickTime = this.timeAt(pp.x);
                if (clickTime > (medTime = this.getMediaTime())) {
                    this.setSelection(medTime, clickTime);
                } else if (clickTime < medTime) {
                    this.setSelection(clickTime, medTime);
                }
            }
        } else {
            Point inverse = new Point(pp);
            this.dismissEditBox();
            if (!this.timeRulerVisible || pp.y >= this.rulerHeight) {
                inverse.x += this.timeToPixels(this.intervalBeginTime);
                inverse.y += this.verticalScrollOffset;
                this.cursorTierIndex = this.getTierIndexForPoint(inverse);
                this.cursorTag2D = this.getTagAt(inverse, this.cursorTierIndex);
                if (this.cursorTag2D != null) {
                    annotation = this.cursorTag2D.getAnnotation();
                    this.setActiveAnnotation(annotation);
                } else {
                    this.setActiveAnnotation(null);
                }
                if (e.getClickCount() == 2 && this.cursorTag2D != null) {
                    shouldShowEditBox = true;
                    this.forceOpenControlledVocabulary = e.isShiftDown();
                } else if (e.getClickCount() >= 2 && this.cursorTag2D == null) {
                    this.autoInsertAnnotation(inverse, this.cursorTierIndex);
                }
            }
            if (annotation == null && !e.isAltDown()) {
                this.setMediaTime(this.timeAt(pp.x));
                if (!SwingUtilities.isRightMouseButton(e) && !e.isPopupTrigger()) {
                    this.selectedAnnotations.clear();
                }
            }
            if (shouldShowEditBox && this.cursorTag2D != null) {
                this.showEditBoxForTag(this.cursorTag2D);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point pp = e.getPoint();
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            if (this.popup == null) {
                this.createPopupMenu();
            }
            this.updatePopup(pp);
            this.forceOpenControlledVocabulary = e.isShiftDown();
            if (this.popup.getWidth() == 0 || this.popup.getHeight() == 0) {
                this.popup.show(this, pp.x, pp.y);
            } else {
                this.popup.show(this, pp.x, pp.y);
                SwingUtilities.convertPointToScreen(pp, this);
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                Window w = SwingUtilities.windowForComponent(this);
                Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(w.getGraphicsConfiguration());
                if (pp.x + this.popup.getWidth() > d.width - insets.right) {
                    pp.x -= this.popup.getWidth() + insets.right;
                }
                if (pp.y + this.popup.getHeight() > d.height - insets.bottom) {
                    int diff = d.height - insets.bottom - (pp.y + this.popup.getHeight());
                    pp.y -= diff;
                    if (pp.y < insets.top) {
                        pp.y = insets.top;
                    }
                }
                if (pp.y + this.popup.getHeight() > w.getLocationOnScreen().y + w.getHeight()) {
                    pp.y -= this.popup.getHeight();
                }
                this.popup.setLocation(pp);
            }
            return;
        }
        if (this.playerIsPlaying()) {
            this.stopPlayer();
        }
        this.dragStartPoint = e.getPoint();
        this.dragStartTime = this.timeAt(this.dragStartPoint.x);
        if (e.isAltDown() && this.timeRulerVisible && this.dragStartPoint.y < this.rulerHeight) {
            this.panMode = true;
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else if (e.isAltDown()) {
            if (this.cursorTag2D != null && this.dragEditTag2D == null && this.getHoverTag(new Point(e.getPoint())) == this.cursorTag2D) {
                this.dragEditTag2D = new DragTag2D(this.cursorTag2D.getAnnotation());
                this.dragEditTag2D.copyFrom(this.cursorTag2D);
            }
            if (this.dragEditTag2D == null) {
                Point inverse = new Point(pp);
                this.dismissEditBox();
                inverse.y += this.verticalScrollOffset;
                Tag2D hover = this.getHoverTag(e.getPoint());
                if (hover != null && hover.getAnnotation() instanceof AlignableAnnotation) {
                    this.dragEditTag2D = new DragTag2D(hover.getAnnotation());
                    this.dragEditTag2D.copyFrom(hover);
                    this.cursorTag2D = hover;
                    this.cursorTierIndex = this.getTierIndexForPoint(inverse);
                }
            }
            if (this.dragEditTag2D != null) {
                DragTag2D copy = new DragTag2D(this.dragEditTag2D.getAnnotation());
                copy.copyFrom(this.dragEditTag2D);
                this.dragEditTag2D = copy;
                this.dragEditing = true;
                if (((TierImpl)this.dragEditTag2D.getAnnotation().getTier()).hasParentTier()) {
                    AlignableAnnotation pa = (AlignableAnnotation)this.dragEditTag2D.getAnnotation().getParentAnnotation();
                    if (pa != null) {
                        this.dragParentBegin = pa.getBeginTimeBoundary();
                        this.dragParentEnd = pa.getEndTimeBoundary();
                    } else {
                        this.dragParentBegin = -1L;
                        this.dragParentEnd = -1L;
                    }
                } else {
                    this.dragParentBegin = -1L;
                    this.dragParentEnd = -1L;
                }
                int x = (int)((float)this.dragEditTag2D.getBeginTime() / this.msPerPixel - (float)this.intervalBeginTime / this.msPerPixel);
                int x2 = x + (int)((float)(this.dragEditTag2D.getEndTime() - this.dragEditTag2D.getBeginTime()) / this.msPerPixel);
                if (x2 - x < 24) {
                    this.dragEditMode = 0;
                    this.setCursor(Cursor.getPredefinedCursor(12));
                } else if (Math.abs(x - e.getX()) < 8) {
                    this.dragEditMode = 1;
                    this.setCursor(Cursor.getPredefinedCursor(10));
                } else if (Math.abs(x2 - e.getX()) < 8) {
                    this.dragEditMode = 2;
                    this.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    this.dragEditMode = 0;
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        } else {
            this.panMode = false;
            this.stopScroll();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.stopScroll();
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(this.intervalBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        }
        if (this.panMode) {
            this.panMode = false;
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (this.dragEditing) {
            this.setCursor(Cursor.getDefaultCursor());
            if (this.dragEditTag2D != null) {
                if (this.dragEditTag2D.getY() != this.dragEditTag2D.getOrigY()) {
                    Tier2D t2d;
                    Point inverse = new Point(e.getPoint());
                    inverse.y += this.verticalScrollOffset;
                    int tindex = this.getTierIndexForPoint(inverse);
                    if (tindex > -1 && (t2d = this.visibleTiers.get(tindex)).getTier() != this.dragEditTag2D.getAnnotation().getTier() && t2d.getTier().getParentTier() == null) {
                        this.doMoveAnnotation(this.dragEditTag2D.getAnnotation(), t2d.getTier());
                    }
                } else {
                    this.doDragModifyAnnotationTime();
                }
            }
            this.dragEditing = false;
            this.dragEditTag2D = null;
            this.dragParentBegin = -1L;
            this.dragParentEnd = -1L;
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.stopScroll();
        this.hoverTag2D = null;
        this.showEmptySlots = false;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        this.dragEndPoint = e.getPoint();
        if (this.panMode) {
            int scrolldiff = this.dragEndPoint.x - this.dragStartPoint.x;
            long newTime = this.intervalBeginTime - (long)((int)((float)scrolldiff * this.msPerPixel));
            if (this.intervalBeginTime < 0L && newTime < this.intervalBeginTime) {
                newTime = this.intervalBeginTime;
            }
            this.setIntervalBeginTime(newTime);
            this.dragStartPoint = this.dragEndPoint;
            return;
        }
        if (this.dragEndPoint.x <= 0 || this.dragEndPoint.x >= this.getWidth() - this.defBarWidth) {
            this.stopScroll();
            return;
        }
        if (this.dragEndPoint.x < 16 && this.dragEndPoint.x > 0) {
            if (this.scroller == null) {
                if (this.dragStartPoint.x < 16 && this.dragStartPoint.x > 0) {
                    this.setSelection(this.dragStartTime, this.dragStartTime);
                }
                this.stopScrolling = false;
                this.scroller = new DragScroller(-4, 30L);
                this.scroller.start();
            }
            return;
        }
        if (this.dragEndPoint.x > this.getWidth() - this.defBarWidth - 16 && this.dragEndPoint.x < this.getWidth() - this.defBarWidth) {
            if (this.scroller == null) {
                if (this.dragStartPoint.x > this.getWidth() - this.defBarWidth - 16 && this.dragStartPoint.x < this.getWidth() - this.defBarWidth) {
                    this.setSelection(this.dragStartTime, this.dragStartTime);
                }
                this.stopScrolling = false;
                this.scroller = new DragScroller(4, 30L);
                this.scroller.start();
            }
            return;
        }
        this.stopScroll();
        if (this.dragEditing) {
            this.updateDragEditTag(this.dragEndPoint);
            return;
        }
        if (this.timeAt(this.dragEndPoint.x) > this.dragStartTime) {
            this.selectionEndTime = this.timeAt(this.dragEndPoint.x);
            if (this.selectionEndTime > this.getMediaDuration()) {
                this.selectionEndTime = this.getMediaDuration();
            }
            this.selectionBeginTime = this.dragStartTime;
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            if (this.selectionEndTime < 0L) {
                this.selectionEndTime = 0L;
            }
            this.setMediaTime(this.selectionEndTime);
        } else {
            this.selectionBeginTime = this.timeAt(this.dragEndPoint.x);
            if (this.selectionBeginTime > this.getMediaDuration()) {
                this.selectionBeginTime = this.getMediaDuration();
            }
            this.selectionEndTime = this.dragStartTime;
            if (this.selectionEndTime > this.getMediaDuration()) {
                this.selectionEndTime = this.getMediaDuration();
            }
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            if (this.selectionEndTime < 0L) {
                this.selectionEndTime = 0L;
            }
            this.setMediaTime(this.selectionBeginTime);
        }
        this.setSelection(this.selectionBeginTime, this.selectionEndTime);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point pp = e.getPoint();
        this.hoverTag2D = null;
        this.dragEditTag2D = null;
        if (this.timeRulerVisible && pp.y < this.rulerHeight) {
            this.setToolTipText(this.getCommentTip(pp));
            this.showEmptySlots = false;
            return;
        }
        Point inverse = new Point(pp);
        this.hoverTag2D = this.getHoverTag(inverse);
        if (this.hoverTag2D != null && this.hoverTag2D == this.cursorTag2D && e.isAltDown()) {
            this.setToolTipText(null);
            if (this.cursorTag2D.getAnnotation() instanceof AlignableAnnotation) {
                this.dragEditTag2D = new DragTag2D(this.cursorTag2D.getAnnotation());
                this.dragEditTag2D.copyFrom(this.cursorTag2D);
            }
        } else if (this.hoverTag2D != null && e.isControlDown()) {
            if (this.hoverTag2D != this.previousHoverTag2D) {
                this.setToolTipText(null);
                if (this.mediaDisplayer != null) {
                    this.mediaDisplayer.discard();
                }
                this.previousHoverTag2D = this.hoverTag2D;
                Annotation annot = this.hoverTag2D.getAnnotation();
                int tierIndex = this.getTierIndexForAnnotation(this.hoverTag2D.getAnnotation());
                int y = this.rulerHeight + tierIndex * this.pixelsForTierHeight - this.verticalScrollOffset;
                int xBegin = this.xAt(this.hoverTag2D.getBeginTime());
                int hoverTag2DWidth = this.hoverTag2D.getWidth();
                int tierHeight = this.calcTierHeight();
                this.hostMediaDisplayer(new Object[]{annot}, new Rectangle(xBegin, y, hoverTag2DWidth, tierHeight));
            }
        } else if (this.hoverTag2D != null) {
            StringBuilder sb = new StringBuilder();
            if (this.hoverTag2D.getAnnotation() instanceof AlignableAnnotation) {
                sb.append("BT: ");
                sb.append(TimeFormatter.toString(this.hoverTag2D.getBeginTime()));
                sb.append(", ET: ");
                sb.append(TimeFormatter.toString(this.hoverTag2D.getEndTime()));
                sb.append(" ");
            }
            sb.append(this.hoverTag2D.getValue());
            int MAXTOOLTIPLENGTH = 140;
            String strTemp = sb.toString();
            Object strEnd = "<html>";
            while (strTemp.length() > 140) {
                int index = strTemp.lastIndexOf(" ", 140);
                if (index > 0 && index <= 140) {
                    strEnd = (String)strEnd + strTemp.substring(0, index) + "<br>";
                    strTemp = strTemp.substring(index);
                    continue;
                }
                if (strTemp.length() <= 140) continue;
                strEnd = (String)strEnd + strTemp.substring(0, 140);
                strTemp = "";
                break;
            }
            strEnd = (String)strEnd + strTemp;
            if (this.hoverTag2D.getAnnotation() instanceof AbstractAnnotation) {
                String dataCategory;
                AbstractAnnotation annot = (AbstractAnnotation)this.hoverTag2D.getAnnotation();
                String cvName = ((TierImpl)annot.getTier()).getLinguisticType().getControlledVocabularyName();
                ControlledVocabulary cv = null;
                int langIndex = 0;
                String lang = Preferences.getString("DefaultControlledVocabularyLanguage", null);
                if (cvName != null && !cvName.isEmpty() && (cv = this.transcription.getControlledVocabulary(cvName)) != null) {
                    String d;
                    CVEntry entry;
                    int i;
                    if (lang != null && (i = cv.getIndexOfLanguage(lang)) >= 0) {
                        langIndex = i;
                    }
                    if ((entry = cv.getEntrybyId(annot.getCVEntryId())) != null && (d = entry.getDescription(langIndex)) != null && !d.isEmpty()) {
                        strEnd = (String)strEnd + "<br>" + d;
                    }
                }
                if (annot.getExtRef() != null && (dataCategory = annot.getExtRefValue(2)) != null && !dataCategory.isEmpty()) {
                    String name = ELANLocalDCRConnector.getInstance().getNameForDC(dataCategory);
                    strEnd = name != null ? (String)strEnd + "<br>DCR: " + name : (String)strEnd + "<br>DCR: " + dataCategory;
                }
            }
            strEnd = (String)strEnd + "</html>";
            this.setToolTipText((String)strEnd);
        } else if (this.hoverTag2D == null) {
            this.setToolTipText(null);
            if (this.mediaDisplayer != null) {
                this.mediaDisplayer.discard();
            }
            this.previousHoverTag2D = null;
        }
        if (e.isAltDown()) {
            if (this.hoverTag2D != null && this.hoverTag2D.getAnnotation() instanceof AlignableAnnotation) {
                Tag2D copy = new Tag2D(this.hoverTag2D.getAnnotation());
                copy.setX(this.hoverTag2D.getX());
                copy.setWidth(this.hoverTag2D.getWidth());
                this.hoverTag2D = copy;
                this.dragEditing = true;
                if (((TierImpl)this.hoverTag2D.getAnnotation().getTier()).hasParentTier()) {
                    AlignableAnnotation pa = (AlignableAnnotation)this.hoverTag2D.getAnnotation().getParentAnnotation();
                    if (pa != null) {
                        this.dragParentBegin = pa.getBeginTimeBoundary();
                        this.dragParentEnd = pa.getEndTimeBoundary();
                    } else {
                        this.dragParentBegin = -1L;
                        this.dragParentEnd = -1L;
                    }
                } else {
                    this.dragParentBegin = -1L;
                    this.dragParentEnd = -1L;
                }
                int x = (int)((float)this.hoverTag2D.getBeginTime() / this.msPerPixel - (float)this.intervalBeginTime / this.msPerPixel);
                int x2 = x + (int)((float)(this.hoverTag2D.getEndTime() - this.hoverTag2D.getBeginTime()) / this.msPerPixel);
                if (Math.abs(x - e.getX()) < 8) {
                    this.dragEditMode = 1;
                    this.setCursor(Cursor.getPredefinedCursor(10));
                } else if (Math.abs(x2 - e.getX()) < 8) {
                    this.dragEditMode = 2;
                    this.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    this.dragEditMode = 0;
                    this.setCursor(Cursor.getPredefinedCursor(13));
                }
                if (x2 - x < 24) {
                    this.dragEditMode = 0;
                    this.setCursor(Cursor.getPredefinedCursor(13));
                }
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() == 0 && e.getPreciseWheelRotation() == 0.0) {
            return;
        }
        if (e.isControlDown()) {
            if (e.getUnitsToScroll() > 0) {
                this.zoomOut();
            } else {
                this.zoomIn();
            }
            return;
        }
        if (e.isShiftDown()) {
            long newTime;
            int timeDiff = (int)((float)(this.horScrollSpeed * e.getWheelRotation()) * this.msPerPixel);
            long l = newTime = this.intervalBeginTime + (long)timeDiff > 0L ? this.intervalBeginTime + (long)timeDiff : 0L;
            if (newTime != this.intervalBeginTime && newTime < this.getMediaDuration()) {
                this.setIntervalBeginTime(newTime);
            }
            return;
        }
        if (e.isAltDown()) {
            long newTime;
            int timeDiff = (int)((float)this.imageWidth * this.msPerPixel);
            if (e.getWheelRotation() < 0) {
                timeDiff = -timeDiff;
            }
            long l = newTime = this.intervalBeginTime + (long)timeDiff > 0L ? this.intervalBeginTime + (long)timeDiff : 0L;
            if (newTime != this.intervalBeginTime && newTime < this.getMediaDuration()) {
                this.setIntervalBeginTime(newTime);
            }
            return;
        }
        if (e.getUnitsToScroll() > 0) {
            this.scrollBar.setValue(this.scrollBar.getValue() + this.pixelsForTierHeight);
        } else {
            this.scrollBar.setValue(this.scrollBar.getValue() - this.pixelsForTierHeight);
        }
    }

    @Override
    public void magnify(double zoom) {
        if (zoom > 0.0) {
            this.zoomIn();
        } else if (zoom < 0.0) {
            this.zoomOut();
        }
    }

    @Override
    public void swipe(int x, int y) {
        if (x != 0) {
            long newTime = this.intervalBeginTime + this.pixelToTime(x);
            if (newTime != this.intervalBeginTime && (newTime >= 0L || newTime >= this.intervalBeginTime)) {
                this.setIntervalBeginTime(newTime);
            }
        } else if (y != 0) {
            if (y < 0 && this.verticalScrollOffset == 0) {
                return;
            }
            int newValue = this.scrollBar.getValue() + y;
            if (newValue >= 0 && newValue <= this.scrollBar.getMaximum() && newValue != this.scrollBar.getValue()) {
                this.scrollBar.setValue(this.scrollBar.getValue() + y);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getModifiers() == 8 + Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1) {
            if (!this.showEmptySlots) {
                this.showEmptySlots = true;
                this.repaint();
            }
        } else if (this.showEmptySlots) {
            this.showEmptySlots = false;
            this.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if ((e.getKeyCode() == 17 || e.getKeyCode() == 18 || e.getKeyCode() == 16) && this.showEmptySlots) {
            this.showEmptySlots = false;
            this.repaint();
        }
        if (e.getKeyCode() == 18 && !this.dragEditing) {
            this.dragEditTag2D = null;
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.copyAnnoMI) {
            this.copyAnno();
        } else if (e.getSource() == this.copyAnnoTreeMI) {
            this.copyAnnoTree();
        } else if (e.getSource() == this.pasteAnnoHereMI) {
            this.pasteAnnoHere();
        } else if (e.getSource() == this.pasteAnnoTreeHereMI) {
            this.pasteAnnoTreeHere();
        } else if (e.getSource() == this.deleteSelAnnosMI) {
            this.deleteSelectedAnnotations();
        } else if (e.getSource() == this.zoomSelectionMI) {
            this.zoomToSelection();
        } else if (e.getSource() == this.zoomToEntireMediaMI) {
            this.zoomToShowEntireMedia();
        } else if (e.getSource() == this.splitAnnotationMI) {
            Annotation ann = this.getActiveAnnotation();
            Object[] arguments = new Object[2];
            arguments[0] = ann;
            if (ann.getBeginTimeBoundary() < this.splitTime && ann.getEndTimeBoundary() > this.splitTime) {
                arguments[1] = this.splitTime;
            }
            Command command = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.SplitAnnotation");
            command.execute(this.transcription, arguments);
        } else if (e.getSource() == this.tickerModeMI) {
            this.tickerMode = this.tickerModeMI.isSelected();
            this.setPreference("TimeLineViewer.TickerMode", this.tickerMode, this.transcription);
        } else if (e.getSource() == this.timeRulerVisMI) {
            this.timeRulerVisible = this.timeRulerVisMI.isSelected();
            this.rulerHeight = this.timeRulerVisible ? this.ruler.getHeight() : 0;
            this.paintBuffer();
            this.notifyMultiTierControlPanel();
            this.setPreference("TimeLineViewer.TimeRulerVisible", this.timeRulerVisible, this.transcription);
        } else if (e.getActionCommand().equals("connect")) {
            boolean connected = ((JCheckBoxMenuItem)e.getSource()).getState();
            this.setTimeScaleConnected(connected);
            this.setPreference("TimeLineViewer.TimeScaleConnected", connected, this.transcription);
        } else if (e.getActionCommand().equals("aastroke")) {
            this.aaStrokeBold = ((JCheckBoxMenuItem)e.getSource()).getState();
            this.repaint();
            this.setPreference("TimeLineViewer.ActiveAnnotationBold", this.aaStrokeBold, this.transcription);
        } else if (e.getActionCommand().equals("redTH")) {
            this.reducedTierHeight = ((JCheckBoxMenuItem)e.getSource()).getState();
            this.pixelsForTierHeight = this.calcTierHeight();
            this.notifyMultiTierControlPanel();
            this.paintBuffer();
            this.setPreference("TimeLineViewer.ReducedTierHeight", this.reducedTierHeight, this.transcription);
        } else if (e.getActionCommand().equals("hsVis")) {
            this.hScrollBarVisible = ((JCheckBoxMenuItem)e.getSource()).getState();
            if (this.hScrollBarVisible) {
                this.add(this.hScrollBar);
            } else {
                this.remove(this.hScrollBar);
            }
            this.componentResized(null);
            this.setPreference("TimeLineViewer.HorizontalScrollBarVisible", this.hScrollBarVisible, this.transcription);
        } else if (e.getActionCommand().equals("newAnn")) {
            this.doNewAnnotation();
        } else if (e.getActionCommand().equals("annBefore")) {
            this.doAnnotationBefore();
        } else if (e.getActionCommand().equals("annAfter")) {
            this.doAnnotationAfter();
        } else if (e.getActionCommand().equals("modifyAnn")) {
            this.doModifyAnnotation();
        } else if (e.getActionCommand().equals("deleteAnn")) {
            this.doDeleteAnnotation();
        } else if (e.getActionCommand().indexOf("font") > -1) {
            String sizeString = e.getActionCommand();
            int index = sizeString.indexOf("font") + 4;
            int size = 12;
            try {
                size = Integer.parseInt(sizeString.substring(index));
            }
            catch (NumberFormatException nfe) {
                System.err.println("Error parsing font size");
            }
            this.updateFont(this.getFont().deriveFont((float)size));
            this.setPreference("TimeLineViewer.FontSize", size, this.transcription);
        } else {
            String zoomString = e.getActionCommand();
            int zoom = 100;
            try {
                zoom = Integer.parseInt(zoomString);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Error parsing the zoom level");
            }
            float newMsPerPixel = 100.0f / (float)zoom * 10.0f;
            this.setMsPerPixel(newMsPerPixel);
        }
    }

    @Override
    public void editingCancelled() {
        if (this.delayedAnnotationActivation) {
            if (this.activateNewAnnotation) {
                this.setActiveAnnotationA(this.lastCreatedAnnotation);
            }
            this.delayedAnnotationActivation = false;
        }
    }

    @Override
    public void editingCommitted() {
        if (this.delayedAnnotationActivation) {
            if (this.activateNewAnnotation) {
                this.setActiveAnnotationA(this.lastCreatedAnnotation);
            }
            this.delayedAnnotationActivation = false;
        }
    }

    private void setActiveAnnotationA(Annotation aa) {
        Command c = ELANCommandFactory.createCommand(this.getViewerManager().getTranscription(), "Commands.ActiveAnnotation");
        c.execute(this.getViewerManager(), new Object[]{aa, Boolean.FALSE});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void preferencesChanged() {
        Integer intPref;
        Color color;
        Boolean boolPref;
        Map<String, Font> foMap;
        Float zoomLevel;
        Boolean rulerVis;
        Boolean ticMode;
        Boolean tsConnect;
        Boolean hsVis;
        Boolean redTH;
        Boolean centerAnn;
        Boolean aaBold;
        Integer fontSize = Preferences.getInt("TimeLineViewer.FontSize", this.transcription);
        if (fontSize != null) {
            this.setFontSize(fontSize);
        }
        if ((aaBold = Preferences.getBool("TimeLineViewer.ActiveAnnotationBold", this.transcription)) == null) {
            aaBold = Preferences.getBool("TimeLineViewer.ActiveAnnotationBold", null);
        }
        if (aaBold != null) {
            if (this.activeAnnStrokeBoldMI != null) {
                this.activeAnnStrokeBoldMI.setSelected(aaBold);
            }
            this.aaStrokeBold = aaBold;
        }
        this.centerAnnotation = (centerAnn = Preferences.getBool("EditingPanel.ActiveAnnotationInCenter", null)) == null ? true : centerAnn;
        Boolean clearSel = Preferences.getBool("ClearSelectionAfterCreation", null);
        if (clearSel != null) {
            boolean bl = this.activateNewAnnotation = clearSel == false;
        }
        if ((redTH = Preferences.getBool("TimeLineViewer.ReducedTierHeight", this.transcription)) == null) {
            redTH = Preferences.getBool("TimeLineViewer.ReducedTierHeight", null);
        }
        if (redTH != null) {
            boolean oldReduce = this.reducedTierHeight;
            this.reducedTierHeight = redTH;
            if (this.reducedTierHeightMI != null) {
                this.reducedTierHeightMI.setSelected(this.reducedTierHeight);
            }
            if (oldReduce != this.reducedTierHeight) {
                this.pixelsForTierHeight = this.calcTierHeight();
                this.notifyMultiTierControlPanel();
            }
        }
        if ((hsVis = Preferences.getBool("TimeLineViewer.HorizontalScrollBarVisible", this.transcription)) != null) {
            this.hScrollBarVisible = hsVis;
            if (this.hScrollBarVisMI != null) {
                this.hScrollBarVisMI.setSelected(this.hScrollBarVisible);
            }
            if (!this.hScrollBarVisible) {
                this.remove(this.hScrollBar);
            }
        }
        if ((tsConnect = Preferences.getBool("TimeLineViewer.TimeScaleConnected", this.transcription)) != null) {
            if (this.timeScaleConMI != null) {
                this.timeScaleConMI.setSelected(tsConnect);
            }
            this.setTimeScaleConnected(tsConnect);
        }
        if ((ticMode = Preferences.getBool("TimeLineViewer.TickerMode", this.transcription)) != null) {
            this.tickerMode = ticMode;
            if (this.tickerModeMI != null) {
                this.tickerModeMI.setSelected(this.tickerMode);
            }
        }
        if ((rulerVis = Preferences.getBool("TimeLineViewer.TimeRulerVisible", this.transcription)) != null) {
            this.timeRulerVisible = rulerVis;
            if (this.timeRulerVisMI != null) {
                this.timeRulerVisMI.setSelected(this.timeRulerVisible);
            }
            this.rulerHeight = this.timeRulerVisible ? this.ruler.getHeight() : 0;
        }
        if ((zoomLevel = Preferences.getFloat("TimeLineViewer.ZoomLevel", this.transcription)) != null) {
            float zl = zoomLevel.floatValue();
            if ((double)zl > 5000.0) {
                zl = 5000.0f;
            }
            float newMsPerPixel = 100.0f / zl * 10.0f;
            this.setMsPerPixel(newMsPerPixel);
        }
        if ((foMap = Preferences.getMapOfFont("TierFonts", this.transcription)) != null) {
            for (Map.Entry<String, Font> entry : foMap.entrySet()) {
                void var16_33;
                Tier2D tier2D;
                String string = entry.getKey();
                Font ft = entry.getValue();
                Object var16_34 = null;
                if (string == null || ft == null) continue;
                for (int i = 0; i < this.allTiers.size() && !(tier2D = this.allTiers.get(i)).getName().equals(string); ++i) {
                }
                if (this.prefTierFonts.containsKey(string)) {
                    Font oldF = (Font)this.prefTierFonts.get(string);
                    if (oldF.getName().equals(ft.getName())) continue;
                    this.prefTierFonts.put(string, new Font(ft.getName(), 0, this.font.getSize()));
                    this.reextractTagsForTier((Tier2D)var16_33);
                    continue;
                }
                this.prefTierFonts.put(string, new Font(ft.getName(), 0, this.font.getSize()));
                this.reextractTagsForTier((Tier2D)var16_33);
            }
            ArrayList<String> remKeys = new ArrayList<String>(4);
            for (String string : this.prefTierFonts.keySet()) {
                if (foMap.containsKey(string)) continue;
                remKeys.add(string);
            }
            if (!remKeys.isEmpty()) {
                block3: for (String string : remKeys) {
                    this.prefTierFonts.remove(string);
                    for (Tier2D tier2D : this.allTiers) {
                        if (!tier2D.getName().equals(string)) continue;
                        this.reextractTagsForTier(tier2D);
                        continue block3;
                    }
                }
            }
        }
        if ((boolPref = Preferences.getBool("InlineEdit.EnterCommits", null)) != null) {
            this.editBox.setEnterCommits(boolPref);
        }
        if ((boolPref = Preferences.getBool("InlineEdit.DeselectCommits", null)) != null) {
            this.deselectCommits = boolPref;
        }
        this.highlightColors = Preferences.getMapOfColor("TierHighlightColors", this.transcription);
        for (Tier2D t2d : this.allTiers) {
            ControlledVocabulary controlledVocabulary;
            ControlledVocabulary controlledVocabulary2 = this.transcription.getControlledVocabulary(t2d.getTier().getLinguisticType().getControlledVocabularyName());
            if (controlledVocabulary2 != null) {
                for (Tag2D tag2d : t2d.getTagsList()) {
                    Annotation ann = tag2d.getAnnotation();
                    if (ann.getValue() == null || ann.getValue().isEmpty()) continue;
                    this.setColor(tag2d, ann, controlledVocabulary2);
                }
                continue;
            }
            TierImpl tierImpl = TierAssociation.findMarkerTierFor(this.transcription, t2d.getTier());
            if (tierImpl == null || (controlledVocabulary = this.transcription.getControlledVocabulary(tierImpl.getLinguisticType().getControlledVocabularyName())) == null) continue;
            for (Tag2D tag2d : t2d.getTagsList()) {
                List<Annotation> ch = ((AbstractAnnotation)tag2d.getAnnotation()).getChildrenOnTier(tierImpl);
                if (ch.size() < 1) continue;
                Annotation ma = ch.get(0);
                this.setColor(tag2d, ma, controlledVocabulary);
            }
        }
        boolPref = Preferences.getBool("ClearSelectionOnSingleClick", null);
        if (boolPref != null) {
            this.clearSelOnSingleClick = boolPref;
        }
        if ((color = Preferences.getColor("Preferences.SymAnnColor", null)) != null) {
            this.symAnnColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
        }
        if ((intPref = Preferences.getInt("Preferences.TimeLine.HorScrollSpeed", null)) instanceof Integer) {
            this.horScrollSpeed = intPref;
        }
        boolPref = Preferences.getBool("UI.UseBufferedPainting", null);
        if (!SystemReporting.isBufferedPaintingPropertySet && boolPref instanceof Boolean) {
            this.useBufferedImage = boolPref;
        }
        this.paintBuffer();
    }

    public void finalize() throws Throwable {
        System.out.println("Finalize TimeLineViewer...");
        if (this.bi != null) {
            this.bi.flush();
        }
        if (this.big2d != null) {
            this.big2d.dispose();
        }
        if (this.editBox != null) {
            this.editBox.removeInlineEditBoxListener(this);
        }
        super.finalize();
    }

    synchronized void scroll(int numPixels) {
        long begin = this.intervalBeginTime + (long)((int)((float)numPixels * this.msPerPixel));
        if (numPixels > 0) {
            this.setIntervalBeginTime(begin);
            this.selectionEndTime = this.getSelectionEndTime() + (long)((int)((float)numPixels * this.msPerPixel));
            if (this.selectionEndTime > this.getMediaDuration()) {
                this.selectionEndTime = this.getMediaDuration();
            }
            this.setMediaTime(this.selectionEndTime);
            this.setSelection(this.getSelectionBeginTime(), this.selectionEndTime);
        } else {
            if (begin < 0L) {
                begin = 0L;
            }
            this.setIntervalBeginTime(begin);
            this.selectionBeginTime = this.getSelectionBeginTime() + (long)((int)((float)numPixels * this.msPerPixel));
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            this.setMediaTime(this.selectionBeginTime);
            this.setSelection(this.selectionBeginTime, this.getSelectionEndTime());
        }
    }

    void stopScroll() {
        this.stopScrolling = true;
        this.scroller = null;
    }

    private void doNewAnnotation() {
        long end;
        if (this.rightClickTier == null) {
            return;
        }
        TierImpl tier = this.rightClickTier.getTier();
        long begin = this.getSelectionBeginTime();
        if (begin == (end = this.getSelectionEndTime())) {
            return;
        }
        if (!tier.isTimeAlignable()) {
            begin = this.rightClickTime;
            end = this.rightClickTime;
        }
        Command c = this.createNewAnnotationCommand();
        Object[] args = new Object[]{begin, end};
        c.execute(tier, args);
    }

    private void doAnnotationBefore() {
        if (this.rightClickTier == null || this.cursorTag2D == null) {
            return;
        }
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.NewAnnotationBefore");
        Object[] args = new Object[]{this.cursorTag2D.getAnnotation()};
        c.execute(this.rightClickTier.getTier(), args);
    }

    private void doAnnotationAfter() {
        if (this.rightClickTier == null || this.cursorTag2D == null) {
            return;
        }
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.NewAnnotationAfter");
        Object[] args = new Object[]{this.cursorTag2D.getAnnotation()};
        c.execute(this.rightClickTier.getTier(), args);
    }

    private void doModifyAnnotation() {
        if (this.cursorTag2D != null) {
            this.showEditBoxForTag(this.cursorTag2D);
        }
    }

    private void doDeleteAnnotation() {
        if (this.cursorTag2D != null) {
            TierImpl tier = this.cursorTag2D.getTier2D().getTier();
            Annotation aa = this.cursorTag2D.getAnnotation();
            Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.DeleteAnnotation");
            c.execute(tier, new Object[]{this.getViewerManager(), aa});
        }
    }

    private void deleteSelectedAnnotations() {
        if (this.selectedAnnotations.size() == 0) {
            return;
        }
        ArrayList<Annotation> selAnnos = new ArrayList<Annotation>(this.selectedAnnotations.size());
        for (Tag2D t2d : this.selectedAnnotations) {
            selAnnos.add(t2d.getAnnotation());
        }
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.DeleteSelectedAnnotations");
        c.execute(this.transcription, new Object[]{selAnnos});
        this.selectedAnnotations.clear();
        this.repaint();
    }

    private void copyAnno() {
        if (this.cursorTag2D != null) {
            Annotation aa = this.cursorTag2D.getAnnotation();
            Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.CopyAnnotation");
            c.execute(null, new Object[]{aa});
        }
    }

    private void copyAnnoTree() {
        if (this.cursorTag2D != null) {
            Annotation aa = this.cursorTag2D.getAnnotation();
            Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.CopyAnnotationTree");
            c.execute(null, new Object[]{aa});
        }
    }

    private void pasteAnnoHere() {
        if (this.rightClickTier != null) {
            TierImpl tier = this.rightClickTier.getTier();
            Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.PasteAnnotationHere");
            c.execute(this.transcription, new Object[]{tier.getName(), this.rightClickTime});
        }
    }

    private void pasteAnnoTreeHere() {
        if (this.rightClickTier != null) {
            TierImpl tier = this.rightClickTier.getTier();
            Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.PasteAnnotationTreeHere");
            c.execute(this.transcription, new Object[]{tier.getName(), this.rightClickTime});
        }
    }

    private void doDragModifyAnnotationTime() {
        if (this.dragEditTag2D == null) {
            return;
        }
        AlignableAnnotation editAnn = null;
        if (this.dragEditTag2D != null && this.dragEditTag2D.getAnnotation() instanceof AlignableAnnotation) {
            editAnn = (AlignableAnnotation)this.dragEditTag2D.getAnnotation();
        }
        if (editAnn == null) {
            return;
        }
        long beginTime = 0L;
        long endTime = 0L;
        switch (this.dragEditMode) {
            case 0: {
                beginTime = this.pixelToTime(this.dragEditTag2D.getX());
                endTime = this.pixelToTime(this.dragEditTag2D.getX() + this.dragEditTag2D.getWidth());
                if (beginTime >= 0L) break;
                long corr = -beginTime;
                beginTime += corr;
                endTime += corr;
                break;
            }
            case 1: {
                beginTime = this.pixelToTime(this.dragEditTag2D.getX());
                endTime = this.dragEditTag2D.getEndTime();
                break;
            }
            case 2: {
                beginTime = this.dragEditTag2D.getBeginTime();
                endTime = this.pixelToTime(this.dragEditTag2D.getX() + this.dragEditTag2D.getWidth());
            }
        }
        if (endTime <= beginTime) {
            return;
        }
        if ((float)Math.abs(beginTime - this.dragEditTag2D.getBeginTime()) < this.msPerPixel && (float)Math.abs(endTime - this.dragEditTag2D.getEndTime()) < this.msPerPixel) {
            return;
        }
        Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.ModifyAnnotationTime");
        c.execute(editAnn, new Object[]{beginTime, endTime});
    }

    private void doMoveAnnotation(Annotation ann, Tier t) {
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.MoveAnnotationToTier");
        c.execute(t, new Object[]{ann});
    }

    @Override
    public void hostMediaDisplayer(Object[] arguments, Rectangle sourceBounds) {
        this.mediaDisplayer = MediaDisplayerFactory.getMediaDisplayer(arguments);
        if (this.mediaDisplayer != null) {
            int videoWidth = 320;
            int videoHeight = 180;
            MediaDisplayerFactory.MEDIA_ORIENTATION horizontalOrientation = MediaDisplayerFactory.MEDIA_ORIENTATION.WEST;
            MediaDisplayerFactory.MEDIA_ORIENTATION verticalOrientation = MediaDisplayerFactory.MEDIA_ORIENTATION.NORTH;
            int hoverTag2DCenterY = sourceBounds.y + sourceBounds.height / 2;
            int viewportCenterY = this.imageHeight / 2;
            int videoYCoordinate = sourceBounds.y;
            if (hoverTag2DCenterY > viewportCenterY) {
                videoYCoordinate = sourceBounds.y + sourceBounds.height;
                verticalOrientation = MediaDisplayerFactory.MEDIA_ORIENTATION.SOUTH;
            }
            int hoverTag2DCenterX = sourceBounds.x + sourceBounds.width / 2;
            int viewportCenterX = this.imageWidth / 2;
            int videoXCoordinate = sourceBounds.x + sourceBounds.width + 2;
            if (hoverTag2DCenterX > viewportCenterX) {
                videoXCoordinate = sourceBounds.x - 2;
                horizontalOrientation = MediaDisplayerFactory.MEDIA_ORIENTATION.EAST;
            }
            Rectangle bounds = new Rectangle(videoXCoordinate, videoYCoordinate, videoWidth, videoHeight);
            this.mediaDisplayer.displayMedia(this, bounds, 500, horizontalOrientation, verticalOrientation);
        } else if (ClientLogger.LOG.isLoggable(Level.FINE)) {
            ClientLogger.LOG.fine("mediaDisplayer == null");
        }
    }

    @Override
    public void discardMediaDisplayer() {
        if (this.mediaDisplayer != null) {
            this.mediaDisplayer.discard();
        }
    }

    class DragScroller
    extends Thread {
        int numPixels;
        long sleepTime;

        DragScroller(int numPixels, long sleepTime) {
            this.numPixels = numPixels;
            this.sleepTime = sleepTime;
        }

        @Override
        public void run() {
            while (!TimeLineViewer.this.stopScrolling) {
                TimeLineViewer.this.scroll(this.numPixels);
                try {
                    DragScroller.sleep(this.sleepTime);
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    class TLLayoutManager
    implements LayoutManager2 {
        TLLayoutManager() {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            System.out.println("add...");
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
            System.out.println("invalidate...");
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return null;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            System.out.println("layout container...");
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

