/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.webserviceclient.weblicht;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;

public class WebLichtStep2
extends StepPane
implements DocumentListener {
    private JTextArea textArea;
    private JLabel textLabel;

    public WebLichtStep2(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.textLabel = new JLabel(ElanLocale.getString("WebServicesDialog.WebLicht.TypeText"));
        this.textArea = new JTextArea();
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 0, 6, 0);
        gbc.anchor = 18;
        this.add((Component)this.textLabel, gbc);
        gbc.gridy = 1;
        gbc.insets = new Insets(2, 0, 2, 0);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JScrollPane(this.textArea), gbc);
        this.textArea.getDocument().addDocumentListener(this);
    }

    @Override
    public void enterStepForward() {
        this.textArea.requestFocus();
        this.checkText();
    }

    @Override
    public boolean leaveStepForward() {
        String text = this.textArea.getText();
        if (text != null && text.length() > 0) {
            this.multiPane.putStepProperty("InputText", text);
            return true;
        }
        return false;
    }

    @Override
    public void enterStepBackward() {
        this.checkText();
        this.textArea.requestFocus();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("WebServicesDialog.WebLicht.StepTitle2a");
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.checkText();
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.checkText();
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.checkText();
    }

    private void checkText() {
        String t = this.textArea.getText();
        if (t != null && t.length() > 0) {
            this.multiPane.setButtonEnabled(1, true);
        } else {
            this.multiPane.setButtonEnabled(1, false);
        }
    }
}

