/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.webserviceclient.weblicht;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.webserviceclient.weblicht.WLDescriptorListRenderer;
import mpi.eudico.webserviceclient.weblicht.WLServiceDescriptor;
import mpi.eudico.webserviceclient.weblicht.WebLichtHarvester;

public class WebLichtStep3
extends StepPane
implements ListSelectionListener {
    private JLabel sentenceDurationLabel;
    private JTextField sentenceDurationTF;
    private JLabel selectTokenizerLabel;
    private JList serviceList;
    private DefaultListModel model;
    private List<WLServiceDescriptor> wlDescList = null;
    private WebLichtHarvester harvester;

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("WebServicesDialog.WebLicht.StepTitle3a");
    }

    public WebLichtStep3(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.sentenceDurationLabel = new JLabel(ElanLocale.getString("WebServicesDialog.WebLicht.Duration"));
        this.sentenceDurationTF = new JTextField(12);
        this.sentenceDurationTF.setText("3000");
        this.selectTokenizerLabel = new JLabel(ElanLocale.getString("WebServicesDialog.WebLicht.Tokenizer"));
        this.model = new DefaultListModel();
        this.serviceList = new JList(this.model);
        this.serviceList.getSelectionModel().setSelectionMode(0);
        this.serviceList.setCellRenderer(new WLDescriptorListRenderer());
        JScrollPane scrollPane = new JScrollPane(this.serviceList);
        scrollPane.setPreferredSize(new Dimension(100, 80));
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(5, 10, 5, 10));
        Insets insets = new Insets(2, 0, 2, 0);
        Insets globalInsets = new Insets(5, 10, 5, 10);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        this.add((Component)this.selectTokenizerLabel, gbc);
        gbc.fill = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)scrollPane, gbc);
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(12, 0, 2, 0);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        this.add((Component)this.sentenceDurationLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(12, 4, 2, 0);
        this.add((Component)this.sentenceDurationTF, gbc);
        Integer val = Preferences.getInt("WebLicht.SentenceDuration", null);
        if (val != null) {
            this.sentenceDurationTF.setText(String.valueOf(val));
        }
    }

    @Override
    public void enterStepForward() {
        this.fillTokenizerList();
        if (this.serviceList.getSelectedIndex() > -1) {
            this.multiPane.setButtonEnabled(3, true);
        } else {
            this.multiPane.setButtonEnabled(3, false);
        }
        this.multiPane.setButtonEnabled(1, false);
    }

    @Override
    public boolean leaveStepForward() {
        Object selValue;
        int duration = 3000;
        String durInput = this.sentenceDurationTF.getText();
        if (durInput != null) {
            try {
                duration = Integer.parseInt(durInput);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.multiPane.putStepProperty("SentenceDuration", duration);
        if (duration != 3000 || Preferences.getInt("WebLicht.SentenceDuration", null) != null) {
            Preferences.set("WebLicht.SentenceDuration", duration, null);
        }
        if ((selValue = this.serviceList.getSelectedValue()) == null) {
            this.showWarning(ElanLocale.getString("WebServicesDialog.WebLicht.Warning3"));
            this.multiPane.setButtonEnabled(3, false);
            return false;
        }
        this.multiPane.putStepProperty("WLTokenizerDescriptor", selValue);
        Preferences.set("WebLicht.TokenizerDescriptor", ((WLServiceDescriptor)selValue).fullURL, null);
        return true;
    }

    @Override
    public boolean doFinish() {
        if (this.leaveStepForward()) {
            this.multiPane.nextStep();
            return false;
        }
        return false;
    }

    private void fillTokenizerList() {
        block12: {
            if (this.harvester == null) {
                this.harvester = new WebLichtHarvester();
            }
            if (this.wlDescList == null) {
                try {
                    String cachePath = Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + this.harvester.CACHE_FILENAME;
                    long lastCache = this.harvester.getLastCachingTime(cachePath);
                    if (lastCache == 0L || System.currentTimeMillis() - lastCache > this.harvester.cacheReloadInterval) {
                        String oaiResult = this.harvester.harvestServicesRemote();
                        if (oaiResult != null) {
                            this.wlDescList = this.harvester.parseRelevantServices(oaiResult);
                            this.harvester.storeCachedVersion(cachePath, oaiResult);
                        }
                    } else {
                        this.wlDescList = this.harvester.loadRelevantServicesFromCache(cachePath);
                    }
                    if (this.wlDescList != null) {
                        for (WLServiceDescriptor descriptor : this.wlDescList) {
                            if (!descriptor.tcfInput || !descriptor.sentenceOutput || !descriptor.tokensOutput) continue;
                            this.model.addElement(descriptor);
                        }
                    }
                    this.serviceList.addListSelectionListener(this);
                    String tokUrl = Preferences.getString("WebLicht.TokenizerDescriptor", null);
                    if (tokUrl == null) break block12;
                    for (int i = 0; i < this.model.getSize(); ++i) {
                        WLServiceDescriptor wlDesc = (WLServiceDescriptor)this.model.getElementAt(i);
                        if (!tokUrl.equals(wlDesc.fullURL)) continue;
                        this.serviceList.setSelectedIndex(i);
                        this.serviceList.scrollRectToVisible(this.serviceList.getCellBounds(i, i));
                        break;
                    }
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Unable to harvest and show relevant WebLicht services: " + ioe.getMessage());
                    this.showWarning(ElanLocale.getString("WebServicesDialog.WebLicht.Warning1") + ": \n" + ioe.getMessage());
                    return;
                }
                catch (Throwable th) {
                    ClientLogger.LOG.warning("Unable to harvest and show relevant WebLicht services: " + th.getMessage());
                    this.showWarning(ElanLocale.getString("WebServicesDialog.WebLicht.Warning1") + ": \n" + th.getMessage());
                    return;
                }
            }
        }
        if (this.wlDescList == null) {
            this.showWarning(ElanLocale.getString("WebServicesDialog.WebLicht.Warning1"));
            return;
        }
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.serviceList.getSelectedIndex() > -1) {
            this.multiPane.setButtonEnabled(3, true);
        }
    }
}

