/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.webserviceclient.weblicht;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.TierTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class WebLichtTierBasedStep2
extends StepPane
implements ItemListener,
ListSelectionListener {
    private TierTableModel ttm;
    private JTable tierTable;
    private ComboBoxModel typeModel;
    private JComboBox typeCB;
    private boolean tiersLoaded = false;

    public WebLichtTierBasedStep2(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        Insets insets;
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(5, 10, 5, 10));
        JLabel selectLabel = new JLabel(ElanLocale.getString("WebServicesDialog.WebLicht.SelectTier"));
        JLabel typeLabel = new JLabel(ElanLocale.getString("WebServicesDialog.WebLicht.SpecifyContentType"));
        this.ttm = new TierTableModel();
        this.tierTable = new JTable(this.ttm);
        JScrollPane tierScroll = new JScrollPane(this.tierTable);
        this.typeModel = new DefaultComboBoxModel();
        this.typeCB = new JComboBox(this.typeModel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets = new Insets(2, 0, 2, 0);
        gbc.anchor = 18;
        gbc.gridwidth = 2;
        this.add((Component)selectLabel, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)tierScroll, gbc);
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)typeLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(2, 4, 2, 0);
        this.add((Component)this.typeCB, gbc);
    }

    @Override
    public void enterStepForward() {
        if (!this.tiersLoaded) {
            TranscriptionImpl trans = (TranscriptionImpl)this.multiPane.getStepProperty("transcription");
            if (trans != null) {
                List<TierImpl> tiers = trans.getTiers();
                for (int i = 0; i < tiers.size(); ++i) {
                    this.ttm.addRow(tiers.get(i));
                }
            }
            this.tierTable.getSelectionModel().addListSelectionListener(this);
            this.tierTable.getSelectionModel().setSelectionMode(0);
            this.typeCB.addItem(ElanLocale.getString("WebServicesDialog.WebLicht.SentenceInput"));
            this.typeCB.addItem(ElanLocale.getString("WebServicesDialog.WebLicht.TokenInput"));
            this.typeCB.addItemListener(this);
            String stringPref = Preferences.getString("WebLicht.TierContentType", null);
            if (stringPref != null && "token".equals(stringPref)) {
                this.typeCB.setSelectedIndex(1);
            }
            if ((stringPref = Preferences.getString("WebLicht.SelectedTier", null)) != null) {
                String tierName = stringPref;
                int nameCol = this.ttm.findColumn("TierName");
                for (int i = 0; i < this.ttm.getRowCount(); ++i) {
                    if (!tierName.equals(this.ttm.getValueAt(i, nameCol))) continue;
                    this.tierTable.setRowSelectionInterval(i, i);
                    this.tierTable.scrollRectToVisible(this.tierTable.getCellRect(i, nameCol, true));
                }
            }
            this.tiersLoaded = true;
        }
        if (this.tierTable.getSelectedRow() > -1) {
            this.multiPane.setButtonEnabled(1, true);
        } else {
            this.multiPane.setButtonEnabled(1, false);
        }
        this.multiPane.setButtonEnabled(2, true);
    }

    @Override
    public void enterStepBackward() {
        super.enterStepBackward();
        this.multiPane.setButtonEnabled(1, true);
        this.multiPane.setButtonEnabled(3, false);
    }

    @Override
    public String getPreferredPreviousStep() {
        return "TextOrTierStep1";
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("WebServicesDialog.WebLicht.StepTitle2b");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (this.tierTable.getSelectedRow() < 0) {
                this.multiPane.setButtonEnabled(1, false);
            } else {
                this.multiPane.setButtonEnabled(1, true);
            }
        }
    }

    @Override
    public boolean leaveStepForward() {
        if (this.tierTable.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "WebServicesDialog.WebLicht.Warning.SelectTier", ElanLocale.getString("Message.Warning"), 2, null);
            this.multiPane.setButtonEnabled(1, false);
            return false;
        }
        int selTypeIndex = this.typeCB.getSelectedIndex();
        String cType = selTypeIndex == 0 ? "sentence" : "token";
        String tName = (String)this.tierTable.getValueAt(this.tierTable.getSelectedRow(), 0);
        this.multiPane.putStepProperty("Tier", tName);
        this.multiPane.putStepProperty("ContentType", cType);
        Preferences.set("WebLicht.SelectedTier", tName, null);
        Preferences.set("WebLicht.TierContentType", cType, null);
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this.tierTable.getSelectedRow();
        if (row < 0) {
            this.multiPane.setButtonEnabled(1, false);
        } else {
            this.multiPane.setButtonEnabled(1, true);
        }
    }
}

