/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.im.spi.lookup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodContext;
import java.util.Locale;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class LookupListPanel
extends JPanel {
    InputMethod inputMethod;
    InputMethodContext context;
    Window lookupWindow;
    String[] candidates;
    Locale[] locales;
    int candidateCount;
    int lookupCandidateIndex;
    final int FONT_SIZE = 20;
    final int INSIDE_INSET = 4;
    final int LINE_SPACING = 22;
    final int NUM_VISIBLE_ROWS = 10;
    int windowWidth = 80;
    private JList<String> luList;
    private DefaultListModel<String> luModel;

    public LookupListPanel(InputMethod inputMethod, InputMethodContext context, String[] candidates, Font editorFont) {
        if (context == null) {
            System.out.println("assertion failed! LookupList.java context is null!");
            return;
        }
        this.inputMethod = inputMethod;
        this.context = context;
        this.candidates = candidates;
        this.candidateCount = candidates.length;
        this.lookupCandidateIndex = 0;
        this.lookupWindow = context.createInputMethodJFrame("Lookup list", true);
        this.setLayout(new BorderLayout(2, 2));
        this.luModel = new DefaultListModel();
        for (int i = 0; i < candidates.length && i < 10; ++i) {
            this.luModel.add(i, candidates[i]);
        }
        this.luList = new JList<String>(this.luModel);
        this.luList.getSelectionModel().setSelectionMode(0);
        this.luList.setCellRenderer(new CandidateRenderer());
        this.add(this.luList);
        if (editorFont != null) {
            if (editorFont.getSize() != 20) {
                this.setFont(editorFont.deriveFont(20.0f));
            } else {
                this.setFont(editorFont);
            }
        } else {
            this.setFont(new Font("Arial Unicode MS", 0, 20));
        }
        this.luList.setFont(this.getFont());
        Dimension prefSize = new Dimension(this.windowWidth, 228);
        this.setPreferredSize(prefSize);
        this.luList.setPreferredSize(prefSize);
        this.enableEvents(8L);
        this.enableEvents(16L);
        ((JFrame)this.lookupWindow).getContentPane().add(this);
        this.lookupWindow.pack();
        if (this.lookupWindow.getWidth() > this.windowWidth) {
            this.lookupWindow.setSize(this.windowWidth, this.lookupWindow.getHeight());
        }
        this.updateWindowLocation();
        this.lookupWindow.setVisible(true);
        this.luList.setFixedCellHeight(this.luList.getHeight() / 10);
    }

    private void updateWindowLocation() {
        Point windowLocation = new Point();
        Rectangle caretRect = this.context.getTextLocation(TextHitInfo.leading(0));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = this.lookupWindow.getSize();
        int SPACING = 2;
        windowLocation.x = caretRect.x + windowSize.width > screenSize.width ? screenSize.width - windowSize.width : caretRect.x;
        windowLocation.y = caretRect.y + caretRect.height + 2 + windowSize.height > screenSize.height ? caretRect.y - 2 - windowSize.height : caretRect.y + caretRect.height + 2;
        this.lookupWindow.setLocation(windowLocation);
    }

    void selectCandidate(int candidate) {
        int targetRowIndex;
        if (candidate < 0) {
            candidate = 0;
        }
        if (candidate > this.candidateCount - 1) {
            candidate = this.candidateCount - 1;
        }
        if ((targetRowIndex = candidate - this.lookupCandidateIndex) < 0) {
            this.luModel.removeAllElements();
            int i = candidate;
            for (int j = 0; i < this.candidates.length && j < 10; ++i, ++j) {
                this.luModel.addElement(this.candidates[i]);
            }
            this.lookupCandidateIndex = candidate;
            this.luList.setSelectedIndex(0);
        } else if (targetRowIndex > 10) {
            int firstEl = candidate - 10;
            this.luModel.removeAllElements();
            int i = firstEl;
            for (int j = 0; i < this.candidateCount && j < 10; ++i, ++j) {
                this.luModel.addElement(this.candidates[i]);
            }
            this.lookupCandidateIndex = firstEl;
            this.luList.setSelectedIndex(this.luModel.getSize() - 1);
        } else {
            this.luList.setSelectedIndex(targetRowIndex);
        }
    }

    void selectNext() {
        int curSelRow = this.luList.getSelectedIndex();
        if (curSelRow + this.lookupCandidateIndex == this.candidateCount - 1) {
            return;
        }
        if (curSelRow == 9) {
            ++this.lookupCandidateIndex;
            this.luModel.remove(0);
            this.luModel.addElement(this.candidates[9 + this.lookupCandidateIndex]);
            this.luList.setSelectedIndex(curSelRow);
        } else {
            this.luList.setSelectedIndex(++curSelRow);
        }
    }

    void selectPrevious() {
        int curSelRow = this.luList.getSelectedIndex();
        if (curSelRow == 0 && this.lookupCandidateIndex == 0) {
            return;
        }
        if (curSelRow == 0) {
            this.luModel.remove(this.luModel.size() - 1);
            --this.lookupCandidateIndex;
            this.luModel.add(0, this.candidates[this.lookupCandidateIndex]);
            this.luList.setSelectedIndex(curSelRow);
        } else {
            this.luList.setSelectedIndex(--curSelRow);
        }
    }

    void selectPageUp() {
        if (this.luModel.getSize() < 10) {
            this.luList.setSelectedIndex(0);
            return;
        }
        int curSelRow = this.luList.getSelectedIndex();
        int targetBeginIndex = this.lookupCandidateIndex - 10;
        if (targetBeginIndex < 0) {
            targetBeginIndex = 0;
        }
        if (targetBeginIndex != this.lookupCandidateIndex) {
            this.lookupCandidateIndex = targetBeginIndex;
            this.luModel.clear();
            int i = this.lookupCandidateIndex;
            for (int j = 0; i < this.candidateCount && j < 10; ++i, ++j) {
                this.luModel.addElement(this.candidates[i]);
            }
            this.luList.setSelectedIndex(curSelRow);
        }
    }

    void selectPageDown() {
        if (this.luModel.getSize() < 10) {
            this.luList.setSelectedIndex(this.luModel.getSize() - 1);
            return;
        }
        int curSelRow = this.luList.getSelectedIndex();
        int targetBeginIndex = this.lookupCandidateIndex + 10;
        if (targetBeginIndex + 10 > this.candidateCount) {
            targetBeginIndex = this.candidateCount - 10;
        }
        if (targetBeginIndex != this.lookupCandidateIndex) {
            this.lookupCandidateIndex = targetBeginIndex;
            this.luModel.clear();
            int i = this.lookupCandidateIndex;
            for (int j = 0; i < this.candidateCount && j < 10; ++i, ++j) {
                this.luModel.addElement(this.candidates[i]);
            }
            if (curSelRow < this.luModel.getSize()) {
                this.luList.setSelectedIndex(curSelRow);
            } else {
                this.luList.setSelectedIndex(this.luModel.getSize() - 1);
            }
        }
    }

    void selectHome() {
        if (this.lookupCandidateIndex > 0) {
            this.luModel.removeAllElements();
            for (int i = 0; i < this.candidateCount && i < 10; ++i) {
                this.luModel.addElement(this.candidates[i]);
            }
            this.lookupCandidateIndex = 0;
        }
        this.luList.setSelectedIndex(0);
    }

    void selectEnd() {
        if (this.lookupCandidateIndex < this.candidateCount - this.luModel.getSize()) {
            this.luModel.removeAllElements();
            int firstEl = this.candidateCount - 10;
            if (firstEl < 0) {
                firstEl = 0;
            }
            int i = firstEl;
            for (int j = 0; i < this.candidateCount && j < 10; ++i, ++j) {
                this.luModel.addElement(this.candidates[i]);
            }
            this.lookupCandidateIndex = firstEl;
        }
        this.luList.setSelectedIndex(this.luModel.getSize() - 1);
    }

    int getSelectedCandidateIndex(int mouseLocation) {
        int curSelRow = mouseLocation / this.luList.getFixedCellHeight();
        if (curSelRow + this.lookupCandidateIndex >= this.candidateCount) {
            return -1;
        }
        return curSelRow + this.lookupCandidateIndex;
    }

    int getSelectedCandidateIndex() {
        int curSelRow = this.luList.getSelectedIndex();
        return curSelRow + this.lookupCandidateIndex;
    }

    int getCandidateIndexForNumberKeyShortcut(int numberKey) {
        if (numberKey < 0 || numberKey > 9 || numberKey > 10) {
            return -1;
        }
        int firstRowNumber = this.lookupCandidateIndex % 10 + 1;
        if (numberKey == firstRowNumber) {
            return this.lookupCandidateIndex;
        }
        if (numberKey < firstRowNumber) {
            int targetIndex;
            int targetRow = 10 - (firstRowNumber - numberKey);
            if (targetRow < this.luModel.getSize() && (targetIndex = this.lookupCandidateIndex + targetRow) < this.candidateCount) {
                return targetIndex;
            }
        } else {
            int distance = numberKey - firstRowNumber;
            int targetIndex = this.lookupCandidateIndex + distance;
            if (targetIndex < this.candidateCount) {
                return targetIndex;
            }
        }
        return -1;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.lookupWindow != null) {
            this.lookupWindow.setVisible(false);
            this.lookupWindow.dispose();
            this.lookupWindow = null;
        } else if (visible && this.lookupWindow != null) {
            this.lookupWindow.setVisible(true);
            this.lookupWindow.toFront();
        }
        super.setVisible(visible);
    }

    @Override
    protected void processKeyEvent(KeyEvent event) {
        this.inputMethod.dispatchEvent(event);
    }

    @Override
    protected void processMouseEvent(MouseEvent event) {
        if (event.getID() == 501) {
            this.inputMethod.dispatchEvent(event);
        }
    }

    class CandidateRenderer
    extends JPanel
    implements ListCellRenderer<String> {
        private JLabel candidateLabel;
        private JLabel numberLabel;

        public CandidateRenderer() {
            super(new GridBagLayout());
            this.setOpaque(true);
            this.candidateLabel = new JLabel();
            this.numberLabel = new JLabel();
            this.numberLabel.setHorizontalAlignment(11);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 4, 0, 0);
            this.add((Component)this.candidateLabel, gbc);
            gbc.gridx = 1;
            gbc.anchor = 13;
            gbc.insets = new Insets(0, 0, 0, 4);
            this.add((Component)this.numberLabel, gbc);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            this.candidateLabel.setText(value);
            this.numberLabel.setText(String.valueOf((index + LookupListPanel.this.lookupCandidateIndex + 1) % 10));
            this.candidateLabel.setFont(list.getFont());
            this.numberLabel.setFont(list.getFont());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                this.candidateLabel.setBackground(list.getSelectionBackground());
                this.candidateLabel.setForeground(list.getSelectionForeground());
                this.numberLabel.setBackground(list.getSelectionBackground());
                this.numberLabel.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                this.candidateLabel.setBackground(list.getBackground());
                this.candidateLabel.setForeground(list.getForeground());
                this.numberLabel.setBackground(list.getBackground());
                this.numberLabel.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

