/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.mediacontrol;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.mediacontrol.Controller;
import mpi.eudico.client.mediacontrol.EventPostingBase;

public class ControllerManager
extends EventPostingBase {
    private List<Controller> controllers = new ArrayList<Controller>();
    private boolean controllersAreStarted = false;

    public synchronized void addController(Controller controller) {
        if (!this.controllers.contains(controller)) {
            this.controllers.add(controller);
        }
    }

    public synchronized void removeController(Controller controller) {
        this.controllers.remove(controller);
    }

    public void startControllers() {
        if (!this.controllersAreStarted) {
            int size = this.controllers.size();
            for (int i = 0; i < size; ++i) {
                this.controllers.get(i).start();
            }
            this.controllersAreStarted = true;
        }
    }

    public void stopControllers() {
        if (this.controllersAreStarted) {
            int size = this.controllers.size();
            for (int i = 0; i < size; ++i) {
                this.controllers.get(i).stop();
            }
            this.controllersAreStarted = false;
        }
    }

    public void setControllersStopTime(long time) {
        int size = this.controllers.size();
        for (int i = 0; i < size; ++i) {
            this.controllers.get(i).setStopTime(time);
        }
    }

    public void setControllersMediaTime(long time) {
        int size = this.controllers.size();
        for (int i = 0; i < size; ++i) {
            this.controllers.get(i).setMediaTime(time);
        }
    }

    public void setControllersRate(float rate) {
        int size = this.controllers.size();
        for (int i = 0; i < size; ++i) {
            this.controllers.get(i).setRate(rate);
        }
    }
}

