/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.mediacontrol;

import mpi.eudico.client.mediacontrol.Controller;
import mpi.eudico.client.mediacontrol.EventPostingBase;
import mpi.eudico.client.mediacontrol.StartEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;

public class PeriodicUpdateController
extends EventPostingBase
implements Controller,
Runnable {
    private final int STARTED = 0;
    private final int STOPPED = 1;
    private long period;
    private float rate;
    private Thread thread;
    private volatile int state;
    private TimeEvent timeEvent;
    private StartEvent startEvent;
    private StopEvent stopEvent;

    public PeriodicUpdateController(long period) {
        this.period = period;
        this.state = 1;
        this.timeEvent = new TimeEvent(this);
        this.startEvent = new StartEvent(this);
        this.stopEvent = new StopEvent(this);
    }

    @Override
    public void run() {
        long n = 0L;
        this.state = 0;
        while (this.state == 0) {
            this.postEvent(this.timeEvent);
            if (Thread.currentThread().isInterrupted()) continue;
            try {
                Thread.sleep(this.period);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void setStopTime(long time) {
    }

    @Override
    public void setMediaTime(long time) {
        this.postEvent(this.timeEvent);
    }

    @Override
    public void setRate(float rate) {
        this.rate = rate;
    }

    @Override
    public void stop() {
        if (this.state == 1) {
            return;
        }
        this.state = 1;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.postEvent(this.stopEvent);
    }

    @Override
    public void start() {
        if (this.state == 0) {
            return;
        }
        this.postEvent(this.startEvent);
        this.thread = new Thread((Runnable)this, "PeriodicUpdateController");
        this.thread.start();
    }
}

