/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class TierTree {
    private DefaultMutableTreeNode[] nodes;
    List<TierImpl> tierVector;

    public TierTree(TranscriptionImpl transcription) {
        TierImpl tier;
        int i;
        HashMap<TierImpl, DefaultMutableTreeNode> tierNodes = new HashMap<TierImpl, DefaultMutableTreeNode>();
        this.tierVector = new ArrayList<TierImpl>(transcription.getTiers());
        this.nodes = new DefaultMutableTreeNode[this.tierVector.size() + 1];
        this.nodes[0] = new DefaultMutableTreeNode();
        for (i = 0; i < this.tierVector.size(); ++i) {
            tier = this.tierVector.get(i);
            this.nodes[i + 1] = new DefaultMutableTreeNode(tier.getName());
            tierNodes.put(tier, this.nodes[i + 1]);
        }
        for (i = 0; i < this.tierVector.size(); ++i) {
            tier = this.tierVector.get(i);
            if (tier.hasParentTier()) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tierNodes.get(tier.getParentTier());
                if (parent == null) continue;
                parent.add(this.nodes[i + 1]);
                continue;
            }
            this.nodes[0].add(this.nodes[i + 1]);
        }
    }

    public DefaultMutableTreeNode getTree() {
        return this.nodes[0];
    }

    public int getNumberOfNodes() {
        return this.tierVector.size();
    }

    public DefaultMutableTreeNode sortAlphabetically() {
        return this.performSorting(false);
    }

    public DefaultMutableTreeNode sortReverseAlphabetically() {
        return this.performSorting(true);
    }

    private DefaultMutableTreeNode performSorting(Boolean reverse) {
        int i;
        if (this.tierVector.size() < 2) {
            return this.nodes[0];
        }
        Boolean stillSorting = true;
        HashMap<TierImpl, DefaultMutableTreeNode> tierNodes = new HashMap<TierImpl, DefaultMutableTreeNode>();
        block0: while (stillSorting.booleanValue()) {
            for (i = 0; i < this.tierVector.size() - 1; ++i) {
                String tierName2;
                String tierName1 = this.tierVector.get(i).getName();
                if (this.doSwap(tierName1, tierName2 = this.tierVector.get(i + 1).getName(), reverse).booleanValue()) {
                    TierImpl tempTier = this.tierVector.get(i);
                    DefaultMutableTreeNode tempTreeNode = this.nodes[i + 1];
                    this.tierVector.set(i, this.tierVector.get(i + 1));
                    this.tierVector.set(i + 1, tempTier);
                    this.nodes[i + 1] = this.nodes[i + 2];
                    this.nodes[i + 2] = tempTreeNode;
                    stillSorting = true;
                    continue block0;
                }
                stillSorting = false;
            }
        }
        for (i = 0; i < this.tierVector.size() - 1; ++i) {
            tierNodes.put(this.tierVector.get(i), this.nodes[i + 1]);
        }
        this.nodes[0].removeAllChildren();
        for (i = 0; i < this.tierVector.size(); ++i) {
            TierImpl tier = this.tierVector.get(i);
            if (tier.hasParentTier()) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tierNodes.get(tier.getParentTier());
                if (parent == null) continue;
                parent.add(this.nodes[i + 1]);
                continue;
            }
            this.nodes[0].add(this.nodes[i + 1]);
        }
        return this.nodes[0];
    }

    private Boolean doSwap(String first, String second, Boolean reverse) {
        if (reverse != false ? first.compareTo(second) < 0 : first.compareTo(second) > 0) {
            return true;
        }
        return false;
    }
}

