/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.export.TabExportTableModel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextEncoderInfoFiles;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextEncoderInfoTrans;
import mpi.eudico.server.corpora.util.AnnotationCoreComparator;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.TimeFormatter;
import mpi.eudico.util.TimeRelation;

public class Transcription2TabDelimitedText {
    public String TAB = "\t";
    private String COMMA = ",";
    private final String NEWLINE = "\n";
    private final String SQ = "\"";
    private final String DQ = "\"\"";
    private boolean csvEncodeText = false;

    public void setDelimiter(String delimiter) {
        if (delimiter != null) {
            this.TAB = delimiter;
        }
    }

    public String getDelimiter() {
        return this.TAB;
    }

    public void exportTiers(DelimitedTextEncoderInfoTrans encoderInfo) throws IOException {
        if (encoderInfo.getExportFile() == null) {
            throw new IOException("Encoder: no destination file specified for export");
        }
        if (encoderInfo.isExportCSVFormat()) {
            this.TAB = this.COMMA;
            this.csvEncodeText = true;
        }
        FileOutputStream out = new FileOutputStream(encoderInfo.getExportFile());
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, encoderInfo.getCharEncoding());
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        if (encoderInfo.getMediaHeaderLines() != null) {
            for (String line : encoderInfo.getMediaHeaderLines()) {
                writer.write(line + "\n");
            }
            writer.write("\n");
        }
        long mediaOffset = 0L;
        if (encoderInfo.isAddMasterMediaOffset() && encoderInfo.getTranscription().getMediaDescriptors() != null && !encoderInfo.getTranscription().getMediaDescriptors().isEmpty()) {
            mediaOffset = encoderInfo.getTranscription().getMediaDescriptors().get((int)0).timeOrigin;
        }
        String smpteType = null;
        if (encoderInfo.isIncludeSMPTE()) {
            smpteType = encoderInfo.isPalFormat() ? "PAL" : (encoderInfo.isPal50Format() ? "PAL-50fps" : "NTSC");
        }
        if (encoderInfo.getTierNames() != null) {
            for (String tierName : encoderInfo.getTierNames()) {
                HashMap<String, String> cvEntryMap = null;
                String cvName = null;
                TierImpl tier = encoderInfo.getTranscription().getTierWithId(tierName);
                String participant = tier.getParticipant();
                if (encoderInfo.isIncludeCVDescription()) {
                    cvEntryMap = new HashMap<String, String>();
                    cvName = tier.getLinguisticType().getControlledVocabularyName();
                    if (cvName != null) {
                        ControlledVocabulary cv = encoderInfo.getTranscription().getControlledVocabulary(cvName);
                        int n = cv.getDefaultLanguageIndex();
                        for (CVEntry cve : cv) {
                            cvEntryMap.put(cve.getValue(n), cve.getDescription(n));
                        }
                    }
                }
                if (participant == null) {
                    participant = "";
                }
                for (Annotation annotation : tier.getAnnotations()) {
                    String description;
                    if (annotation == null || !TimeRelation.overlaps(annotation, encoderInfo.getBeginTime(), encoderInfo.getEndTime())) continue;
                    if (encoderInfo.isIncludeNames()) {
                        writer.write(this.csvEncodeCond1(tierName));
                        if (encoderInfo.isIncludeParticipants()) {
                            writer.write(this.TAB + this.csvEncodeCond1(participant));
                        }
                    } else if (encoderInfo.isIncludeParticipants()) {
                        writer.write(this.csvEncodeCond1(participant));
                    }
                    String ts = this.getTabString(annotation, encoderInfo.isIncludeBeginTime(), encoderInfo.isIncludeEndTime(), encoderInfo.isIncludeDuration(), encoderInfo.isIncludeHHMM(), encoderInfo.isIncludeSSMS(), encoderInfo.isIncludeMS(), encoderInfo.isIncludeSMPTE(), smpteType, mediaOffset);
                    if (encoderInfo.isIncludeCVDescription() && (description = (String)cvEntryMap.get(annotation.getValue())) != null) {
                        StringBuilder tsBuffer = new StringBuilder(ts.replace("\n", this.TAB));
                        tsBuffer.append(this.csvEncodeCond2(description) + "\n");
                        ts = tsBuffer.toString();
                    }
                    if (encoderInfo.isIncludeNames() || encoderInfo.isIncludeParticipants()) {
                        writer.write(ts);
                        continue;
                    }
                    writer.write(ts, 1, ts.length() - 1);
                }
            }
        } else {
            ClientLogger.LOG.warning("There are no tiers selected for export.");
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    public void exportTiersColumnPerTier(DelimitedTextEncoderInfoTrans encoderInfo) throws IOException {
        void var10_14;
        if (encoderInfo.getExportFile() == null) {
            throw new IOException("Encoder: no destination file specified for export");
        }
        if (encoderInfo.getTierNames() == null || encoderInfo.getTierNames().isEmpty()) {
            throw new IOException("Encoder: no tiers selected for export");
        }
        if (encoderInfo.isExportCSVFormat()) {
            this.TAB = this.COMMA;
            this.csvEncodeText = true;
        }
        FileOutputStream out = new FileOutputStream(encoderInfo.getExportFile());
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, encoderInfo.getCharEncoding());
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(100);
        ArrayList<Object> allCVs = new ArrayList<Object>();
        long mediaOffset = 0L;
        if (encoderInfo.isAddMasterMediaOffset() && encoderInfo.getTranscription().getMediaDescriptors() != null && !encoderInfo.getTranscription().getMediaDescriptors().isEmpty()) {
            mediaOffset = encoderInfo.getTranscription().getMediaDescriptors().get((int)0).timeOrigin;
        }
        if (encoderInfo.getMediaHeaderLines() != null) {
            for (String string : encoderInfo.getMediaHeaderLines()) {
                writer.write(string + "\n");
            }
        }
        String smpteType = null;
        if (encoderInfo.isIncludeSMPTE()) {
            smpteType = encoderInfo.isPalFormat() ? "PAL" : (encoderInfo.isPal50Format() ? "PAL-50fps" : "NTSC");
        }
        block5: for (String string : encoderInfo.getTierNames()) {
            Object cvName;
            TierImpl tierImpl = encoderInfo.getTranscription().getTierWithId(string);
            if (tierImpl == null) continue;
            if (encoderInfo.isIncludeCVDescription() && (cvName = tierImpl.getLinguisticType().getControlledVocabularyName()) != null) {
                allCVs.add(cvName);
            }
            cvName = tierImpl.getAnnotations().iterator();
            while (cvName.hasNext()) {
                Annotation annotation = (Annotation)cvName.next();
                if (annotation == null) continue;
                if (TimeRelation.overlaps(annotation, encoderInfo.getBeginTime(), encoderInfo.getEndTime())) {
                    allAnnotations.add(annotation);
                }
                if (annotation.getBeginTimeBoundary() <= encoderInfo.getEndTime()) continue;
                continue block5;
            }
        }
        Collections.sort(allAnnotations, new AnnotationCoreComparator());
        Object var10_12 = null;
        if (encoderInfo.isIncludeCVDescription()) {
            HashMap hashMap = new HashMap();
            for (String string : allCVs) {
                HashMap<String, String> map = new HashMap<String, String>();
                ControlledVocabulary cv = encoderInfo.getTranscription().getControlledVocabulary(string);
                if (cv.isEmpty()) continue;
                hashMap.put(string, map);
                int defLang = cv.getDefaultLanguageIndex();
                for (CVEntry entry : cv) {
                    map.put(entry.getValue(defLang), entry.getDescription(defLang));
                }
            }
        }
        TabExportTableModel tabExportTableModel = new TabExportTableModel(allAnnotations, (Map<String, Map<String, String>>)var10_14, encoderInfo.getTierNames());
        writer.write(this.getHeaders(tabExportTableModel, encoderInfo.isIncludeBeginTime(), encoderInfo.isIncludeEndTime(), encoderInfo.isIncludeDuration(), encoderInfo.isIncludeHHMM(), encoderInfo.isIncludeSSMS(), encoderInfo.isIncludeMS(), encoderInfo.isIncludeSMPTE(), smpteType));
        this.writeRows(writer, tabExportTableModel, encoderInfo.isIncludeBeginTime(), encoderInfo.isIncludeEndTime(), encoderInfo.isIncludeDuration(), encoderInfo.isIncludeHHMM(), encoderInfo.isIncludeSSMS(), encoderInfo.isIncludeMS(), encoderInfo.isIncludeSMPTE(), smpteType, mediaOffset, false, false);
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void exportTiersColumnPerTierFromFiles(DelimitedTextEncoderInfoFiles encoderInfo) throws IOException {
        if (encoderInfo.getExportFile() == null) {
            throw new IOException("Encoder: no destination file specified for export");
        }
        if (encoderInfo.getTierNames() == null || encoderInfo.getTierNames().isEmpty()) {
            throw new IOException("Encoder: no tiers specified for export");
        }
        if (encoderInfo.getFiles() == null || encoderInfo.getFiles().isEmpty()) {
            throw new IOException("Encoder: no files specified for export");
        }
        if (encoderInfo.isExportCSVFormat()) {
            this.TAB = this.COMMA;
            this.csvEncodeText = true;
        }
        FileOutputStream out = new FileOutputStream(encoderInfo.getExportFile());
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, encoderInfo.getCharEncoding());
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(100);
        AnnotationCoreComparator comparator = new AnnotationCoreComparator();
        String smpteType = null;
        if (encoderInfo.isIncludeSMPTE()) {
            smpteType = encoderInfo.isPalFormat() ? "PAL" : (encoderInfo.isPal50Format() ? "PAL-50fps" : "NTSC");
        }
        ArrayList<Object> allCVs = new ArrayList<Object>();
        for (int i = 0; i < encoderInfo.getFiles().size(); ++i) {
            File file = encoderInfo.getFiles().get(i);
            allAnnotations.clear();
            if (file == null) continue;
            try {
                List<String> medHeaders;
                TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                long mediaOffset = 0L;
                if (encoderInfo.isAddMasterMediaOffset() && trans.getMediaDescriptors() != null && !trans.getMediaDescriptors().isEmpty()) {
                    mediaOffset = trans.getMediaDescriptors().get((int)0).timeOrigin;
                }
                for (String string : encoderInfo.getTierNames()) {
                    Object cvName;
                    TierImpl tier = trans.getTierWithId(string);
                    if (tier == null) continue;
                    if (encoderInfo.isIncludeCVDescription() && (cvName = tier.getLinguisticType().getControlledVocabularyName()) != null) {
                        allCVs.add(cvName);
                    }
                    cvName = tier.getAnnotations().iterator();
                    while (cvName.hasNext()) {
                        Annotation annotation = (Annotation)cvName.next();
                        if (annotation == null) continue;
                        allAnnotations.add(annotation);
                    }
                }
                Collections.sort(allAnnotations, comparator);
                HashMap<String, Map<String, String>> cvMap = null;
                if (encoderInfo.isIncludeCVDescription()) {
                    cvMap = new HashMap<String, Map<String, String>>();
                    for (String cvName : allCVs) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        ControlledVocabulary cv = trans.getControlledVocabulary(cvName);
                        if (cv.isEmpty()) continue;
                        cvMap.put(cvName, map);
                        int defLang = cv.getDefaultLanguageIndex();
                        for (CVEntry entry : cv) {
                            map.put(entry.getValue(defLang), entry.getDescription(defLang));
                        }
                    }
                }
                TabExportTableModel tabExportTableModel = new TabExportTableModel(allAnnotations, cvMap, encoderInfo.getTierNames());
                tabExportTableModel.setFileName(file.getName());
                tabExportTableModel.setAbsoluteFilePath(file.getAbsolutePath());
                if (i == 0) {
                    String header = this.getHeaders(tabExportTableModel, encoderInfo.isIncludeBeginTime(), encoderInfo.isIncludeEndTime(), encoderInfo.isIncludeDuration(), encoderInfo.isIncludeHHMM(), encoderInfo.isIncludeSSMS(), encoderInfo.isIncludeMS(), encoderInfo.isIncludeSMPTE(), smpteType);
                    writer.write(header, 0, header.length() - 1);
                    writer.write(this.TAB + this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnFileName")) + this.TAB + this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnFilePath")) + "\n");
                }
                if (encoderInfo.isFileNameInRow()) {
                    writer.write("\n");
                    if (encoderInfo.isIncludeFileName()) {
                        writer.write(this.csvEncodeCond1(file.getName()) + "\n");
                    }
                    if (encoderInfo.isIncludeFilePath() || !encoderInfo.isIncludeFileName() && !encoderInfo.isIncludeFilePath()) {
                        writer.write(this.csvEncodeCond1(file.getAbsolutePath()) + "\n");
                    }
                }
                if (encoderInfo.isIncludeMediaHeaders() && (medHeaders = this.getMediaHeaders(trans)) != null) {
                    if (!encoderInfo.isFileNameInRow()) {
                        writer.write("\n");
                    }
                    for (String s : medHeaders) {
                        writer.write(s);
                        writer.write("\n");
                    }
                }
                this.writeRows(writer, tabExportTableModel, encoderInfo.isIncludeBeginTime(), encoderInfo.isIncludeEndTime(), encoderInfo.isIncludeDuration(), encoderInfo.isIncludeHHMM(), encoderInfo.isIncludeSSMS(), encoderInfo.isIncludeMS(), encoderInfo.isIncludeSMPTE(), smpteType, mediaOffset, encoderInfo.isIncludeFileName() && !encoderInfo.isFileNameInRow(), encoderInfo.isIncludeFilePath() && !encoderInfo.isFileNameInRow());
                continue;
            }
            catch (Exception ex) {
                ClientLogger.LOG.warning("Could not handle file: " + file.getAbsolutePath());
            }
        }
        writer.close();
    }

    public void exportTiersFromFiles(DelimitedTextEncoderInfoFiles encoderInfo) throws IOException {
        if (encoderInfo.getExportFile() == null) {
            throw new IOException("Encoder: no destination file specified for export");
        }
        if (encoderInfo.getTierNames() == null || encoderInfo.getTierNames().isEmpty()) {
            throw new IOException("Encoder: no tiers specified for export");
        }
        if (encoderInfo.getFiles() == null || encoderInfo.getFiles().isEmpty()) {
            throw new IOException("Encoder: no files specified for export");
        }
        if (encoderInfo.isExportCSVFormat()) {
            this.TAB = this.COMMA;
            this.csvEncodeText = true;
        }
        FileOutputStream out = new FileOutputStream(encoderInfo.getExportFile());
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, encoderInfo.getCharEncoding());
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        String EMPTY = "";
        for (File file : encoderInfo.getFiles()) {
            if (file == null) continue;
            try {
                List<String> medHeaders;
                TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                long mediaOffset = 0L;
                if (encoderInfo.isAddMasterMediaOffset() && trans.getMediaDescriptors() != null && !trans.getMediaDescriptors().isEmpty()) {
                    mediaOffset = trans.getMediaDescriptors().get((int)0).timeOrigin;
                }
                if (encoderInfo.isFileNameInRow()) {
                    if (encoderInfo.isIncludeFileName()) {
                        writer.write("\"#" + file.getName() + "\"\n");
                    }
                    if (encoderInfo.isIncludeFilePath() || !encoderInfo.isIncludeFileName() && !encoderInfo.isIncludeFilePath()) {
                        writer.write("\"#" + file.getAbsolutePath() + "\"\n");
                    }
                }
                if (encoderInfo.isIncludeMediaHeaders() && (medHeaders = this.getMediaHeaders(trans)) != null) {
                    for (String s : medHeaders) {
                        writer.write(s);
                        writer.write("\n");
                    }
                }
                String smpteType = null;
                if (encoderInfo.isIncludeSMPTE()) {
                    smpteType = encoderInfo.isPalFormat() ? "PAL" : (encoderInfo.isPal50Format() ? "PAL-50fps" : "NTSC");
                }
                List<TierImpl> tiers = trans.getTiersWithIds(encoderInfo.getTierNames());
                for (TierImpl tier : tiers) {
                    String participant;
                    HashMap<String, String> cvEntryMap = null;
                    String cvName = null;
                    if (encoderInfo.isIncludeCVDescription()) {
                        cvEntryMap = new HashMap<String, String>();
                        cvName = tier.getLinguisticType().getControlledVocabularyName();
                        if (cvName != null) {
                            ControlledVocabulary cv = trans.getControlledVocabulary(cvName);
                            int defLang = cv.getDefaultLanguageIndex();
                            for (CVEntry cve : cv) {
                                cvEntryMap.put(cve.getValue(defLang), cve.getDescription(defLang));
                            }
                        }
                    }
                    if ((participant = tier.getParticipant()) == null) {
                        participant = "";
                    }
                    for (AnnotationCore annotationCore : tier.getAnnotations()) {
                        String description;
                        if (annotationCore == null) continue;
                        if (encoderInfo.isIncludeNames()) {
                            writer.write(this.csvEncodeCond1(tier.getName()));
                            if (encoderInfo.isIncludeParticipants()) {
                                writer.write(this.TAB + this.csvEncodeCond1(participant));
                            }
                        } else if (encoderInfo.isIncludeParticipants()) {
                            writer.write(this.csvEncodeCond1(participant));
                        }
                        String tabString = this.getTabString(annotationCore, encoderInfo.isIncludeBeginTime(), encoderInfo.isIncludeEndTime(), encoderInfo.isIncludeDuration(), encoderInfo.isIncludeHHMM(), encoderInfo.isIncludeSSMS(), encoderInfo.isIncludeMS(), encoderInfo.isIncludeSMPTE(), smpteType, mediaOffset);
                        if (encoderInfo.isIncludeCVDescription() && (description = (String)cvEntryMap.get(annotationCore.getValue())) != null) {
                            StringBuilder tsBuffer = new StringBuilder(tabString.replace("\n", this.TAB));
                            tsBuffer.append(this.csvEncodeCond2(description) + "\n");
                            tabString = tsBuffer.toString();
                        }
                        if (encoderInfo.isIncludeNames() || encoderInfo.isIncludeParticipants()) {
                            writer.write(tabString, 0, tabString.length() - 1);
                        } else {
                            writer.write(tabString, 1, tabString.length() - 2);
                        }
                        if (!encoderInfo.isFileNameInRow()) {
                            if (encoderInfo.isIncludeFileName()) {
                                writer.write(this.TAB + this.csvEncodeCond1(file.getName()));
                            }
                            if (encoderInfo.isIncludeFilePath()) {
                                writer.write(this.TAB + this.csvEncodeCond1(file.getAbsolutePath()));
                            }
                        }
                        writer.write("\n");
                    }
                }
                if (!encoderInfo.isFileNameInRow() && !encoderInfo.isIncludeMediaHeaders()) continue;
                writer.write("\n");
            }
            catch (Exception ex) {
                ClientLogger.LOG.warning("Could not handle file: " + file.getAbsolutePath());
            }
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getHeaders(TabExportTableModel model, boolean includeBeginTime, boolean includeEndTime, boolean includeDuration, boolean includeHHMM, boolean includeSSMS, boolean includeMS, boolean includeSMPTE, String actualSMPTEType) {
        StringBuilder buf = new StringBuilder();
        if (includeBeginTime) {
            if (includeHHMM) {
                buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode")) + this.TAB);
            }
            if (includeSSMS) {
                buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.Seconds")) + this.TAB);
            }
            if (includeMS) {
                buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.MilliSec")) + this.TAB);
            }
            if (includeSMPTE) {
                if (actualSMPTEType == null || actualSMPTEType == "PAL") {
                    buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL")) + this.TAB);
                } else if (actualSMPTEType == "PAL-50fps") {
                    buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL50")) + this.TAB);
                } else {
                    buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC")) + this.TAB);
                }
            }
        }
        if (includeEndTime) {
            if (includeHHMM) {
                buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode")) + this.TAB);
            }
            if (includeSSMS) {
                buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.Seconds")) + this.TAB);
            }
            if (includeMS) {
                buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.MilliSec")) + this.TAB);
            }
            if (includeSMPTE) {
                if (actualSMPTEType == null || actualSMPTEType == "PAL") {
                    buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL")) + this.TAB);
                } else if (actualSMPTEType == "PAL-50fps") {
                    buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL50")) + this.TAB);
                } else {
                    buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC")) + this.TAB);
                }
            }
        }
        if (includeDuration) {
            if (includeHHMM) {
                buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode")) + this.TAB);
            }
            if (includeSSMS) {
                buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.Seconds")) + this.TAB);
            }
            if (includeMS) {
                buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.MilliSec")) + this.TAB);
            }
            if (includeSMPTE) {
                if (actualSMPTEType == null || actualSMPTEType == "PAL") {
                    buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL")) + this.TAB);
                } else if (actualSMPTEType == "PAL-50fps") {
                    buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL50")) + this.TAB);
                } else {
                    buf.append(this.csvEncodeCond1(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC")) + this.TAB);
                }
            }
        }
        for (int i = 2; i < model.getColumnCount(); ++i) {
            buf.append(this.csvEncodeCond1(model.getColumnName(i)));
            if (i == model.getColumnCount() - 1) continue;
            buf.append(this.TAB);
        }
        buf.append("\n");
        return buf.toString();
    }

    private void writeRows(BufferedWriter writer, TabExportTableModel model, boolean includeBeginTime, boolean includeEndTime, boolean includeDuration, boolean includeHHMM, boolean includeSSMS, boolean includeMS, boolean includeSMPTE, String smpteType, long mediaOffset, boolean includeFileName, boolean includeFilePath) throws IOException {
        for (int i = 0; i < model.getRowCount(); ++i) {
            long bt = (Long)model.getValueAt(i, 0) + mediaOffset;
            long et = (Long)model.getValueAt(i, 1) + mediaOffset;
            if (includeBeginTime) {
                if (includeHHMM) {
                    writer.write(TimeFormatter.toString(bt) + this.TAB);
                }
                if (includeSSMS) {
                    writer.write(Double.toString((double)bt / 1000.0) + this.TAB);
                }
                if (includeMS) {
                    writer.write(bt + this.TAB);
                }
                if (includeSMPTE) {
                    if (smpteType == null || smpteType == "PAL") {
                        writer.write(TimeFormatter.toTimecodePAL(bt) + this.TAB);
                    } else if (smpteType == "PAL-50fps") {
                        writer.write(TimeFormatter.toTimecodePAL50(bt) + this.TAB);
                    } else {
                        writer.write(TimeFormatter.toTimecodeNTSC(bt) + this.TAB);
                    }
                }
            }
            if (includeEndTime) {
                if (includeHHMM) {
                    writer.write(TimeFormatter.toString(et) + this.TAB);
                }
                if (includeSSMS) {
                    writer.write(Double.toString((double)et / 1000.0) + this.TAB);
                }
                if (includeMS) {
                    writer.write(et + this.TAB);
                }
                if (includeSMPTE) {
                    if (smpteType == null || smpteType == "PAL") {
                        writer.write(TimeFormatter.toTimecodePAL(et) + this.TAB);
                    } else if (smpteType == "PAL-50fps") {
                        writer.write(TimeFormatter.toTimecodePAL50(et) + this.TAB);
                    } else {
                        writer.write(TimeFormatter.toTimecodeNTSC(et) + this.TAB);
                    }
                }
            }
            if (includeDuration) {
                long d = et - bt;
                if (includeHHMM) {
                    writer.write(TimeFormatter.toString(d) + this.TAB);
                }
                if (includeSSMS) {
                    writer.write(Double.toString((double)d / 1000.0) + this.TAB);
                }
                if (includeMS) {
                    writer.write(d + this.TAB);
                }
                if (includeSMPTE) {
                    if (smpteType == null || smpteType == "PAL") {
                        writer.write(TimeFormatter.toTimecodePAL(d) + this.TAB);
                    } else if (smpteType == "PAL-50fps") {
                        writer.write(TimeFormatter.toTimecodePAL50(d) + this.TAB);
                    } else {
                        writer.write(TimeFormatter.toTimecodeNTSC(d) + this.TAB);
                    }
                }
            }
            for (int j = 2; j < model.getColumnCount(); ++j) {
                Object value = model.getValueAt(i, j);
                if (value instanceof String) {
                    writer.write(this.csvEncodeCond2((String)value));
                }
                if (j == model.getColumnCount() - 1) continue;
                writer.write(this.TAB);
            }
            if (model.getFileName() != null) {
                if (includeFileName) {
                    writer.write(this.TAB + this.csvEncodeCond1(model.getFileName()));
                }
                if (includeFilePath) {
                    writer.write(this.TAB + this.csvEncodeCond1(model.getAbsoluteFilePath()));
                }
            }
            writer.write("\n");
        }
        writer.write("\n");
    }

    public void exportAnnotations(String tierName, List<AnnotationCore> annotations, File exportFile) throws IOException {
        if (exportFile == null) {
            return;
        }
        FileOutputStream out = new FileOutputStream(exportFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        for (int i = 0; i < annotations.size(); ++i) {
            if (!(annotations.get(i) instanceof AnnotationCore)) continue;
            writer.write(this.csvEncodeCond1(tierName) + this.getTabString(annotations.get(i)));
        }
        writer.close();
    }

    private List<String> getMediaHeaders(Transcription transcription) {
        if (transcription != null && transcription.getMediaDescriptors() != null && !transcription.getMediaDescriptors().isEmpty()) {
            ArrayList<String> lines = new ArrayList<String>(transcription.getMediaDescriptors().size());
            for (MediaDescriptor md : transcription.getMediaDescriptors()) {
                lines.add("\"#" + md.mediaURL + " -- offset: " + md.timeOrigin + "\"");
            }
            return lines;
        }
        return null;
    }

    public String getTabString(AnnotationCore annotationCore) {
        return this.getTabString(annotationCore, true, true);
    }

    public String getTabString(AnnotationCore annotationCore, boolean HHMMformat, boolean SSMSFormat) {
        return this.getTabString(annotationCore, true, true, true, HHMMformat, SSMSFormat, false);
    }

    public String getTabString(AnnotationCore annotationCore, boolean beginTime, boolean endTime, boolean duration, boolean HHMMformat, boolean SSMSFormat, boolean MSFormat) {
        return this.getTabString(annotationCore, beginTime, endTime, duration, HHMMformat, SSMSFormat, MSFormat, false, null, 0L);
    }

    public String getTabString(AnnotationCore annotationCore, boolean beginTime, boolean endTime, boolean duration, boolean HHMMformat, boolean SSMSFormat, boolean MSFormat, boolean SMPTEFormat, String actualSMPTEType, long mediaOffset) {
        StringBuilder sb = new StringBuilder(this.TAB);
        long bt = annotationCore.getBeginTimeBoundary() + mediaOffset;
        long et = annotationCore.getEndTimeBoundary() + mediaOffset;
        if (beginTime) {
            if (HHMMformat) {
                sb.append(TimeFormatter.toString(bt) + this.TAB);
            }
            if (SSMSFormat) {
                sb.append(Double.toString((double)bt / 1000.0) + this.TAB);
            }
            if (MSFormat) {
                sb.append(bt + this.TAB);
            }
            if (SMPTEFormat) {
                if (actualSMPTEType == null || actualSMPTEType == "PAL") {
                    sb.append(TimeFormatter.toTimecodePAL(bt) + this.TAB);
                } else if (actualSMPTEType == "PAL-50fps") {
                    sb.append(TimeFormatter.toTimecodePAL50(bt) + this.TAB);
                } else {
                    sb.append(TimeFormatter.toTimecodeNTSC(bt) + this.TAB);
                }
            }
        }
        if (endTime) {
            if (HHMMformat) {
                sb.append(TimeFormatter.toString(et) + this.TAB);
            }
            if (SSMSFormat) {
                sb.append(Double.toString((double)et / 1000.0) + this.TAB);
            }
            if (MSFormat) {
                sb.append(et + this.TAB);
            }
            if (SMPTEFormat) {
                if (actualSMPTEType == null || actualSMPTEType == "PAL") {
                    sb.append(TimeFormatter.toTimecodePAL(et) + this.TAB);
                } else if (actualSMPTEType == "PAL-50fps") {
                    sb.append(TimeFormatter.toTimecodePAL50(et) + this.TAB);
                } else {
                    sb.append(TimeFormatter.toTimecodeNTSC(et) + this.TAB);
                }
            }
        }
        if (duration) {
            long d = et - bt;
            if (HHMMformat) {
                sb.append(TimeFormatter.toString(d) + this.TAB);
            }
            if (SSMSFormat) {
                sb.append(Double.toString((double)d / 1000.0) + this.TAB);
            }
            if (MSFormat) {
                sb.append(d + this.TAB);
            }
            if (SMPTEFormat) {
                if (actualSMPTEType == null || actualSMPTEType == "PAL") {
                    sb.append(TimeFormatter.toTimecodePAL(d) + this.TAB);
                } else if (actualSMPTEType == "PAL-50fps") {
                    sb.append(TimeFormatter.toTimecodePAL50(d) + this.TAB);
                } else {
                    sb.append(TimeFormatter.toTimecodeNTSC(d) + this.TAB);
                }
            }
        }
        sb.append(this.csvEncodeCond2(annotationCore.getValue()) + "\n");
        return sb.toString();
    }

    private String csvEncodeCond1(String inputText) {
        if (this.csvEncodeText) {
            return "\"" + inputText.replace('\n', ' ').replaceAll("\"", "\"\"") + "\"";
        }
        return inputText;
    }

    private String csvEncodeCond2(String inputText) {
        if (this.csvEncodeText) {
            return "\"" + inputText.replace('\n', ' ').replaceAll("\"", "\"\"") + "\"";
        }
        return inputText.replace('\n', ' ');
    }
}

