/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.TimeRelation;

public class Transcription2TeX {
    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile) throws IOException {
        Transcription2TeX.exportTiers(transcription, tierNames, exportFile, 0L, Long.MAX_VALUE);
    }

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime) throws IOException {
        if (exportFile == null) {
            return;
        }
        ArrayList<Tier> rootTiers = new ArrayList<Tier>();
        for (String tierName : tierNames) {
            rootTiers.add(transcription.getTierWithId(tierName));
        }
        if (!Transcription2TeX.hasOnlyLinearDependencies(rootTiers)) {
            throw new IOException("Export.TeX.TierSelectionException");
        }
        Transcription2TeX.removeDependentTiers(rootTiers);
        FileOutputStream out = new FileOutputStream(exportFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        writer.write("\\documentclass{article}\n");
        writer.write("\\usepackage{pstricks,pst-node,pst-tree}\n");
        writer.write("\\begin{document}\n");
        writer.write("\\begin{center}\n");
        for (int i = 0; i < rootTiers.size(); ++i) {
            writer.write(((TierImpl)rootTiers.get(i)).getName() + "\\\\\n");
            List<? extends Annotation> annotations = ((Tier)rootTiers.get(i)).getAnnotations();
            int j = 0;
            while (j < annotations.size()) {
                if (TimeRelation.overlaps(annotations.get(j), beginTime, endTime)) {
                    ++j;
                    continue;
                }
                annotations.remove(j);
            }
            Transcription2TeX.exportAnnotations(writer, tierNames, annotations, exportFile);
        }
        writer.write("\\end{center}\n");
        writer.write("\\end{document}\n");
        writer.close();
    }

    private static void removeDependentTiers(List<Tier> rootTiers) {
        for (int i = 0; i < rootTiers.size() - 1; ++i) {
            TierImpl tier1 = (TierImpl)rootTiers.get(i);
            for (int j = i + 1; j < rootTiers.size(); ++j) {
                TierImpl tier2 = (TierImpl)rootTiers.get(j);
                if (tier2.hasAncestor(tier1)) {
                    rootTiers.remove(tier2);
                    --j;
                }
                if (!tier1.hasAncestor(tier2)) continue;
                rootTiers.remove(tier1);
                --j;
                --i;
            }
        }
    }

    private static boolean hasOnlyLinearDependencies(List<Tier> rootTiers) {
        for (int i = 0; i < rootTiers.size() - 1; ++i) {
            TierImpl tier1 = (TierImpl)rootTiers.get(i);
            for (int j = i + 1; j < rootTiers.size(); ++j) {
                TierImpl tier2 = (TierImpl)rootTiers.get(j);
                if (tier1.getParentTier() != tier2.getParentTier() || !rootTiers.contains(tier1.getParentTier())) continue;
                return false;
            }
        }
        return true;
    }

    private static void exportAnnotations(BufferedWriter writer, String[] tierNames, List<? extends AnnotationCore> annotations, File exportFile) throws IOException {
        if (exportFile == null) {
            return;
        }
        for (int i = 0; i < annotations.size(); ++i) {
            if (!(annotations.get(i) instanceof Annotation)) continue;
            writer.write(Transcription2TeX.getTeXTree(tierNames, (Annotation)annotations.get(i)) + "\\\\[5mm]\n");
        }
    }

    private static String getTeXTree(String[] tierNames, Annotation annotation) {
        StringBuilder sb = new StringBuilder();
        TierImpl tier = (TierImpl)annotation.getTier();
        List<TierImpl> childrenTiers = tier.getChildTiers();
        StringBuilder childrenTree = new StringBuilder();
        try {
            block2: for (Tier tier2 : childrenTiers) {
                String childrenTierName = tier2.getName();
                for (String tierName : tierNames) {
                    if (!tierName.equals(childrenTierName)) continue;
                    List<Annotation> children = annotation.getChildrenOnTier(tier2);
                    if (children.size() <= 0) continue block2;
                    for (Annotation anno : children) {
                        childrenTree.append(Transcription2TeX.getTeXTree(tierNames, anno));
                    }
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String annotationValue = annotation.getValue();
        if (annotationValue != null && !annotationValue.equals("")) {
            if (childrenTree.length() > 0) {
                sb.append("\\pstree");
            }
            sb.append("{\\TR{" + annotationValue + "}}\n");
            if (childrenTree.length() > 0) {
                sb.append("{" + childrenTree + "}");
            }
        }
        return sb.toString();
    }
}

