/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

public class LinkedFileDescriptor
implements Cloneable {
    public static final String UNKNOWN_MIME_TYPE = "unknown";
    public static final String TEXT_TYPE = "text/plain";
    public static final String XML_TYPE = "text/xml";
    public static final String SVG_TYPE = "image/svg+xml";
    public static final String CMDI_TYPE = "application/x-cmdi+xml";
    public static final String IMDI_TYPE = "application/x-imdi+xml";
    public String linkURL;
    public String relativeLinkURL;
    public String mimeType;
    public long timeOrigin;
    public String associatedWith;
    public String configFile;

    public LinkedFileDescriptor(String linkURL, String mimeType) {
        if (linkURL == null) {
            throw new NullPointerException();
        }
        this.linkURL = linkURL;
        this.mimeType = mimeType != null ? mimeType : UNKNOWN_MIME_TYPE;
    }

    public String toString() {
        return this.linkURL + " " + this.mimeType + " " + this.timeOrigin + " " + this.associatedWith + " " + this.configFile;
    }

    public Object clone() {
        try {
            LinkedFileDescriptor cloneLFD = (LinkedFileDescriptor)super.clone();
            if (this.linkURL != null) {
                cloneLFD.linkURL = new String(this.linkURL);
            }
            if (this.relativeLinkURL != null) {
                cloneLFD.relativeLinkURL = new String(this.relativeLinkURL);
            }
            if (this.mimeType != null) {
                cloneLFD.mimeType = new String(this.mimeType);
            }
            if (this.associatedWith != null) {
                cloneLFD.associatedWith = new String(this.associatedWith);
            }
            if (this.configFile != null) {
                cloneLFD.configFile = new String(this.configFile);
            }
            cloneLFD.timeOrigin = this.timeOrigin;
            return cloneLFD;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LinkedFileDescriptor)) {
            return false;
        }
        LinkedFileDescriptor other = (LinkedFileDescriptor)obj;
        if (!this.sameString(this.linkURL, other.linkURL)) {
            return false;
        }
        if (!this.sameString(this.relativeLinkURL, other.relativeLinkURL)) {
            return false;
        }
        if (!this.sameString(this.mimeType, other.mimeType)) {
            return false;
        }
        if (!this.sameString(this.associatedWith, other.associatedWith)) {
            return false;
        }
        if (!this.sameString(this.configFile, other.configFile)) {
            return false;
        }
        return this.timeOrigin == other.timeOrigin;
    }

    private boolean sameString(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.associatedWith == null ? 0 : this.associatedWith.hashCode());
        result = 31 * result + (this.configFile == null ? 0 : this.configFile.hashCode());
        result = 31 * result + (this.linkURL == null ? 0 : this.linkURL.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + (this.relativeLinkURL == null ? 0 : this.relativeLinkURL.hashCode());
        result = 31 * result + (int)(this.timeOrigin ^ this.timeOrigin >>> 32);
        return result;
    }
}

