/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

public class MediaDescriptor
implements Cloneable {
    public static final String MPG_MIME_TYPE = "video/mpeg";
    public static final String WAV_MIME_TYPE = "audio/x-wav";
    public static final String UNKNOWN_MIME_TYPE = "unknown";
    public static final String QUICKTIME_MIME_TYPE = "video/quicktime";
    public static final String MP4_MIME_TYPE = "video/mp4";
    public static final String GENERIC_VIDEO_TYPE = "video/*";
    public static final String GENERIC_AUDIO_TYPE = "audio/*";
    public static final String JPEG_TYPE = "image/jpeg";
    public String mediaURL;
    public String relativeMediaURL;
    public String mimeType;
    public long timeOrigin;
    public String extractedFrom;
    public boolean isValid;

    public MediaDescriptor(String theMediaURL, String theMimeType) {
        this.mediaURL = theMediaURL;
        this.mimeType = theMimeType != null ? theMimeType : UNKNOWN_MIME_TYPE;
        this.isValid = true;
    }

    public String toString() {
        return this.mediaURL + " " + this.mimeType + " " + this.timeOrigin + " " + this.extractedFrom;
    }

    public Object clone() {
        try {
            MediaDescriptor cloneMD = (MediaDescriptor)super.clone();
            if (this.mediaURL != null) {
                cloneMD.mediaURL = new String(this.mediaURL);
            }
            if (this.relativeMediaURL != null) {
                cloneMD.relativeMediaURL = new String(this.relativeMediaURL);
            }
            if (this.mimeType != null) {
                cloneMD.mimeType = new String(this.mimeType);
            }
            if (this.extractedFrom != null) {
                cloneMD.extractedFrom = new String(this.extractedFrom);
            }
            cloneMD.timeOrigin = this.timeOrigin;
            cloneMD.isValid = this.isValid;
            return cloneMD;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MediaDescriptor)) {
            return false;
        }
        MediaDescriptor other = (MediaDescriptor)obj;
        if (!this.sameString(this.mediaURL, other.mediaURL)) {
            return false;
        }
        if (!this.sameString(this.relativeMediaURL, other.relativeMediaURL)) {
            return false;
        }
        if (!this.sameString(this.mimeType, other.mimeType)) {
            return false;
        }
        if (!this.sameString(this.extractedFrom, other.extractedFrom)) {
            return false;
        }
        if (this.timeOrigin != other.timeOrigin) {
            return false;
        }
        return this.isValid == other.isValid;
    }

    private boolean sameString(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.extractedFrom == null ? 0 : this.extractedFrom.hashCode());
        result = 31 * result + (this.isValid ? 1231 : 1237);
        result = 31 * result + (this.mediaURL == null ? 0 : this.mediaURL.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + (this.relativeMediaURL == null ? 0 : this.relativeMediaURL.hashCode());
        result = 31 * result + (int)(this.timeOrigin ^ this.timeOrigin >>> 32);
        return result;
    }
}

