/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.chat.CHATParser;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextParser;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF26Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF27Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF28Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF30Parser;
import mpi.eudico.server.corpora.clomimpl.flex.FlexParser;
import mpi.eudico.server.corpora.clomimpl.json.JSONWAParser;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxParser;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxParser;
import mpi.eudico.server.corpora.clomimpl.subtitletext.SubtitleTextParser;
import mpi.eudico.server.corpora.clomimpl.transcriber.Transcriber14Parser;

public class ParserFactory {
    public static final int EAF21 = 0;
    public static final int CHAT = 1;
    public static final int SHOEBOX = 2;
    public static final int TRANSCRIBER = 3;
    public static final int CGN = 4;
    public static final int WAC = 5;
    public static final int EAF22 = 6;
    public static final int EAF23 = 7;
    public static final int EAF24 = 8;
    public static final int EAF25 = 9;
    public static final int CSV = 10;
    public static final int EAF26 = 11;
    public static final int TOOLBOX = 12;
    public static final int FLEX = 13;
    public static final int EAF27 = 14;
    public static final int EAF28 = 15;
    public static final int EAF30 = 16;
    public static final int SUBTITLE = 17;
    public static final int JSON = 18;
    public static final int JSON_WA = 19;

    public static Parser getParser(int parserCode) {
        switch (parserCode) {
            case 1: {
                return new CHATParser();
            }
            case 2: {
                return new ShoeboxParser();
            }
            case 3: {
                return new Transcriber14Parser();
            }
            case 4: {
                Parser parser = null;
                try {
                    parser = (Parser)Class.forName("mpi.eudico.server.corpora.clomimpl.cgn2acm.CGN2ACMParser").newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return parser;
            }
            case 10: {
                return new DelimitedTextParser();
            }
            case 0: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                return new EAF26Parser();
            }
            case 12: {
                return new ToolboxParser();
            }
            case 13: {
                return new FlexParser();
            }
            case 14: {
                return new EAF27Parser();
            }
            case 15: {
                return new EAF28Parser();
            }
            case 16: {
                return new EAF30Parser();
            }
            case 17: {
                return new SubtitleTextParser();
            }
            case 18: 
            case 19: {
                return new JSONWAParser();
            }
        }
        return new EAF30Parser();
    }
}

