/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeProposer2;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.IllegalEditException;
import mpi.eudico.server.corpora.util.ACMEditableObject;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.Pair;

public class TierImpl
implements Tier {
    protected String tierName;
    protected TranscriptionImpl transcription;
    protected TreeSet<Annotation> annotations;
    protected Map<String, Object> tierMetadata;
    protected TierImpl parentTier;
    private LinguisticType linguisticType;
    private String extRef;
    private String langRef;

    @Override
    public void modified(int operation, Object modification) {
        this.handleModification(this, operation, modification);
    }

    @Override
    public void handleModification(ACMEditableObject source, int operation, Object modification) {
        if (this.transcription != null) {
            this.transcription.handleModification(source, operation, modification);
        }
    }

    public TierImpl(String name, String participant, TranscriptionImpl transcription, LinguisticType theType) {
        this(transcription);
        this.tierName = name;
        if (participant == null) {
            this.setParticipant("");
        } else {
            this.setParticipant(participant);
        }
        this.setDefaultLocale(null);
        this.setLinguisticType(theType);
    }

    public TierImpl(TierImpl parenttier, String name, String participant, TranscriptionImpl transcription, LinguisticType theType) {
        this(name, participant, transcription, theType);
        this.setParentTier(parenttier);
    }

    private TierImpl(TranscriptionImpl trans) {
        this.transcription = trans;
        this.annotations = new TreeSet();
        this.tierMetadata = new HashMap<String, Object>();
    }

    public Annotation createAnnotation(long beginTime, long endTime) {
        AbstractAnnotation annotation = null;
        TimeOrder timeOrder = this.transcription.getTimeOrder();
        if (!this.isTimeAlignable() && beginTime == endTime) {
            Annotation referedAnnot = this.getParentTier().getAnnotationAtTime(beginTime);
            if (referedAnnot != null && this.getAnnotationAtTime(beginTime) == null) {
                annotation = new RefAnnotation(referedAnnot, this);
            }
        } else if (endTime > beginTime) {
            Constraint c = this.getLinguisticType().getConstraints();
            if (c != null) {
                List<TimeSlot> slots = c.getTimeSlotsForNewAnnotation(beginTime, endTime, this);
                if (slots.size() == 2) {
                    annotation = new AlignableAnnotation(slots.get(0), slots.get(1), this);
                }
            } else {
                TimeSlotImpl bts = new TimeSlotImpl(beginTime, timeOrder);
                timeOrder.insertTimeSlot(bts);
                TimeSlotImpl ets = new TimeSlotImpl(endTime, timeOrder);
                timeOrder.insertTimeSlot(ets);
                annotation = new AlignableAnnotation(bts, ets, this);
            }
        }
        if (annotation != null) {
            this.addAnnotation(annotation);
            this.modified(3, annotation);
        }
        return annotation;
    }

    @Override
    public String getName() {
        return this.tierName;
    }

    @Override
    public TranscriptionImpl getTranscription() {
        return this.transcription;
    }

    @Override
    public void setName(String theName) {
        this.tierName = theName;
        this.modified(2, null);
    }

    @Override
    public void addAnnotation(Annotation theAnnotation) {
        this.addAnnotation((AbstractAnnotation)theAnnotation);
    }

    public void addAnnotation(AbstractAnnotation theAnnotation) {
        this.annotations.add(theAnnotation);
        if (theAnnotation instanceof AlignableAnnotation) {
            AlignableAnnotation a = (AlignableAnnotation)theAnnotation;
            if (this.transcription.getTimeChangePropagationMode() == 1 && this.getParentTier() == null) {
                this.correctOverlapsByPushing(a, a.getBegin().getTime(), a.getBegin().getTime());
            } else if (this.transcription.getTimeChangePropagationMode() == 2 && this.getParentTier() == null) {
                ArrayList<TimeSlot> fixedSlots = new ArrayList<TimeSlot>();
                fixedSlots.add(a.getBegin());
                this.transcription.correctOverlapsByShifting(a, fixedSlots, a.getBegin().getTime(), a.getBegin().getTime());
                this.correctTimeOverlaps(a);
            } else if (this.linguisticType.getConstraints() != null && this.linguisticType.getConstraints().getStereoType() == 0) {
                List<Annotation> overLaps;
                if (a.getBegin().isTimeAligned() && a.getEnd().isTimeAligned() && (overLaps = this.getOverlappingAnnotations(a.getBegin().getTime(), a.getEnd().getTime())).size() > 1) {
                    this.correctTimeOverlaps(a);
                    this.correctDependingOverlaps(a);
                }
            } else {
                this.correctTimeOverlaps(a);
            }
        }
    }

    public int shiftAnnotations(long numMsToShift, long lowerBoundary, long upperBoundary) throws IllegalEditException, IllegalArgumentException {
        if (numMsToShift == 0L) {
            return 0;
        }
        if (lowerBoundary >= upperBoundary) {
            throw new IllegalArgumentException("The lower boundary is greater than or the same as the upper boundary.");
        }
        if (lowerBoundary < 0L) {
            throw new IllegalArgumentException("The lower boundary has a negative value: " + lowerBoundary);
        }
        if (this.hasParentTier() || !this.isTimeAlignable()) {
            throw new IllegalEditException("Shifting annotations is only supported for time-alignableroot tiers");
        }
        ArrayList<AlignableAnnotation> annosToShift = new ArrayList<AlignableAnnotation>();
        Iterator<Annotation> annIt = this.annotations.iterator();
        Object var9_6 = null;
        while (annIt.hasNext()) {
            AlignableAnnotation alignableAnnotation = (AlignableAnnotation)annIt.next();
            if (alignableAnnotation.getBegin().getTime() >= lowerBoundary && alignableAnnotation.getEnd().getTime() <= upperBoundary) {
                annosToShift.add(alignableAnnotation);
            }
            if (alignableAnnotation.getBegin().getTime() < upperBoundary) continue;
        }
        if (annosToShift.size() == 0) {
            return 0;
        }
        long[] emptySpace = new long[2];
        if (numMsToShift < 0L) {
            AlignableAnnotation alignableAnnotation = (AlignableAnnotation)annosToShift.get(0);
            emptySpace[0] = alignableAnnotation.getBegin().getTime() + numMsToShift;
            emptySpace[1] = alignableAnnotation.getBegin().getTime();
        } else {
            AlignableAnnotation alignableAnnotation = (AlignableAnnotation)annosToShift.get(annosToShift.size() - 1);
            emptySpace[0] = alignableAnnotation.getEnd().getTime();
            emptySpace[1] = alignableAnnotation.getEnd().getTime() + numMsToShift;
        }
        for (AlignableAnnotation alignableAnnotation : this.annotations) {
            if (alignableAnnotation.getEnd().getTime() <= emptySpace[0]) continue;
            if (alignableAnnotation.getBegin().getTime() >= emptySpace[1]) break;
            if (alignableAnnotation.getEnd().getTime() <= emptySpace[0] || alignableAnnotation.getBegin().getTime() >= emptySpace[1] || annosToShift.contains(alignableAnnotation)) continue;
            throw new IllegalEditException("There is at least one annotation in the time interval where annotations should be moved to. \nMove it out of the way first.\nB: " + alignableAnnotation.getBegin().getTime() + " E: " + alignableAnnotation.getEnd().getTime());
        }
        TreeSet<AbstractAnnotation> annots = new TreeSet<AbstractAnnotation>();
        TreeSet slots = new TreeSet();
        TranscriptionImpl trans = this.getTranscription();
        if (numMsToShift < 0L) {
            for (int i = 0; i < annosToShift.size(); ++i) {
                AlignableAnnotation alignableAnnotation = (AlignableAnnotation)annosToShift.get(i);
                annots.clear();
                slots.clear();
                trans.getConnectedAnnots(annots, slots, alignableAnnotation);
                for (TimeSlot slot : slots) {
                    trans.getTimeOrder().removeTimeSlot(slot);
                }
                for (TimeSlot slot : slots) {
                    if (((TimeSlotImpl)slot).isTimeAligned()) {
                        ((TimeSlotImpl)slot).updateTime(((TimeSlotImpl)slot).getTime() + numMsToShift);
                        continue;
                    }
                    ((TimeSlotImpl)slot).setProposedTime(((TimeSlotImpl)slot).getProposedTime() + numMsToShift);
                }
                TimeSlot slot1 = (TimeSlot)slots.first();
                trans.getTimeOrder().insertTimeSlot(slot1);
                TimeSlot slot2 = (TimeSlot)slots.last();
                trans.getTimeOrder().insertTimeSlot(slot2);
                for (TimeSlot slot : slots) {
                    if (slot == slot1) {
                        slot1 = slot;
                        continue;
                    }
                    if (slot == slot2) continue;
                    if (slot.isTimeAligned()) {
                        trans.getTimeOrder().insertTimeSlot(slot);
                    } else {
                        trans.getTimeOrder().insertTimeSlot(slot, slot1, slot2);
                    }
                    slot1 = slot;
                }
            }
        } else {
            for (int i = annosToShift.size() - 1; i >= 0; --i) {
                AlignableAnnotation alignableAnnotation = (AlignableAnnotation)annosToShift.get(i);
                annots.clear();
                slots.clear();
                trans.getConnectedAnnots(annots, slots, alignableAnnotation);
                for (TimeSlotImpl slot : slots) {
                    trans.getTimeOrder().removeTimeSlot(slot);
                }
                for (TimeSlotImpl slot : slots) {
                    if (slot.isTimeAligned()) {
                        slot.updateTime(slot.getTime() + numMsToShift);
                        continue;
                    }
                    slot.setProposedTime(slot.getProposedTime() + numMsToShift);
                }
                Object slot1 = (TimeSlot)slots.first();
                trans.getTimeOrder().insertTimeSlot((TimeSlot)slot1);
                TimeSlot slot2 = (TimeSlot)slots.last();
                trans.getTimeOrder().insertTimeSlot(slot2);
                for (TimeSlot slot : slots) {
                    if (slot == slot1) {
                        slot1 = slot;
                        continue;
                    }
                    if (slot == slot2) continue;
                    if (slot.isTimeAligned()) {
                        trans.getTimeOrder().insertTimeSlot(slot);
                    } else {
                        trans.getTimeOrder().insertTimeSlot(slot, (TimeSlot)slot1, slot2);
                    }
                    slot1 = slot;
                }
            }
        }
        return annosToShift.size();
    }

    public void insertAnnotation(Annotation theAnnotation) {
        this.annotations.add(theAnnotation);
    }

    public boolean checkAnnotationOrderConsistency() {
        ArrayList<Annotation> v = new ArrayList<Annotation>(this.annotations);
        for (int i = 0; i < v.size() - 1; ++i) {
            Annotation a2;
            Annotation a1 = (Annotation)v.get(i);
            if (a1.compareTo(a2 = (Annotation)v.get(i + 1)) <= 0) continue;
            return false;
        }
        return true;
    }

    void resortAnnotations() {
        ArrayList<Annotation> v = new ArrayList<Annotation>(this.annotations);
        this.annotations.clear();
        this.annotations.addAll(v);
    }

    public Annotation createAnnotationBefore(Annotation beforeAnn) {
        Annotation a = null;
        Constraint c = this.linguisticType.getConstraints();
        if (c != null && c.supportsInsertion()) {
            a = c.insertBefore(beforeAnn, this);
            this.modified(4, a);
        }
        return a;
    }

    public Annotation createAnnotationAfter(Annotation afterAnn) {
        Annotation a = null;
        Constraint c = this.linguisticType.getConstraints();
        if (c != null && c.supportsInsertion()) {
            a = c.insertAfter(afterAnn, this);
            this.modified(5, a);
        }
        return a;
    }

    @Override
    public void removeAnnotation(Annotation theAnnotation) {
        theAnnotation.markDeleted(true);
        this.transcription.pruneAnnotations(this, theAnnotation);
    }

    @Override
    public void removeAllAnnotations() {
        for (Annotation annot : this.annotations) {
            annot.markDeleted(true);
        }
        this.transcription.pruneAnnotations(this);
    }

    public List<AbstractAnnotation> getAnnotations() {
        ArrayList<Annotation> annList = new ArrayList<Annotation>(this.annotations);
        return annList;
    }

    public List<AlignableAnnotation> getAlignableAnnotations() {
        if (this.isTimeAlignable()) {
            ArrayList<Annotation> annList = new ArrayList<Annotation>(this.annotations);
            return annList;
        }
        System.err.println("Error: getAlignableAnnotations called on not-time-alignable Tier " + this.getName());
        return new ArrayList<AlignableAnnotation>(0);
    }

    public List<RefAnnotation> getRefAnnotations() {
        if (!this.isTimeAlignable()) {
            ArrayList<Annotation> annList = new ArrayList<Annotation>(this.annotations);
            return annList;
        }
        System.err.println("Error: getRefAnnotations called on time-alignable Tier " + this.getName());
        return new ArrayList<RefAnnotation>(0);
    }

    public Annotation getAnnotationById(String id) {
        if (id == null) {
            return null;
        }
        for (Annotation a : this.annotations) {
            if (!id.equals(a.getId())) continue;
            return a;
        }
        return null;
    }

    public void getAnnotationsByIdMap(Map<String, Annotation> map) {
        for (Annotation a : this.annotations) {
            map.put(a.getId(), a);
        }
    }

    @Override
    public int getNumberOfAnnotations() {
        return this.annotations.size();
    }

    public Annotation getAnnotationBefore(Annotation theAnnotation) {
        Annotation previousAnnotation = null;
        Annotation currentAnnotation = null;
        Iterator<Annotation> iter = this.annotations.iterator();
        while (iter.hasNext()) {
            previousAnnotation = currentAnnotation;
            currentAnnotation = iter.next();
            if (!currentAnnotation.equals(theAnnotation)) continue;
            break;
        }
        return previousAnnotation;
    }

    public Annotation getAnnotationBefore(long time) {
        Annotation previousAnnotation = null;
        Annotation currentAnnotation = null;
        Annotation foundAnnotation = null;
        long lastEndTime = -1L;
        Iterator<Annotation> iter = this.annotations.iterator();
        while (iter.hasNext()) {
            previousAnnotation = currentAnnotation;
            currentAnnotation = iter.next();
            lastEndTime = currentAnnotation.getEndTimeBoundary();
            if (lastEndTime <= time) continue;
            foundAnnotation = previousAnnotation;
            break;
        }
        if (foundAnnotation != null) {
            return foundAnnotation;
        }
        if (lastEndTime > -1L && lastEndTime < time) {
            return currentAnnotation;
        }
        return null;
    }

    public Annotation getAnnotationAfter(Annotation theAnnotation) {
        Annotation nextAnnotation = null;
        Annotation currentAnnotation = null;
        Iterator<Annotation> iter = this.annotations.iterator();
        while (iter.hasNext()) {
            currentAnnotation = iter.next();
            if (!currentAnnotation.equals(theAnnotation)) continue;
            if (!iter.hasNext()) break;
            nextAnnotation = iter.next();
            break;
        }
        return nextAnnotation;
    }

    public Annotation getAnnotationAfter(long time) {
        Annotation currentAnnotation2 = null;
        Annotation resultAnnotation = null;
        for (Annotation currentAnnotation2 : this.annotations) {
            if (currentAnnotation2.getEndTimeBoundary() <= time) continue;
            resultAnnotation = currentAnnotation2;
            break;
        }
        return resultAnnotation;
    }

    public void correctTimeOverlaps(AlignableAnnotation fixedAnnotation) {
        TimeSlot fixedSlot1 = fixedAnnotation.getBegin();
        TimeSlot fixedSlot2 = fixedAnnotation.getEnd();
        if (!fixedSlot1.isTimeAligned()) {
            return;
        }
        if (!fixedSlot2.isTimeAligned()) {
            return;
        }
        TreeSet<AbstractAnnotation> connectedAnnots = new TreeSet<AbstractAnnotation>();
        TreeSet connectedTimeSlots = new TreeSet();
        this.transcription.getConnectedAnnots(connectedAnnots, connectedTimeSlots, fixedAnnotation);
        ArrayList<AbstractAnnotation> connectedAnnotVector = new ArrayList<AbstractAnnotation>(connectedAnnots);
        ArrayList<AlignableAnnotation> correctedAnnos = new ArrayList<AlignableAnnotation>(connectedAnnotVector.size());
        TimeSlot[] graphEndpoints = this.getGraphEndpoints(connectedAnnotVector);
        TreeSet<AlignableAnnotation> overlappingAnnots = new TreeSet<AlignableAnnotation>();
        for (AlignableAnnotation ann : this.getOverlappingAnnotationsIncludeExtremes(fixedSlot1, fixedSlot2)) {
            List<Annotation> children;
            if (ann != fixedAnnotation) {
                overlappingAnnots.add(ann);
            }
            if ((children = this.transcription.getChildAnnotationsOf(ann)).size() <= 0) continue;
            for (Annotation annotation : children) {
                if (!(annotation instanceof AlignableAnnotation)) continue;
                overlappingAnnots.add((AlignableAnnotation)annotation);
            }
        }
        List<AbstractAnnotation> overlappingAnnotVector = new ArrayList<AbstractAnnotation>(overlappingAnnots);
        overlappingAnnotVector = this.inGraphOrder(overlappingAnnotVector, graphEndpoints[0]);
        boolean forcedInside = false;
        for (AlignableAnnotation alignableAnnotation : overlappingAnnotVector) {
            if (correctedAnnos.contains(alignableAnnotation)) continue;
            correctedAnnos.add(alignableAnnotation);
            Constraint constraint = ((TierImpl)alignableAnnotation.getTier()).getLinguisticType().getConstraints();
            if (constraint != null && constraint.getStereoType() == 1) {
                if (fixedAnnotation.isAncestorOf(alignableAnnotation)) {
                    this.forceAnnotationInInterval(alignableAnnotation, fixedAnnotation);
                    continue;
                }
                this.forceOutOfFixedInterval(alignableAnnotation, fixedAnnotation);
                continue;
            }
            if (!connectedAnnotVector.contains(alignableAnnotation)) {
                if (alignableAnnotation.getTier() != fixedAnnotation.getTier()) continue;
                this.forceOutOfFixedInterval(alignableAnnotation, fixedAnnotation);
                this.forceChildAnnotationsOfAlignable(alignableAnnotation);
                continue;
            }
            if (!fixedAnnotation.hasParentAnnotation()) {
                if (!forcedInside) {
                    this.forceInsideFixedInterval(graphEndpoints, fixedAnnotation);
                    forcedInside = true;
                }
                if (constraint == null || constraint.getStereoType() != 0) continue;
                this.forceTSInsideFixedInterval(alignableAnnotation, graphEndpoints, fixedAnnotation);
                continue;
            }
            if (alignableAnnotation.getTier() != fixedAnnotation.getTier()) continue;
            this.forceAnnotChainOutOfFixedInterval(graphEndpoints, fixedSlot1, fixedSlot2);
            if (!alignableAnnotation.getBegin().isTimeAligned() || alignableAnnotation.getBegin().getTime() >= alignableAnnotation.getEnd().getTime()) continue;
            if (alignableAnnotation.getBegin().getTime() < fixedSlot1.getTime() && alignableAnnotation.getEnd().getTime() > fixedSlot1.getTime()) {
                this.forceChildChainOutOfInterval(alignableAnnotation, graphEndpoints, fixedSlot1, fixedSlot2, true);
                continue;
            }
            if (alignableAnnotation.getBegin().getTime() > fixedSlot2.getTime() || alignableAnnotation.getEnd().getTime() <= fixedSlot2.getTime()) continue;
            this.forceChildChainOutOfInterval(alignableAnnotation, graphEndpoints, fixedSlot1, fixedSlot2, false);
        }
        for (AlignableAnnotation alignableAnnotation : connectedAnnotVector) {
            if (correctedAnnos.contains(alignableAnnotation)) continue;
            correctedAnnos.add(alignableAnnotation);
            if (overlappingAnnotVector.contains(alignableAnnotation) || alignableAnnotation == fixedAnnotation || !((TierImpl)alignableAnnotation.getTier()).hasAncestor(this)) continue;
            Constraint cc = ((TierImpl)alignableAnnotation.getTier()).getLinguisticType().getConstraints();
            if (cc != null && cc.getStereoType() == 1) {
                if (fixedAnnotation.isAncestorOf(alignableAnnotation)) {
                    this.forceAnnotationInInterval(alignableAnnotation, fixedAnnotation);
                } else {
                    this.forceOutOfFixedInterval(alignableAnnotation, fixedAnnotation);
                }
                overlappingAnnotVector.add(alignableAnnotation);
                continue;
            }
            if (cc == null || cc.getStereoType() != 0 || fixedAnnotation.isAncestorOf(alignableAnnotation)) continue;
            this.forceOutOfFixedInterval(alignableAnnotation, fixedAnnotation);
            overlappingAnnotVector.add(alignableAnnotation);
        }
        this.repositionUnalignedSlots(graphEndpoints[0]);
        if (overlappingAnnotVector.size() > 0) {
            this.markAnnotationsForDeletion(overlappingAnnotVector);
            this.transcription.pruneAnnotations(this);
        }
    }

    public TimeSlot[] getGraphEndpoints(List<AbstractAnnotation> connectedAnnotList) {
        TimeSlot[] endpoints = new TimeSlot[2];
        for (AlignableAnnotation alignableAnnotation : connectedAnnotList) {
            if (alignableAnnotation.hasParentAnnotation()) continue;
            endpoints[0] = alignableAnnotation.getBegin();
            endpoints[1] = alignableAnnotation.getEnd();
            break;
        }
        if (endpoints[0] == null && endpoints[1] == null) {
            int n;
            int n2 = -1;
            int leastAncestors = Integer.MAX_VALUE;
            boolean isUnique = false;
            for (int i = 0; i < connectedAnnotList.size(); ++i) {
                AbstractAnnotation aa = connectedAnnotList.get(i);
                Tier t = aa.getTier();
                int curAncest = 0;
                while (t.hasParentTier()) {
                    ++curAncest;
                    t = t.getParentTier();
                }
                if (curAncest < leastAncestors) {
                    leastAncestors = curAncest;
                    isUnique = true;
                    n = i;
                    continue;
                }
                if (curAncest != leastAncestors) continue;
                isUnique = false;
            }
            if (isUnique && n >= 0) {
                AlignableAnnotation ann = (AlignableAnnotation)connectedAnnotList.get(n);
                endpoints[0] = ann.getBegin();
                endpoints[1] = ann.getEnd();
            }
        }
        return endpoints;
    }

    public TimeSlot[] getEndpointsOfSubchain(TimeSlot theSlot, boolean stopAtAlignedSlot) {
        TimeSlot[] endpoints = new TimeSlot[]{this.getBeginSlotOfChain(theSlot, stopAtAlignedSlot), this.getEndSlotOfChain(theSlot, stopAtAlignedSlot)};
        return endpoints;
    }

    public TimeSlot getEndSlotOfChain(TimeSlot theSlot, boolean stopAtAlignedSlot) {
        TimeSlot endSlot = theSlot;
        if (this.getParentTier() != null && this.getParentTier().getAnnotationsUsingTimeSlot(endSlot).size() > 0) {
            return endSlot;
        }
        List<Annotation> annotsFromSlot = this.getAnnotsBeginningAtTimeSlot(theSlot);
        if (annotsFromSlot.size() > 0) {
            AlignableAnnotation nextAnnot = (AlignableAnnotation)annotsFromSlot.get(0);
            TimeSlot nextSlot = nextAnnot.getEnd();
            endSlot = nextSlot.isTimeAligned() && stopAtAlignedSlot || this.getParentTier() != null && this.getParentTier().getAnnotationsUsingTimeSlot(nextSlot).size() > 0 ? nextSlot : this.getEndSlotOfChain(nextSlot, stopAtAlignedSlot);
        }
        return endSlot;
    }

    public TimeSlot getBeginSlotOfChain(TimeSlot theSlot, boolean stopAtAlignedSlot) {
        TimeSlot beginSlot = theSlot;
        if (this.getParentTier() != null && this.getParentTier().getAnnotationsUsingTimeSlot(beginSlot).size() > 0) {
            return beginSlot;
        }
        List<Annotation> annotsToSlot = this.getAnnotsEndingAtTimeSlot(theSlot);
        if (annotsToSlot.size() > 0) {
            AlignableAnnotation prevAnnot = (AlignableAnnotation)annotsToSlot.get(0);
            TimeSlot prevSlot = prevAnnot.getBegin();
            beginSlot = prevSlot.isTimeAligned() && stopAtAlignedSlot || this.getParentTier() != null && this.getParentTier().getAnnotationsUsingTimeSlot(prevSlot).size() > 0 ? prevSlot : this.getBeginSlotOfChain(prevSlot, stopAtAlignedSlot);
        }
        return beginSlot;
    }

    private List<AbstractAnnotation> inGraphOrder(List<AbstractAnnotation> overlappingAnnots, TimeSlot graphBegin) {
        TimeSlot aBegin = graphBegin;
        TimeSlot aEnd = graphBegin;
        List<Annotation> annsForTS = null;
        AlignableAnnotation currentA = null;
        ArrayList<AbstractAnnotation> result = new ArrayList<AbstractAnnotation>();
        while (aEnd != null) {
            annsForTS = this.getAnnotsBeginningAtTimeSlot(aBegin);
            if (annsForTS != null && annsForTS.size() > 0) {
                currentA = (AlignableAnnotation)annsForTS.get(0);
                aEnd = currentA.getEnd();
                if (overlappingAnnots.contains(currentA)) {
                    result.add(currentA);
                }
                aBegin = aEnd;
                continue;
            }
            aEnd = null;
        }
        for (AlignableAnnotation alignableAnnotation : overlappingAnnots) {
            if (result.contains(alignableAnnotation)) continue;
            result.add(alignableAnnotation);
        }
        return result;
    }

    private void forceOutOfFixedInterval(AlignableAnnotation aa, AlignableAnnotation fixedAnnotation) {
        TimeSlot begin = aa.getBegin();
        TimeSlot end = aa.getEnd();
        TimeSlot fixedSlot1 = fixedAnnotation.getBegin();
        TimeSlot fixedSlot2 = fixedAnnotation.getEnd();
        if (aa.getTier() == this) {
            boolean beginInFixedInterval = false;
            boolean endInFixedInterval = false;
            TreeSet<AbstractAnnotation> connAnnots = new TreeSet<AbstractAnnotation>();
            TreeSet<TimeSlot> connTimeSlots = new TreeSet<TimeSlot>();
            this.transcription.getConnectedAnnots(connAnnots, connTimeSlots, begin);
            if (begin.isAfter(fixedSlot1) && fixedSlot2.isAfter(begin) || begin.getTime() == fixedSlot1.getTime()) {
                beginInFixedInterval = true;
            }
            if (end.isAfter(fixedSlot1) && fixedSlot2.isAfter(end) || end.getTime() == fixedSlot1.getTime()) {
                endInFixedInterval = true;
            }
            if (beginInFixedInterval && !endInFixedInterval) {
                this.shiftAfterTimeSlot(fixedSlot2, connTimeSlots);
            } else {
                this.shiftBeforeTimeSlot(fixedSlot1, connTimeSlots);
            }
        } else {
            Constraint cc = ((TierImpl)aa.getTier()).getLinguisticType().getConstraints();
            if (cc != null && cc.getStereoType() == 1) {
                if (begin.getTime() >= fixedAnnotation.getBeginTimeBoundary() && begin.getTime() < fixedAnnotation.getEndTimeBoundary()) {
                    begin.setTime(fixedAnnotation.getEndTimeBoundary());
                    if (end.getTime() < fixedAnnotation.getEndTimeBoundary()) {
                        end.setTime(fixedAnnotation.getEndTimeBoundary());
                    }
                } else if (begin.getTime() < fixedAnnotation.getBeginTimeBoundary() && end.getTime() > fixedAnnotation.getBeginTimeBoundary()) {
                    end.setTime(fixedAnnotation.getBeginTimeBoundary());
                } else if (begin.getTime() < fixedAnnotation.getBeginTimeBoundary() && end.getTime() >= fixedAnnotation.getEndTimeBoundary()) {
                    end.setTime(fixedAnnotation.getBeginTimeBoundary());
                }
                this.forceChildAnnotationsOfAlignable(aa);
            } else if (cc != null && cc.getStereoType() == 0) {
                if (aa.getBegin().isTimeAligned() && aa.getEnd().isTimeAligned() && aa.getBegin().getTime() > fixedAnnotation.getBegin().getTime() && aa.getEnd().getTime() < fixedAnnotation.getEnd().getTime()) {
                    aa.markDeleted(true);
                } else if (aa.getBegin().isTimeAligned() && aa.getBegin().getTime() <= fixedAnnotation.getEnd().getTime() && aa.getBegin().getTime() > fixedAnnotation.getBegin().getTime() && aa.getEnd().getTime() >= fixedAnnotation.getEnd().getTime()) {
                    aa.setBegin(fixedAnnotation.getEnd());
                    this.forceChildAnnotationsOfAlignable(aa);
                }
            }
        }
    }

    private void shiftAfterTimeSlot(TimeSlot fixedSlot, TreeSet<TimeSlot> connTimeSlots) {
        TimeSlot lastShiftedSlot = null;
        for (TimeSlot ts : connTimeSlots) {
            if (!fixedSlot.isAfter(ts)) continue;
            if (ts.isTimeAligned()) {
                ts.setTime(fixedSlot.getTime());
                lastShiftedSlot = ts;
                continue;
            }
            this.transcription.getTimeOrder().removeTimeSlot(ts);
            this.transcription.getTimeOrder().insertTimeSlot(ts, lastShiftedSlot, null);
            lastShiftedSlot = ts;
        }
    }

    private void shiftBeforeTimeSlot(TimeSlot fixedSlot, TreeSet<TimeSlot> connTimeSlots) {
        TimeSlot lastShiftedSlot = null;
        TimeSlot afterThisSlot = null;
        ArrayList<TimeSlot> pending = new ArrayList<TimeSlot>();
        for (TimeSlot ts : connTimeSlots) {
            if (ts.isAfter(fixedSlot)) {
                if (ts.isTimeAligned()) {
                    ts.setTime(fixedSlot.getTime());
                    lastShiftedSlot = ts;
                    if (pending.size() <= 0) continue;
                    for (int i = 0; i < pending.size(); ++i) {
                        TimeSlot uts = (TimeSlot)pending.get(i);
                        this.transcription.getTimeOrder().removeTimeSlot(uts);
                        this.transcription.getTimeOrder().insertTimeSlot(uts, afterThisSlot, ts);
                    }
                    pending.clear();
                    continue;
                }
                pending.add(ts);
                continue;
            }
            afterThisSlot = ts;
        }
        if (pending.size() > 0) {
            for (int i = 0; i < pending.size(); ++i) {
                TimeSlot uts = (TimeSlot)pending.get(i);
                this.transcription.getTimeOrder().removeTimeSlot(uts);
                this.transcription.getTimeOrder().insertTimeSlot(uts, afterThisSlot, fixedSlot);
            }
            pending.clear();
        }
    }

    private void forceInsideFixedInterval(TimeSlot[] graphEndpoints, AlignableAnnotation fixedAnnotation) {
        TimeSlot annBegin = graphEndpoints[0];
        TimeSlot annEnd = graphEndpoints[0];
        List<Annotation> annotsForTS = null;
        AlignableAnnotation currentAnn = null;
        while (annEnd != null) {
            annotsForTS = this.getAnnotsBeginningAtTimeSlot(annBegin);
            if (annotsForTS != null && annotsForTS.size() > 0) {
                currentAnn = (AlignableAnnotation)annotsForTS.get(0);
                annEnd = currentAnn.getEnd();
                if (annEnd.isTimeAligned() && annEnd.getTime() < fixedAnnotation.getBegin().getTime()) {
                    annEnd.setTime(fixedAnnotation.getBegin().getTime());
                }
                if (!annEnd.isTimeAligned() && fixedAnnotation.getBegin().isAfter(annEnd)) {
                    this.transcription.getTimeOrder().removeTimeSlot(annEnd);
                    this.transcription.getTimeOrder().insertTimeSlot(annEnd, fixedAnnotation.getBegin(), null);
                }
                annBegin = annEnd;
                continue;
            }
            annEnd = null;
        }
    }

    private void forceAnnotationInInterval(AlignableAnnotation aa, AlignableAnnotation fixedAnnotation) {
        TimeSlot begin = aa.getBegin();
        TimeSlot end = aa.getEnd();
        Constraint cc = ((TierImpl)aa.getTier()).getLinguisticType().getConstraints();
        if (cc != null && cc.getStereoType() == 1) {
            if (begin.getTime() >= fixedAnnotation.getBeginTimeBoundary() && end.getTime() <= fixedAnnotation.getEndTimeBoundary()) {
                return;
            }
            if (begin.getTime() < fixedAnnotation.getBeginTimeBoundary() && end.getTime() > fixedAnnotation.getBeginTimeBoundary()) {
                begin.setTime(fixedAnnotation.getBeginTimeBoundary());
                if (end.getTime() > fixedAnnotation.getEndTimeBoundary()) {
                    end.setTime(fixedAnnotation.getEndTimeBoundary());
                }
                this.forceChildAnnotationsOfAlignable(aa);
            } else if (end.getTime() > fixedAnnotation.getEndTimeBoundary() && begin.getTime() < fixedAnnotation.getEndTimeBoundary()) {
                end.setTime(fixedAnnotation.getEndTimeBoundary());
                if (begin.getTime() < fixedAnnotation.getBeginTimeBoundary()) {
                    begin.setTime(fixedAnnotation.getBeginTimeBoundary());
                }
                this.forceChildAnnotationsOfAlignable(aa);
            } else {
                end.setTime(begin.getTime());
            }
        }
    }

    private void forceTSInsideFixedInterval(AlignableAnnotation aa, TimeSlot[] graphEndpoints, AlignableAnnotation fixedAnnotation) {
        Constraint cc = ((TierImpl)aa.getTier()).getLinguisticType().getConstraints();
        if (cc == null || cc.getStereoType() != 0) {
            return;
        }
        if (!aa.getBegin().isTimeAligned() || !aa.getEnd().isTimeAligned()) {
            return;
        }
        TimeSlot begin = aa.getBegin();
        TimeSlot end = aa.getEnd();
        if (begin.getTime() < end.getTime() && end.getTime() < fixedAnnotation.getBegin().getTime() && begin != fixedAnnotation.getBegin() && begin != graphEndpoints[0]) {
            begin.setTime(fixedAnnotation.getBegin().getTime());
        } else if (begin.getTime() < end.getTime() && begin.getTime() > fixedAnnotation.getEnd().getTime() && end != fixedAnnotation.getEnd() && end != graphEndpoints[1]) {
            end.setTime(fixedAnnotation.getEnd().getTime());
        }
    }

    private void forceChildAnnotationsOfAlignable(AlignableAnnotation aa) {
        Constraint cc = ((TierImpl)aa.getTier()).getLinguisticType().getConstraints();
        if (cc != null && cc.getStereoType() != 1 && cc.getStereoType() != 0) {
            return;
        }
        List<Annotation> chan = aa.getParentListeners();
        Constraint sc = null;
        HashMap tsChildren = null;
        for (int i = 0; i < chan.size(); ++i) {
            Annotation next = chan.get(i);
            if (!(next instanceof AlignableAnnotation)) continue;
            AlignableAnnotation ann = (AlignableAnnotation)next;
            sc = ((TierImpl)ann.getTier()).getLinguisticType().getConstraints();
            if (sc.getStereoType() == 1) {
                this.forceAnnotationInInterval(ann, aa);
                if (ann.getBegin().getTime() != ann.getEnd().getTime()) continue;
                ann.markDeleted(true);
                continue;
            }
            if (sc.getStereoType() != 0) continue;
            if (tsChildren == null) {
                tsChildren = new HashMap(3);
            }
            if (tsChildren.containsKey(ann.getTier())) {
                ((ArrayList)tsChildren.get(ann.getTier())).add(ann);
                continue;
            }
            ArrayList<AlignableAnnotation> al = new ArrayList<AlignableAnnotation>(5);
            al.add(ann);
            tsChildren.put(ann.getTier(), al);
        }
        if (tsChildren != null) {
            for (Object key : tsChildren.keySet()) {
                this.updateTSChildren(aa, (TierImpl)key, (ArrayList)tsChildren.get(key));
            }
        }
    }

    private void updateTSChildren(AlignableAnnotation parAnn, TierImpl tier, ArrayList<AlignableAnnotation> tsAnnos) {
        if (tier.getLinguisticType().getConstraints() == null || tier.getLinguisticType().getConstraints().getStereoType() != 0) {
            return;
        }
        Collections.sort(tsAnnos);
        boolean shouldPropagate = false;
        for (int i = 0; i < tsAnnos.size(); ++i) {
            AlignableAnnotation ann = tsAnnos.get(i);
            shouldPropagate = false;
            if (ann.getBegin() == parAnn.getBegin()) {
                if (ann.getEnd().isTimeAligned() && ann.getEnd().getTime() < parAnn.getBegin().getTime()) {
                    ann.markDeleted(true);
                } else {
                    shouldPropagate = true;
                }
            } else {
                if (!ann.getBegin().isTimeAligned() && parAnn.getBegin().isAfter(ann.getEnd())) {
                    this.transcription.getTimeOrder().removeTimeSlot(ann.getBegin());
                    this.transcription.getTimeOrder().insertTimeSlot(ann.getBegin(), parAnn.getBegin(), null);
                    shouldPropagate = true;
                }
                if (ann.getEnd().isTimeAligned() && parAnn.getBegin().getTime() >= ann.getEnd().getTime() || ann.getBegin().isTimeAligned() && parAnn.getEnd().getTime() <= ann.getBegin().getTime()) {
                    ann.markDeleted(true);
                }
                if (ann.getBegin().isTimeAligned() && parAnn.getBegin().getTime() >= ann.getBegin().getTime() && ann.getBegin() != parAnn.getBegin()) {
                    ann.setBegin(parAnn.getBegin());
                    if (!ann.getEnd().isTimeAligned() && ann.getBegin().isAfter(ann.getEnd())) {
                        this.transcription.getTimeOrder().removeTimeSlot(ann.getEnd());
                        this.transcription.getTimeOrder().insertTimeSlot(ann.getEnd(), ann.getBegin(), parAnn.getEnd());
                    }
                    shouldPropagate = true;
                }
                if (ann.getEnd().isTimeAligned() && parAnn.getEnd().getTime() <= ann.getEnd().getTime() && ann.getEnd() != parAnn.getEnd()) {
                    ann.setEnd(parAnn.getEnd());
                    shouldPropagate = true;
                }
                if (!ann.getEnd().isTimeAligned() && ann.getEnd().isAfter(parAnn.getEnd())) {
                    this.transcription.getTimeOrder().removeTimeSlot(ann.getEnd());
                    this.transcription.getTimeOrder().insertTimeSlot(ann.getEnd(), ann.getBegin(), parAnn.getEnd());
                    shouldPropagate = true;
                }
                if (!ann.getBegin().isTimeAligned() && !ann.getEnd().isTimeAligned() && ann.getBegin().isAfter(ann.getEnd())) {
                    this.transcription.getTimeOrder().removeTimeSlot(ann.getEnd());
                    this.transcription.getTimeOrder().insertTimeSlot(ann.getEnd(), ann.getBegin(), parAnn.getEnd());
                    shouldPropagate = true;
                }
            }
            if (!shouldPropagate) continue;
            this.forceChildAnnotationsOfAlignable(ann);
        }
    }

    private void forceAnnotChainOutOfFixedInterval(TimeSlot[] graphEndpoints, TimeSlot fixedSlot1, TimeSlot fixedSlot2) {
        TimeSlot annBegin = graphEndpoints[0];
        TimeSlot annEnd = graphEndpoints[0];
        List<Annotation> annotsForTS = null;
        AlignableAnnotation currentAnn = null;
        boolean passedFixedSlot1 = false;
        boolean passedFixedSlot2 = false;
        if (annBegin == fixedSlot1 || annBegin.getTime() >= fixedSlot1.getTime()) {
            passedFixedSlot1 = true;
        }
        while (annEnd != null) {
            annotsForTS = this.getAnnotsBeginningAtTimeSlot(annBegin);
            if (annotsForTS != null && annotsForTS.size() > 0) {
                currentAnn = (AlignableAnnotation)annotsForTS.get(0);
                annEnd = currentAnn.getEnd();
                if (passedFixedSlot1 && !passedFixedSlot2 && annEnd != fixedSlot2 && annEnd.isTimeAligned() && annEnd.getTime() > fixedSlot1.getTime()) {
                    annEnd.setTime(fixedSlot1.getTime());
                }
                if (passedFixedSlot2 && annEnd.isTimeAligned() && annEnd.getTime() < fixedSlot2.getTime()) {
                    annEnd.setTime(fixedSlot2.getTime());
                }
                if (annEnd.getTime() >= fixedSlot1.getTime()) {
                    passedFixedSlot1 = true;
                }
                if (annEnd == fixedSlot2) {
                    passedFixedSlot2 = true;
                }
                annBegin = annEnd;
                if (annEnd != graphEndpoints[1]) continue;
                break;
            }
            annEnd = null;
        }
    }

    private void forceChildChainOutOfInterval(AlignableAnnotation aa, TimeSlot[] graphEndpoints, TimeSlot fixedSlot1, TimeSlot fixedSlot2, boolean left) {
        List<TierImpl> ct = this.getDependentTiers();
        block0: for (int i = 0; i < ct.size(); ++i) {
            TierImpl t = ct.get(i);
            if (t.getLinguisticType().getConstraints().getStereoType() != 0) continue;
            if (left) {
                t.forceAnnotChainOutOfFixedInterval(new TimeSlot[]{aa.getBegin(), aa.getEnd()}, fixedSlot1, fixedSlot2);
                continue;
            }
            TimeSlot annBegin = aa.getBegin();
            TimeSlot annEnd = aa.getBegin();
            List<Annotation> annotsForTS = null;
            AlignableAnnotation currentAnn = null;
            boolean passedFixedSlot1 = false;
            boolean passedFixedSlot2 = false;
            if (annBegin == fixedSlot1 || annBegin.getTime() >= fixedSlot1.getTime()) {
                passedFixedSlot1 = true;
            }
            if (annBegin == fixedSlot2 || annBegin.getTime() >= fixedSlot2.getTime()) {
                passedFixedSlot2 = true;
            }
            while (annEnd != null) {
                annotsForTS = t.getAnnotsBeginningAtTimeSlot(annBegin);
                if (annotsForTS != null && annotsForTS.size() > 0) {
                    currentAnn = (AlignableAnnotation)annotsForTS.get(0);
                    annEnd = currentAnn.getEnd();
                    if (passedFixedSlot1 && !passedFixedSlot2 && annEnd != fixedSlot2 && annEnd.isTimeAligned() && annEnd != graphEndpoints[1] && annEnd.getTime() > fixedSlot1.getTime()) {
                        annEnd.setTime(fixedSlot1.getTime());
                    }
                    if (passedFixedSlot2 && annEnd != graphEndpoints[1] && annEnd.isTimeAligned() && annEnd.getTime() < fixedSlot2.getTime()) {
                        annEnd.setTime(fixedSlot2.getTime());
                    }
                    if (annEnd.getTime() >= fixedSlot1.getTime()) {
                        passedFixedSlot1 = true;
                    }
                    if (annEnd == fixedSlot2) {
                        passedFixedSlot2 = true;
                    }
                    annBegin = annEnd;
                    if (annEnd != graphEndpoints[1]) continue;
                    continue block0;
                }
                annEnd = null;
            }
        }
    }

    private void repositionUnalignedSlots(TimeSlot graphBegin) {
        TimeSlot annBegin = graphBegin;
        TimeSlot annEnd = graphBegin;
        List<Annotation> annotsForTS = null;
        AlignableAnnotation currentAnn = null;
        while (annEnd != null) {
            annotsForTS = this.getAnnotsBeginningAtTimeSlot(annBegin);
            if (annotsForTS != null && annotsForTS.size() > 0) {
                currentAnn = (AlignableAnnotation)annotsForTS.get(0);
                annEnd = currentAnn.getEnd();
                if (annBegin.isAfter(annEnd) && annBegin.isTimeAligned() && !annEnd.isTimeAligned() || annBegin.isAfter(annEnd) && !annBegin.isTimeAligned() && !annEnd.isTimeAligned()) {
                    this.transcription.getTimeOrder().removeTimeSlot(annEnd);
                    this.transcription.getTimeOrder().insertTimeSlot(annEnd, annBegin, null);
                }
                if (annBegin.isAfter(annEnd) && !annBegin.isTimeAligned() && annEnd.isTimeAligned()) {
                    this.transcription.getTimeOrder().removeTimeSlot(annBegin);
                    this.transcription.getTimeOrder().insertTimeSlot(annBegin, null, annEnd);
                }
                annBegin = annEnd;
                continue;
            }
            annEnd = null;
        }
    }

    public void correctOverlapsByPushing(AlignableAnnotation fixedAnnotation, long oldBegin, long oldEnd) {
        long timeGap;
        AlignableAnnotation a;
        long newBegin = fixedAnnotation.getBegin().getTime();
        long newEnd = fixedAnnotation.getEnd().getTime();
        long storeOldEnd = oldEnd;
        if (newEnd > oldEnd) {
            a = null;
            timeGap = 0L;
            long rightShift = newEnd - oldEnd;
            Iterator<Annotation> annIter = this.annotations.iterator();
            while (annIter.hasNext() && (a = (AlignableAnnotation)annIter.next()) != fixedAnnotation) {
            }
            while (annIter.hasNext()) {
                a = (AlignableAnnotation)annIter.next();
                timeGap = a.getBegin().getTime() - oldEnd;
                if (timeGap > 0L) {
                    rightShift -= timeGap;
                }
                if (rightShift > 0L) {
                    oldEnd = a.getEnd().getTime();
                    this.shiftConnectedAnnots(a, rightShift);
                }
                if (rightShift > 0L) continue;
            }
        }
        if (newBegin < oldBegin && fixedAnnotation.getBegin().isTimeAligned() || oldBegin == storeOldEnd) {
            a = null;
            timeGap = 0L;
            long leftShift = oldBegin - newBegin;
            boolean leftShiftNotYetSpecified = false;
            if (oldBegin == storeOldEnd) {
                leftShiftNotYetSpecified = true;
            }
            ArrayList<Annotation> annVector = new ArrayList<Annotation>(this.annotations);
            ListIterator annIter2 = annVector.listIterator();
            while (annIter2.hasNext() && (a = (AlignableAnnotation)annIter2.next()) != fixedAnnotation) {
            }
            boolean firstIteration = true;
            while (annIter2.hasPrevious()) {
                a = (AlignableAnnotation)annIter2.previous();
                if (a == fixedAnnotation) {
                    firstIteration = false;
                    continue;
                }
                timeGap = oldBegin - a.getEnd().getTime();
                if (timeGap > 0L) {
                    leftShift -= timeGap;
                }
                if ((leftShift > 0L || leftShiftNotYetSpecified) && !firstIteration) {
                    if (leftShiftNotYetSpecified) {
                        leftShift = a.getEnd().getTime() - storeOldEnd;
                        if (leftShift < 0L) {
                            leftShift = 0L;
                        }
                        leftShiftNotYetSpecified = false;
                    }
                    oldBegin = a.getBegin().getTime();
                    this.shiftConnectedAnnots(a, -leftShift);
                }
                if (leftShift <= 0L) break;
                firstIteration = false;
            }
        }
    }

    private void shiftConnectedAnnots(AlignableAnnotation ann, long shift) {
        TreeSet<AbstractAnnotation> connectedAnnots = new TreeSet<AbstractAnnotation>();
        TreeSet connectedTimeSlots = new TreeSet();
        this.getTranscription().getConnectedAnnots(connectedAnnots, connectedTimeSlots, ann);
        TimeSlot prevSlot = null;
        for (TimeSlot ts : connectedTimeSlots) {
            if (ts.isTimeAligned()) {
                if (ts.getTime() + shift < 0L) {
                    ts.setTime(0L);
                } else if (prevSlot != null && !prevSlot.isTimeAligned()) {
                    this.transcription.getTimeOrder().removeTimeSlot(ts);
                    this.transcription.getTimeOrder().insertTimeSlot(ts, prevSlot, null);
                    ts.setTime(ts.getTime() + shift);
                } else {
                    ts.setTime(ts.getTime() + shift);
                }
            } else if (prevSlot != null) {
                this.transcription.getTimeOrder().removeTimeSlot(ts);
                this.transcription.getTimeOrder().insertTimeSlot(ts, prevSlot, null);
            }
            prevSlot = ts;
        }
        if (connectedAnnots.size() > 0) {
            this.markAnnotationsForDeletion(connectedAnnots);
            this.transcription.pruneAnnotations(this);
        }
    }

    private void markAnnotationsForDeletion(Collection<? extends Annotation> annots) {
        for (Annotation annotation : annots) {
            if (!(annotation instanceof AlignableAnnotation) || ((AlignableAnnotation)annotation).calculateBeginTime() < ((AlignableAnnotation)annotation).calculateEndTime()) continue;
            annotation.markDeleted(true);
        }
    }

    public boolean pruneAnnotations() {
        boolean somethingChanged = false;
        TreeSet<Annotation> copiedAnnotations = new TreeSet<Annotation>((SortedSet<Annotation>)this.annotations);
        for (Annotation ann : copiedAnnotations) {
            if (!ann.isMarkedDeleted()) continue;
            Constraint c = this.linguisticType.getConstraints();
            if (c != null) {
                c.detachAnnotation(ann, this);
            }
            this.annotations.remove(ann);
            somethingChanged = true;
        }
        return somethingChanged;
    }

    private void setMetadata(String element, Object value) {
        if (element == null || value == null) {
            return;
        }
        this.tierMetadata.put(element, value);
        this.modified(2, null);
    }

    private Object getMetadataValue(String element) {
        if (element == null) {
            return null;
        }
        return this.tierMetadata.get(element);
    }

    @Override
    public void setLinguisticType(LinguisticType theType) {
        this.linguisticType = theType;
        this.updateCVEntryIds();
        this.modified(2, null);
    }

    @Override
    public LinguisticType getLinguisticType() {
        return this.linguisticType;
    }

    @Override
    public String getParticipant() {
        String participant = "not specified";
        if (this.getMetadataValue("PARTICIPANT") != null) {
            participant = (String)this.getMetadataValue("PARTICIPANT");
        }
        return participant;
    }

    @Override
    public void setParticipant(String theParticipant) {
        this.setMetadata("PARTICIPANT", theParticipant);
    }

    @Override
    public String getAnnotator() {
        String annotator = (String)this.getMetadataValue("ANNOTATOR");
        return annotator != null ? annotator : "";
    }

    @Override
    public void setAnnotator(String annotator) {
        this.setMetadata("ANNOTATOR", annotator);
    }

    public Locale getDefaultLocale() {
        Locale locale = null;
        Object val = this.getMetadataValue("DEFAULT_LOCALE");
        if (val instanceof Locale) {
            locale = (Locale)val;
        }
        return locale;
    }

    public void setDefaultLocale(Locale l) {
        if (l == null) {
            this.setMetadata("DEFAULT_LOCALE", "");
        } else {
            this.setMetadata("DEFAULT_LOCALE", l);
        }
    }

    public void setParentTier(TierImpl newParent) {
        if (this.annotations.size() > 0) {
            return;
        }
        this.parentTier = newParent;
        this.modified(2, null);
    }

    @Override
    public void setParentTier(Tier newParent) {
        this.setParentTier((TierImpl)newParent);
    }

    private void enforceConstraints() {
        if (this.linguisticType.hasConstraints()) {
            Constraint c = this.linguisticType.getConstraints();
            c.enforceOnWholeTier(this);
        }
    }

    private Annotation selectParentCandidate(TierImpl parent, Annotation forAnnotation) {
        Annotation selectedCandidate = null;
        long begin = forAnnotation.getBeginTimeBoundary();
        long end = forAnnotation.getEndTimeBoundary();
        List<Annotation> candidates = parent.getOverlappingAnnotations(begin, end);
        Iterator<Annotation> candIter = candidates.iterator();
        while (candIter.hasNext()) {
            boolean candAvailable = true;
            Annotation cand = candIter.next();
            for (Annotation listener : ((AbstractAnnotation)cand).getParentListeners()) {
                if (listener.getTier() != this) continue;
                candAvailable = false;
                break;
            }
            if (!candAvailable) continue;
            selectedCandidate = cand;
            break;
        }
        return selectedCandidate;
    }

    @Override
    public TierImpl getParentTier() {
        return this.parentTier;
    }

    @Override
    public boolean hasParentTier() {
        return this.parentTier != null;
    }

    @Override
    public final TierImpl getRootTier() {
        if (this.parentTier == null) {
            return this;
        }
        return this.parentTier.getRootTier();
    }

    public final TierImpl getTimeSubDivAncestor() {
        Constraint constraint = this.getLinguisticType().getConstraints();
        if (constraint != null && constraint.getStereoType() == 0) {
            return this;
        }
        if (this.parentTier != null) {
            return this.parentTier.getTimeSubDivAncestor();
        }
        return null;
    }

    @Override
    public boolean hasAncestor(Tier ancestor) {
        if (this.parentTier == null) {
            return false;
        }
        if (this.parentTier == ancestor) {
            return true;
        }
        return this.parentTier.hasAncestor(ancestor);
    }

    public List<TierImpl> getDependentTiers() {
        ArrayList<TierImpl> depTiers = new ArrayList<TierImpl>();
        for (TierImpl t : this.transcription.getTiers()) {
            if (!t.hasAncestor(this)) continue;
            depTiers.add(t);
        }
        return depTiers;
    }

    public List<TierImpl> getChildTiers() {
        ArrayList<TierImpl> childTiers = new ArrayList<TierImpl>();
        for (TierImpl t : this.transcription.getTiers()) {
            if (t.getParentTier() != this) continue;
            childTiers.add(t);
        }
        return childTiers;
    }

    public Annotation getAnnotationAtTime(long theTime, boolean forceRecalculation) {
        Annotation result = null;
        if (!this.isTimeAlignable() || !forceRecalculation) {
            for (Annotation annotation : this.annotations) {
                if (annotation.getBeginTimeBoundary() > theTime || annotation.getEndTimeBoundary() <= theTime) continue;
                result = annotation;
                break;
            }
        } else if (this.getParentTier() == null || this.linguisticType.getConstraints() != null && this.linguisticType.getConstraints().getStereoType() == 1) {
            for (AlignableAnnotation alignableAnnotation : this.annotations) {
                long b = alignableAnnotation.calculateBeginTime();
                long e = alignableAnnotation.calculateEndTime();
                if (b > theTime || e <= theTime) continue;
                result = alignableAnnotation;
                break;
            }
        } else {
            TierImpl tierImpl;
            AlignableAnnotation rootAnn;
            for (AlignableAnnotation alignableAnnotation : this.annotations) {
                if (!alignableAnnotation.getBegin().isTimeAligned() || !alignableAnnotation.getEnd().isTimeAligned()) continue;
                if (alignableAnnotation.getBegin().getTime() <= theTime && alignableAnnotation.getEnd().getTime() > theTime) {
                    result = alignableAnnotation;
                    break;
                }
                if (alignableAnnotation.getBegin().getTime() <= theTime) continue;
                break;
            }
            if (result == null && (rootAnn = (AlignableAnnotation)(tierImpl = this.getRootTier()).getAnnotationAtTime(theTime)) != null) {
                ArrayList<TierImpl> relTiers = new ArrayList<TierImpl>();
                relTiers.add(this);
                for (TierImpl pt = this.getParentTier(); pt != null; pt = pt.getParentTier()) {
                    relTiers.add(0, pt);
                }
                TimeProposer2 tp2 = new TimeProposer2();
                result = tp2.getAnnotationAtTime(relTiers, rootAnn, this, theTime);
            }
        }
        return result;
    }

    public Annotation getAnnotationAtTime(long theTime) {
        return this.getAnnotationAtTime(theTime, false);
    }

    public List<Annotation> getOverlappingAnnotations(long t1, long t2) {
        ArrayList<Annotation> annots = new ArrayList<Annotation>();
        for (Annotation ann : this.annotations) {
            long b = ann.getBeginTimeBoundary();
            long e = ann.getEndTimeBoundary();
            if (!(t1 <= b && b < t2 || t1 < e && e <= t2 || b <= t1 && t1 < e) && (b >= t2 || t2 > e)) continue;
            annots.add(ann);
        }
        return annots;
    }

    public List<AlignableAnnotation> getOverlappingAnnotations(TimeSlot t1, TimeSlot t2) {
        ArrayList<AlignableAnnotation> v = new ArrayList<AlignableAnnotation>();
        if (!this.isTimeAlignable()) {
            return v;
        }
        for (Annotation a : this.annotations) {
            AlignableAnnotation ann = (AlignableAnnotation)a;
            TimeSlot bt = ann.getBegin();
            TimeSlot et = ann.getEnd();
            if (!(et.getIndex() > t1.getIndex() && et.getIndex() < t2.getIndex() || bt.getIndex() > t1.getIndex() && bt.getIndex() < t2.getIndex()) && (bt.getIndex() >= t1.getIndex() || et.getIndex() <= t2.getIndex())) continue;
            v.add(ann);
        }
        return v;
    }

    public List<AlignableAnnotation> getOverlappingAnnotationsIncludeExtremes(TimeSlot t1, TimeSlot t2) {
        ArrayList<AlignableAnnotation> v = new ArrayList<AlignableAnnotation>();
        if (!this.isTimeAlignable()) {
            return v;
        }
        for (Annotation a : this.annotations) {
            AlignableAnnotation ann = (AlignableAnnotation)a;
            TimeSlot bt = ann.getBegin();
            TimeSlot et = ann.getEnd();
            if (!(et.getIndex() > t1.getIndex() && et.getIndex() <= t2.getIndex() || bt.getIndex() >= t1.getIndex() && bt.getIndex() < t2.getIndex()) && (bt.getIndex() >= t1.getIndex() || et.getIndex() <= t2.getIndex())) continue;
            v.add(ann);
        }
        return v;
    }

    public List<Annotation> getAnnotationsUsingTimeSlot(TimeSlot theSlot) {
        ArrayList<Annotation> resultAnnots = new ArrayList<Annotation>();
        if (!this.isTimeAlignable()) {
            return resultAnnots;
        }
        for (Annotation ann : this.annotations) {
            if (!(ann instanceof AlignableAnnotation) || ((AlignableAnnotation)ann).getBegin() != theSlot && ((AlignableAnnotation)ann).getEnd() != theSlot) continue;
            resultAnnots.add(ann);
        }
        return resultAnnots;
    }

    public List<Annotation> getAnnotsBeginningAtTimeSlot(TimeSlot theSlot) {
        ArrayList<Annotation> resultAnnots = new ArrayList<Annotation>();
        if (!this.isTimeAlignable()) {
            return resultAnnots;
        }
        boolean foundOne = false;
        for (Annotation ann : this.annotations) {
            if (!(ann instanceof AlignableAnnotation)) continue;
            if (((AlignableAnnotation)ann).getBegin() == theSlot) {
                foundOne = true;
                resultAnnots.add(ann);
                if (this.linguisticType == null || this.linguisticType.getConstraints() == null || this.linguisticType.getConstraints().getStereoType() == 0 || this.linguisticType.getConstraints().getStereoType() != 1) continue;
                continue;
            }
            if (!foundOne || this.linguisticType == null || this.linguisticType.getConstraints() == null || this.linguisticType.getConstraints().getStereoType() != 0 && this.linguisticType.getConstraints().getStereoType() != 1) continue;
            break;
        }
        return resultAnnots;
    }

    public List<Annotation> getAnnotsEndingAtTimeSlot(TimeSlot theSlot) {
        ArrayList<Annotation> resultAnnots = new ArrayList<Annotation>();
        if (!this.isTimeAlignable()) {
            return resultAnnots;
        }
        boolean foundOne = false;
        for (Annotation ann : this.annotations) {
            if (!(ann instanceof AlignableAnnotation)) continue;
            if (((AlignableAnnotation)ann).getEnd() == theSlot) {
                foundOne = true;
                resultAnnots.add(ann);
                if (this.linguisticType == null || this.linguisticType.getConstraints() == null || this.linguisticType.getConstraints().getStereoType() == 0 || this.linguisticType.getConstraints().getStereoType() != 1) continue;
                continue;
            }
            if (!foundOne || this.linguisticType == null || this.linguisticType.getConstraints() == null || this.linguisticType.getConstraints().getStereoType() != 0 && this.linguisticType.getConstraints().getStereoType() != 1) continue;
            break;
        }
        return resultAnnots;
    }

    public boolean isTimeAlignable() {
        boolean timeAlignable = true;
        if (this.linguisticType != null) {
            timeAlignable = this.linguisticType.isTimeAlignable();
        }
        return timeAlignable;
    }

    public long proposeTimeFor(TimeSlot theSlot) {
        long proposedTime = 0L;
        if (!this.hasParentTier()) {
            return this.transcription.getTimeOrder().proposeTimeFor(theSlot);
        }
        TimeSlot[] graphEndpoints = this.getEndpointsOfSubchain(theSlot, true);
        TimeSlot aBegin = graphEndpoints[0];
        TimeSlot aEnd = graphEndpoints[0];
        List<Annotation> annsForTS = null;
        AlignableAnnotation currentA = null;
        boolean beginFound = false;
        int unalignedCounter = 1;
        int foundAtPosition = 0;
        TimeSlot segBegin = aBegin;
        TimeSlot segEnd = graphEndpoints[1];
        if (theSlot == aEnd) {
            aEnd = null;
        }
        while (aEnd != null) {
            annsForTS = this.getAnnotsBeginningAtTimeSlot(aBegin);
            if (annsForTS != null && annsForTS.size() > 0) {
                currentA = (AlignableAnnotation)annsForTS.get(0);
                aEnd = currentA.getEnd();
                if (aEnd.isTimeAligned() && !beginFound) {
                    segBegin = aEnd;
                    unalignedCounter = 1;
                    foundAtPosition = 0;
                }
                if (!aEnd.isTimeAligned() && aEnd != segEnd) {
                    ++unalignedCounter;
                    if (!beginFound) {
                        ++foundAtPosition;
                    }
                }
                if (aEnd.isTimeAligned() && beginFound) {
                    segEnd = aEnd;
                    break;
                }
                if (aEnd == theSlot) {
                    beginFound = true;
                }
                aBegin = aEnd;
                continue;
            }
            aEnd = null;
        }
        long segB = 0L;
        long segE = 0L;
        if (this.getParentTier() != null) {
            segB = !segBegin.isTimeAligned() ? this.getParentTier().proposeTimeFor(segBegin) : segBegin.getTime();
            segE = !segEnd.isTimeAligned() ? this.getParentTier().proposeTimeFor(segEnd) : segEnd.getTime();
        }
        proposedTime = segB + (long)foundAtPosition * ((segE - segB) / (long)unalignedCounter);
        if (theSlot == segBegin && !segBegin.isTimeAligned()) {
            proposedTime = segB;
        }
        if (theSlot == segEnd && !segEnd.isTimeAligned()) {
            proposedTime = segE;
        }
        return proposedTime;
    }

    private void correctDependingOverlaps(AlignableAnnotation a) {
        int i;
        TierImpl tier;
        List<TierImpl> depTiers = this.getDependentTiers();
        depTiers.add(0, this);
        ArrayList<AlignableAnnotation> annots = new ArrayList<AlignableAnnotation>();
        TimeSlot bts = a.getBegin();
        TimeSlot ets = a.getEnd();
        for (int i2 = 0; i2 < depTiers.size(); ++i2) {
            tier = depTiers.get(i2);
            if (!tier.isTimeAlignable()) continue;
            this.getAnnotsChainStartingWithSlot(annots, tier, bts, ets);
            this.getAnnotsChainEndingWithSlot(annots, tier, ets, bts);
        }
        boolean pruneNeeded = false;
        for (i = 0; i < annots.size(); ++i) {
            AlignableAnnotation ann = (AlignableAnnotation)annots.get(i);
            if (ann == a || ann.isMarkedDeleted()) continue;
            ann.markDeleted(true);
            pruneNeeded = true;
        }
        for (i = 0; i < depTiers.size(); ++i) {
            tier = depTiers.get(i);
            if (tier == this || !tier.isTimeAlignable()) continue;
            tier.repositionUnalignedSlots(a.getEnd());
        }
        if (pruneNeeded) {
            for (i = 0; i < depTiers.size(); ++i) {
                tier = depTiers.get(i);
                tier.pruneAnnotationsWithoutDetach();
            }
        }
    }

    private void getAnnotsChainStartingWithSlot(ArrayList<AlignableAnnotation> annots, TierImpl tier, TimeSlot bts, TimeSlot ets) {
        List<Annotation> v = tier.getAnnotsBeginningAtTimeSlot(bts);
        for (int i = 0; i < v.size(); ++i) {
            AlignableAnnotation ann = (AlignableAnnotation)v.get(i);
            if (annots.contains(ann)) continue;
            annots.add(ann);
            if (ann.getEnd() == ets) continue;
            this.getAnnotsChainStartingWithSlot(annots, tier, ann.getEnd(), ets);
        }
    }

    private void getAnnotsChainEndingWithSlot(ArrayList<AlignableAnnotation> annots, TierImpl tier, TimeSlot ets, TimeSlot bts) {
        List<Annotation> v = tier.getAnnotsEndingAtTimeSlot(ets);
        for (int i = 0; i < v.size(); ++i) {
            AlignableAnnotation ann = (AlignableAnnotation)v.get(i);
            if (annots.contains(ann)) continue;
            annots.add(ann);
            if (ann.getBegin() == bts) continue;
            this.getAnnotsChainEndingWithSlot(annots, tier, ann.getBegin(), bts);
        }
    }

    public void pruneAnnotationsWithoutDetach() {
        Iterator<Annotation> annIter = this.annotations.iterator();
        while (annIter.hasNext()) {
            Annotation ann = annIter.next();
            if (!ann.isMarkedDeleted()) continue;
            annIter.remove();
            this.transcription.modified(6, ann);
        }
    }

    public Pair<ControlledVocabulary, Integer> getEffectiveLanguage() {
        if (this.transcription == null || !(this.transcription instanceof TranscriptionImpl)) {
            return null;
        }
        LinguisticType lt = this.getLinguisticType();
        String cvname = lt.getControlledVocabularyName();
        if (cvname == null || cvname.isEmpty()) {
            return new Pair<Object, Integer>(null, 0);
        }
        ControlledVocabulary cv = this.transcription.getControlledVocabulary(cvname);
        if (cv == null) {
            return null;
        }
        int langIndex = -1;
        String tierLanguage = this.getLangRef();
        if (tierLanguage != null) {
            langIndex = cv.getIndexOfLanguage(tierLanguage);
        }
        if (langIndex < 0) {
            String transcriptionLanguage = this.transcription.getCVLanguage();
            langIndex = cv.getIndexOfLanguage(transcriptionLanguage);
        }
        return new Pair<ControlledVocabulary, Integer>(cv, langIndex);
    }

    public void updateCVLanguage() {
        if (this.annotations.isEmpty()) {
            return;
        }
        Pair<ControlledVocabulary, Integer> pair = this.getEffectiveLanguage();
        if (pair == null) {
            return;
        }
        ControlledVocabulary cv = pair.getFirst();
        int langIndex = pair.getSecond();
        if (cv == null || langIndex < 0) {
            return;
        }
        if (cv instanceof ExternalCV && !((ExternalCV)cv).isLoadedFromURL() && !((ExternalCV)cv).isLoadedFromCache()) {
            return;
        }
        for (Annotation a : this.annotations) {
            String cveId = a.getCVEntryId();
            CVEntry cve = cv.getEntrybyId(cveId);
            if (cve == null) {
                a.setCVEntryId(null);
                continue;
            }
            String newWord = cve.getValue(langIndex);
            if (newWord.isEmpty()) continue;
            a.setValue(newWord);
        }
    }

    public void updateCVEntryIds() {
        if (this.annotations.isEmpty()) {
            return;
        }
        Pair<ControlledVocabulary, Integer> pair = this.getEffectiveLanguage();
        if (pair == null) {
            return;
        }
        ControlledVocabulary cv = pair.getFirst();
        int langIndex = pair.getSecond();
        if (cv == null) {
            for (Annotation a : this.annotations) {
                a.setCVEntryId(null);
            }
            return;
        }
        if (langIndex < 0) {
            return;
        }
        if (cv instanceof ExternalCV && !((ExternalCV)cv).isLoadedFromURL() && !((ExternalCV)cv).isLoadedFromCache()) {
            return;
        }
        for (Annotation a : this.annotations) {
            CVEntry cve = cv.getEntryWithValue(langIndex, a.getValue());
            if (cve != null) {
                a.setCVEntryId(cve.getId());
                continue;
            }
            a.setCVEntryId(null);
        }
    }

    @Override
    public String getExtRef() {
        return this.extRef;
    }

    @Override
    public void setExtRef(String extRef) {
        this.extRef = extRef;
    }

    @Override
    public String getLangRef() {
        return this.langRef;
    }

    @Override
    public void setLangRef(String newLangRef) {
        if (this.langRef == newLangRef || this.langRef != null && this.langRef.equals(newLangRef)) {
            return;
        }
        this.langRef = newLangRef;
        this.updateCVLanguage();
    }

    public static class LocaleGetter
    implements ValueGetter {
        @Override
        public String getSortValue(TierImpl t) {
            return t.getDefaultLocale() == null ? "" : t.getDefaultLocale().toString();
        }
    }

    public static class ParentTierNameGetter
    implements ValueGetter {
        @Override
        public String getSortValue(TierImpl t) {
            return t.getParentTier() == null ? "" : t.getParentTier().getName();
        }
    }

    public static class NameGetter
    implements ValueGetter {
        @Override
        public String getSortValue(TierImpl t) {
            return t.getName();
        }
    }

    public static class LanguageGetter
    implements ValueGetter {
        @Override
        public String getSortValue(TierImpl t) {
            String l = t.getLangRef();
            return l == null ? "" : l;
        }
    }

    public static class LinguisticTypeNameGetter
    implements ValueGetter {
        @Override
        public String getSortValue(TierImpl t) {
            return t.getLinguisticType().getLinguisticTypeName();
        }
    }

    public static class ParticipantGetter
    implements ValueGetter {
        @Override
        public String getSortValue(TierImpl t) {
            return t.getParticipant();
        }
    }

    public static class AnnotatorGetter
    implements ValueGetter {
        @Override
        public String getSortValue(TierImpl t) {
            return t.getAnnotator();
        }
    }

    public static interface ValueGetter {
        public String getSortValue(TierImpl var1);
    }
}

