/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.delimitedtext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.TimeFormatter;

public class DelimitedTextReader {
    private final String TAB = "\t";
    private final String SC = ";";
    private final String COLON = ":";
    private final String COMMA = ",";
    private final String PIPE = "\\|";
    private File sourceFile;
    private String delimiter = "\t";
    private int numColumns = 1;
    private int firstRowIndex = 0;

    public DelimitedTextReader(File sourceFile) throws FileNotFoundException {
        this.sourceFile = sourceFile;
        if (!sourceFile.exists()) {
            throw new FileNotFoundException("Input file does not exist");
        }
        try {
            this.delimiter = this.detectDelimiter();
        }
        catch (IOException ioe) {
            ServerLogger.LOG.warning("Unable to detect the delimiter");
        }
        try {
            this.numColumns = this.detectNumColumns();
        }
        catch (IOException ioe) {
            ServerLogger.LOG.warning("Unable to detect the delimiter");
        }
    }

    public DelimitedTextReader(String fileName) throws FileNotFoundException {
        if (fileName == null) {
            throw new NullPointerException("The file name is null");
        }
        if (fileName.startsWith("file:")) {
            fileName = fileName.substring(5);
        }
        this.sourceFile = new File(fileName);
        if (!this.sourceFile.exists()) {
            throw new FileNotFoundException("Input file does not exist");
        }
        try {
            this.delimiter = this.detectDelimiter();
        }
        catch (IOException ioe) {
            ServerLogger.LOG.warning("Unable to detect the delimiter");
        }
        try {
            this.numColumns = this.detectNumColumns();
        }
        catch (IOException ioe) {
            ServerLogger.LOG.warning("Unable to detect the number of columns");
        }
    }

    private String detectDelimiterPr() throws IOException {
        if (this.sourceFile == null) {
            throw new IOException("No source file specified");
        }
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), "UTF-8");
        BufferedReader bufRead = new BufferedReader(fileReader);
        int maxNumLines = 10;
        int numLines = 0;
        String[] valArray = new String[]{"\t", ";", ":", ",", "\\|"};
        int[] counts = new int[valArray.length];
        Pattern[] pats = new Pattern[valArray.length];
        for (int i = 0; i < valArray.length; ++i) {
            pats[i] = Pattern.compile(valArray[i]);
        }
        String line = null;
        while ((line = bufRead.readLine()) != null && numLines < maxNumLines) {
            if (line.length() == 0) continue;
            ++numLines;
            for (int i = 0; i < pats.length; ++i) {
                int n = i;
                counts[n] = counts[n] + (pats[i].split(line).length - 1);
            }
        }
        try {
            bufRead.close();
        }
        catch (IOException i) {
            // empty catch block
        }
        String del = null;
        int maxCount = 0;
        int maxIndex = 0;
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] <= maxCount) continue;
            maxCount = counts[i];
            maxIndex = i;
        }
        del = valArray[maxIndex];
        if (del == null) {
            del = "\t";
        }
        this.delimiter = del;
        return del;
    }

    public String detectDelimiter() throws IOException {
        String del = this.detectDelimiterPr();
        if ("\\|".equals(del)) {
            return "|";
        }
        return del;
    }

    public int detectNumColumns() throws IOException {
        if (this.sourceFile == null) {
            throw new IOException("No source file specified");
        }
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), "UTF-8");
        BufferedReader bufRead = new BufferedReader(fileReader);
        int maxNumLines = 20;
        int numLines = 0;
        int numCols = 0;
        String line = null;
        Pattern pat = Pattern.compile(this.delimiter);
        while ((line = bufRead.readLine()) != null && numLines < maxNumLines) {
            if (line.length() == 0) continue;
            ++numLines;
            String[] nextRow = pat.split(line, -1);
            numCols += nextRow.length;
        }
        try {
            bufRead.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (numLines > 0 && numCols > 0) {
            this.numColumns = Math.round((float)numCols / (float)numLines);
            return this.numColumns;
        }
        return 1;
    }

    public TimeFormatter.TIME_FORMAT detectTimeFormat(int timeColumn) throws IOException {
        if (this.sourceFile == null) {
            throw new IOException("No source file specified");
        }
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), "UTF-8");
        BufferedReader bufRead = new BufferedReader(fileReader);
        int maxNumLines = 20;
        int numLines = 0;
        String line = null;
        Pattern pat = Pattern.compile(this.delimiter);
        int hmCount = 0;
        int secCount = 0;
        int msCount = 0;
        int numTimesRead = 0;
        while ((line = bufRead.readLine()) != null && numLines < maxNumLines) {
            if (line.length() == 0) continue;
            ++numLines;
            String[] nextRow = pat.split(line, -1);
            if (nextRow.length <= timeColumn) continue;
            String timeString = nextRow[timeColumn];
            if (timeString.indexOf(58) > -1) {
                ++hmCount;
            } else if (timeString.indexOf(46) > -1 || timeString.indexOf(44) > -1) {
                ++secCount;
            } else {
                ++msCount;
            }
            ++numTimesRead;
        }
        try {
            bufRead.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (numTimesRead > 1) {
            if (hmCount > secCount && hmCount > msCount) {
                return TimeFormatter.TIME_FORMAT.HHMMSSMS;
            }
            if (secCount > hmCount && secCount >= msCount) {
                return TimeFormatter.TIME_FORMAT.SSMS;
            }
            if (msCount > hmCount && msCount > secCount) {
                return TimeFormatter.TIME_FORMAT.MS;
            }
        }
        return null;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        if (delimiter != null) {
            this.delimiter = delimiter;
            if (delimiter.equals("|")) {
                this.delimiter = "\\|";
            }
        }
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    public List<String[]> getRowDataForColumns(int[] columns) throws IOException {
        return this.getRowDataForColumns(this.firstRowIndex, columns);
    }

    public List<String[]> getRowDataForColumns(int firstRow, int[] columns) throws IOException {
        if (this.sourceFile == null || columns == null) {
            throw new IOException("No source file specified");
        }
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), "UTF-8");
        BufferedReader bufRead = new BufferedReader(fileReader);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        String line = null;
        int rowCount = 0;
        Pattern pat = Pattern.compile(this.delimiter);
        while ((line = bufRead.readLine()) != null) {
            if (line.length() == 0) continue;
            if (rowCount < firstRow) {
                ++rowCount;
                continue;
            }
            String[] nextRow = pat.split(line);
            String[] row = new String[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                row[i] = columns[i] < nextRow.length ? nextRow[columns[i]] : "";
            }
            rows.add(row);
            ++rowCount;
        }
        try {
            bufRead.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rows;
    }

    public List<String[]> getSamples(int rowCount) throws IOException {
        if (this.sourceFile == null) {
            throw new IOException("No source file specified");
        }
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), "UTF-8");
        BufferedReader bufRead = new BufferedReader(fileReader);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        String line = null;
        int count = 0;
        Pattern pat = Pattern.compile(this.delimiter);
        while ((line = bufRead.readLine()) != null && count < rowCount) {
            if (line.length() == 0) continue;
            String[] nextRow = pat.split(line);
            rows.add(nextRow);
            ++count;
        }
        try {
            bufRead.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rows;
    }

    public int getFirstRowIndex() {
        return this.firstRowIndex;
    }

    public void setFirstRowIndex(int firstRow) {
        this.firstRowIndex = firstRow;
    }
}

