/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.ACM30TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF30Parser;
import nl.mpi.util.FileUtility;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ACMTranscriptionStore {
    private ACMTranscriptionStore() {
    }

    public static final TranscriptionStore getCurrentTranscriptionStore() {
        return new ACM30TranscriptionStore();
    }

    public static final Parser getCurrentEAFParser() {
        return new EAF30Parser();
    }

    public static final EntityResolver getCurrentEAFResolver() {
        return null;
    }

    public static final String getCurrentEAFSchemaLocal() {
        return "/mpi/eudico/resources/EAFv3.0.xsd";
    }

    public static final String getCurrentEAFSchemaRemote() {
        return "http://www.mpi.nl/tools/elan/EAFv3.0.xsd";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int eafFileFormatTaster(String trPathName) {
        InputSource is = null;
        int version = 16;
        try {
            is = ACMTranscriptionStore.toInputSource(trPathName);
            if (is == null) {
                return version;
            }
        }
        catch (IOException ioe) {
            return version;
        }
        TasterContentHandler handler = new TasterContentHandler();
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            parserFactory.setNamespaceAware(true);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema eafSchema = schemaFactory.newSchema(ACMTranscriptionStore.class.getResource(ACMTranscriptionStore.getCurrentEAFSchemaLocal()));
            parserFactory.setSchema(eafSchema);
            SAXParser parser = parserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (SAXParseException parserFactory) {
        }
        catch (SAXException sax) {
            int schemaFactory = version;
            return schemaFactory;
        }
        catch (ParserConfigurationException pce) {
            int schemaFactory = version;
            return schemaFactory;
        }
        catch (IOException ioe) {
            int schemaFactory = version;
            return schemaFactory;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (is.getByteStream() != null) {
                    is.getByteStream().close();
                } else if (is.getCharacterStream() != null) {
                    is.getCharacterStream().close();
                }
            }
            catch (Throwable eafSchema) {}
        }
        if (handler.format != null) {
            int majorVersion = 0;
            int minorVersion = 0;
            String[] mmVersion = handler.format.split("\\.");
            if (mmVersion.length >= 2) {
                try {
                    majorVersion = Integer.parseInt(mmVersion[0]);
                    minorVersion = Integer.parseInt(mmVersion[1]);
                }
                catch (NumberFormatException parser) {
                    // empty catch block
                }
            }
            int toolow = 11;
            int toohigh = 16;
            if (majorVersion < 2) {
                version = toolow;
            } else if (majorVersion == 2) {
                if (minorVersion < 7) {
                    version = toolow;
                } else if (minorVersion == 7) {
                    version = 14;
                } else if (minorVersion == 8) {
                    version = 15;
                } else if (minorVersion > 8) {
                    version = toohigh;
                }
            } else if (majorVersion > 2) {
                version = toohigh;
            }
        }
        return version;
    }

    public static InputSource toInputSource(String trPathName) throws IOException {
        File trFile;
        if (trPathName == null) {
            return null;
        }
        if (trPathName.toLowerCase().startsWith("file:")) {
            trPathName = FileUtility.urlToAbsPath(trPathName);
        }
        if ((trFile = new File(trPathName)).exists()) {
            if (!trFile.isDirectory() && trFile.canRead()) {
                FileInputStream fis = new FileInputStream(trFile);
                InputSource is = new InputSource(fis);
                is.setSystemId(trPathName);
                return is;
            }
        } else {
            try {
                URI fileURI = new URI(trPathName);
                InputStream inStream = fileURI.toURL().openStream();
                InputSource is = new InputSource(inStream);
                is.setSystemId(trPathName);
                return is;
            }
            catch (URISyntaxException usex) {
                throw new IOException(usex);
            }
            catch (Throwable thr) {
                throw new IOException(thr);
            }
        }
        return null;
    }

    static class TasterContentHandler
    extends DefaultHandler {
        String format;

        TasterContentHandler() {
        }

        @Override
        public void startElement(String uri, String localname, String qName, Attributes atts) throws SAXException {
            if (localname.isEmpty()) {
                localname = qName;
            }
            if (localname.equals("ANNOTATION_DOCUMENT")) {
                this.format = atts.getValue("FORMAT");
            }
            throw new SAXParseException("Seen enough of the document", null);
        }
    }
}

