/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.util.Comparator;
import java.util.logging.Level;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.util.ServerLogger;

public class AnnotationRecordComparator
implements Comparator<AnnotationRecord> {
    private boolean includeIDs;

    public AnnotationRecordComparator() {
        this.includeIDs = false;
    }

    public AnnotationRecordComparator(boolean includeIDs) {
        this.includeIDs = includeIDs;
    }

    @Override
    public int compare(AnnotationRecord ar1, AnnotationRecord ar2) {
        if (ar1 == null || ar2 == null) {
            return 0;
        }
        if (ar1.getBeginTimeSlotRecord() != null && ar2.getBeginTimeSlotRecord() != null && ar1.getBeginTimeSlotRecord().getValue() > -1L && ar2.getBeginTimeSlotRecord().getValue() > -1L) {
            if (ar1.getBeginTimeSlotRecord().getValue() < ar2.getBeginTimeSlotRecord().getValue()) {
                return -1;
            }
            if (ar1.getBeginTimeSlotRecord().getValue() > ar2.getBeginTimeSlotRecord().getValue()) {
                return 1;
            }
        }
        if (ar1.getEndTimeSlotRecord() != null && ar2.getEndTimeSlotRecord() != null && ar1.getEndTimeSlotRecord().getValue() > -1L && ar2.getEndTimeSlotRecord().getValue() > -1L) {
            if (ar1.getEndTimeSlotRecord().getValue() < ar2.getEndTimeSlotRecord().getValue()) {
                return -1;
            }
            if (ar1.getEndTimeSlotRecord().getValue() > ar2.getEndTimeSlotRecord().getValue()) {
                return 1;
            }
        }
        return this.includeIDs ? this.compareID(ar1, ar2) : 0;
    }

    private int compareID(AnnotationRecord ar1, AnnotationRecord ar2) {
        block6: {
            try {
                Long l1 = Long.valueOf(ar1.getAnnotationId().substring(1));
                Long l2 = Long.valueOf(ar2.getAnnotationId().substring(1));
                if (l1 < l2) {
                    return -1;
                }
                if (l1 > l2) {
                    return 1;
                }
            }
            catch (NumberFormatException nfe) {
                if (ServerLogger.LOG.isLoggable(Level.FINE)) {
                    ServerLogger.LOG.fine("Cannot convert the annotation id to a Long value");
                }
            }
            catch (Throwable t) {
                if (!ServerLogger.LOG.isLoggable(Level.FINE)) break block6;
                ServerLogger.LOG.fine("Cannot convert the annotation id to a Long value: " + t.getMessage());
            }
        }
        return 0;
    }
}

