/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class EAFBase {
    protected String EAF_Format;
    protected String EAF_Schema_Location;
    public static final String TIME_UNIT_MILLISEC = "milliseconds";
    public static final String TIME_UNIT_NTSC = "NTSC-frames";
    public static final String TIME_UNIT_PAL = "PAL-frames";
    protected Document doc;

    public EAFBase() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.newDocument();
    }

    public Element getDocumentElement() {
        return this.doc.getDocumentElement();
    }

    public Node appendChild(Node e) {
        return this.doc.appendChild(e);
    }

    public Element newAnnotationDocument(String creationDate, String author, String version) {
        if (creationDate == null) {
            throw new RuntimeException("EAF");
        }
        if (author == null) {
            throw new RuntimeException("EAF");
        }
        if (version == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("ANNOTATION_DOCUMENT");
        result.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        result.setAttribute("xsi:noNamespaceSchemaLocation", this.EAF_Schema_Location);
        result.setAttribute("DATE", creationDate);
        result.setAttribute("AUTHOR", author);
        result.setAttribute("VERSION", version);
        result.setAttribute("FORMAT", this.EAF_Format);
        return result;
    }

    public Element newHeader(String mediaFile, String timeUnits) {
        if (mediaFile == null) {
            throw new RuntimeException("EAF");
        }
        if (timeUnits == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("HEADER");
        result.setAttribute("MEDIA_FILE", mediaFile);
        result.setAttribute("TIME_UNITS", timeUnits);
        return result;
    }

    public Element newHeader(String mediaFile) {
        if (mediaFile == null) {
            throw new RuntimeException("EAF");
        }
        return this.newHeader(mediaFile, TIME_UNIT_MILLISEC);
    }

    public Element newMediaDescriptor(String mediaURL, String relMediaURL, String mimeType, String timeOrigin, String extractedFrom) {
        if (mediaURL == null) {
            throw new RuntimeException("EAF");
        }
        if (mimeType == null) {
            throw new RuntimeException("EAF");
        }
        Element mdElement = this.doc.createElement("MEDIA_DESCRIPTOR");
        mdElement.setAttribute("MEDIA_URL", mediaURL);
        mdElement.setAttribute("MIME_TYPE", mimeType);
        this.attributeIfNotEmpty(mdElement, "RELATIVE_MEDIA_URL", relMediaURL);
        if (timeOrigin != null) {
            mdElement.setAttribute("TIME_ORIGIN", String.valueOf(timeOrigin));
        }
        if (extractedFrom != null) {
            mdElement.setAttribute("EXTRACTED_FROM", extractedFrom);
        }
        return mdElement;
    }

    public Element newLinkedFileDescriptor(String linkURL, String relLinkURL, String mimeType, String origin, String associatedWith) {
        if (linkURL == null) {
            throw new RuntimeException("EAF");
        }
        Element lfdElement = this.doc.createElement("LINKED_FILE_DESCRIPTOR");
        lfdElement.setAttribute("LINK_URL", linkURL);
        if (mimeType == null) {
            lfdElement.setAttribute("MIME_TYPE", "unknown");
        } else {
            lfdElement.setAttribute("MIME_TYPE", mimeType);
        }
        this.attributeIfNotEmpty(lfdElement, "RELATIVE_LINK_URL", relLinkURL);
        if (origin != null) {
            lfdElement.setAttribute("TIME_ORIGIN", origin);
        }
        if (associatedWith != null) {
            lfdElement.setAttribute("ASSOCIATED_WITH", associatedWith);
        }
        return lfdElement;
    }

    public Element newProperty(String name, String value) {
        Element propElement = this.doc.createElement("PROPERTY");
        this.attributeIfNotEmpty(propElement, "NAME", name);
        if (value != null && value.length() > 0) {
            propElement.appendChild(this.doc.createTextNode(value));
        }
        return propElement;
    }

    public Element newTimeOrder() {
        Element result = this.doc.createElement("TIME_ORDER");
        return result;
    }

    public Element newTimeSlot(String id, long time) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("TIME_SLOT");
        result.setAttribute("TIME_SLOT_ID", id);
        result.setAttribute("TIME_VALUE", "" + time);
        return result;
    }

    public Element newTimeSlot(String id) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("TIME_SLOT");
        result.setAttribute("TIME_SLOT_ID", id);
        return result;
    }

    public Element newTier(String id, String participant, String annotator, String typeRef, Locale language, String parent) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        if (typeRef == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("TIER");
        result.setAttribute("TIER_ID", id);
        this.attributeIfNotEmpty(result, "PARTICIPANT", participant);
        this.attributeIfNotEmpty(result, "ANNOTATOR", annotator);
        result.setAttribute("LINGUISTIC_TYPE_REF", typeRef);
        if (language != null) {
            result.setAttribute("DEFAULT_LOCALE", language.getLanguage());
        }
        this.attributeIfNotEmpty(result, "PARENT_REF", parent);
        return result;
    }

    public Element newAnnotation() {
        Element result = this.doc.createElement("ANNOTATION");
        return result;
    }

    public Element newAlignableAnnotation(String id, String beginTimeSlot, String endTimeSlot) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("ALIGNABLE_ANNOTATION");
        result.setAttribute("ANNOTATION_ID", id);
        result.setAttribute("TIME_SLOT_REF1", beginTimeSlot);
        result.setAttribute("TIME_SLOT_REF2", endTimeSlot);
        return result;
    }

    public Element newRefAnnotation(String id, String annotationRef, String previousAnnotation) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        if (annotationRef == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("REF_ANNOTATION");
        result.setAttribute("ANNOTATION_ID", id);
        result.setAttribute("ANNOTATION_REF", annotationRef);
        this.attributeIfNotEmpty(result, "PREVIOUS_ANNOTATION", previousAnnotation);
        return result;
    }

    public Element newAnnotationValue(String value) {
        if (value == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("ANNOTATION_VALUE");
        result.appendChild(this.doc.createTextNode(value));
        return result;
    }

    public Element newLinguisticType(String id, boolean timeAlignable, String constraint, String controlledVocabularyName) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("LINGUISTIC_TYPE");
        result.setAttribute("LINGUISTIC_TYPE_ID", id);
        result.setAttribute("TIME_ALIGNABLE", timeAlignable ? "true" : "false");
        result.setAttribute("GRAPHIC_REFERENCES", "false");
        if (constraint != null) {
            result.setAttribute("CONSTRAINTS", constraint);
        }
        this.attributeIfNotEmpty(result, "CONTROLLED_VOCABULARY_REF", controlledVocabularyName);
        return result;
    }

    public Element newConstraint(String stereotype, String description) {
        if (stereotype == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("CONSTRAINT");
        result.setAttribute("STEREOTYPE", stereotype);
        if (description != null) {
            result.setAttribute("DESCRIPTION", description);
        }
        return result;
    }

    public Element newLocale(Locale l) {
        if (l == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("LOCALE");
        result.setAttribute("LANGUAGE_CODE", l.getLanguage());
        if (!l.getCountry().equals("")) {
            result.setAttribute("COUNTRY_CODE", l.getCountry());
        }
        if (!l.getVariant().equals("")) {
            result.setAttribute("VARIANT", l.getVariant());
        }
        return result;
    }

    public Element newControlledVocabulary(String conVocId, String description) {
        if (conVocId == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("CONTROLLED_VOCABULARY");
        result.setAttribute("CV_ID", conVocId);
        if (description != null) {
            result.setAttribute("DESCRIPTION", description);
        }
        return result;
    }

    public Element newCVEntry(String value, String description) {
        if (value == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("CV_ENTRY");
        result.appendChild(this.doc.createTextNode(value));
        if (description != null) {
            result.setAttribute("DESCRIPTION", description);
        }
        return result;
    }

    protected void attributeIfNotEmpty(Element e, String name, String val) {
        if (val != null && !val.isEmpty()) {
            e.setAttribute(name, val);
        }
    }
}

