/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ECV01;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.ExternalCVEntry;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Element;

public class ECV01Encoder {
    public static final String VERSION = "0.1";

    public void encodeAndSave(ExternalCV cv, String path, String extRefId) throws IOException {
        Element documentElement = this.createDOM(cv);
        ExternalReference extRef = cv.getExternalRef();
        if (extRef != null) {
            this.save(documentElement, path, extRef.getValue());
        }
    }

    public void encodeAndSave(List<ExternalCV> cvs, String path, ExternalReference extRef) throws IOException {
        Element documentElement = this.createDOM(cvs);
        this.save(documentElement, path, extRef.getValue());
    }

    public void encodeAndSave(List<ExternalCV> cvs, String path) throws IOException {
        Element documentElement = this.createDOM(cvs);
        this.save(documentElement, path);
    }

    private void save(Element documentElement, String path) throws IOException {
        try {
            if (("" + documentElement).length() == 0) {
                throw new IOException("Unable to save this file (zero length).");
            }
            IoUtil.writeEncodedFile("UTF-8", path, documentElement);
        }
        catch (Exception eee) {
            ServerLogger.LOG.severe("Could not save the cache file: " + eee.getMessage());
        }
    }

    private void save(Element documentElement, String cachePath, String urlString) throws IOException {
        Object savePath = cachePath;
        String fileName = "";
        try {
            URL url = new URL(urlString);
            String urlHost = url.getHost();
            if (urlHost.equals("")) {
                urlHost = "localfile_system";
            }
            savePath = (String)savePath + File.separator + urlHost;
            String[] pathElements = url.getPath().substring(1).split("/");
            for (int i = 0; i < pathElements.length - 1; ++i) {
                savePath = (String)savePath + File.separator + pathElements[i];
            }
            fileName = pathElements[pathElements.length - 1];
        }
        catch (MalformedURLException e) {
            ServerLogger.LOG.warning("Could not create a cache directory structure: " + e.getMessage());
            int index = urlString.lastIndexOf(File.separator);
            fileName = index > -1 && index < urlString.length() - 2 ? urlString.substring(index + 1) : ((index = urlString.lastIndexOf("/")) > -1 && index < urlString.length() - 2 ? urlString.substring(index + 1) : urlString);
        }
        File dir = new File((String)savePath);
        if (dir.exists() || dir.mkdirs()) {
            savePath = (String)savePath + File.separator + fileName;
            try {
                if (("" + documentElement).length() == 0) {
                    throw new IOException("Unable to save this file (zero length).");
                }
                IoUtil.writeEncodedFile("UTF-8", (String)savePath, documentElement);
            }
            catch (Exception eee) {
                ServerLogger.LOG.severe("Could not save the cache file: " + eee.getMessage());
            }
        }
    }

    private Element createDOM(ExternalCV cv) {
        ECV01 ecvFactory = null;
        Object extRefId = null;
        try {
            ecvFactory = new ECV01();
        }
        catch (Exception ex) {
            ServerLogger.LOG.severe("Could not create a document builder: " + ex.getMessage());
        }
        HashMap<CallSite, ExternalReference> extRefIds = new HashMap<CallSite, ExternalReference>();
        ArrayList<CallSite> extRefList = new ArrayList<CallSite>();
        int extRefIndex = 1;
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = ECV01Encoder.correctDate(dateString);
        Element ecvDocument = ecvFactory.newExternalCVDocument(dateString, "", VERSION);
        ecvFactory.appendChild(ecvDocument);
        Element cvElement = ecvFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
        CVEntry[] entries = cv.getEntries();
        for (int j = 0; j < entries.length; ++j) {
            CVEntry entry = entries[j];
            if (entry.getExternalRef() != null) {
                if (!extRefIds.containsValue(entry.getExternalRef())) {
                    extRefId = "er" + extRefIndex++;
                    extRefIds.put((CallSite)extRefId, entry.getExternalRef());
                    extRefList.add((CallSite)extRefId);
                } else {
                    for (int k = 0; k < extRefList.size(); ++k) {
                        if (!entry.getExternalRef().equals(extRefIds.get(extRefList.get(k)))) continue;
                        extRefId = (String)extRefList.get(k);
                        break;
                    }
                }
            } else {
                extRefId = null;
            }
            String entryId = null;
            if (entry instanceof ExternalCVEntry) {
                entryId = ((ExternalCVEntry)entry).getId();
            }
            Element entryElement = ecvFactory.newCVEntry(entryId, entry.getValue(), entry.getDescription(), (String)extRefId);
            cvElement.appendChild(entryElement);
        }
        ecvDocument.appendChild(cvElement);
        for (int i = 0; i < extRefList.size(); ++i) {
            String id = (String)extRefList.get(i);
            ExternalReferenceImpl eri = (ExternalReferenceImpl)extRefIds.get(id);
            if (id == null || eri == null) continue;
            Element erElement = ecvFactory.newExternalReference(id, eri.getTypeString(), eri.getValue());
            ecvDocument.appendChild(erElement);
        }
        return ecvFactory.getDocumentElement();
    }

    private Element createDOM(List<ExternalCV> cvs) {
        ECV01 ecvFactory = null;
        Object extRefId = null;
        try {
            ecvFactory = new ECV01();
        }
        catch (Exception ex) {
            ServerLogger.LOG.severe("Could not create a document builder: " + ex.getMessage());
        }
        HashMap<CallSite, ExternalReference> extRefIds = new HashMap<CallSite, ExternalReference>();
        ArrayList<CallSite> extRefList = new ArrayList<CallSite>();
        int extRefIndex = 1;
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = ECV01Encoder.correctDate(dateString);
        Element ecvDocument = ecvFactory.newExternalCVDocument(dateString, "", VERSION);
        ecvFactory.appendChild(ecvDocument);
        if (cvs != null && cvs.size() > 0) {
            for (int i = 0; i < cvs.size(); ++i) {
                ExternalCV cv = cvs.get(i);
                Element cvElement = ecvFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
                CVEntry[] entries = cv.getEntries();
                for (int j = 0; j < entries.length; ++j) {
                    CVEntry entry = entries[j];
                    if (entry.getExternalRef() != null) {
                        if (!extRefIds.containsValue(entry.getExternalRef())) {
                            extRefId = "er" + extRefIndex++;
                            extRefIds.put((CallSite)extRefId, entry.getExternalRef());
                            extRefList.add((CallSite)extRefId);
                        } else {
                            for (int k = 0; k < extRefList.size(); ++k) {
                                if (!entry.getExternalRef().equals(extRefIds.get(extRefList.get(k)))) continue;
                                extRefId = (String)extRefList.get(k);
                                break;
                            }
                        }
                    } else {
                        extRefId = null;
                    }
                    String entryId = null;
                    if (entry instanceof ExternalCVEntry) {
                        entryId = ((ExternalCVEntry)entry).getId();
                    }
                    Element entryElement = ecvFactory.newCVEntry(entryId, entry.getValue(), entry.getDescription(), (String)extRefId);
                    cvElement.appendChild(entryElement);
                }
                ecvDocument.appendChild(cvElement);
            }
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add("undefined");
        types.add("reference_group");
        types.add("iso12620");
        types.add("resource_url");
        types.add("external_cv");
        for (int i = 0; i < extRefList.size(); ++i) {
            String id = (String)extRefList.get(i);
            ExternalReferenceImpl eri = (ExternalReferenceImpl)extRefIds.get(id);
            if (id == null || eri == null) continue;
            Element erElement = ecvFactory.newExternalReference(id, (String)types.get(eri.getReferenceType()), eri.getValue());
            ecvDocument.appendChild(erElement);
        }
        return ecvFactory.getDocumentElement();
    }

    private static String correctDate(String strIn) {
        Object strResult = new String(strIn);
        try {
            int indexSpace;
            int offsetGMT = Calendar.getInstance().getTimeZone().getRawOffset() / 3600000;
            Object strOffset = "+";
            if (offsetGMT < 0) {
                strOffset = "-";
            }
            if ((offsetGMT = Math.abs(offsetGMT)) < 10) {
                strOffset = (String)strOffset + "0";
            }
            if ((indexSpace = ((String)(strResult = (String)strResult + (String)(strOffset = (String)strOffset + offsetGMT + ":00"))).indexOf(" ")) != -1) {
                String strEnd = ((String)strResult).substring(indexSpace + 1);
                strResult = ((String)strResult).substring(0, indexSpace);
                strResult = (String)strResult + "T";
                strResult = (String)strResult + strEnd;
            }
            strResult = ((String)strResult).replace('.', '-');
        }
        catch (Exception ex) {
            return strIn;
        }
        return strResult;
    }
}

