/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.ExternalCVEntry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ECV01Parser {
    private SAXParser parser;
    private boolean strict;
    private String url;
    private final ArrayList<ControlledVocabulary> cvList = new ArrayList();
    private final HashMap<String, ExternalReference> extReferences = new HashMap();
    private final HashMap<CVEntry, String> cvEntryExtRef = new HashMap();
    private String currentCVId;
    private ControlledVocabulary currentCV;
    private String currentEntryDesc;
    private String currentEntryExtRef;
    private String content = "";
    public String currentEntryId;

    public ECV01Parser(String url) throws ParseException {
        this(url, false);
    }

    public ECV01Parser(String url, boolean strict) throws ParseException {
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
        this.strict = strict;
        try {
            boolean validate = Boolean.parseBoolean(System.getProperty("ELAN.EAF.Validate", "true"));
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            parserFactory.setNamespaceAware(true);
            if (validate) {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema eafSchema = schemaFactory.newSchema(this.getClass().getResource(ACMTranscriptionStore.getCurrentEAFSchemaLocal()));
                parserFactory.setSchema(eafSchema);
            } else {
                parserFactory.setValidating(false);
            }
            this.parser = parserFactory.newSAXParser();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            throw new ParseException(thr.getMessage());
        }
    }

    public void parse() throws ParseException {
        try {
            InputSource is = ACMTranscriptionStore.toInputSource(this.url);
            ECV01Handler ecvHandler = new ECV01Handler();
            this.parser.parse(is, (DefaultHandler)ecvHandler);
            this.createObjects();
        }
        catch (IOException ioe) {
            System.out.println("IO error: " + ioe.getMessage());
            throw new ParseException("IO error: " + ioe.getMessage(), ioe.getCause());
        }
        catch (SAXException saex) {
            System.out.println("Parsing error: " + saex.getMessage());
            throw new ParseException("Parsing error: " + saex.getMessage(), saex.getCause());
        }
    }

    private void createObjects() {
        if (this.cvEntryExtRef.size() > 0) {
            for (CVEntry entry : this.cvEntryExtRef.keySet()) {
                String erId = this.cvEntryExtRef.get(entry);
                ExternalReferenceImpl eri = (ExternalReferenceImpl)this.extReferences.get(erId);
                if (eri == null) continue;
                try {
                    entry.setExternalRef(eri.clone());
                }
                catch (CloneNotSupportedException cnse) {
                    System.out.println("Could not set the external reference: " + cnse.getMessage());
                }
            }
        }
    }

    public ArrayList<ControlledVocabulary> getControlledVocabularies() {
        return this.cvList;
    }

    public Map<String, ExternalReference> getExternalReferences() {
        return this.extReferences;
    }

    public class ECV01Handler
    extends DefaultHandler {
        @Override
        public void characters(char[] ch, int start, int end) throws SAXException {
            ECV01Parser.this.content = ECV01Parser.this.content + new String(ch, start, end);
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("CV_ENTRY")) {
                ExternalCVEntry entry = new ExternalCVEntry((BasicControlledVocabulary)ECV01Parser.this.currentCV, ECV01Parser.this.content, ECV01Parser.this.currentEntryDesc, ECV01Parser.this.currentEntryId);
                ECV01Parser.this.currentCV.addEntry(entry);
                if (ECV01Parser.this.currentEntryExtRef != null) {
                    ECV01Parser.this.cvEntryExtRef.put(entry, ECV01Parser.this.currentEntryExtRef);
                }
            }
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            ECV01Parser.this.content = "";
            if (!name.equals("CV_RESOURCE")) {
                if (name.equals("CONTROLLED_VOCABULARY")) {
                    ExternalReferenceImpl eri;
                    String extRefId;
                    ECV01Parser.this.currentCVId = attributes.getValue("CV_ID");
                    ECV01Parser.this.currentCV = new ExternalCV(ECV01Parser.this.currentCVId);
                    String desc = attributes.getValue("DESCRIPTION");
                    if (desc != null) {
                        ECV01Parser.this.currentCV.setDescription(desc);
                    }
                    if ((extRefId = attributes.getValue("EXT_REF")) != null && (eri = (ExternalReferenceImpl)ECV01Parser.this.extReferences.get(extRefId)) != null) {
                        try {
                            ((ExternalCV)ECV01Parser.this.currentCV).setExternalRef(eri.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            // empty catch block
                        }
                    }
                    ECV01Parser.this.cvList.add(ECV01Parser.this.currentCV);
                } else if (name.equals("CV_ENTRY")) {
                    ECV01Parser.this.currentEntryDesc = attributes.getValue("DESCRIPTION");
                    ECV01Parser.this.currentEntryExtRef = attributes.getValue("EXT_REF");
                    ECV01Parser.this.currentEntryId = attributes.getValue("CVE_ID");
                } else if (name.equals("EXTERNAL_REF")) {
                    String value = attributes.getValue("VALUE");
                    String type = attributes.getValue("TYPE");
                    String refId = attributes.getValue("EXT_REF_ID");
                    if (value != null) {
                        ExternalReferenceImpl eri = new ExternalReferenceImpl(value, type);
                        ECV01Parser.this.extReferences.put(refId, eri);
                    }
                }
            }
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (ECV01Parser.this.strict) {
                System.out.println("Error: " + exception.getMessage());
                System.out.println("System id: " + exception.getSystemId());
                System.out.println("Public id: " + exception.getPublicId());
                System.out.println("Line: " + exception.getLineNumber());
                System.out.println("Column: " + exception.getColumnNumber());
                throw exception;
            }
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            if (ECV01Parser.this.strict) {
                System.out.println("FatalError: " + exception.getMessage());
                throw exception;
            }
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (ECV01Parser.this.strict) {
                System.out.println("Warning: " + exception.getMessage());
            }
        }
    }
}

