/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.dobes.ECV02Encoder;
import mpi.eudico.server.corpora.clomimpl.dobes.ECV02Parser;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.ExternalCV;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ECVStore {
    public void loadExternalCV(ExternalCV cv, String url) throws ParseException {
        ArrayList<ExternalCV> ecvList = new ArrayList<ExternalCV>(1);
        ecvList.add(cv);
        this.loadExternalCVS(ecvList, url);
    }

    public void loadExternalCVS(List<ExternalCV> ecvList, String url) throws ParseException {
        if (ecvList == null || ecvList.size() == 0) {
            return;
        }
        ECV02Parser ecvParser = null;
        try {
            ecvParser = new ECV02Parser(url);
            ecvParser.parse(ecvList);
        }
        catch (ParseException pe) {
            ServerLogger.LOG.severe("Parse failed " + url);
            throw pe;
        }
    }

    public void storeExternalCV(ExternalCV cv, String cachePath, String urlString) {
        if (cv == null) {
            ServerLogger.LOG.warning("Could not create a cached version: no external CV provided.");
            return;
        }
        ArrayList<ExternalCV> list = new ArrayList<ExternalCV>(1);
        this.storeExternalCVS(list, cachePath, urlString);
    }

    public void storeExternalCVS(List<ExternalCV> ecvList, String cachePath, String urlString) {
        if (ecvList == null || ecvList.size() == 0) {
            ServerLogger.LOG.warning("Could not create a cached version: no external CV's provided.");
            return;
        }
        if (cachePath == null) {
            ServerLogger.LOG.warning("Could not create a cached version: no cache folder specified.");
            return;
        }
        if (urlString == null) {
            ServerLogger.LOG.warning("Could not create a cached version: no source URL specified.");
            return;
        }
        ExternalReferenceImpl eri = new ExternalReferenceImpl(urlString, 4);
        try {
            ECV02Encoder encoder = new ECV02Encoder();
            encoder.encodeAndSave(ecvList, cachePath, eri);
        }
        catch (Throwable thr) {
            ServerLogger.LOG.severe("Could not create a cached version: " + thr.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String ecvFileFormatTest(String path) {
        SAXParser parser = null;
        FormatTestHandler handler = new FormatTestHandler();
        InputSource is = null;
        String version = "0.2";
        try {
            is = ACMTranscriptionStore.toInputSource(path);
            if (is == null) {
                return version;
            }
        }
        catch (IOException ioe) {
            return version;
        }
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            parserFactory.setNamespaceAware(true);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema eafSchema = schemaFactory.newSchema(ECVStore.class.getResource(ACMTranscriptionStore.getCurrentEAFSchemaLocal()));
            parserFactory.setSchema(eafSchema);
            parser = parserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (SAXParseException parserFactory) {
        }
        catch (SAXException sax) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.warning(sax.getMessage());
            }
            String string = version;
            return string;
        }
        catch (ParserConfigurationException pce) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.warning(pce.getMessage());
            }
            String string = version;
            return string;
        }
        catch (IOException ioe) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.warning(ioe.getMessage());
            }
            String string = version;
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (is.getByteStream() != null) {
                    is.getByteStream().close();
                } else if (is.getCharacterStream() != null) {
                    is.getCharacterStream().close();
                }
            }
            catch (Throwable throwable) {}
        }
        if (handler.version != null) {
            if (ServerLogger.LOG.isLoggable(Level.FINE)) {
                ServerLogger.LOG.fine("The .ecv file has version: " + handler.version);
            }
            return handler.version;
        }
        return version;
    }

    class FormatTestHandler
    extends DefaultHandler {
        String version;

        FormatTestHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.isEmpty()) {
                localName = qName;
            }
            if (localName.equals("CV_RESOURCE")) {
                this.version = attributes.getValue("VERSION");
            }
            throw new SAXParseException("Seen enough of the document", null);
        }
    }
}

