/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.json;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LanguageRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TierRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TimeSlotRecord;
import mpi.eudico.server.corpora.clomimpl.json.JSONWADecoderInfo;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.TimeFormatter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONWAParser
extends Parser {
    private JSONWADecoderInfo waDecoderInfo;
    private String lastParsedFile = "";
    private Map<TierRecord, List<String>> tierAnnotationsMap = new HashMap<TierRecord, List<String>>();
    private List<TierRecord> tierRecordList = new ArrayList<TierRecord>();
    private List<String> mediaUrls = new ArrayList<String>();
    private List<String> creators = new ArrayList<String>();
    private int tsId = 0;
    private final Map<String, TierRecord> tierMap = new HashMap<String, TierRecord>();
    private final Map<String, List<AnnotationRecord>> tiers = new HashMap<String, List<AnnotationRecord>>();
    private final List<String> tierNames = new ArrayList<String>();
    private final List<LingTypeRecord> linguisticTypes = new ArrayList<LingTypeRecord>();
    private ArrayList<TimeSlotRecord> timeSlots = new ArrayList();
    private Map<String, String> timeSlotsMap = new HashMap<String, String>();
    private final List<Property> docProperties = new ArrayList<Property>();
    private final List<LanguageRecord> languages = new ArrayList<LanguageRecord>();
    private final List<String> langList = new ArrayList<String>();
    private final List<String> timeOrder = new ArrayList<String>();
    private List<MediaDescriptor> mediaDescriptors = new ArrayList<MediaDescriptor>();
    private Map<String, List<WAAnnotationRecord>> annIdToRecordsMap = new HashMap<String, List<WAAnnotationRecord>>();
    private Map<String, List<String>> colIdToPageIdMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> pageIdToAnnoIdMap = new HashMap<String, List<String>>();
    private final String TYPE_NAME = "wa-type";
    private final String TS_ID_PREFIX = "ts";

    @Override
    public void setDecoderInfo(DecoderInfo decoderInfo) {
        if (decoderInfo instanceof JSONWADecoderInfo) {
            this.waDecoderInfo = (JSONWADecoderInfo)decoderInfo;
        }
    }

    private void parse(String path) {
        if (path == null) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "The path to the file to parse is null");
            }
            return;
        }
        if (path.equals(this.lastParsedFile)) {
            return;
        }
        this.reset();
        try {
            JSONObject rootJO;
            JSONArray rootJA;
            block19: {
                String charsetName = "UTF-8";
                if (this.waDecoderInfo != null && this.waDecoderInfo.getCharsetName() != null) {
                    charsetName = this.waDecoderInfo.getCharsetName();
                }
                JSONTokener jt = new JSONTokener((Reader)new InputStreamReader((InputStream)new FileInputStream(new File(path)), charsetName));
                rootJA = null;
                rootJO = null;
                try {
                    rootJO = new JSONObject(jt);
                }
                catch (JSONException jse) {
                    if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                        ServerLogger.LOG.log(Level.WARNING, "JSON syntax error: the root is not a JSONObject:");
                        ServerLogger.LOG.log(Level.WARNING, jse.getMessage());
                    }
                    try {
                        rootJA = new JSONArray(jt);
                    }
                    catch (JSONException jse2) {
                        if (!ServerLogger.LOG.isLoggable(Level.WARNING)) break block19;
                        ServerLogger.LOG.log(Level.WARNING, "JSON syntax error: the root is not a JSONArray:");
                        ServerLogger.LOG.log(Level.WARNING, jse2.getMessage());
                    }
                }
            }
            if (rootJO != null) {
                this.handleRoot(rootJO);
                Iterator keyIter = rootJO.keys();
                while (keyIter.hasNext()) {
                    Object jobj = rootJO.get((String)keyIter.next());
                    if (jobj instanceof JSONObject) {
                        this.handleJSONObject(null, (JSONObject)jobj);
                        continue;
                    }
                    if (!(jobj instanceof JSONArray)) continue;
                    this.handleJSONArray(null, (JSONArray)jobj);
                }
            } else if (rootJA != null) {
                for (Object jobj : rootJA) {
                    if (jobj instanceof JSONObject) {
                        this.handleJSONObject(null, (JSONObject)jobj);
                        continue;
                    }
                    if (!(jobj instanceof JSONArray)) continue;
                    this.handleJSONArray(null, (JSONArray)jobj);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.createObjects();
        this.lastParsedFile = path;
    }

    private void createObjects() {
        TimeSlotRecord tsr;
        int i;
        LingTypeRecord ltr = new LingTypeRecord();
        ltr.setLingTypeId("wa-type");
        ltr.setStereoType("alignable");
        ltr.setTimeAlignable("true");
        this.linguisticTypes.add(ltr);
        if (!this.langList.isEmpty()) {
            for (String lng : this.langList) {
                this.languages.add(new LanguageRecord(lng, lng, lng));
            }
        }
        if (!this.tierRecordList.isEmpty()) {
            for (TierRecord tr : this.tierRecordList) {
                if (!this.tierNames.contains(tr.getName())) {
                    this.tierNames.add(tr.getName());
                }
                if (!this.tiers.containsKey(tr.getName())) {
                    this.tiers.put(tr.getName(), new ArrayList());
                }
                String colId = null;
                for (String cid : this.tierMap.keySet()) {
                    if (tr != this.tierMap.get(cid)) continue;
                    colId = cid;
                    break;
                }
                if (colId == null) {
                    if (!ServerLogger.LOG.isLoggable(Level.WARNING)) continue;
                    ServerLogger.LOG.log(Level.WARNING, "The Collection ID of the tier record could not be found");
                    continue;
                }
                ArrayList<String> curAnnIdList = new ArrayList<String>();
                List<String> curPageIdList = this.colIdToPageIdMap.get(colId);
                for (String pid : curPageIdList) {
                    List<String> paAnn = this.pageIdToAnnoIdMap.get(pid);
                    if (paAnn == null) continue;
                    curAnnIdList.addAll(paAnn);
                }
                if (!curAnnIdList.isEmpty()) {
                    for (String annId : curAnnIdList) {
                        List<WAAnnotationRecord> arList = this.annIdToRecordsMap.get(annId);
                        if (arList != null && !arList.isEmpty()) {
                            WAAnnotationRecord ar = arList.get(0);
                            this.tiers.get(tr.getName()).add(ar);
                            String shortId = this.extractLastFragment(ar.getAnnotationId());
                            if (shortId != null) {
                                ar.setAnnotationId(shortId);
                            }
                            if (!this.validXMLID(ar.getAnnotationId())) {
                                ar.setAnnotationId(null);
                            }
                            if (ar.getLanguage() == null || ar.getLanguage().isEmpty() || tr.getLangRef() != null && !tr.getLangRef().isEmpty()) continue;
                            tr.setLangRef(ar.getLanguage());
                            continue;
                        }
                        if (!ServerLogger.LOG.isLoggable(Level.INFO)) continue;
                        ServerLogger.LOG.log(Level.INFO, "The annotation record list for this annotation is empty: " + annId);
                    }
                    continue;
                }
                if (!ServerLogger.LOG.isLoggable(Level.INFO)) continue;
                ServerLogger.LOG.log(Level.INFO, "The annotation ID list of this tier is empty: " + tr.getName());
            }
        }
        for (i = 0; i < this.timeSlots.size(); ++i) {
            tsr = this.timeSlots.get(i);
            this.timeOrder.add("ts" + tsr.getId());
        }
        for (i = 0; i < this.timeSlots.size(); ++i) {
            tsr = this.timeSlots.get(i);
            this.timeSlotsMap.put("ts" + tsr.getId(), Long.toString(tsr.getValue()));
        }
    }

    private void handleRoot(JSONObject rootObj) {
        String type = this.getTypeOfObject(rootObj);
        if (type != null) {
            if (type.indexOf("Container") > -1) {
                String docId = this.getIdOfObject(rootObj);
                if (docId != null) {
                    this.docProperties.add(new PropertyImpl("id", docId));
                    String label = rootObj.optString("label");
                    if (label != null && !label.isEmpty()) {
                        this.docProperties.add(new PropertyImpl("label", label));
                    }
                }
            } else if (type.equals("AnnotationCollection")) {
                this.handleCollection(rootObj);
            } else if (type.equals("AnnotationPage")) {
                this.handlePage(null, rootObj);
            } else if (type.equals("Annotation")) {
                this.handleAnnotation(null, rootObj);
            }
        }
    }

    private void handleJSONObject(String parentOrContextType, JSONObject jObj) {
        String objType = this.getTypeOfObject(jObj);
        if ("AnnotationCollection".equals(objType)) {
            this.handleCollection(jObj);
        } else if ("AnnotationPage".equals(objType)) {
            this.handlePage(parentOrContextType, jObj);
        } else if ("Annotation".equals(objType)) {
            this.handleAnnotation(parentOrContextType, jObj);
        }
    }

    private void handleJSONArray(String contextKey, JSONArray jArray) {
        for (Object obj : jArray) {
            if (obj instanceof JSONObject) {
                this.handleJSONObject(contextKey, (JSONObject)obj);
                continue;
            }
            if (!(obj instanceof JSONArray)) continue;
            this.handleJSONArray(contextKey, (JSONArray)obj);
        }
    }

    private void printJSONObject(JSONObject jObj) {
        System.out.println("JObject Type: " + this.getTypeOfObject(jObj));
        System.out.println("JObject length: " + jObj.length());
        System.out.println("Keys: " + jObj.names());
        Iterator keyIter = jObj.keys();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            Object vObj = jObj.get(key);
            if (vObj instanceof JSONArray) {
                System.out.println("k: " + key + " - v: ");
                this.printJSONArray((JSONArray)vObj);
                continue;
            }
            System.out.println("k: " + key + " - v: " + vObj);
        }
        System.out.println();
    }

    private void printJSONArray(JSONArray jArr) {
        System.out.println("JArray length: " + jArr.length());
        for (Object arrObj : jArr) {
            if (arrObj instanceof JSONObject) {
                this.printJSONObject((JSONObject)arrObj);
                continue;
            }
            if (arrObj instanceof JSONArray) {
                this.printJSONArray((JSONArray)arrObj);
                continue;
            }
            if (!(arrObj instanceof String)) continue;
            System.out.println("S: " + arrObj.toString());
        }
    }

    private String getTypeOfObject(JSONObject jObj) {
        if (jObj != null) {
            Object typeObj = jObj.opt("type");
            if (typeObj == null) {
                typeObj = jObj.opt("@type");
            }
            if (typeObj instanceof String) {
                String typeStr = (String)typeObj;
                if ((typeStr = this.noNameSpace(typeStr)).equals("TextualBody") || typeStr.equals("Text")) {
                    return "TextualBody";
                }
                return typeStr;
            }
            if (typeObj instanceof JSONArray) {
                JSONArray typeArr = (JSONArray)typeObj;
                String typeStr = null;
                for (Object nextObj : typeArr) {
                    if (!(nextObj instanceof String)) continue;
                    String nextStr = this.noNameSpace((String)nextObj);
                    if (nextStr.equals("TextualBody") || nextStr.equals("Text")) {
                        return "TextualBody";
                    }
                    if ("Annotation".equals(nextStr) || "AnnotationPage".equals(nextStr) || "AnnotationCollection".equals(nextStr)) {
                        return nextStr;
                    }
                    if (typeStr != null) continue;
                    typeStr = nextStr;
                }
                return typeStr;
            }
        }
        return null;
    }

    private String getIdOfObject(JSONObject jObj) {
        if (jObj != null) {
            Object idObj = jObj.opt("id");
            if (idObj == null) {
                idObj = jObj.opt("@id");
            }
            if (idObj instanceof String) {
                return (String)idObj;
            }
            if (idObj instanceof Integer) {
                return ((Integer)idObj).toString();
            }
        }
        return null;
    }

    private String noNameSpace(String s) {
        if (s == null) {
            return s;
        }
        int index = s.lastIndexOf(58);
        if (index > -1 && index < s.length() - 1) {
            return s.substring(index + 1);
        }
        return s;
    }

    private String extractLastFragment(String iri) {
        if (iri != null) {
            int index = iri.lastIndexOf(35);
            if (index < 0 || index == iri.length() - 1) {
                index = iri.lastIndexOf(47);
            }
            if (index > -1 && index < iri.length() - 1) {
                return iri.substring(index + 1);
            }
        }
        return iri;
    }

    private boolean validXMLID(String id) {
        if (id == null || id.isEmpty()) {
            return false;
        }
        if (Character.isDigit(id.charAt(0))) {
            return false;
        }
        int[] codepoints = id.codePoints().toArray();
        String s = "_-";
        int underCP = Character.codePointAt(s, 0);
        int hyphCP = Character.codePointAt(s, 1);
        for (int cp : codepoints) {
            if (Character.isLetterOrDigit(cp) || cp == underCP || cp == hyphCP) continue;
            return false;
        }
        return true;
    }

    private void createUnnamedCollection() {
        if (!this.colIdToPageIdMap.containsKey("Unnamed") && !this.tierMap.containsKey("Unnamed")) {
            TierRecord tr = new TierRecord();
            tr.setName("Unnamed");
            this.tierMap.put("Unnamed", tr);
            this.tierRecordList.add(tr);
            this.tierAnnotationsMap.put(tr, new ArrayList());
            this.colIdToPageIdMap.put("Unnamed", new ArrayList());
            this.pageIdToAnnoIdMap.put("Unnamed", new ArrayList());
            this.colIdToPageIdMap.get("Unnamed").add("Unnamed");
        }
    }

    private void handleCollection(JSONObject jObj) {
        int totalNum;
        if (jObj == null) {
            return;
        }
        TierRecord tr = new TierRecord();
        String label = this.getFirstStringValue(jObj, "label");
        String collId = this.getIdOfObject(jObj);
        if (collId == null) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "The AnnotationCollection does not have an \"id\" property: ignored");
            }
            return;
        }
        this.tierMap.put(collId, tr);
        this.tierRecordList.add(tr);
        if (label == null && (label = this.extractLastFragment(collId)) == null) {
            label = "Unnamed";
        }
        tr.setName(label);
        Object creatorObj = jObj.opt("creator");
        if (creatorObj instanceof JSONObject) {
            Object partName = ((JSONObject)creatorObj).opt("name");
            if (partName == null) {
                partName = ((JSONObject)creatorObj).opt("nickname");
            }
            if (partName instanceof String) {
                tr.setAnnotator(partName.toString());
            }
        } else if (creatorObj instanceof String) {
            tr.setAnnotator((String)creatorObj);
        }
        if (tr.getAnnotator() != null && !tr.getAnnotator().isEmpty() && !this.creators.contains(tr.getAnnotator())) {
            this.creators.add(tr.getAnnotator());
        }
        if ((totalNum = jObj.optInt("total", -1)) == -1) {
            totalNum = 10;
        }
        ArrayList annIdList = new ArrayList(totalNum);
        this.tierAnnotationsMap.put(tr, annIdList);
        Object firstObj = jObj.opt("first");
        if (firstObj instanceof String) {
            ArrayList<String> pageList = new ArrayList<String>();
            pageList.add((String)firstObj);
            String lastPage = jObj.optString("last");
            if (lastPage != null && !lastPage.isEmpty()) {
                pageList.add(lastPage);
            }
            this.colIdToPageIdMap.put(collId, pageList);
        } else if (firstObj instanceof JSONObject) {
            this.handlePage(collId, (JSONObject)firstObj);
        }
    }

    private void handlePage(String collId, JSONObject jObj) {
        Object itemObj;
        List<String> pList;
        if (jObj == null) {
            return;
        }
        String type = this.getTypeOfObject(jObj);
        if (type == null || !"AnnotationPage".equals(type)) {
            if (ServerLogger.LOG.isLoggable(Level.INFO)) {
                ServerLogger.LOG.log(Level.INFO, "The JSONObject does not represent an AnnotationPage: " + type);
            }
            return;
        }
        String pageId = this.getIdOfObject(jObj);
        if (pageId == null) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "The AnnotationPage does not have an \"id\" property, skipping this page");
            }
            return;
        }
        if (collId == null) {
            collId = this.getFirstStringValue(jObj, "partOf");
        }
        if (collId != null) {
            List<String> pList2 = this.colIdToPageIdMap.get(collId);
            if (pList2 == null) {
                pList2 = new ArrayList<String>();
                this.colIdToPageIdMap.put(collId, pList2);
            }
            if (!pList2.contains(pageId)) {
                pList2.add(pageId);
            }
        } else {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "The AnnotationPage does not seem to belong to an AnnotationCollection: " + pageId);
            }
            return;
        }
        String next = this.getFirstStringValue(jObj, "next");
        if (next != null && (pList = this.colIdToPageIdMap.get(collId)) != null && !pList.contains(next)) {
            pList.add(next);
        }
        if ((itemObj = jObj.opt("items")) instanceof JSONObject) {
            this.handleAnnotation(pageId, (JSONObject)itemObj);
        } else if (itemObj instanceof JSONArray) {
            JSONArray itemArray = (JSONArray)itemObj;
            for (Object annObj : itemArray) {
                if (annObj instanceof JSONObject) {
                    this.handleAnnotation(pageId, (JSONObject)annObj);
                    continue;
                }
                if (!(annObj instanceof String)) continue;
                String annId = (String)annObj;
                List<String> annList = this.pageIdToAnnoIdMap.get(pageId);
                if (annList == null) {
                    annList = new ArrayList<String>();
                    this.pageIdToAnnoIdMap.put(pageId, annList);
                }
                if (!annList.contains(annId)) continue;
                annList.add(annId);
            }
        }
    }

    private void handleAnnotation(String pageId, JSONObject jObj) {
        if (jObj == null) {
            return;
        }
        String annType = this.getTypeOfObject(jObj);
        if (annType == null || !"Annotation".equals(annType)) {
            if (ServerLogger.LOG.isLoggable(Level.INFO)) {
                ServerLogger.LOG.log(Level.INFO, "The JSONObject does not represent an Annotation: " + annType);
            }
            return;
        }
        String annId = this.getIdOfObject(jObj);
        if (annId == null) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "The Annotation does not have an \"id\" property, skipping this annotation");
            }
            return;
        }
        Object target = jObj.opt("target");
        if (target == null) {
            List<String> annList;
            if (pageId == null) {
                pageId = "Unnamed";
            }
            if ((annList = this.pageIdToAnnoIdMap.get(pageId)) == null) {
                annList = new ArrayList<String>();
                this.pageIdToAnnoIdMap.put((String)pageId, annList);
            }
            if (!annList.contains(annId)) {
                annList.add(annId);
            }
        } else {
            if (pageId == null) {
                for (String string : this.pageIdToAnnoIdMap.keySet()) {
                    List<String> annIds = this.pageIdToAnnoIdMap.get(string);
                    if (annIds == null || !annIds.contains(annId)) continue;
                    pageId = string;
                    break;
                }
            }
            if (pageId == null) {
                pageId = "Unnamed";
            }
            String collId = null;
            for (String cid : this.colIdToPageIdMap.keySet()) {
                List<String> pageIds = this.colIdToPageIdMap.get(cid);
                if (pageIds == null || !pageIds.contains(pageId)) continue;
                collId = cid;
                break;
            }
            if (collId == null) {
                collId = "Unnamed";
                this.createUnnamedCollection();
            }
            if (!this.colIdToPageIdMap.containsKey(collId)) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                this.colIdToPageIdMap.put(collId, arrayList);
                arrayList.add(pageId);
            } else {
                List<String> list = this.colIdToPageIdMap.get(collId);
                if (!list.contains(pageId)) {
                    list.add((String)pageId);
                }
            }
            ArrayList<WAAnnotationRecord> arrayList = new ArrayList<WAAnnotationRecord>();
            String motivation = this.getFirstStringValue(jObj, "motivation");
            String bodyValue = jObj.optString("bodyValue");
            if (bodyValue != null && !bodyValue.isEmpty()) {
                WAAnnotationRecord ar = new WAAnnotationRecord();
                ar.setValue(bodyValue);
                arrayList.add(ar);
            } else {
                Object bodyObj = jObj.opt("body");
                if (bodyObj instanceof JSONObject) {
                    this.handleBody((JSONObject)bodyObj, arrayList);
                } else if (bodyObj instanceof JSONArray) {
                    JSONArray bodyArr = (JSONArray)bodyObj;
                    for (Object obj : bodyArr) {
                        if (!(obj instanceof JSONObject)) continue;
                        this.handleBody((JSONObject)obj, arrayList);
                    }
                } else if (bodyObj instanceof String) {
                    // empty if block
                }
            }
            long[] times = this.handleTargets(target);
            if (times != null) {
                List<String> annList = this.pageIdToAnnoIdMap.get(pageId);
                if (annList == null) {
                    annList = new ArrayList<String>();
                    this.pageIdToAnnoIdMap.put((String)pageId, annList);
                }
                if (!annList.contains(annId)) {
                    annList.add(annId);
                }
                for (WAAnnotationRecord ar : arrayList) {
                    ar.setAnnotationType("alignable");
                    ar.setAnnotationId(annId);
                    if (motivation != null) {
                        ar.setMotivation(motivation);
                    }
                    TimeSlotRecord tsRec = new TimeSlotRecord(this.tsId++, times[0]);
                    ar.setBeginTimeSlotRecord(tsRec);
                    this.timeSlots.add(tsRec);
                    tsRec = new TimeSlotRecord(this.tsId++, times[1]);
                    ar.setEndTimeSlotRecord(tsRec);
                    this.timeSlots.add(tsRec);
                }
                this.annIdToRecordsMap.put(annId, arrayList);
            }
        }
    }

    private void handleBody(JSONObject bodyJSON, List<WAAnnotationRecord> annList) {
        JSONArray items;
        String type = this.getTypeOfObject(bodyJSON);
        if ("TextualBody".equals(type)) {
            String lang = bodyJSON.optString("language");
            String annId = this.getIdOfObject(bodyJSON);
            Object valueObj = bodyJSON.opt("value");
            if (valueObj instanceof String) {
                String purposeStr;
                String value = (String)valueObj;
                WAAnnotationRecord ar = new WAAnnotationRecord();
                ar.setAnnotationId(annId);
                ar.setValue(value == null ? "" : value);
                if (lang != null && !lang.isEmpty()) {
                    ar.setLanguage(lang);
                    if (!this.langList.contains(lang)) {
                        this.langList.add(lang);
                    }
                }
                if ((purposeStr = this.getFirstStringValue(bodyJSON, "purpose")) != null && !purposeStr.isEmpty()) {
                    ar.setPurpose(purposeStr);
                }
                annList.add(ar);
            } else if (valueObj instanceof JSONArray) {
                if (ServerLogger.LOG.isLoggable(Level.INFO)) {
                    ServerLogger.LOG.log(Level.INFO, "The 'value' property is an array instead of a character sequence");
                }
            } else if (valueObj instanceof JSONObject && ServerLogger.LOG.isLoggable(Level.INFO)) {
                ServerLogger.LOG.log(Level.INFO, "The 'value' property is an object instead of a character sequence");
            }
        } else if ("Choice".equals(type) && (items = bodyJSON.optJSONArray("items")) != null) {
            JSONObject firstItem = this.getFirstJSONObjectWithKey(items, "type", "TextualBody");
            if (firstItem == null) {
                firstItem = this.getFirstJSONObjectWithKey(items, "@type", "TextualBody");
            }
            if (firstItem != null) {
                this.handleBody(firstItem, annList);
            }
        }
    }

    private long[] handleTargets(Object obj) {
        if (obj instanceof String) {
            String urlWithFrag = (String)obj;
            int fragIndex = urlWithFrag.lastIndexOf(35);
            if (fragIndex > 0 && fragIndex < urlWithFrag.length() - 1) {
                String url = urlWithFrag.substring(0, fragIndex);
                this.addMediaDescriptor(url, null);
                String timeFrag = urlWithFrag.substring(fragIndex + 1);
                long[] times = this.extractTimeSelection(timeFrag);
                return times;
            }
            this.addMediaDescriptor(urlWithFrag, null);
        } else if (obj instanceof JSONObject) {
            Object selectObj;
            JSONObject jObj = (JSONObject)obj;
            String source = jObj.optString("source");
            if (source == null || source.isEmpty()) {
                source = this.getIdOfObject(jObj);
            }
            if ((selectObj = jObj.opt("selector")) instanceof JSONObject) {
                return this.handleSelector(source, (JSONObject)selectObj);
            }
            if (selectObj instanceof JSONArray) {
                long[] times = null;
                for (Object sobj : (JSONArray)selectObj) {
                    if (!(sobj instanceof JSONObject)) continue;
                    long[] nt = this.handleSelector(source, (JSONObject)sobj);
                    if (times != null) continue;
                    times = nt;
                }
                return times;
            }
            if (selectObj != null) {
                return this.handleTargets(source);
            }
        } else if (obj instanceof JSONArray) {
            long[] times = null;
            for (Object iterObj : (JSONArray)obj) {
                long[] nt = this.handleTargets(iterObj);
                if (times != null) continue;
                times = nt;
            }
            return times;
        }
        return null;
    }

    private long[] handleSelector(String source, JSONObject selectObj) {
        String type = this.getTypeOfObject(selectObj);
        if ("FragmentSelector".equals(type)) {
            String conforms = selectObj.optString("conformsTo");
            if (conforms != null && !conforms.isEmpty() && !conforms.equals("http://www.w3.org/TR/media-frags/")) {
                return null;
            }
            String value = selectObj.optString("value");
            if (value != null && !value.isEmpty()) {
                this.addMediaDescriptor(source, null);
                long[] times = this.extractTimeSelection(value);
                return times;
            }
        }
        return null;
    }

    private void addMediaDescriptor(String url, String mime) {
        if (url == null || url.isEmpty()) {
            return;
        }
        for (MediaDescriptor md : this.mediaDescriptors) {
            if (!md.mediaURL.equals(url)) continue;
            if (md.mimeType == null && mime != null) {
                md.mimeType = mime;
            }
            return;
        }
        this.mediaDescriptors.add(new MediaDescriptor(url, mime));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long[] extractTimeSelection(String timeString) {
        if (timeString == null) return null;
        if (ServerLogger.LOG.isLoggable(Level.FINE) && timeString.startsWith("t=")) {
            ServerLogger.LOG.log(Level.FINE, String.format("Time string \"%s\" does not start with \"t=\"", timeString));
        }
        int eqInd = timeString.indexOf(61);
        int comInd = timeString.indexOf(44);
        if (eqInd >= 0 && comInd > eqInd) {
            try {
                long et;
                long bt;
                if (comInd == eqInd + 1) {
                    String etString;
                    bt = 0L;
                    et = comInd == timeString.length() - 1 ? Long.MAX_VALUE : ((etString = timeString.substring(comInd + 1)).indexOf(46) > -1 || etString.indexOf(58) > -1 ? TimeFormatter.toMilliSeconds(etString) : TimeFormatter.toMilliSeconds(etString, TimeFormatter.TIME_FORMAT.SSMS));
                    return new long[]{bt, et};
                } else {
                    String etString;
                    String btString = timeString.substring(eqInd + 1, comInd);
                    bt = btString.indexOf(46) > -1 || btString.indexOf(58) > -1 ? TimeFormatter.toMilliSeconds(btString) : TimeFormatter.toMilliSeconds(btString, TimeFormatter.TIME_FORMAT.SSMS);
                    et = comInd == timeString.length() - 1 ? Long.MAX_VALUE : ((etString = timeString.substring(comInd + 1)).indexOf(46) > -1 || etString.indexOf(58) > -1 ? TimeFormatter.toMilliSeconds(etString) : TimeFormatter.toMilliSeconds(etString, TimeFormatter.TIME_FORMAT.SSMS));
                }
                return new long[]{bt, et};
            }
            catch (NumberFormatException nfe) {
                if (!ServerLogger.LOG.isLoggable(Level.INFO)) return null;
                ServerLogger.LOG.log(Level.INFO, "Cannot parse time: " + nfe.getMessage());
                return null;
            }
        } else {
            if (!ServerLogger.LOG.isLoggable(Level.INFO)) return null;
            ServerLogger.LOG.log(Level.INFO, "Cannot extract time values from: " + timeString);
        }
        return null;
    }

    private String getFirstStringValue(Object inputObj, String key) {
        if (inputObj instanceof String) {
            return (String)inputObj;
        }
        if (inputObj instanceof JSONArray) {
            return this.getFirstStringValue((JSONArray)inputObj, key);
        }
        if (inputObj instanceof JSONObject) {
            return this.getFirstStringValue((JSONObject)inputObj, key);
        }
        return null;
    }

    private String getFirstStringValue(JSONArray inputArr, String key) {
        for (Object itObj : inputArr) {
            String nextObj;
            if (itObj instanceof JSONArray) {
                nextObj = this.getFirstStringValue((JSONArray)itObj, key);
                if (!(nextObj instanceof String)) continue;
                return nextObj;
            }
            if (itObj instanceof JSONObject) {
                nextObj = this.getFirstStringValue((JSONObject)itObj, key);
                if (!(nextObj instanceof String)) continue;
                return nextObj;
            }
            if (!(itObj instanceof String)) continue;
            return (String)itObj;
        }
        return null;
    }

    private String getFirstStringValue(JSONObject inputJSObj, String key) {
        Object nextObj = inputJSObj.opt(key);
        if (nextObj instanceof String) {
            return (String)nextObj;
        }
        if (nextObj instanceof JSONObject) {
            return this.getFirstStringValue((JSONObject)nextObj, key);
        }
        if (nextObj instanceof JSONArray) {
            return this.getFirstStringValue((JSONArray)nextObj, key);
        }
        return null;
    }

    private JSONObject getFirstJSONObjectWithKey(Object inputObj, String key, String value) {
        if (inputObj instanceof JSONObject) {
            return this.getFirstJSONObjectWithKey((JSONObject)inputObj, key, value);
        }
        if (inputObj instanceof JSONArray) {
            return this.getFirstJSONObjectWithKey((JSONArray)inputObj, key, value);
        }
        return null;
    }

    private JSONObject getFirstJSONObjectWithKey(JSONObject inputJSObj, String key, String value) {
        Object nextObj = inputJSObj.opt(key);
        if (nextObj instanceof JSONObject) {
            if (value == null) {
                return (JSONObject)nextObj;
            }
            if (value.equals(((JSONObject)nextObj).opt(key))) {
                return (JSONObject)nextObj;
            }
        } else {
            if (nextObj instanceof JSONArray) {
                return this.getFirstJSONObjectWithKey((JSONArray)nextObj, key, value);
            }
            if (nextObj instanceof String && value != null && value.equals(nextObj)) {
                return inputJSObj;
            }
        }
        return null;
    }

    private JSONObject getFirstJSONObjectWithKey(JSONArray inputJSArr, String key, String value) {
        for (Object itObj : inputJSArr) {
            if (itObj instanceof JSONArray) {
                JSONObject fjo = this.getFirstJSONObjectWithKey((JSONArray)itObj, key, value);
                if (fjo == null) continue;
                return fjo;
            }
            if (!(itObj instanceof JSONObject) || value == null || !value.equals(((JSONObject)itObj).get(key))) continue;
            return (JSONObject)itObj;
        }
        return null;
    }

    private void reset() {
        this.mediaDescriptors.clear();
        this.langList.clear();
        this.languages.clear();
        this.linguisticTypes.clear();
        this.timeSlots.clear();
        this.timeSlotsMap.clear();
        this.timeOrder.clear();
        this.docProperties.clear();
        this.annIdToRecordsMap.clear();
        this.colIdToPageIdMap.clear();
        this.pageIdToAnnoIdMap.clear();
        this.tierMap.clear();
        this.tiers.clear();
        this.mediaUrls.clear();
        this.creators.clear();
        this.tierRecordList.clear();
        this.tierAnnotationsMap.clear();
        this.tierNames.clear();
    }

    public static void main(String[] args) {
        JSONWAParser waj = new JSONWAParser();
        waj.parse(args[0]);
    }

    @Override
    public String getMediaFile(String fileName) {
        this.parse(fileName);
        if (this.mediaUrls.size() > 0) {
            return this.mediaUrls.get(0);
        }
        if (this.mediaDescriptors.size() > 0) {
            return this.mediaDescriptors.get((int)0).mediaURL;
        }
        return super.getMediaFile(fileName);
    }

    @Override
    public String getAuthor(String fileName) {
        this.parse(fileName);
        if (this.creators.size() == 1) {
            return this.creators.get(0);
        }
        return null;
    }

    @Override
    public List<Property> getTranscriptionProperties(String fileName) {
        this.parse(fileName);
        return this.docProperties;
    }

    @Override
    public String getAnnotatorOf(String tierName, String fileName) {
        this.parse(fileName);
        TierRecord tr = this.tierMap.get(tierName);
        if (tr != null) {
            return tr.getAnnotator();
        }
        return super.getAnnotatorOf(tierName, fileName);
    }

    @Override
    public List<LanguageRecord> getLanguages(String fileName) {
        this.parse(fileName);
        return this.languages;
    }

    @Override
    public String getLangRefOf(String tierName, String fileName) {
        this.parse(fileName);
        TierRecord tr = this.tierMap.get(tierName);
        if (tr != null) {
            return tr.getLangRef();
        }
        return super.getLangRefOf(tierName, fileName);
    }

    @Override
    public List<MediaDescriptor> getMediaDescriptors(String fileName) {
        this.parse(fileName);
        return this.mediaDescriptors;
    }

    @Override
    public List<LingTypeRecord> getLinguisticTypes(String fileName) {
        this.parse(fileName);
        return this.linguisticTypes;
    }

    @Override
    public List<String> getTimeOrder(String fileName) {
        this.parse(fileName);
        return this.timeOrder;
    }

    @Override
    public Map<String, String> getTimeSlots(String fileName) {
        this.parse(fileName);
        return this.timeSlotsMap;
    }

    @Override
    public List<String> getTierNames(String fileName) {
        this.parse(fileName);
        return this.tierNames;
    }

    @Override
    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        TierRecord tr = this.tierMap.get(tierName);
        if (tr != null) {
            return tr.getParticipant();
        }
        return null;
    }

    @Override
    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        this.parse(fileName);
        return "wa-type";
    }

    @Override
    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        return null;
    }

    @Override
    public List<AnnotationRecord> getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        return this.tiers.get(tierName);
    }

    private class WAAnnotationRecord
    extends AnnotationRecord {
        private String language;
        private String purpose;
        private String motivation;

        private WAAnnotationRecord() {
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getPurpose() {
            return this.purpose;
        }

        public void setPurpose(String purpose) {
            this.purpose = purpose;
        }

        public String getMotivation() {
            return this.motivation;
        }

        public void setMotivation(String motivation) {
            this.motivation = motivation;
        }
    }
}

