/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.AnnotationSizeContainer;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class AnnotationSize
implements ACMEditListener {
    TranscriptionImpl _trans = null;
    Annotation _refAnn = null;
    List<TierImpl> _vBlockTiers = new ArrayList<TierImpl>();
    Map<Long, Integer> _htTimeList = new TreeMap<Long, Integer>();
    FontMetrics _fontmetric = null;
    Map<Tier, List<Annotation>> htAnnBetween = new HashMap<Tier, List<Annotation>>();
    Map<String, FontMetrics> metricsPerTier = null;

    public AnnotationSize(TranscriptionImpl trans, Annotation _ref) {
        this._trans = trans;
        this._refAnn = _ref;
        this._fontmetric = null;
        this.getBlockTiers();
        this.buildTimeBlock();
    }

    public AnnotationSize(TranscriptionImpl trans, Annotation _ref, FontMetrics fontmetrics) {
        this._trans = trans;
        this._refAnn = _ref;
        this._fontmetric = fontmetrics;
        this.getBlockTiers();
        this.buildTimeBlock();
    }

    public AnnotationSize(TranscriptionImpl trans, Annotation _ref, FontMetrics defaultFontMetrics, Map<String, FontMetrics> metricsPerTier) {
        this._trans = trans;
        this._refAnn = _ref;
        this._fontmetric = defaultFontMetrics;
        this.metricsPerTier = metricsPerTier;
        this.getBlockTiers();
        this.buildTimeBlock();
    }

    public List<AnnotationSizeContainer> getTierLayoutInChar(Tier tier) {
        return new ArrayList<AnnotationSizeContainer>();
    }

    public List<AnnotationSizeContainer> getTierLayoutInPixels(Tier tier, FontMetrics fontmetrics) {
        int type;
        boolean bNaturalSize = false;
        this._fontmetric = fontmetrics;
        ArrayList<AnnotationSizeContainer> vecRet = new ArrayList<AnnotationSizeContainer>(50);
        List<Annotation> vans = this.getAnnBetweenTime(tier, this._refAnn.getBeginTimeBoundary(), this._refAnn.getEndTimeBoundary());
        if (!this.includeTierInCalculation((TierImpl)tier)) {
            bNaturalSize = true;
        }
        Iterator<Long> enumTime = this._htTimeList.keySet().iterator();
        long currentTime = this._refAnn.getBeginTimeBoundary();
        long origCurrentTime = 0L;
        int endMarker = 0;
        if (enumTime.hasNext()) {
            origCurrentTime = currentTime = enumTime.next().longValue();
        }
        int n = type = this._fontmetric != null ? AnnotationSizeContainer.PIXELS : AnnotationSizeContainer.SPACES;
        if (vans.size() == 0) {
            Integer tmptime = this._htTimeList.get(currentTime);
            if (tmptime == null) {
                tmptime = 999;
            }
            vecRet.add(new AnnotationSizeContainer(null, tmptime, currentTime, currentTime, type));
            if (enumTime.hasNext()) {
                currentTime = enumTime.next();
            }
        }
        for (int ii = 0; ii < vans.size(); ++ii) {
            Annotation aa = vans.get(ii);
            while (aa.getBeginTimeBoundary() != currentTime && enumTime.hasNext()) {
                vecRet.add(new AnnotationSizeContainer(null, this._htTimeList.get(currentTime), currentTime, currentTime, type));
                currentTime = enumTime.next();
            }
            if (!bNaturalSize) {
                vecRet.add(new AnnotationSizeContainer(aa, this._htTimeList.get(currentTime), type));
            } else {
                vecRet.add(new AnnotationSizeContainer(aa, this.getStringSize(aa.getValue()), type));
            }
            if (enumTime.hasNext()) {
                currentTime = enumTime.next();
                continue;
            }
            endMarker = -1;
        }
        boolean truth = true;
        while (truth && currentTime != origCurrentTime && endMarker != -1 && !bNaturalSize) {
            vecRet.add(new AnnotationSizeContainer(null, this._htTimeList.get(currentTime), currentTime, currentTime, type));
            if (enumTime.hasNext()) {
                currentTime = enumTime.next();
                continue;
            }
            truth = false;
        }
        return vecRet;
    }

    public List<TierImpl> getTiers() {
        return this._vBlockTiers;
    }

    public void getBlockTiers() {
        List<TierImpl> vAllTiers = null;
        Iterator<TierImpl> etier = null;
        try {
            vAllTiers = this._trans.getTiers();
            etier = vAllTiers.iterator();
        }
        catch (Exception rmiexp) {
            rmiexp.printStackTrace();
            return;
        }
        while (etier.hasNext()) {
            TierImpl t = etier.next();
            if (t.getRootTier() != this._refAnn.getTier()) continue;
            this._vBlockTiers.add(t);
        }
    }

    private void buildTimeBlock() {
        for (TierImpl ti : this._vBlockTiers) {
            this.fillTimeBlock(ti);
        }
    }

    private void fillTimeBlock(TierImpl ti) {
        if (!this.includeTierInCalculation(ti)) {
            return;
        }
        FontMetrics tiMetrics = null;
        FontMetrics refAnnMetrics = null;
        if (this.metricsPerTier != null) {
            tiMetrics = this.metricsPerTier.get(ti.getName());
            refAnnMetrics = this.metricsPerTier.get(this._refAnn.getTier().getName());
        }
        List<Annotation> v = this.getAnnBetweenTime(ti, this._refAnn.getBeginTimeBoundary(), this._refAnn.getEndTimeBoundary());
        for (Annotation a : v) {
            Integer blocklen = null;
            blocklen = this._htTimeList.get(a.getBeginTimeBoundary());
            if (blocklen != null) {
                int strLength = this.getStringSize(a.getValue(), tiMetrics);
                if (blocklen >= strLength) continue;
                this._htTimeList.put(a.getBeginTimeBoundary(), strLength);
                continue;
            }
            this._htTimeList.put(a.getBeginTimeBoundary(), this.getStringSize(a.getValue(), tiMetrics));
        }
        if (this._htTimeList.size() == 0) {
            this._htTimeList.put(this._refAnn.getBeginTimeBoundary(), this.getStringSize(this._refAnn.getValue(), refAnnMetrics));
        }
    }

    private List<Annotation> getAnnBetweenTime(Tier tier, long start, long end) {
        List<? extends Annotation> v = null;
        if (this.htAnnBetween.containsKey(tier)) {
            return this.htAnnBetween.get(tier);
        }
        ArrayList<Annotation> vecRet = new ArrayList<Annotation>(50);
        try {
            v = tier.getAnnotations();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        for (int i = 0; i < v.size(); ++i) {
            Annotation a = v.get(i);
            if (a.getBeginTimeBoundary() >= start && a.getEndTimeBoundary() <= end) {
                vecRet.add(a);
                continue;
            }
            if (a.getEndTimeBoundary() > start) break;
        }
        this.htAnnBetween.put(tier, vecRet);
        return vecRet;
    }

    private boolean includeTierInCalculation(TierImpl ti) {
        if (!ti.hasParentTier()) {
            return false;
        }
        if (ti.getLinguisticType() == null) {
            return true;
        }
        if (ti.getLinguisticType().getConstraints() == null) {
            return true;
        }
        return ti.getLinguisticType().getConstraints().getStereoType() != 4 || ti.getParentTier() != ti.getRootTier();
    }

    public int getStringSize(String str) {
        if (this._fontmetric != null) {
            return this._fontmetric.stringWidth(str.trim());
        }
        return str.trim().length();
    }

    public int getStringSize(String str, FontMetrics metrics) {
        if (metrics == null) {
            return this.getStringSize(str);
        }
        return metrics.stringWidth(str.trim());
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
    }
}

