/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxTypFile;
import mpi.eudico.util.TimeFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ShoeboxArray {
    private String shoeboxheader = "";
    private String label_ref;
    public static String label_eudicoparticipant = "\\EUDICOp";
    public static String label_eudicot0 = "\\EUDICOt0";
    public static String label_eudicot1 = "\\EUDICOt1";
    private File file = null;
    private List<String> markerOrder = new ArrayList<String>();
    private String prevLabel = null;
    private List<String> labelList = new ArrayList<String>();
    private List<DefaultMutableTreeNode> labelNodeList = new ArrayList<DefaultMutableTreeNode>();
    private String[][] shoeboxArray;
    private int[] shoeboxArrayMaxLength;
    private int currentIndexBlock = -1;
    private int currentIndexLabel = -1;
    private int maxIndexBlocks;
    private boolean isShoeboxArrayPreparation = true;
    private boolean strict1;
    private Set<String> interlinearTierMarkers;
    private Map<String, Integer> lineCounts = new HashMap<String, Integer>();
    private boolean readingWAC = false;
    private ArrayList<MediaDescriptor> mediaDescriptors = new ArrayList();
    private ShoeboxTypFile typFile;

    public ShoeboxArray(File file, String label_ref, ShoeboxTypFile theTypFile) throws Exception {
        this(file, false, label_ref, theTypFile);
    }

    public ShoeboxArray(File file, boolean strict1, String label_ref, ShoeboxTypFile theTypFile) throws Exception {
        if (!file.canRead()) {
            throw new Exception("cannot read \"" + file + "\"");
        }
        this.file = file;
        this.typFile = theTypFile;
        this.strict1 = strict1;
        this.define_default_labels(label_ref);
        if (label_ref == null) {
            label_ref = "\\block";
        }
        this.label_ref = label_ref;
        this.interlinearTierMarkers = theTypFile.getInterlinearTierMarkers();
        this.readSbx();
        this.maxIndexBlocks = this.currentIndexBlock;
        this.shoeboxArray = new String[this.getNumberOfLabels()][this.getNumberOfBlocks()];
        this.shoeboxArrayMaxLength = new int[this.getNumberOfBlocks()];
        this.currentIndexBlock = -1;
        this.readSbx();
    }

    public ShoeboxArray(File wacfile) throws Exception {
        this.readingWAC = true;
        this.define_default_labels("\\ref");
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(wacfile);
        this.readWac(doc);
        this.prepare_or_finish_block();
        this.isShoeboxArrayPreparation = false;
        this.shoeboxArray = new String[this.getNumberOfLabels()][this.getNumberOfBlocks()];
        this.shoeboxArrayMaxLength = new int[this.getNumberOfBlocks()];
        this.currentIndexBlock = -1;
        this.readWac(doc);
        this.prepare_or_finish_block();
    }

    public final String getShoeboxHeader() {
        return this.shoeboxheader;
    }

    public final String getCell(int label, int block) {
        Object result = null;
        result = this.shoeboxArray[label][block];
        if (label > 3 && result != null) {
            while (((String)result).length() < this.shoeboxArrayMaxLength[block]) {
                result = (String)result + " ";
            }
        }
        return result;
    }

    public final String getCell(String label, int block) {
        int x = this.labelList.indexOf(label);
        if (x < 0) {
            System.out.println(this.getClass() + ".getCell(" + label + ", " + block + ") \n FATAL ERROR");
            return "";
        }
        return this.getCell(x, block);
    }

    private final void setC(int label, int block, String value) {
        this.shoeboxArray[label][block] = value;
    }

    public final String getSpeaker(int block) {
        String result = this.getCell("\\ELANParticipant", block);
        if (result == null || result.length() == 0) {
            result = "unknown";
        }
        result = result.trim();
        return result;
    }

    public final long getT0(int block) {
        long t0 = this.getTX("\\ELANBegin", block);
        if (block == 0 && t0 < 0L) {
            t0 = 0L;
        }
        return t0;
    }

    public final long getT1(int block) {
        long t1 = this.getTX("\\ELANEnd", block);
        return t1;
    }

    public ArrayList<MediaDescriptor> getMediaDescriptors() {
        return this.mediaDescriptors;
    }

    private final long getTX(String label, int block) {
        String sresult = this.getCell(label, block);
        long result = 0L;
        try {
            double d = Double.parseDouble(sresult);
            if ((d *= 1000.0) == -1000.0) {
                d = -1.0;
            }
            result = (long)d;
        }
        catch (NumberFormatException e) {
            return this.toMilliSeconds(sresult, block);
        }
        return result;
    }

    public long toMilliSeconds(String timeString, int block) {
        long t = TimeFormatter.toMilliSeconds(timeString);
        if (t < 0L) {
            System.out.println("TX: " + block + " unknown time format: " + timeString);
        }
        return t;
    }

    public final List<String> getMarkerOrder() {
        return this.markerOrder;
    }

    public final int getNumberOfLabels() {
        return this.labelList.size();
    }

    public final Iterator<String> getLabels() {
        return this.labelList.iterator();
    }

    public final String getLabel(int i) {
        return this.labelList.get(i);
    }

    public final DefaultMutableTreeNode getLabelNode(int i) {
        return this.labelNodeList.get(i);
    }

    public final DefaultMutableTreeNode getLabelNode(String name) {
        try {
            return this.labelNodeList.get(this.getLabelIndex(name));
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.labelNodeList.get(0);
        }
    }

    public final int getLabelIndex(String labelincludingtrailingbackslash) {
        return this.labelList.indexOf(labelincludingtrailingbackslash);
    }

    public final int getNumberOfBlocks() {
        return this.maxIndexBlocks;
    }

    public final String getShoeboxFile() throws Exception {
        String result = this.getShoeboxHeader() + "\n";
        for (int bi = 0; bi < this.getNumberOfBlocks(); ++bi) {
            for (int i = 0; i < this.getNumberOfLabels(); ++i) {
                String cntnt = this.shoeboxArray[i][bi];
                if (cntnt == null || cntnt.length() == 0) continue;
                String label = this.getLabel(i);
                if (i == 0) {
                    result = result + "\n";
                }
                result = result + label + "\t" + cntnt.replace('\n', ' ') + "\n";
            }
        }
        return result;
    }

    public final void dump() throws Exception {
        for (int bi = 0; bi < this.getNumberOfBlocks(); ++bi) {
            for (int i = 0; i < this.getNumberOfLabels(); ++i) {
                String cntnt = this.getCell(i, bi);
                if (cntnt == null) {
                    cntnt = "#";
                }
                String label = this.getLabel(i);
                System.out.println(i + "/" + bi + ":\t" + label + "\t" + cntnt.replace('\n', ' '));
            }
        }
    }

    public final void dump2() throws Exception {
        for (int _b = 0; _b < this.getNumberOfBlocks(); ++_b) {
            for (int _l = 0; _l < this.getNumberOfLabels(); ++_l) {
                String label = this.getLabel(_l);
                String cntnt = this.getCell(label, _b);
                System.out.println(_b + " " + label + " \t" + cntnt);
            }
        }
    }

    public final void dumpSbx() throws Exception {
        for (int bi = 0; bi < this.getNumberOfBlocks(); ++bi) {
            for (int i = 0; i < this.getNumberOfLabels(); ++i) {
                String cntnt = this.getCell(i, bi);
                if (cntnt == null) {
                    cntnt = "#";
                }
                if (i != this.getNumberOfLabels() - 1) continue;
            }
        }
    }

    private void define_default_labels(String label_ref) throws Exception {
        this.store_label(label_ref);
        this.store_label("\\ELANParticipant");
        this.store_label("\\ELANBegin");
        this.store_label("\\ELANEnd");
    }

    private void storeLabelInOrder(String label, String prevLabel) {
        if (label == null || label.length() == 1 || this.markerOrder.contains(label)) {
            return;
        }
        if (prevLabel == null) {
            this.markerOrder.add(label);
        } else {
            if (this.markerOrder.size() == 0) {
                this.markerOrder.add(label);
                return;
            }
            for (int i = 0; i < this.markerOrder.size(); ++i) {
                if (!prevLabel.equals(this.markerOrder.get(i))) continue;
                this.markerOrder.add(i + 1, label);
                return;
            }
        }
    }

    public static void main(String[] arg) throws Exception {
        ShoeboxArray s = new ShoeboxArray(new File(arg[0]));
        s.dump2();
    }

    private void store_label(String label) throws Exception {
        if (this.labelList.contains(label) || label == null || label.length() == 1 || this.typFile.excludeFromImport(label)) {
            return;
        }
        this.labelList.add(label);
        this.labelNodeList.add(new DefaultMutableTreeNode(label));
        if (this.readingWAC) {
            return;
        }
        if (this.getNumberOfLabels() == 0 && !label.equals(this.label_ref)) {
            throw new Exception("found '" + label + "', expected '" + this.label_ref + "'.");
        }
    }

    private final void prepare_or_finish_block() {
        int elanPax = this.getLabelIndex("\\ELANParticipant");
        int elanT0 = this.getLabelIndex("\\ELANBegin");
        int elanT1 = this.getLabelIndex("\\ELANEnd");
        if (!this.isShoeboxArrayPreparation && this.currentIndexBlock >= 0) {
            Integer II;
            if (this.shoeboxArray[elanPax][this.currentIndexBlock] == null || this.shoeboxArray[elanPax][this.currentIndexBlock].length() == 0) {
                this.shoeboxArray[elanPax][this.currentIndexBlock] = "unknown";
            }
            if (this.shoeboxArray[elanT0][this.currentIndexBlock] == null || this.shoeboxArray[elanT0][this.currentIndexBlock].length() == 0) {
                II = -1;
                this.shoeboxArray[elanT0][this.currentIndexBlock] = II.toString();
            }
            if (this.shoeboxArray[elanT1][this.currentIndexBlock] == null || this.shoeboxArray[elanT1][this.currentIndexBlock].length() == 0) {
                II = -1;
                this.shoeboxArray[elanT1][this.currentIndexBlock] = II.toString();
            }
            this.correctLineBreaksIfNeeded();
        }
        ++this.currentIndexBlock;
        this.currentIndexLabel = -1;
    }

    private final void overwriteContent(String label, int block, String content) throws Exception {
        if (this.isShoeboxArrayPreparation) {
            return;
        }
        this.shoeboxArray[this.labelList.indexOf((Object)label)][block] = content;
        this.shoeboxArrayMaxLength[block] = content.length();
    }

    private final void store_label_and_content(String label, String content) throws Exception {
        int max;
        String testi;
        if (label.equals(label_eudicoparticipant)) {
            label = "\\ELANParticipant";
        }
        if (label.equals(label_eudicot0)) {
            label = "\\ELANBegin";
        }
        if (label.equals(label_eudicot1)) {
            label = "\\ELANEnd";
        }
        this.currentIndexLabel = this.labelList.indexOf(label);
        if (this.isShoeboxArrayPreparation) {
            return;
        }
        if (this.currentIndexLabel < 0) {
            return;
        }
        if (this.typFile.excludeFromImport(label)) {
            return;
        }
        if (this.currentIndexBlock < 0) {
            return;
        }
        if (this.currentIndexLabel > 0 && this.currentIndexBlock > 0 && ((testi = this.shoeboxArray[0][this.currentIndexBlock]) == null || "".equals(testi))) {
            this.shoeboxArray[0][this.currentIndexBlock] = null;
        }
        String oldContent = this.shoeboxArray[this.currentIndexLabel][this.currentIndexBlock];
        if (this.interlinearTierMarkers.contains(label)) {
            this.lineCounts.put(label, this.lineCounts.get(label) + 1);
        }
        if (oldContent != null) {
            content = oldContent + "\n" + (String)content;
        }
        this.shoeboxArray[this.currentIndexLabel][this.currentIndexBlock] = content;
        this.correctLineBreaksIfNeeded();
        int oldLen = this.shoeboxArrayMaxLength[this.currentIndexBlock];
        int newLen = ((String)content).length();
        this.shoeboxArrayMaxLength[this.currentIndexBlock] = max = oldLen < newLen ? newLen : oldLen;
    }

    private void correctLineBreaksIfNeeded() {
        boolean correct = true;
        Iterator<String> markerIter = this.interlinearTierMarkers.iterator();
        while (markerIter.hasNext()) {
            if (this.lineCounts.get(markerIter.next()) != 0) continue;
            correct = false;
            break;
        }
        if (correct) {
            this.correctLineBreaks();
        }
    }

    private void correctLineBreaks() {
        int maxLengthInInterlinearBlock = 0;
        Iterator<String> markerIter2 = this.interlinearTierMarkers.iterator();
        while (markerIter2.hasNext()) {
            int lblIndex = this.labelList.indexOf(markerIter2.next());
            String c = this.shoeboxArray[lblIndex][this.currentIndexBlock];
            int l = -1;
            if (c != null) {
                l = c.indexOf("\n");
            }
            if (l < 0 && c != null) {
                l = c.length();
            }
            maxLengthInInterlinearBlock = l < maxLengthInInterlinearBlock ? maxLengthInInterlinearBlock : l;
        }
        Iterator<String> markerIter3 = this.interlinearTierMarkers.iterator();
        while (markerIter3.hasNext()) {
            int lblIndex = this.labelList.indexOf(markerIter3.next());
            String c = this.shoeboxArray[lblIndex][this.currentIndexBlock];
            if (c == null) continue;
            boolean nlFound = true;
            int l = c.indexOf("\n");
            if (l < 0) {
                l = c.length();
                nlFound = false;
            }
            int numOfSpaces = maxLengthInInterlinearBlock - l;
            Object spaces = "";
            for (int i = 0; i < numOfSpaces; ++i) {
                spaces = (String)spaces + " ";
            }
            Object newC = "";
            newC = nlFound ? c.substring(0, l) + (String)spaces + " " + c.substring(l + 1) : c.substring(0, l) + (String)spaces;
            this.shoeboxArray[lblIndex][this.currentIndexBlock] = newC;
        }
        for (String lbl : this.interlinearTierMarkers) {
            int newCount = this.lineCounts.get(lbl) - 1;
            if (newCount < 0) {
                newCount = 0;
            }
            Integer i = newCount;
            this.lineCounts.put(lbl, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readSbx() throws Exception {
        String line = null;
        String utf8Line = null;
        InputStreamReader filereader = null;
        InputStreamReader utf8FileReader = null;
        MediaDescriptor mediaDescriptor = null;
        this.mediaDescriptors = new ArrayList();
        filereader = new InputStreamReader((InputStream)new FileInputStream(this.file), "ISO-8859-1");
        utf8FileReader = new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8");
        BufferedReader br = null;
        BufferedReader utf8Br = null;
        try {
            br = new BufferedReader(filereader);
            utf8Br = new BufferedReader(utf8FileReader);
            String label = null;
            this.prevLabel = null;
            String content = null;
            int linenumber = 0;
            while ((line = br.readLine()) != null) {
                utf8Line = utf8Br.readLine();
                this.prevLabel = label;
                StringTokenizer t = new StringTokenizer(line);
                if (t.hasMoreTokens()) {
                    label = t.nextToken();
                    if (!(label.length() <= 1 || utf8Line.startsWith("\ufeff") || label.startsWith("\\") && (label.charAt(0) != '\\' || label.charAt(1) != ' ' && label.charAt(1) != '\t'))) {
                        label = this.prevLabel;
                    }
                    if (this.typFile.isUnicodeTier(label)) {
                        line = utf8Line;
                        if (!this.isShoeboxArrayPreparation && this.interlinearTierMarkers.contains(label)) {
                            line = this.decodeToolboxUnicode(line);
                        }
                    }
                }
                line = line.trim();
                if (++linenumber == 1) {
                    if (line.startsWith("\\_sh v4.0") || line.startsWith("\\_sh v3.0") || utf8Line.startsWith("\ufeff\\_sh v3.0") || utf8Line.startsWith("\ufeff\\_sh v4.0")) {
                        this.shoeboxheader = line;
                        String dbType = "";
                        while (t.hasMoreTokens()) {
                            dbType = t.nextToken();
                        }
                        if (dbType.equals("")) continue;
                        this.typFile.setDatabaseType(dbType);
                        continue;
                    }
                    throw new Exception("A shoebox file must begin with '\\_sh v4.0' or '\\_sh v3.0', found " + line + "!");
                }
                if (line.length() == 0) continue;
                if (line.startsWith("\\_") && this.currentIndexBlock == -1) {
                    this.shoeboxheader = this.shoeboxheader + "\n" + line;
                    continue;
                }
                if (!line.startsWith("\\")) {
                    if (this.strict1) {
                        throw new Exception("tier without leading label \"" + line + "\"");
                    }
                    if (this.currentIndexLabel < 0) {
                        throw new Exception("There is no tier where I can append \"" + line + "\" to!");
                    }
                    if (this.isShoeboxArrayPreparation) continue;
                    String oldContent = this.shoeboxArray[this.currentIndexLabel][this.currentIndexBlock];
                    if (oldContent == null) {
                        throw new Exception("There is no tier where I can append \"" + line + "\" to!");
                    }
                    this.shoeboxArray[this.currentIndexLabel][this.currentIndexBlock] = oldContent + " " + line;
                    content = "";
                    continue;
                }
                if (!(this.isShoeboxArrayPreparation || line.length() != 1 && line.charAt(1) != ' ' && line.charAt(1) != '\t')) {
                    if (this.shoeboxArray[this.currentIndexLabel][this.currentIndexBlock] == null) continue;
                    this.shoeboxArray[this.currentIndexLabel][this.currentIndexBlock] = this.shoeboxArray[this.currentIndexLabel][this.currentIndexBlock] + " " + line;
                    content = "";
                    continue;
                }
                StringTokenizer xxx = new StringTokenizer(line);
                label = xxx.nextToken();
                this.storeLabelInOrder(label, this.prevLabel);
                content = "";
                if (line.length() > label.length()) {
                    content = line.substring(label.length() + 1);
                }
                if (content.length() > 0) {
                    int lastNonSpaceIndex = content.length() - 1;
                    while (content.charAt(lastNonSpaceIndex) == ' ') {
                        --lastNonSpaceIndex;
                    }
                    if (lastNonSpaceIndex < content.length() - 1 && lastNonSpaceIndex >= 0) {
                        content = content.substring(0, lastNonSpaceIndex);
                    }
                }
                if (line.startsWith("\\ELANMediaURL")) {
                    if (mediaDescriptor != null) {
                        this.mediaDescriptors.add(mediaDescriptor);
                    }
                    mediaDescriptor = new MediaDescriptor(content, null);
                    continue;
                }
                if (line.startsWith("\\ELANMediaMIME")) {
                    if (mediaDescriptor == null) continue;
                    mediaDescriptor.mimeType = content;
                    continue;
                }
                if (line.startsWith("\\ELANMediaExtracted")) {
                    if (mediaDescriptor == null) continue;
                    mediaDescriptor.extractedFrom = content;
                    continue;
                }
                if (line.startsWith("\\ELANMediaOrigin")) {
                    if (mediaDescriptor == null) continue;
                    mediaDescriptor.timeOrigin = Long.parseLong(content);
                    continue;
                }
                this.store_label(label);
                if (label.equals(this.label_ref)) {
                    this.prepare_or_finish_block();
                    Iterator<String> markerIter = this.interlinearTierMarkers.iterator();
                    while (markerIter.hasNext()) {
                        this.lineCounts.put(markerIter.next(), 0);
                    }
                }
                this.store_label_and_content(label, content);
            }
            if (mediaDescriptor != null) {
                this.mediaDescriptors.add(mediaDescriptor);
            }
            this.prepare_or_finish_block();
        }
        finally {
            this.isShoeboxArrayPreparation = false;
            try {
                if (br != null) {
                    br.close();
                }
            }
            finally {
                if (utf8Br != null) {
                    utf8Br.close();
                }
            }
        }
    }

    public String getRootMarkerForBlock(int row) {
        String result = "";
        Iterator<String> en = this.getLabels();
        while (en.hasNext()) {
            String lbl = en.next();
            if (lbl.equals("\\ELANBegin") || lbl.equals("\\ELANEnd") || lbl.equals("\\ELANParticipant") || lbl.equals("\\ELANExport") || lbl.equals("\\block") || this.typFile.tofromHash.containsKey(lbl) || this.getCell(lbl, row) == null) continue;
            result = lbl;
            break;
        }
        return result;
    }

    private final void readWac(Document doc) throws Exception {
        NodeList blockList = doc.getElementsByTagName("block");
        for (int i = 0; i < blockList.getLength(); ++i) {
            Element blockElement = (Element)blockList.item(i);
            if (this.isShoeboxArrayPreparation) {
                ++this.maxIndexBlocks;
            }
            NodeList tierList = blockElement.getElementsByTagName("tier");
            for (int j = 0; j < tierList.getLength(); ++j) {
                Element tierElement = (Element)tierList.item(j);
                String tierName = "\\" + tierElement.getAttribute("name");
                String tierValue = tierElement.getFirstChild().getNodeValue();
                if (this.isShoeboxArrayPreparation) {
                    this.store_label(tierName);
                    continue;
                }
                this.overwriteContent(tierName, i, tierValue);
            }
            this.prepare_or_finish_block();
        }
    }

    private String decodeToolboxUnicode(String value) {
        char cc;
        if (value == null) {
            return value;
        }
        int length = value.length();
        char[] chars = value.toCharArray();
        int count = 0;
        for (int i = 0; i < length; ++i) {
            cc = chars[i];
            if (cc == '\u0000' || cc >= '\u0080' && cc <= '\u07ff') {
                ++count;
                continue;
            }
            if (cc < '\u0800' || cc > '\uffff') continue;
            count += 2;
        }
        char[] resChars = new char[length + count];
        count = 0;
        int k = 0;
        for (int i = 0; i < length && k < resChars.length; ++i, ++k) {
            cc = chars[i];
            resChars[k] = chars[i];
            if (cc == ' ') {
                if (count <= 0) continue;
                for (int z = 0; z < count && ++k < resChars.length; ++z) {
                    resChars[k] = 32;
                }
                count = 0;
                continue;
            }
            if (cc == '\u0000' || cc >= '\u0080' && cc <= '\u07ff') {
                ++count;
                continue;
            }
            if (cc < '\u0800' || cc > '\uffff') continue;
            count += 2;
        }
        return new String(resChars);
    }
}

