/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.interlinear;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Interlinearizer;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.TimeCodedTranscription;

public class Metrics {
    private TimeCodedTranscription transcription;
    private Interlinearizer interlinearizer;
    private Map<Annotation, Integer> sizeTable;
    private Map<Annotation, Integer> usedWidthTable;
    private Map<Annotation, Integer> horizontalPositions;
    private Map<Annotation, Integer> verticalPositions;
    private Map<String, Integer> tierHeights;
    private List<Annotation> blockWiseOrdered;
    private List<Annotation> verticallyOrdered;
    private int leftMargin;
    private boolean leftMarginOn = false;

    public Metrics(TimeCodedTranscription tr, Interlinearizer interlinearizer) {
        this.transcription = tr;
        this.interlinearizer = interlinearizer;
        this.sizeTable = new HashMap<Annotation, Integer>();
        this.usedWidthTable = new HashMap<Annotation, Integer>();
        this.horizontalPositions = new HashMap<Annotation, Integer>();
        this.verticalPositions = new HashMap<Annotation, Integer>();
        this.tierHeights = new HashMap<String, Integer>();
    }

    public void reset() {
        this.sizeTable.clear();
        this.usedWidthTable.clear();
        this.horizontalPositions.clear();
        this.verticalPositions.clear();
        this.tierHeights.clear();
        this.blockWiseOrdered = null;
        this.verticallyOrdered = null;
    }

    public void setSize(Annotation annot, int size) {
        this.sizeTable.put(annot, size);
    }

    public int getSize(Annotation annot) {
        int size = 0;
        Integer intSize = this.sizeTable.get(annot);
        if (intSize != null) {
            size = intSize;
        }
        return size;
    }

    public void setUsedWidth(Annotation annot, int width) {
        this.usedWidthTable.put(annot, width);
    }

    public int getUsedWidth(Annotation annot) {
        int usedWidth = 0;
        Integer intWidth = this.usedWidthTable.get(annot);
        if (intWidth != null) {
            usedWidth = intWidth;
        }
        return usedWidth;
    }

    public void setHorizontalPosition(Annotation annot, int hPos) {
        this.horizontalPositions.put(annot, hPos);
    }

    public int getHorizontalPosition(Annotation annot) {
        int hPos = 0;
        Integer intHPos = this.horizontalPositions.get(annot);
        if (intHPos != null) {
            hPos = intHPos;
        }
        return hPos;
    }

    public void setVerticalPosition(Annotation annot, int vPos) {
        this.verticalPositions.put(annot, vPos);
    }

    public void setVerticalPosition(Annotation annot) {
        int vPos = 0;
        String tierName = annot.getTier().getName();
        String[] visibleTiers = this.getInterlinearizer().getVisibleTiers();
        for (int i = 0; i < visibleTiers.length; ++i) {
            if (tierName.equals(visibleTiers[i])) {
                vPos += this.getTierHeight(visibleTiers[i]);
                break;
            }
            vPos += this.getTierHeight(visibleTiers[i]) + this.getInterlinearizer().getLineSpacing();
        }
        this.verticalPositions.put(annot, vPos);
    }

    public int getVerticalPosition(Annotation annot) {
        int vPos = 0;
        Integer intVPos = this.verticalPositions.get(annot);
        if (intVPos != null) {
            vPos = intVPos;
        }
        return vPos;
    }

    public int getMaxVerticalPosition() {
        int maxPosition = 0;
        Collection<Integer> c = this.verticalPositions.values();
        for (int vPos : c) {
            if (vPos <= maxPosition) continue;
            maxPosition = vPos;
        }
        return maxPosition;
    }

    public int getMaxHorizontallyUsedWidth() {
        int maxHUsed = 0;
        for (Annotation a : this.horizontalPositions.keySet()) {
            int usedWidth;
            int hpos = this.horizontalPositions.get(a);
            if (hpos + (usedWidth = this.usedWidthTable.get(a).intValue()) <= maxHUsed) continue;
            maxHUsed = hpos + usedWidth;
        }
        return maxHUsed + this.getLeftMargin();
    }

    public void setTierHeight(String tierName, int tierHeight) {
        this.tierHeights.put(tierName, tierHeight);
    }

    public int getTierHeight(String forTier) {
        Integer i = this.tierHeights.get(forTier);
        if (i != null) {
            return i;
        }
        return 0;
    }

    public int getCumulativeTierHeights() {
        int totalHeight = 0;
        Collection<Integer> heights = this.tierHeights.values();
        Iterator<Integer> hIter = heights.iterator();
        while (hIter.hasNext()) {
            totalHeight += hIter.next().intValue();
        }
        int numOfVisibleTiers = this.getInterlinearizer().getVisibleTiers().length;
        return totalHeight += numOfVisibleTiers * this.getInterlinearizer().getLineSpacing();
    }

    public List<Integer> getPositionsOfNonEmptyTiers() {
        Collection<Integer> c = this.verticalPositions.values();
        return new ArrayList<Integer>(new HashSet<Integer>(c));
    }

    public String getTierLabelAt(int position) {
        String label = null;
        for (Annotation a : this.verticalPositions.keySet()) {
            if (this.verticalPositions.get(a) != position) continue;
            label = a.getTier().getName();
            break;
        }
        return label;
    }

    public int[] getVPositionsInTemplate() {
        int[] vPositions = new int[this.getInterlinearizer().getVisibleTiers().length];
        int lineSpacing = this.getInterlinearizer().getLineSpacing();
        int positionInTemplate = 0;
        String[] vTierNames = this.getInterlinearizer().getVisibleTiers();
        for (int index = 0; index < vTierNames.length; ++index) {
            int tierHeight = this.getTierHeight(vTierNames[index]);
            vPositions[index] = positionInTemplate += tierHeight;
            positionInTemplate += lineSpacing;
        }
        return vPositions;
    }

    public TimeCodedTranscription getTranscription() {
        return this.transcription;
    }

    public Interlinearizer getInterlinearizer() {
        return this.interlinearizer;
    }

    public int getLeftMargin() {
        if (this.leftMarginOn) {
            return this.leftMargin;
        }
        return 0;
    }

    public void setLeftMargin(int i) {
        if (this.leftMarginOn) {
            this.leftMargin = i;
        }
    }

    public void showLeftMargin(boolean show) {
        this.leftMarginOn = show;
    }

    public boolean leftMarginShown() {
        return this.leftMarginOn;
    }

    public List<Annotation> getBlockWiseOrdered() {
        if (this.blockWiseOrdered == null) {
            this.blockWiseOrdered = new ArrayList<Annotation>();
            Set<Annotation> allAnnots = this.sizeTable.keySet();
            String[] visibleTiers = this.getInterlinearizer().getVisibleTiers();
            List<String> vTierList = Arrays.asList(visibleTiers);
            for (Annotation a : allAnnots) {
                if (!vTierList.contains(a.getTier().getName())) continue;
                this.blockWiseOrdered.add(a);
            }
            Collections.sort(this.blockWiseOrdered, new AnnotationComparator());
        }
        return this.blockWiseOrdered;
    }

    public List<Annotation> getVerticallyOrdered() {
        if (this.verticallyOrdered == null) {
            this.verticallyOrdered = new ArrayList<Annotation>();
            Set<Annotation> allAnnots = this.sizeTable.keySet();
            String[] visibleTiers = this.getInterlinearizer().getVisibleTiers();
            List<String> vTierList = Arrays.asList(visibleTiers);
            for (Annotation a : allAnnots) {
                if (!vTierList.contains(a.getTier().getName())) continue;
                this.verticallyOrdered.add(a);
            }
            Collections.sort(this.verticallyOrdered, new AnnotComparatorOnVPos());
        }
        return this.verticallyOrdered;
    }

    public int[] getPageBoundaries(int pageHeight) {
        int[] pageBoundaries = null;
        int lastPageBreak = 0;
        ArrayList<Integer> boundaries = new ArrayList<Integer>();
        List<Integer> vPosIntegers = null;
        int[] tierLblVPositions = null;
        vPosIntegers = this.getPositionsOfNonEmptyTiers();
        Collections.sort(vPosIntegers);
        tierLblVPositions = new int[vPosIntegers.size()];
        for (int i = 0; i < vPosIntegers.size(); ++i) {
            tierLblVPositions[i] = vPosIntegers.get(i);
        }
        for (int k = 0; k < tierLblVPositions.length; ++k) {
            if (tierLblVPositions[k] <= lastPageBreak + pageHeight || k <= 0) continue;
            lastPageBreak = tierLblVPositions[k - 1];
            boundaries.add(lastPageBreak);
        }
        pageBoundaries = new int[boundaries.size()];
        for (int m = 0; m < boundaries.size(); ++m) {
            pageBoundaries[m] = (Integer)boundaries.get(m);
        }
        return pageBoundaries;
    }

    public int[] getPageBoundaries(int pageIndex, int pageHeight) {
        int pageCounter = 0;
        int lastPageBreak = 0;
        int[] boundaries = new int[]{0, 0};
        List<Integer> vPosIntegers = null;
        int[] tierLblVPositions = null;
        vPosIntegers = this.getPositionsOfNonEmptyTiers();
        Collections.sort(vPosIntegers);
        tierLblVPositions = new int[vPosIntegers.size()];
        for (int i = 0; i < vPosIntegers.size(); ++i) {
            tierLblVPositions[i] = vPosIntegers.get(i);
        }
        for (int k = 0; k < tierLblVPositions.length; ++k) {
            if (tierLblVPositions[k] > lastPageBreak + pageHeight) {
                if (pageCounter == pageIndex) break;
                if (k > 0) {
                    lastPageBreak = tierLblVPositions[k - 1];
                }
                ++pageCounter;
            }
            boundaries[0] = lastPageBreak;
            boundaries[1] = tierLblVPositions[k];
        }
        if (pageIndex > pageCounter) {
            boundaries[0] = 0;
            boundaries[1] = 0;
        }
        return boundaries;
    }

    class AnnotationComparator
    implements Comparator<Annotation> {
        AnnotationComparator() {
        }

        @Override
        public int compare(Annotation a0, Annotation a1) {
            int hpos1;
            int hpos0 = (Integer)Metrics.this.horizontalPositions.get(a0);
            if (hpos0 < (hpos1 = ((Integer)Metrics.this.horizontalPositions.get(a1)).intValue())) {
                return -1;
            }
            if (hpos0 > hpos1) {
                return 1;
            }
            if (hpos0 == hpos1) {
                if (Metrics.this.transcription.isAncestorOf(a1.getTier(), a0.getTier())) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }

    class AnnotComparatorOnVPos
    implements Comparator<Annotation> {
        AnnotComparatorOnVPos() {
        }

        @Override
        public int compare(Annotation a0, Annotation a1) {
            int vpos1;
            int vpos0 = (Integer)Metrics.this.verticalPositions.get(a0);
            if (vpos0 < (vpos1 = ((Integer)Metrics.this.verticalPositions.get(a1)).intValue())) {
                return -1;
            }
            if (vpos0 >= vpos1) {
                return 1;
            }
            return 0;
        }
    }
}

