/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.interlinear;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Metrics;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.TimeCodedTranscription;

public class SizeCalculator {
    public static void calculateSizes(Metrics metrics, Graphics g) {
        TimeCodedTranscription tr = metrics.getTranscription();
        String[] visibleTiers = metrics.getInterlinearizer().getVisibleTiers();
        int size = 0;
        int maxTierLabelWidth = 0;
        List<String> vTierList = Arrays.asList(visibleTiers);
        for (TierImpl tierImpl : tr.getTiers()) {
            if (!vTierList.contains(tierImpl.getName())) continue;
            Font font = metrics.getInterlinearizer().getFont(tierImpl.getName());
            FontMetrics fontMetrics = g.getFontMetrics(font);
            int tierHeight = fontMetrics.getHeight();
            metrics.setTierHeight(tierImpl.getName(), tierHeight);
            for (Annotation annotation : tierImpl.getAnnotations()) {
                size = fontMetrics.stringWidth(annotation.getValue().trim());
                metrics.setSize(annotation, size);
            }
            if (fontMetrics.stringWidth(tierImpl.getName()) <= maxTierLabelWidth) continue;
            maxTierLabelWidth = fontMetrics.stringWidth(tierImpl.getName());
        }
        metrics.setLeftMargin(maxTierLabelWidth + 10);
    }

    public static void calculateSizes(Metrics metrics) {
        TimeCodedTranscription tr = metrics.getTranscription();
        String[] visibleTiers = metrics.getInterlinearizer().getVisibleTiers();
        int size = 0;
        List<String> vTierList = Arrays.asList(visibleTiers);
        for (TierImpl tierImpl : tr.getTiers()) {
            if (!vTierList.contains(tierImpl.getName())) continue;
            int charEncoding = metrics.getInterlinearizer().getCharEncoding(tierImpl.getName());
            metrics.setTierHeight(tierImpl.getName(), 1);
            for (Annotation annotation : tierImpl.getAnnotations()) {
                size = charEncoding == 0 ? SizeCalculator.getNumOfBytes(annotation.getValue()) : annotation.getValue().length();
                metrics.setSize(annotation, size);
            }
        }
    }

    public static int getNumOfBytes(String utf8String) {
        int numOfBytes = 0;
        char[] chars = new char[utf8String.length()];
        utf8String.getChars(0, utf8String.length(), chars, 0);
        for (char ch : chars) {
            if (ch == '\u0000' || ch >= '\u0080' && ch <= '\u07ff') {
                numOfBytes += 2;
                continue;
            }
            if (ch >= '\u0800' && ch <= '\uffff') {
                numOfBytes += 3;
                continue;
            }
            ++numOfBytes;
        }
        return numOfBytes;
    }

    public static void calculateUsedWidths(Metrics metrics) {
        ArrayList<AbstractAnnotation> rootAnnotations = new ArrayList<AbstractAnnotation>();
        TimeCodedTranscription tr = metrics.getTranscription();
        List<TierImpl> topTiers = ((TranscriptionImpl)tr.getTranscription()).getTopTiers();
        for (TierImpl tierImpl : topTiers) {
            rootAnnotations.addAll(tierImpl.getAnnotations());
        }
        for (Annotation annotation : rootAnnotations) {
            SizeCalculator.determineUsedWidth(annotation, metrics);
        }
    }

    private static int determineUsedWidth(Annotation ann, Metrics metrics) {
        int maxUsedWidth;
        TimeCodedTranscription tr = metrics.getTranscription();
        int annWidth = maxUsedWidth = metrics.getSize(ann);
        int usedWidth = 0;
        HashMap<Tier, Integer> usedPerTier = new HashMap<Tier, Integer>();
        HashMap<Tier, Annotation> lastChildPerTier = new HashMap<Tier, Annotation>();
        List<? extends Annotation> childAnnots = tr.getChildAnnotationsOf(ann);
        for (Annotation annotation : childAnnots) {
            usedWidth = SizeCalculator.determineUsedWidth(annotation, metrics);
            Integer currWidthForTier = (Integer)usedPerTier.get(annotation.getTier());
            if (currWidthForTier != null) {
                usedPerTier.put(annotation.getTier(), currWidthForTier + usedWidth + metrics.getInterlinearizer().getEmptySpace());
            } else {
                usedPerTier.put(annotation.getTier(), usedWidth);
            }
            Annotation lastOnTier = (Annotation)lastChildPerTier.get(annotation.getTier());
            if (lastOnTier != null) {
                if (annotation.compareTo(lastOnTier) <= 0) continue;
                lastChildPerTier.put(annotation.getTier(), annotation);
                continue;
            }
            lastChildPerTier.put(annotation.getTier(), annotation);
        }
        Collection sizes = usedPerTier.values();
        Iterator iterator = sizes.iterator();
        while (iterator.hasNext()) {
            int sizePerTier = (Integer)iterator.next();
            if (sizePerTier <= maxUsedWidth) continue;
            maxUsedWidth = sizePerTier;
        }
        if (maxUsedWidth == annWidth) {
            for (Tier t : usedPerTier.keySet()) {
                int widthToBeAdded = maxUsedWidth - (Integer)usedPerTier.get(t);
                if (widthToBeAdded <= 0) continue;
                Annotation lastAnn = (Annotation)lastChildPerTier.get(t);
                metrics.setUsedWidth(lastAnn, metrics.getUsedWidth(lastAnn) + widthToBeAdded);
            }
        }
        metrics.setUsedWidth(ann, maxUsedWidth);
        return maxUsedWidth;
    }
}

