/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;

public class IncludedIn
extends ConstraintImpl {
    @Override
    public void forceTimes(long[] segment, TierImpl forTier) {
        if (forTier != null) {
            Annotation annAtBegin = forTier.getAnnotationAtTime(segment[0]);
            Annotation annAtEnd = forTier.getAnnotationAtTime(segment[1]);
            if (annAtBegin != null && annAtEnd == null) {
                segment[1] = annAtBegin.getEndTimeBoundary();
            } else if (annAtBegin == null && annAtEnd != null) {
                segment[0] = annAtEnd.getBeginTimeBoundary();
            } else if (annAtBegin != null && annAtEnd != null && annAtBegin != annAtEnd) {
                segment[0] = annAtEnd.getBeginTimeBoundary();
            } else if (annAtBegin == null && annAtEnd == null) {
                List<Annotation> annotsInBetween = forTier.getOverlappingAnnotations(segment[0], segment[1]);
                if (annotsInBetween.size() > 0) {
                    AlignableAnnotation a = (AlignableAnnotation)annotsInBetween.get(0);
                    segment[0] = a.getBegin().getTime();
                    segment[1] = a.getEnd().getTime();
                } else {
                    segment[0] = segment[1];
                }
            }
        }
    }

    @Override
    public int getStereoType() {
        return 1;
    }

    @Override
    public boolean supportsInsertion() {
        return false;
    }

    @Override
    public void detachAnnotation(Annotation theAnn, TierImpl theTier) {
    }

    @Override
    public void enforceOnWholeTier(TierImpl theTier) {
        System.out.println("IncludedIn: enforce...");
    }

    @Override
    public List<TimeSlot> getTimeSlotsForNewAnnotation(long begin, long end, TierImpl forTier) {
        ArrayList<TimeSlot> slots = new ArrayList<TimeSlot>(2);
        TierImpl parentTier = forTier.getParentTier();
        AlignableAnnotation parentAnn = null;
        List<Annotation> overlappingParentAnns = parentTier.getOverlappingAnnotations(begin, end);
        if (overlappingParentAnns.isEmpty()) {
            return slots;
        }
        parentAnn = (AlignableAnnotation)overlappingParentAnns.get(0);
        if (!parentAnn.getBegin().isTimeAligned() || !parentAnn.getEnd().isTimeAligned()) {
            return slots;
        }
        if (parentAnn.getBegin().getTime() > begin) {
            begin = parentAnn.getBegin().getTime();
        }
        if (parentAnn.getEnd().getTime() < end) {
            end = parentAnn.getEnd().getTime();
        }
        List<Annotation> overlappingAnnots = forTier.getOverlappingAnnotations(begin, end);
        TimeOrder timeOrder = forTier.getTranscription().getTimeOrder();
        TimeSlotImpl bts = new TimeSlotImpl(begin, timeOrder);
        TimeSlotImpl ets = new TimeSlotImpl(end, timeOrder);
        timeOrder.insertTimeSlot(bts);
        timeOrder.insertTimeSlot(ets);
        slots.add(bts);
        slots.add(ets);
        Iterator<Annotation> anIt = overlappingAnnots.iterator();
        AlignableAnnotation curAnn = null;
        while (anIt.hasNext()) {
            curAnn = (AlignableAnnotation)anIt.next();
            if (curAnn.getBegin().getTime() >= begin) {
                if (curAnn.getEnd().getTime() > end) {
                    curAnn.getBegin().setTime(end);
                    continue;
                }
                curAnn.setBegin(curAnn.getEnd());
                continue;
            }
            if (curAnn.getEnd().getTime() <= begin) continue;
            curAnn.getEnd().setTime(begin);
        }
        return slots;
    }
}

