/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.abstr.ParserFactory;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.SimpleReport;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class EAFValidator {
    private SimpleReport report = new SimpleReport();
    private String filePath;
    private File eafFile = null;

    public EAFValidator(File eafFile) {
        this.eafFile = eafFile;
    }

    public EAFValidator(String eafFileName) {
        this.filePath = eafFileName;
    }

    public ProcessReport getReport() {
        return this.report;
    }

    public String getReportAsString() {
        return this.report.getReportAsString();
    }

    public void validate() {
        if (this.eafFile == null && this.filePath == null) {
            this.report.append("No eaf file or eaf file path provided, nothing to validate");
            return;
        }
        if (this.eafFile == null) {
            this.eafFile = new File(this.filePath);
        } else {
            this.filePath = this.eafFile.getAbsolutePath();
        }
        if (this.eafFile.exists() && this.eafFile.canRead() && !this.eafFile.isDirectory()) {
            this.validateLocalFile();
        } else {
            this.validateRemoteFile();
        }
    }

    private void validateLocalFile() {
        this.report.append("Checking file: " + this.filePath + "\n");
        try {
            FileInputStream fis = new FileInputStream(this.eafFile);
            InputSource is = new InputSource(fis);
            is.setSystemId(this.filePath);
            this.validateXML(is);
            try {
                fis.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int version = ACMTranscriptionStore.eafFileFormatTaster(this.eafFile.getAbsolutePath());
            Parser eafParser = ParserFactory.getParser(version);
            this.validateContent(eafParser);
        }
        catch (FileNotFoundException fnfe) {
            this.report.append("Cannot validate file - NotFound: " + fnfe.getMessage());
        }
        catch (Throwable t) {
            this.report.append("Cannot validate file: " + t.getMessage());
        }
    }

    private void validateRemoteFile() {
        try {
            this.report.append("Checking file: " + this.filePath + "\n");
            URI fileURI = new URI(this.filePath);
            InputStream inStream = fileURI.toURL().openStream();
            InputSource is = new InputSource(inStream);
            is.setSystemId(this.filePath);
            this.validateXML(is);
            try {
                inStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Parser eafParser = ParserFactory.getParser(16);
            this.validateContent(eafParser);
        }
        catch (URISyntaxException use) {
            this.report.append("Cannot validate file - URISyntax: " + use.getMessage());
        }
        catch (IOException ioe) {
            this.report.append("Cannot validate file - IO: " + ioe.getMessage());
        }
    }

    private void validateXML(InputSource inSource) {
        try {
            ValidationHandler handler = new ValidationHandler();
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            parserFactory.setNamespaceAware(true);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setErrorHandler(handler);
            Schema eafSchema = schemaFactory.newSchema();
            parserFactory.setSchema(eafSchema);
            SAXParser parser = parserFactory.newSAXParser();
            this.report.append("++ Start of XML validation by SAXParser\n");
            parser.parse(inSource, (DefaultHandler)handler);
        }
        catch (FactoryConfigurationError fce) {
            this.report.append("Parse problem - FactoryConfiguration: " + fce.getMessage());
        }
        catch (SAXNotSupportedException snse) {
            this.report.append("Parse problem - SAXNotSupported: " + snse.getMessage());
        }
        catch (SAXNotRecognizedException snre) {
            this.report.append("Parse problem - SaxNotRecognized: " + snre.getMessage());
        }
        catch (ParserConfigurationException pce) {
            this.report.append("Parse problem - ParserConfiguration: " + pce.getMessage());
        }
        catch (SAXException se) {
            this.report.append("Parse problem - SAXException: " + se.getMessage());
        }
        catch (IOException ioe) {
            this.report.append("Parse problem - IO: " + ioe.getMessage());
        }
    }

    private void validateContent(Parser eafParser) {
        this.report.append("Checking contents of the EAF file");
        eafParser.getTierNames(this.filePath);
        this.checkTierTypes(eafParser);
        this.checkTiers(eafParser);
        this.checkCVs(eafParser);
    }

    private void checkTiers(Parser eafParser) {
        this.report.append("++ Start of Tiers");
        List<String> tierNameList = eafParser.getTierNames(this.filePath);
        List<LingTypeRecord> tierTypeRecords = eafParser.getLinguisticTypes(this.filePath);
        Map<String, String> timeSlotMap = eafParser.getTimeSlots(this.filePath);
        int numTierTypeInconsistencies = 0;
        boolean cveRefChecked = false;
        for (String tierName : tierNameList) {
            long et;
            long bt;
            this.report.append("Checking tier: " + tierName);
            String tierType = eafParser.getLinguisticTypeIDOf(tierName, this.filePath);
            LingTypeRecord typeRecord = null;
            for (LingTypeRecord ltr : tierTypeRecords) {
                if (ltr.getLingTypeId() == null || !ltr.getLingTypeId().equals(tierType)) continue;
                typeRecord = ltr;
                break;
            }
            String stereoType = null;
            boolean tierTimeAlignable = false;
            if (typeRecord == null) {
                this.report.append("ERROR: the tier type (linguistic type) of the tier is null");
            } else {
                stereoType = typeRecord.getStereoType();
                tierTimeAlignable = Boolean.valueOf(typeRecord.getTimeAlignable());
                String parentTierName = eafParser.getParentNameOf(tierName, this.filePath);
                if (parentTierName != null && stereoType == null) {
                    ++numTierTypeInconsistencies;
                    this.report.append(String.format("ERROR: tier \"%s\" has parent tier \"%s\" but has no stereotype CONSTRAINT defined in its linguistic type \"%s\"", tierName, parentTierName, typeRecord.getLingTypeId()));
                }
                if (parentTierName == null && stereoType != null) {
                    ++numTierTypeInconsistencies;
                    this.report.append(String.format("ERROR: tier \"%s\" has no parent tier but has stereotype CONSTRAINT \"%s\" defined in its linguistic type \"%s\"", tierName, stereoType, typeRecord.getLingTypeId()));
                }
            }
            cveRefChecked = false;
            List<AnnotationRecord> annRecordList = eafParser.getAnnotationsOf(tierName, this.filePath);
            int numAlignableAnn = 0;
            int numReferenceAnn = 0;
            int numRefAnnOnAlignTier = 0;
            int numAlignAnnOnRefTier = 0;
            for (AnnotationRecord annRec : annRecordList) {
                if ("alignable".equals(annRec.getAnnotationType())) {
                    ++numAlignableAnn;
                    if (!tierTimeAlignable) {
                        ++numAlignAnnOnRefTier;
                    }
                    if (annRec.getAnnotationId() == null || annRec.getAnnotationId().isEmpty()) {
                        this.report.append(String.format("ERROR: annotation at index %d has no ANNOTATION_ID", annRecordList.indexOf(annRec)));
                    }
                    bt = -2L;
                    et = -2L;
                    if (annRec.getBeginTimeSlotId() == null || annRec.getBeginTimeSlotId().isEmpty()) {
                        this.report.append(String.format("ERROR: annotation with id=\"%s\" has no TIME_SLOT_REF1 (begin time)", annRec.getAnnotationId()));
                    } else {
                        bt = this.toTime(timeSlotMap.get(annRec.getBeginTimeSlotId()));
                        if (bt == -2L) {
                            this.report.append(String.format("ERROR: annotation with id=\"%s\" refers to non-existing time slot with id=\"%s\"", annRec.getAnnotationId(), annRec.getBeginTimeSlotId()));
                        } else if (bt == Long.MIN_VALUE) {
                            this.report.append(String.format("ERROR: the value \"%s\" of the time slot with id=\"%s\" is not a valid time in ms", timeSlotMap.get(annRec.getBeginTimeSlotId()), annRec.getBeginTimeSlotId()));
                        } else if (bt == -1L && !"Time_Subdivision".equals(stereoType)) {
                            this.report.append(String.format("ERROR: unaligned time slots are only allowed on \"%s\" type of tiers, not on \"%s\" tiers (time slot id=\"%s\")", "Time_Subdivision", stereoType, annRec.getBeginTimeSlotId()));
                        }
                    }
                    if (annRec.getEndTimeSlotId() == null || annRec.getEndTimeSlotId().isEmpty()) {
                        this.report.append(String.format("ERROR: annotation with id=\"%s\" has no TIME_SLOT_REF2 (end time)", annRec.getAnnotationId()));
                    } else {
                        et = this.toTime(timeSlotMap.get(annRec.getEndTimeSlotId()));
                        if (et == -2L) {
                            this.report.append(String.format("ERROR: annotation with id=\"%s\" refers to non-existing time slot with id=\"%s\"", annRec.getAnnotationId() + annRec.getEndTimeSlotId()));
                        } else if (et == Long.MIN_VALUE) {
                            this.report.append(String.format("ERROR: the value \"%s\" of the time slot with id=\"%s\" is not a valid time in ms", timeSlotMap.get(annRec.getEndTimeSlotId()), annRec.getEndTimeSlotId()));
                        } else if (et == -1L && !"Time_Subdivision".equals(stereoType)) {
                            this.report.append(String.format("ERROR: unaligned time slots are only allowed on \"%s\" type of tiers, not on \"%s\" tiers (time slot id=\"%s\")", "Time_Subdivision", stereoType, annRec.getEndTimeSlotId()));
                        }
                    }
                    if (annRec.getBeginTimeSlotId() != null && annRec.getBeginTimeSlotId().equals(annRec.getEndTimeSlotId())) {
                        this.report.append(String.format("ERROR: annotation with id=\"%s\" has TIME_SLOT_REF1 equal to TIME_SLOT_REF2", annRec.getAnnotationId()));
                    }
                    if (bt > -1L && et > -1L && bt == et) {
                        this.report.append(String.format("ERROR: annotation with id=\"%s\" has begin time equal to end time: %d", annRec.getAnnotationId(), bt));
                    }
                    if (et > -1L && et < bt) {
                        this.report.append(String.format("ERROR: annotation with id=\"%s\" has an end time < begin time: %d < %d", annRec.getAnnotationId(), et, bt));
                    }
                } else if ("reference".equals(annRec.getAnnotationType())) {
                    ++numReferenceAnn;
                    if (tierTimeAlignable) {
                        ++numRefAnnOnAlignTier;
                    }
                    if (stereoType != null && stereoType.equals("Symbolic_Association") && annRec.getPreviousAnnotId() != null && !annRec.getPreviousAnnotId().isEmpty()) {
                        this.report.append(String.format("ERROR: annotation with id=\"%s\" has a previous annotation reference id=\"%s\" while on a Symbolic Association tier", annRec.getAnnotationId(), annRec.getPreviousAnnotId()));
                    }
                }
                if (cveRefChecked || annRec.getCvEntryId() == null) continue;
                if (typeRecord != null && (typeRecord.getControlledVocabulary() == null || typeRecord.getControlledVocabulary().isEmpty())) {
                    this.report.append(String.format("ERROR: annotation id =\"%s\" refers to a CV entry id=\"%s\" while the tier type id=\"%s\" is not linked to a controlled vocabulary", annRec.getAnnotationId(), annRec.getCvEntryId(), typeRecord.getLingTypeId()));
                }
                cveRefChecked = true;
            }
            if (numAlignableAnn > 0) {
                block3: for (int i = 0; i < annRecordList.size(); ++i) {
                    AnnotationRecord annRec;
                    annRec = annRecordList.get(i);
                    bt = this.toTime(timeSlotMap.get(annRec.getBeginTimeSlotId()));
                    et = this.toTime(timeSlotMap.get(annRec.getEndTimeSlotId()));
                    if (bt <= -1L || et <= bt) continue;
                    for (int j = i + 1; j < annRecordList.size(); ++j) {
                        AnnotationRecord annRec2 = annRecordList.get(j);
                        long bt2 = this.toTime(timeSlotMap.get(annRec2.getBeginTimeSlotId()));
                        long et2 = this.toTime(timeSlotMap.get(annRec2.getEndTimeSlotId()));
                        if (bt2 <= -1L || et2 <= bt2 || bt2 >= et || et2 <= bt) continue;
                        this.report.append(String.format("ERROR: annotation with id=\"%s\" overlaps with (at least) annotation with id=\"%s\": %d-%d, %d-%d", annRec.getAnnotationId(), annRec2.getAnnotationId(), bt, et, bt2, et2));
                        continue block3;
                    }
                }
            }
            if (numAlignableAnn > 0 && numReferenceAnn > 0) {
                this.report.append(String.format("ERROR: the tier \"%s\" contains a mixture of annotations, alignable: %d, reference: %d", tierName, numAlignableAnn, numReferenceAnn));
            }
            if (numRefAnnOnAlignTier > 0) {
                this.report.append(String.format("ERROR: the tier \"%s\" contains %d reference annotations not consistent with tier stereotype \"%s\"", tierName, numRefAnnOnAlignTier, stereoType == null ? "None" : stereoType));
            }
            if (numAlignAnnOnRefTier <= 0) continue;
            this.report.append(String.format("ERROR: the tier \"%s\" contains %d alignable annotations not consistent with tier stereotype \"%s\"", tierName, numAlignAnnOnRefTier, stereoType));
        }
        if (numTierTypeInconsistencies > 0) {
            this.report.append("There are tier-type/tier-hierarchy inconsistencies. Please refer to the EAF format documentation:");
            this.report.append("https://www.mpi.nl/tools/elan/EAF_Annotation_Format_3.0_and_ELAN.pdf");
            this.report.append("for valid combinations of tier constraints and tier dependencies.");
        }
        this.report.append("-- End of Tiers");
    }

    private void checkTierTypes(Parser eafParser) {
        this.report.append("++ Start of Tier Types (a.k.a. Linguistic Types)");
        for (LingTypeRecord typeRecord : eafParser.getLinguisticTypes(this.filePath)) {
            String stereoType = typeRecord.getStereoType();
            boolean timeAlignable = Boolean.valueOf(typeRecord.getTimeAlignable());
            if (typeRecord == null) continue;
            if (stereoType == null) {
                if (timeAlignable) continue;
                this.report.append(String.format("ERROR: the tier type \"%s\" is for a top-level tier (no CONSTRAINTS), yet is not TIME_ALIGNABLE", typeRecord.getLingTypeId()));
                continue;
            }
            if (stereoType.equals("Time_Subdivision") || stereoType.equals("Included_In")) {
                if (timeAlignable) continue;
                this.report.append(String.format("ERROR: Stereotype \"%s\" should be TIME_ALIGNABLE", stereoType));
                continue;
            }
            if (stereoType.equals("Symbolic_Subdivision") || stereoType.equals("Symbolic_Association")) {
                if (!timeAlignable) continue;
                this.report.append(String.format("ERROR: Stereotype \"%s\" should not be TIME_ALIGNABLE", stereoType));
                continue;
            }
            this.report.append(String.format("ERROR: Stereotype \"%s\" is an unknown stereotype", stereoType));
        }
        this.report.append("-- End of Tier Types");
    }

    private void checkCVs(Parser eafParser) {
        this.report.append("++ Start of Controlled Vocabularies");
        Map<String, CVRecord> cvRecords = eafParser.getControlledVocabularies(this.filePath);
        for (CVRecord cvr : cvRecords.values()) {
            if (cvr.getExtRefId() == null || cvr.getExtRefId().isEmpty() || !cvr.getExtRefId().trim().toLowerCase().endsWith(".ecv") || cvr.getEntries() == null || cvr.getEntries().isEmpty()) continue;
            this.report.append(String.format("The CONTROLLED_VOCABULARY id=\"%s\" seems to be external (EXT_REF=\"%s\"), it should not contain internal entries", cvr.getCv_id(), cvr.getExtRefId()));
        }
        this.report.append("-- End of Controlled Vocabularies");
    }

    private long toTime(String timeValue) {
        if (timeValue != null) {
            try {
                return Long.valueOf(timeValue);
            }
            catch (NumberFormatException nfe) {
                return Long.MIN_VALUE;
            }
        }
        return -2L;
    }

    private class ValidationHandler
    extends DefaultHandler {
        int numWarnings = 0;
        int numErrors = 0;

        private ValidationHandler() {
        }

        @Override
        public void endDocument() throws SAXException {
            EAFValidator.this.report.append(String.format("Received %d warnings and %d errors", this.numWarnings, this.numErrors));
            EAFValidator.this.report.append("-- End of XML validation by SAXParser\n");
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (this.numWarnings < 5) {
                EAFValidator.this.report.append("Warning: " + e.getMessage());
            }
            ++this.numWarnings;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            if (this.numErrors < 10) {
                EAFValidator.this.report.append("ERROR:   " + e.getMessage());
                EAFValidator.this.report.append("Line:    " + e.getLineNumber());
                EAFValidator.this.report.append("Column:  " + e.getColumnNumber());
            }
            ++this.numErrors;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            EAFValidator.this.report.append("Fatal parsing error: " + e.getMessage());
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            InputStream stream = null;
            String resource = null;
            if (systemId.equals(ACMTranscriptionStore.getCurrentEAFSchemaRemote())) {
                resource = ACMTranscriptionStore.getCurrentEAFSchemaLocal();
            } else if (systemId.equals("http://www.mpi.nl/tools/elan/EAFv3.0.xsd")) {
                resource = "/mpi/eudico/resources/EAFv3.0.xsd";
            } else if (systemId.equals("http://www.mpi.nl/tools/elan/EAFv2.8.xsd")) {
                resource = "/mpi/eudico/resources/EAFv2.8.xsd";
            } else if (systemId.equals("http://www.mpi.nl/tools/elan/EAFv2.8.xsd")) {
                resource = "/mpi/eudico/resources/EAFv2.8.xsd";
            } else if (systemId.equals("http://www.mpi.nl/tools/elan/EAFv2.7.xsd")) {
                resource = "/mpi/eudico/resources/EAFv2.7.xsd";
            } else if (systemId.matches(".*v[3-9].[1-9]\\.xsd\\s*")) {
                resource = ACMTranscriptionStore.getCurrentEAFSchemaLocal();
                EAFValidator.this.report.append("The schema version of the file seems to be newer than expected: " + systemId.substring(systemId.lastIndexOf(47) + 1));
            } else {
                resource = "/mpi/eudico/resources/EAFv2.7.xsd";
            }
            if (resource != null) {
                try {
                    stream = this.getClass().getResource(resource).openStream();
                    InputStreamReader reader = new InputStreamReader(stream);
                    EAFValidator.this.report.append("Resolved schema to local resource: " + resource + "\n");
                    return new InputSource(reader);
                }
                catch (IOException e) {
                    EAFValidator.this.report.append("Cannot create a local Input Source for the EAF schema");
                }
            }
            return null;
        }
    }
}

