/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.wordlist;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.wordlist.WordListEncoderInfo;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.ProcessReporter;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.MutableInt;

public class Transcription2WordList
implements AnnotationDocEncoder,
ProcessReporter {
    private final String NEWLINE = "\n";
    private String delimiters = " \t\n\r\f.,!?\"'";
    private ProcessReport report;
    private int wordCount;
    private int annCount;
    private int uniqueCount;
    private int tierCount;
    private int fileCount;

    @Override
    public void encodeAndSave(Transcription transcription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, String path) throws IOException {
        if (transcription == null) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "Error while exporting the list: transcription is null");
            }
            throw new IllegalArgumentException("The transcription is null");
        }
        if (!(encoderInfo instanceof WordListEncoderInfo)) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "Error while exporting the list: the encoder information is null or of the wrong type");
            }
            throw new IllegalArgumentException("The encoder settings object is null or of the wrong type");
        }
        this.exportWords((TranscriptionImpl)transcription, (WordListEncoderInfo)encoderInfo);
    }

    public void encodeAndSave(List<File> files, EncoderInfo encoderInfo) throws IOException {
        if (files == null || files.size() == 0) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "Error while exporting the list: the list of files is null or empty");
            }
            throw new IllegalArgumentException("The list of files is null or empty");
        }
        if (!(encoderInfo instanceof WordListEncoderInfo)) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "Error while exporting the list: the encoder information is null or of the wrong type");
            }
            throw new IllegalArgumentException("The encoder settings object is null or of the wrong type");
        }
        this.exportWords(files, (WordListEncoderInfo)encoderInfo);
    }

    private void exportWords(TranscriptionImpl transcription, WordListEncoderInfo encoderInfo) throws IOException {
        if (encoderInfo.getExportFile() == null) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.warning("No destination file specified for export");
            }
            throw new IOException("No destination file specified for export");
        }
        if (encoderInfo.getDelimiters() != null) {
            this.delimiters = encoderInfo.getDelimiters();
        }
        if (encoderInfo.getSelectedTiers() == null && ServerLogger.LOG.isLoggable(Level.WARNING)) {
            ServerLogger.LOG.log(Level.WARNING, "No tiers specified for the wordlist: using all tiers");
        }
        this.fileCount = 1;
        TreeMap<String, MutableInt> uniqueWords = new TreeMap<String, MutableInt>();
        this.addUniqueWordsAndCount(uniqueWords, transcription, encoderInfo.getSelectedTiers());
        this.writeResults(encoderInfo, uniqueWords);
        this.createReport(!this.delimiters.isEmpty());
    }

    private void exportWords(List<File> files, WordListEncoderInfo encoderInfo) throws IOException {
        if (encoderInfo.getExportFile() == null) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.warning("No destination file specified for export");
            }
            throw new IOException("No destination file specified for export");
        }
        if (encoderInfo.getDelimiters() != null) {
            this.delimiters = encoderInfo.getDelimiters();
        }
        if (encoderInfo.getSelectedTiers() == null && ServerLogger.LOG.isLoggable(Level.WARNING)) {
            ServerLogger.LOG.log(Level.WARNING, "No tiers specified for the wordlist: using all tiers");
        }
        TreeMap<String, MutableInt> uniqueWords = new TreeMap<String, MutableInt>();
        for (int i = 0; i < files.size(); ++i) {
            block7: {
                File file = files.get(i);
                if (file == null) continue;
                try {
                    TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                    this.addUniqueWordsAndCount(uniqueWords, trans, encoderInfo.getSelectedTiers());
                }
                catch (Exception ex) {
                    if (!ServerLogger.LOG.isLoggable(Level.SEVERE)) break block7;
                    ServerLogger.LOG.log(Level.SEVERE, "Could not handle file: " + file.getAbsolutePath());
                    ServerLogger.LOG.log(Level.SEVERE, ex.getMessage());
                }
            }
            ++this.fileCount;
        }
        this.writeResults(encoderInfo, uniqueWords);
        this.createReport(!this.delimiters.isEmpty());
    }

    private void writeResults(WordListEncoderInfo encoderInfo, Map<String, MutableInt> uniqueWords) throws IOException {
        this.uniqueCount = uniqueWords.size();
        FileOutputStream out = new FileOutputStream(encoderInfo.getExportFile());
        OutputStreamWriter osw = null;
        try {
            String encoding = encoderInfo.getEncoding() != null ? encoderInfo.getEncoding() : "UTF-8";
            osw = new OutputStreamWriter((OutputStream)out, encoding);
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        for (Map.Entry<String, MutableInt> e : uniqueWords.entrySet()) {
            String key = e.getKey();
            writer.write(key);
            if (encoderInfo.isCountOccurrences()) {
                MutableInt val = e.getValue();
                writer.write("\t" + val.intValue);
                if (encoderInfo.isIncludeFreqPercent()) {
                    writer.write(String.format("\t%4.3f", Float.valueOf(100.0f * ((float)val.intValue / (float)this.wordCount))));
                }
            }
            writer.write("\n");
        }
        if (encoderInfo.isIncludeCounts()) {
            writer.write("\n");
            writer.write("Statistics:");
            writer.write("\n");
            writer.write(String.format("Files:\t%d", this.fileCount));
            writer.write("\n");
            writer.write(String.format("Tiers:\t%d", this.tierCount));
            writer.write("\n");
            writer.write(String.format("Annotations:\t%d", this.annCount));
            writer.write("\n");
            if (encoderInfo.getExportMode() == WordListEncoderInfo.WORDS) {
                writer.write(String.format("Unique Words:\t%d", this.uniqueCount));
                writer.write("\n");
                writer.write(String.format("Total Words:\t%d", this.wordCount));
            } else {
                writer.write(String.format("Unique Annotation Values:\t%d", this.uniqueCount));
                writer.write("\n");
                writer.write(String.format("Total Annotation Values:\t%d", this.wordCount));
            }
        }
        try {
            writer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addUniqueWordsAndCount(Map<String, MutableInt> uniqueWords, TranscriptionImpl transcription, List<String> tierNames) {
        if (transcription == null) {
            if (ServerLogger.LOG.isLoggable(Level.SEVERE)) {
                ServerLogger.LOG.severe("The transcription to extract words from is null");
            }
            return;
        }
        List<TierImpl> tierList = tierNames != null ? transcription.getTiersWithIds(tierNames) : transcription.getTiers();
        for (Tier tier : tierList) {
            if (tier != null) {
                for (Annotation annotation : tier.getAnnotations()) {
                    if (annotation != null) {
                        String value = annotation.getValue();
                        if (value.length() > 0) {
                            if (this.delimiters.length() > 0) {
                                StringTokenizer tokenizer = new StringTokenizer(value, this.delimiters);
                                while (tokenizer.hasMoreTokens()) {
                                    String token = tokenizer.nextToken();
                                    if (!uniqueWords.containsKey(token)) {
                                        uniqueWords.put(token, new MutableInt(1));
                                    } else {
                                        ++uniqueWords.get((Object)token).intValue;
                                    }
                                    ++this.wordCount;
                                }
                            } else {
                                if (!uniqueWords.containsKey(value)) {
                                    uniqueWords.put(value, new MutableInt(1));
                                } else {
                                    ++uniqueWords.get((Object)value).intValue;
                                }
                                ++this.wordCount;
                            }
                        }
                        ++this.annCount;
                        continue;
                    }
                    if (!ServerLogger.LOG.isLoggable(Level.WARNING)) continue;
                    ServerLogger.LOG.log(Level.WARNING, "Annotation is null");
                }
            }
            ++this.tierCount;
        }
    }

    private void createReport(boolean wordMode) {
        if (this.report != null) {
            this.report.append("Statistics:\n");
            this.report.append(String.format("Files:\t%d", this.fileCount));
            this.report.append(String.format("Tiers:\t%d", this.tierCount));
            this.report.append(String.format("Annotations:\t%d", this.annCount));
            if (wordMode) {
                this.report.append(String.format("Unique Words:\t%d", this.uniqueCount));
                this.report.append(String.format("Total Words:\t%d", this.wordCount));
            } else {
                this.report.append(String.format("Unique Annotation Values:\t%d", this.uniqueCount));
                this.report.append(String.format("Total Annotation Values:\t%d", this.wordCount));
            }
        }
    }

    @Override
    public void setProcessReport(ProcessReport report) {
        this.report = report;
    }

    @Override
    public ProcessReport getProcessReport() {
        return this.report;
    }

    @Override
    public void report(String message) {
        if (this.report != null) {
            this.report.append(message);
        }
    }
}

