/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.webserviceclient.typecraft;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.webserviceclient.typecraft.MorphRecord;
import mpi.eudico.webserviceclient.typecraft.PhraseRecord;
import mpi.eudico.webserviceclient.typecraft.TextRecord;
import mpi.eudico.webserviceclient.typecraft.WordRecord;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TCParser
extends DefaultHandler {
    private List<PhraseRecord> phraseRecords;
    private TextRecord textRecord;
    private StringBuilder content = new StringBuilder();
    PhraseRecord curPhrase;
    WordRecord curWord;
    MorphRecord curMorph;
    private String inputContent;

    public TCParser(String inputContent) {
        this.inputContent = inputContent;
    }

    public void parse() throws SAXException, IOException {
        if (this.inputContent == null) {
            return;
        }
        this.phraseRecords = new ArrayList<PhraseRecord>();
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(false);
            parserFactory.setValidating(false);
            parserFactory.newSAXParser().parse(new InputSource(new StringReader(this.inputContent)), (DefaultHandler)this);
        }
        catch (SAXException se) {
            ServerLogger.LOG.warning("Parser exception: " + se.getMessage());
            throw se;
        }
        catch (IOException ioe) {
            ServerLogger.LOG.warning("IO exception: " + ioe.getMessage());
            throw ioe;
        }
        catch (ParserConfigurationException pce) {
            ServerLogger.LOG.warning("Parser configuration exception: " + pce.getMessage());
            throw new SAXException(pce);
        }
    }

    public List<PhraseRecord> getPhraseRecords() {
        return this.phraseRecords;
    }

    public TextRecord getTextRecord() {
        return this.textRecord;
    }

    private long parseLong(String longString) {
        if (longString == null) {
            return 0L;
        }
        try {
            return Long.parseLong(longString);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("phrase")) {
            this.curPhrase = new PhraseRecord();
            this.curPhrase.id = atts.getValue("id");
            this.curPhrase.valid = atts.getValue("valid");
            this.curPhrase.speaker = atts.getValue("speaker");
            long bt = this.parseLong(atts.getValue("offset"));
            long dur = this.parseLong(atts.getValue("duration"));
            if (bt != 0L || dur != 0L) {
                this.curPhrase.bt = bt;
                this.curPhrase.et = bt + dur;
            }
        } else if (qName.equals("word")) {
            this.curWord = new WordRecord();
            this.curWord.text = atts.getValue("text");
            this.curWord.head = atts.getValue("head");
        } else if (qName.equals("morpheme")) {
            this.curMorph = new MorphRecord();
            this.curMorph.text = atts.getValue("text");
            this.curMorph.baseform = atts.getValue("baseform");
            this.curMorph.meaning = atts.getValue("meaning");
        } else if (qName.equals("text")) {
            this.textRecord = new TextRecord();
            this.textRecord.id = atts.getValue("id");
            this.textRecord.lang = atts.getValue("lang");
        } else if (qName.equals("globaltags") || qName.equals("globaltag")) {
            // empty if block
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.content.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("phrase")) {
            this.phraseRecords.add(this.curPhrase);
        } else if (qName.equals("original")) {
            this.curPhrase.text = this.content.toString().trim();
        } else if (qName.equals("translation")) {
            this.curPhrase.translation = this.content.toString().trim();
        } else if (qName.equals("description")) {
            this.curPhrase.description = this.content.toString().trim();
        } else if (qName.equals("word")) {
            this.curPhrase.wordRecords.add(this.curWord);
        } else if (qName.equals("pos")) {
            this.curWord.pos = this.content.toString().trim();
        } else if (qName.equals("morpheme")) {
            this.curWord.morphs.add(this.curMorph);
        } else if (qName.equals("gloss")) {
            this.curMorph.glosses.add(this.content.toString().trim());
        } else if (qName.equals("title")) {
            this.textRecord.title = this.content.toString().trim();
        } else if (qName.equals("titleTranslation")) {
            this.textRecord.titleTrans = this.content.toString().trim();
        } else if (qName.equals("body")) {
            this.textRecord.body = this.content.toString().trim();
        } else if (qName.equals("globaltags") || qName.equals("globaltag")) {
            // empty if block
        }
        this.content.delete(0, this.content.length());
    }
}

