/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.viewer;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.TreeNode;
import mpi.eudico.util.CVEntry;
import mpi.search.SearchLocale;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.viewer.LocalizeListCellRenderer;
import mpi.search.content.query.viewer.TierListCellRenderer;

public class PatternPanel
extends JPanel
implements ItemListener {
    protected final CardLayout inputLayout = new CardLayout();
    protected final JComboBox<String> quantifierComboBox = new JComboBox<String>(AnchorConstraint.QUANTIFIERS);
    protected final JPanel inputPanel = new JPanel(this.inputLayout);
    protected JTextField textField = new JTextField(12);
    protected boolean enforceDefaultInputComponent = false;
    protected JComboBox<String> tierComboBox;
    protected final CorpusType type;

    public PatternPanel(CorpusType type, JComboBox<String> tierComboBox, TreeNode node, final Action startAction) {
        JLabel label;
        int gx;
        this.type = type;
        this.tierComboBox = tierComboBox;
        this.textField.setFont(this.getFont().deriveFont(1, this.getFont().getSize2D() * 1.2f));
        this.inputPanel.add((Component)this.textField, "");
        for (int j = 0; j < type.getTierNames().length; ++j) {
            String tierName = type.getTierNames()[j];
            List<CVEntry> closedVoc = type.getClosedVoc(tierName);
            if (closedVoc == null) continue;
            JComboBox<Object> comboBox = new JComboBox<Object>(closedVoc.toArray()){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(PatternPanel.this.textField.getPreferredSize().width, super.getPreferredSize().height);
                }
            };
            comboBox.setMaximumRowCount(15);
            comboBox.setEditable(type.isClosedVocEditable(closedVoc));
            this.inputPanel.add((Component)comboBox, tierName);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        gbc.gridx = gx = 0;
        if (node.getParent() == null || !type.allowsQuantifierNO()) {
            label = new JLabel(SearchLocale.getString("Search.Constraint.Any"));
            label.setFont(this.getFont().deriveFont(0));
            this.add((Component)label, gbc);
        } else {
            gbc.fill = 2;
            gbc.weightx = 0.1;
            this.add(this.quantifierComboBox, gbc);
            gbc.fill = 0;
            gbc.weightx = 0.0;
        }
        ++gx;
        gbc.gridx = gx++;
        label = new JLabel(String.join((CharSequence)" ", SearchLocale.getString("Search.Annotation_SG"), SearchLocale.getString("Search.Constraint.OnTier")));
        label.setFont(this.getFont().deriveFont(0));
        this.add((Component)label, gbc);
        gbc.gridx = gx++;
        this.add(tierComboBox, gbc);
        gbc.gridx = gx++;
        if (node.getParent() == null) {
            label = new JLabel(" " + SearchLocale.getString("Search.Constraint.That"));
            label.setFont(this.getFont().deriveFont(0));
            this.add((Component)label, gbc);
            gbc.gridx = gx;
        }
        label = new JLabel(" " + SearchLocale.getString("Search.Constraint.Matches") + " ");
        label.setFont(this.getFont().deriveFont(0));
        this.add((Component)label, gbc);
        gbc.gridx = ++gx;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.inputPanel, gbc);
        this.inputLayout.show(this.inputPanel, "");
        this.quantifierComboBox.setRenderer(new LocalizeListCellRenderer());
        this.quantifierComboBox.setSelectedItem("Search.Constraint.Any");
        tierComboBox.addItemListener(this);
        tierComboBox.setRenderer(new TierListCellRenderer(type));
        this.textField.requestFocus();
        if (startAction != null) {
            KeyAdapter l = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        startAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), KeyEvent.getKeyText(e.getKeyCode())));
                    }
                }
            };
            this.textField.addKeyListener(l);
        }
    }

    public Component getDefaultInputComponent() {
        return this.textField;
    }

    public void setPattern(String pattern) {
        Component c = this.getVisibleInputComponent();
        if (c instanceof JTextField) {
            ((JTextField)c).setText(pattern);
        } else {
            JComboBox comboBox = (JComboBox)c;
            int matchingIndex = this.getMatchingIndex(comboBox, pattern);
            if (matchingIndex >= 0) {
                comboBox.setSelectedIndex(matchingIndex);
            } else {
                comboBox.setSelectedItem(pattern);
            }
        }
        c.requestFocus();
    }

    private int getMatchingIndex(JComboBox<?> comboBox, String pattern) {
        int selectedIndex = -1;
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            if (!comboBox.getItemAt(i).toString().equals(pattern)) continue;
            comboBox.setSelectedIndex(i);
            selectedIndex = i;
            break;
        }
        return selectedIndex;
    }

    public String getPattern() {
        Component c = this.getVisibleInputComponent();
        return c instanceof JTextField ? ((JTextField)c).getText() : ((JComboBox)c).getSelectedItem().toString();
    }

    public void setQuantifier(String quantifier) {
        this.quantifierComboBox.setSelectedItem(quantifier);
    }

    public String getQuantifier() {
        return (String)this.quantifierComboBox.getSelectedItem();
    }

    public Component getVisibleInputComponent() {
        if (this.enforceDefaultInputComponent) {
            return this.textField;
        }
        Component[] comps = this.inputPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!comps[i].isVisible()) continue;
            return comps[i];
        }
        return this.textField;
    }

    public void setUseDefaultInputComponent(boolean enforceDefault) {
        this.enforceDefaultInputComponent = enforceDefault;
        this.updateInputPanel((String)this.tierComboBox.getSelectedItem());
    }

    protected void updateInputPanel(String tierName) {
        if (tierName == null || tierName.isEmpty()) {
            this.inputLayout.show(this.inputPanel, "");
        } else if (this.enforceDefaultInputComponent) {
            this.inputLayout.show(this.inputPanel, "");
        } else if (this.type.isClosedVoc(tierName)) {
            this.inputLayout.show(this.inputPanel, tierName);
        } else {
            this.inputLayout.show(this.inputPanel, "");
        }
        this.inputPanel.setLocale(this.type.getDefaultLocale(tierName));
        this.validate();
        this.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.updateInputPanel((String)e.getItem());
        }
    }
}

