/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.content.query.model.DependentConstraint;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class QueryContentHandler
extends DefaultHandler {
    private final List<String> tierNames = new ArrayList<String>();
    private final ContentQuery query;
    private final Map<String, Constraint> constraintHash = new HashMap<String, Constraint>();
    private Constraint constraint;
    private String currentContent;

    protected QueryContentHandler(ContentQuery query) {
        this.query = query;
    }

    @Override
    public void characters(char[] ch, int start, int end) throws SAXException {
        this.currentContent = this.currentContent + new String(ch, start, end);
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String namespaceURI, String elementName, String rawName) throws SAXException {
        if (elementName.equals("tier")) {
            this.tierNames.add(this.currentContent);
        } else if (elementName.equals("pattern")) {
            this.constraint.setPattern(this.currentContent);
        } else if (elementName.equals("anchorConstraint") || elementName.equals("dependentConstraint")) {
            this.constraint.setTierNames(this.tierNames.toArray(new String[0]));
        }
    }

    @Override
    public void startElement(String namespaceURI, String elementName, String rawName, Attributes atts) throws SAXException {
        block18: {
            if (elementName.equals("anchorConstraint") || elementName.equals("dependentConstraint")) {
                String s;
                block17: {
                    if (elementName.equals("anchorConstraint")) {
                        this.constraint = new AnchorConstraint();
                        s = atts.getValue("id");
                        if (s == null) {
                            throw new SAXException("Id is null in element " + elementName);
                        }
                        this.query.setAnchorConstraint((AnchorConstraint)this.constraint);
                        this.constraintHash.put(s, this.constraint);
                        this.tierNames.clear();
                    } else if (elementName.equals("dependentConstraint")) {
                        this.constraint = new DependentConstraint();
                        s = atts.getValue("id");
                        if (s == null) {
                            throw new SAXException("Id is null in element " + elementName);
                        }
                        this.constraintHash.put(s, this.constraint);
                        this.tierNames.clear();
                        s = atts.getValue("mode");
                        if (s != null) {
                            ((DependentConstraint)this.constraint).setMode(s);
                        }
                        if ((s = atts.getValue("quantifier")) != null) {
                            ((DependentConstraint)this.constraint).setQuantifier(s);
                        }
                        s = atts.getValue("id_ref");
                        Constraint parent = this.constraintHash.get(s);
                        parent.insert(this.constraint, parent.getChildCount());
                    }
                    s = atts.getValue("regularExpression");
                    if (s != null) {
                        this.constraint.setRegEx(Boolean.valueOf(s));
                    }
                    if ((s = atts.getValue("caseSensitive")) != null) {
                        this.constraint.setCaseSensitive(Boolean.valueOf(s));
                    }
                    if ((s = atts.getValue("unit")) != null) {
                        this.constraint.setUnit(s);
                    }
                    if ((s = atts.getValue("from")) != null) {
                        try {
                            this.constraint.setLowerBoundary(Long.parseLong(s));
                        }
                        catch (NumberFormatException ne) {
                            if (ne.getMessage().equals("null")) break block17;
                            System.out.println(ne.getMessage());
                        }
                    }
                }
                if ((s = atts.getValue("to")) != null) {
                    try {
                        this.constraint.setUpperBoundary(Long.parseLong(s));
                    }
                    catch (NumberFormatException ne) {
                        if (ne.getMessage().equals("null")) break block18;
                        System.out.println(ne.getMessage());
                    }
                }
            }
        }
        this.currentContent = "";
    }
}

