/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.result.model;

import java.util.ArrayList;
import java.util.List;
import mpi.search.content.result.model.ContentMatch;
import mpi.search.result.model.Result;

public class ContentResult
extends Result {
    private final List<String> tierNames = new ArrayList<String>();
    private int occurrenceCount = 0;

    @Override
    public synchronized void addMatch(ContentMatch match) {
        super.addMatch(match);
        if (match instanceof ContentMatch) {
            ContentMatch contentMatch = match;
            if (!this.tierNames.contains(contentMatch.getTierName())) {
                this.tierNames.add(contentMatch.getTierName());
            }
            if (contentMatch.getMatchedSubstringIndices() != null) {
                this.occurrenceCount += contentMatch.getMatchedSubstringIndices().length;
            }
        }
    }

    public List<ContentMatch> getMatches(String tierName) {
        if (tierName == null) {
            return null;
        }
        ArrayList<ContentMatch> matchesInTier = new ArrayList<ContentMatch>();
        for (int i = 1; i <= this.getRealSize(); ++i) {
            if (!tierName.equals(this.getMatch(i).getTierName())) continue;
            matchesInTier.add(this.getMatch(i));
        }
        return matchesInTier;
    }

    @Override
    public void reset() {
        super.reset();
        this.tierNames.clear();
        this.occurrenceCount = 0;
    }

    public String[] getTierNames() {
        return this.tierNames.toArray(new String[0]);
    }

    public int getOccurrenceCount() {
        return this.occurrenceCount;
    }
}

